/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sync.service.impl;

import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.biz.crm.dict.model.MdmDictAttrConfEntity;
import com.biz.crm.dict.model.MdmDictDataEntity;
import com.biz.crm.dict.model.MdmDictTypeEntity;
import com.biz.crm.dict.service.MdmDictAttrConfService;
import com.biz.crm.dict.service.MdmDictDataService;
import com.biz.crm.dict.service.MdmDictTypeService;
import com.biz.crm.nebular.mdm.sync.MdmDictEngineSyncVo;
import com.biz.crm.nebular.mdm.sync.MdmSyncBaseReqVo;
import com.biz.crm.nebular.mdm.sync.MdmSyncDictReqVo;
import com.biz.crm.sync.config.MdmSyncParameterParser;
import com.biz.crm.sync.config.MdmSyncProperty;
import com.biz.crm.sync.service.MdmDictSyncService;
import com.biz.crm.util.CrmBeanUtil;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
@ConditionalOnMissingBean(name={"MdmDictSyncServiceExpandImpl"})
public class MdmDictSyncServiceImpl
implements MdmDictSyncService {
    private static final Logger log = LoggerFactory.getLogger(MdmDictSyncServiceImpl.class);
    @Autowired
    private MdmSyncProperty mdmSyncProperty;
    @Autowired
    private MdmDictTypeService mdmDictTypeService;
    @Autowired
    private MdmDictDataService mdmDictDataService;
    @Autowired
    private MdmDictAttrConfService mdmDictAttrConfService;

    @Override
    public void dictSync(MdmSyncDictReqVo mdmSyncDictReqVo) {
        MdmDictEngineSyncVo mdmDictEngineSyncVo = MdmSyncParameterParser.obtainOriginalData((MdmSyncBaseReqVo)mdmSyncDictReqVo, this.mdmSyncProperty, "/mdm/mdmdicttype/obtainSyncList", mdmSyncDictReqVo, MdmDictEngineSyncVo.class);
        this.saveType(mdmSyncDictReqVo, mdmDictEngineSyncVo);
        this.saveData(mdmSyncDictReqVo, mdmDictEngineSyncVo);
        this.saveConfig(mdmSyncDictReqVo, mdmDictEngineSyncVo);
        this.mdmDictTypeService.deleteAllCache();
    }

    protected void saveConfig(MdmSyncDictReqVo mdmSyncDictReqVo, MdmDictEngineSyncVo mdmDictEngineSyncVo) {
        List mdmDictAttrConfRespVoList = mdmDictEngineSyncVo.getMdmDictAttrConfRespVoList();
        if (!CollectionUtils.isEmpty((Collection)mdmDictAttrConfRespVoList)) {
            Set configKeyList = ((LambdaQueryChainWrapper)this.mdmDictAttrConfService.lambdaQuery().in(!CollectionUtils.isEmpty((Collection)mdmSyncDictReqVo.getDictTypeCodeList()), MdmDictAttrConfEntity::getDictTypeCode, (Collection)mdmSyncDictReqVo.getDictTypeCodeList())).select(new SFunction[]{MdmDictAttrConfEntity::getDictTypeCode, MdmDictAttrConfEntity::getFieldCode}).list().stream().filter(x -> x != null && !StringUtils.isEmpty((Object)x.getDictTypeCode()) && !StringUtils.isEmpty((Object)x.getFieldCode())).map(x -> x.getDictTypeCode() + ":" + x.getFieldCode()).collect(Collectors.toSet());
            List mdmDictAttrConfEntities = mdmDictAttrConfRespVoList.stream().filter(x -> !configKeyList.contains(x.getDictTypeCode() + ":" + x.getFieldCode())).map(x -> (MdmDictAttrConfEntity)CrmBeanUtil.copy((Object)x, MdmDictAttrConfEntity.class)).peek(x -> x.setId(null)).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(mdmDictAttrConfEntities)) {
                this.mdmDictAttrConfService.saveBatch(mdmDictAttrConfEntities);
            }
        }
    }

    protected void saveData(MdmSyncDictReqVo mdmSyncDictReqVo, MdmDictEngineSyncVo mdmDictEngineSyncVo) {
        List mdmDictDataRespVoList = mdmDictEngineSyncVo.getMdmDictDataRespVoList();
        if (!CollectionUtils.isEmpty((Collection)mdmDictDataRespVoList)) {
            Set dataKeyList = ((LambdaQueryChainWrapper)this.mdmDictDataService.lambdaQuery().in(!CollectionUtils.isEmpty((Collection)mdmSyncDictReqVo.getDictTypeCodeList()), MdmDictDataEntity::getDictTypeCode, (Collection)mdmSyncDictReqVo.getDictTypeCodeList())).select(new SFunction[]{MdmDictDataEntity::getDictTypeCode, MdmDictDataEntity::getDictCode}).list().stream().filter(x -> x != null && !StringUtils.isEmpty((Object)x.getDictTypeCode()) && !StringUtils.isEmpty((Object)x.getDictCode())).map(x -> x.getDictTypeCode() + ":" + x.getDictCode()).collect(Collectors.toSet());
            List mdmDictDataEntities = mdmDictDataRespVoList.stream().filter(x -> !dataKeyList.contains(x.getDictTypeCode() + ":" + x.getDictCode())).map(x -> (MdmDictDataEntity)CrmBeanUtil.copy((Object)x, MdmDictDataEntity.class)).peek(x -> x.setId(null)).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(mdmDictDataEntities)) {
                this.mdmDictDataService.saveBatch(mdmDictDataEntities);
            }
        }
    }

    protected void saveType(MdmSyncDictReqVo mdmSyncDictReqVo, MdmDictEngineSyncVo mdmDictEngineSyncVo) {
        List mdmDictTypeRespVoList = mdmDictEngineSyncVo.getMdmDictTypeRespVoList();
        Assert.notEmpty((Collection)mdmDictTypeRespVoList, (String)"\u5b57\u5178\u7c7b\u578b\u67e5\u8be2\u4e3a\u7a7a");
        Set typeKeyList = ((LambdaQueryChainWrapper)this.mdmDictTypeService.lambdaQuery().in(!CollectionUtils.isEmpty((Collection)mdmSyncDictReqVo.getDictTypeCodeList()), MdmDictTypeEntity::getDictTypeCode, (Collection)mdmSyncDictReqVo.getDictTypeCodeList())).select(new SFunction[]{MdmDictTypeEntity::getDictTypeCode}).list().stream().filter(x -> x != null && !StringUtils.isEmpty((Object)x.getDictTypeCode())).map(MdmDictTypeEntity::getDictTypeCode).collect(Collectors.toSet());
        List mdmDictTypeEntities = mdmDictTypeRespVoList.stream().filter(x -> !typeKeyList.contains(x.getDictTypeCode())).map(x -> (MdmDictTypeEntity)CrmBeanUtil.copy((Object)x, MdmDictTypeEntity.class)).peek(x -> x.setId(null)).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(mdmDictTypeEntities)) {
            this.mdmDictTypeService.saveBatch(mdmDictTypeEntities);
        }
    }
}

