/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.newhope.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.base.BusinessException;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.mdm.FilterEnum;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.newhope.service.OrgSyncService;
import com.biz.crm.newhope.util.Body;
import com.biz.crm.newhope.util.HopeResult;
import com.biz.crm.newhope.util.NewHopeUtils;
import com.biz.crm.newhope.vo.req.NewHopeReqVo;
import com.biz.crm.newhope.vo.resp.NewHopeRespVo;
import com.biz.crm.org.mapper.MdmOrgMapper;
import com.biz.crm.org.model.MdmOrgEntity;
import com.biz.crm.org.service.MdmOrgService;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.HttpClientUtils;
import com.biz.crm.util.JsonPropertyUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.TreeRuleCodeUtil;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.assertj.core.util.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OrgSyncServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmOrgMapper, MdmOrgEntity>
implements OrgSyncService {
    private static final Logger log = LoggerFactory.getLogger(OrgSyncServiceImpl.class);
    @Autowired
    private MdmOrgService service;
    @Resource
    private MdmOrgMapper mdmOrgMapper;

    @Override
    public Body orgSyncWithCookie(NewHopeReqVo reqVo) throws UnsupportedEncodingException {
        AssertUtils.isNotEmpty((String)reqVo.getFilter(), (String)"\u540c\u6b65\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isTrue((boolean)FilterEnum.needOrgUrlSet().contains(reqVo.getFilter()), (String)"\u7ec4\u7ec7\u540c\u6b65\u65b9\u5f0f\u4e0eUrl\u4e0d\u5339\u914d");
        if (org.apache.commons.lang3.StringUtils.equals((CharSequence)reqVo.getFilter(), (CharSequence)FilterEnum.INCREMENT_ORG.getCode())) {
            AssertUtils.isNotEmpty((String)reqVo.getIncrementTime(), (String)"\u67e5\u8be2\u7ec4\u7ec7\u589e\u91cf\uff0c\u589e\u91cf\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        NewHopeRespVo respVo = NewHopeUtils.getNewHopeRespVo(reqVo);
        Map<String, String> headers = this.getStringStringMap(respVo);
        Result result = HttpClientUtils.doGet((String)respVo.getUrl(), headers);
        HopeResult hopeResult = (HopeResult)JsonPropertyUtil.toObject((String)((String)result.getResult()), HopeResult.class);
        if (hopeResult == null) {
            return new Body();
        }
        return hopeResult.getBody();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void orgSyncAll(NewHopeReqVo reqVo) throws UnsupportedEncodingException {
        reqVo.setFilter(FilterEnum.ORG.getCode());
        ArrayList entityList = Lists.newArrayList();
        HashSet orgCodes = Sets.newHashSet();
        while (true) {
            NewHopeRespVo respVo = NewHopeUtils.getNewHopeRespVo(reqVo);
            Map<String, String> headers = this.getStringStringMap(respVo);
            Result result = HttpClientUtils.doGet((String)respVo.getUrl(), headers);
            HopeResult hopeResult = (HopeResult)JsonPropertyUtil.toObject((String)((String)ApiResultUtil.objResult((Result)result, (boolean)true)), HopeResult.class);
            if (hopeResult == null) {
                return;
            }
            if (hopeResult.getBody() == null) {
                return;
            }
            if (CollectionUtils.isEmpty(hopeResult.getBody().getOrgs())) {
                return;
            }
            hopeResult.getBody().getOrgs().forEach(x -> {
                if (x != null) {
                    if (x.getOrgId() == null) {
                        return;
                    }
                    MdmOrgEntity entity = new MdmOrgEntity();
                    if (orgCodes.contains(x.getOrgId())) {
                        throw new BusinessException(x.getOrgId() + "\u7ec4\u7ec7\u7f16\u53f7orgId\u4e0d\u80fd\u91cd\u590d");
                    }
                    entity.setOrgCode(x.getOrgId());
                    if ("00000000".equals(x.getParentOrgId())) {
                        entity.setParentCode(null);
                    } else {
                        entity.setParentCode(x.getParentOrgId());
                    }
                    entity.setOrgName(x.getOrgShortName());
                    if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)x.getOrglevel())) {
                        entity.setLevelNum(Integer.valueOf(Integer.parseInt(x.getOrglevel())));
                    }
                    if ("1".equals(x.getOrgstatus())) {
                        entity.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
                    }
                    if ("0".equals(x.getOrgstatus())) {
                        entity.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
                    }
                    orgCodes.add(x.getOrgId());
                    entityList.add(entity);
                }
            });
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)hopeResult.getBody().getCookie())) break;
            reqVo.setCookie(hopeResult.getBody().getCookie());
        }
        if (CollectionUtils.isEmpty((Collection)orgCodes)) {
            return;
        }
        List<MdmOrgRespVo> orgRespVos = this.buildOrg(null, entityList);
        this.saveOrgBatch(orgRespVos);
    }

    private void saveOrgBatch(List<MdmOrgRespVo> orgRespVos) {
        if (!org.springframework.util.CollectionUtils.isEmpty(orgRespVos)) {
            orgRespVos.forEach(e -> {
                e.setRuleCode(this.generateRuleCodeByParentCode(e.getParentCode()));
                MdmOrgEntity en = (MdmOrgEntity)CrmBeanUtil.copy((Object)e, MdmOrgEntity.class);
                this.saveOrUpdate(en);
                if (!org.springframework.util.CollectionUtils.isEmpty((Collection)e.getRespVos())) {
                    this.saveOrgBatch(e.getRespVos());
                }
            });
        }
    }

    private List<MdmOrgRespVo> buildOrg(MdmOrgRespVo respVo, List<MdmOrgEntity> entityList) {
        ArrayList respVos = Lists.newArrayList();
        entityList.forEach(o -> {
            if (org.springframework.util.StringUtils.isEmpty((Object)o.getParentCode())) {
                o.setLevelNum(Integer.valueOf(1));
                o.setId(o.getOrgCode());
                respVos.add(CrmBeanUtil.copy((Object)o, MdmOrgRespVo.class));
            }
        });
        this.buildOrgLevel(respVos, entityList);
        return respVos;
    }

    private void buildOrgLevel(List<MdmOrgRespVo> respVos, List<MdmOrgEntity> entityList) {
        respVos.forEach(o -> {
            String orgCode = o.getOrgCode();
            List<MdmOrgEntity> entities = entityList.stream().filter(e -> orgCode.equals(e.getParentCode())).collect(Collectors.toList());
            entities.forEach(e -> {
                e.setId(e.getOrgCode());
                e.setLevelNum(Integer.valueOf(o.getLevelNum() + 1));
            });
            if (!org.springframework.util.CollectionUtils.isEmpty(entities)) {
                o.setRespVos(CrmBeanUtil.copyList(entities, MdmOrgRespVo.class));
                this.buildOrgLevel(o.getRespVos(), entityList);
            }
        });
    }

    private Map<String, String> getStringStringMap(NewHopeRespVo respVo) {
        HashMap headers = Maps.newHashMap();
        headers.put("sign", respVo.getSign());
        headers.put("encodekey", respVo.getEncodekey());
        headers.put("randomcode", respVo.getRandomcode());
        headers.put("appuser", respVo.getAppuser());
        headers.put("timestamp", respVo.getTimestamp());
        return headers;
    }

    private String generateRuleCodeByParentCode(String parentCode) {
        MdmOrgEntity parent;
        String ruleCode = "";
        boolean top = true;
        String prefix = "";
        if (StringUtils.isNotEmpty((String)parentCode) && (parent = (MdmOrgEntity)this.mdmOrgMapper.selectOne((Wrapper)Wrappers.lambdaQuery().eq(MdmOrgEntity::getOrgCode, (Object)parentCode))) != null) {
            top = false;
            prefix = parent.getRuleCode();
        }
        List list = null;
        list = top ? ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().isNull(MdmOrgEntity::getParentCode)).or()).eq(MdmOrgEntity::getParentCode, (Object)"")).list() : ((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmOrgEntity::getParentCode, (Object)parentCode)).list();
        if (CollectionUtil.listEmpty((List)list)) {
            ruleCode = prefix + TreeRuleCodeUtil.numToSingleCode((Integer)1);
        } else {
            LinkedHashSet<Integer> set = new LinkedHashSet<Integer>();
            for (MdmOrgEntity item : list) {
                if (!StringUtils.isNotEmpty((String)item.getRuleCode())) continue;
                try {
                    Integer integer = TreeRuleCodeUtil.getCurLevelCodeValue((String)item.getRuleCode());
                    set.add(integer);
                }
                catch (BusinessException e) {
                    throw new BusinessException("\u4f01\u4e1a\u7ec4\u7ec7" + e.getMsg());
                }
            }
            int maxRuleCodeValueInLevel = TreeRuleCodeUtil.getMaxRuleCodeValueInLevel();
            for (int i = 1; i <= maxRuleCodeValueInLevel; ++i) {
                if (i == maxRuleCodeValueInLevel) {
                    throw new BusinessException("\u964d\u7ef4\u7f16\u7801\u8d8a\u754c\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406");
                }
                if (set.contains(i)) continue;
                ruleCode = prefix + TreeRuleCodeUtil.numToSingleCode((Integer)i);
                break;
            }
        }
        return ruleCode;
    }
}

