/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.newhope.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.base.BusinessException;
import com.biz.crm.customer.mapper.MdmCustomerMsgMapper;
import com.biz.crm.customer.model.MdmCustomerEntity;
import com.biz.crm.customer.service.MdmCustomerMsgService;
import com.biz.crm.eunm.mdm.FilterEnum;
import com.biz.crm.newhope.service.UserSyncService;
import com.biz.crm.newhope.util.Body;
import com.biz.crm.newhope.util.HopeResult;
import com.biz.crm.newhope.util.NewHopeUtils;
import com.biz.crm.newhope.vo.req.NewHopeReqVo;
import com.biz.crm.newhope.vo.resp.NewHopeRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.HttpClientUtils;
import com.biz.crm.util.JsonPropertyUtil;
import com.biz.crm.util.Result;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.util.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UserSyncServiceImpl
implements UserSyncService {
    private static final Logger log = LoggerFactory.getLogger(UserSyncServiceImpl.class);
    @Autowired
    private MdmCustomerMsgService customerMsgService;
    @Resource
    private MdmCustomerMsgMapper customerMsgMapper;
    private NewHopeReqVo newHopeReqVo;

    @Override
    public Body userSyncWithCookie(NewHopeReqVo reqVo) throws UnsupportedEncodingException {
        AssertUtils.isNotEmpty((String)reqVo.getFilter(), (String)"\u540c\u6b65\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isTrue((!FilterEnum.needOrgUrlSet().contains(reqVo.getFilter()) ? 1 : 0) != 0, (String)"\u7528\u6237\u540c\u6b65\u65b9\u5f0f\u4e0eUrl\u4e0d\u5339\u914d");
        if (StringUtils.equals((CharSequence)reqVo.getFilter(), (CharSequence)FilterEnum.INCREMENT_USER.getCode())) {
            AssertUtils.isNotEmpty((String)reqVo.getIncrementTime(), (String)"\u67e5\u8be2\u7528\u6237\u589e\u91cf\uff0c\u589e\u91cf\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        NewHopeRespVo respVo = NewHopeUtils.getNewHopeRespVo(reqVo);
        Map<String, String> headers = this.getStringStringMap(respVo);
        Result result = HttpClientUtils.doGet((String)respVo.getUrl(), headers);
        HopeResult hopeResult = (HopeResult)JsonPropertyUtil.toObject((String)((String)result.getResult()), HopeResult.class);
        if (hopeResult == null) {
            return new Body();
        }
        return hopeResult.getBody();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void userSync(NewHopeReqVo reqVo) throws UnsupportedEncodingException {
        HopeResult hopeResult;
        this.newHopeReqVo = reqVo;
        reqVo.setFilter(FilterEnum.USER.getCode());
        ArrayList entityList = Lists.newArrayList();
        HashSet cusCodes = Sets.newHashSet();
        do {
            HashSet cusCodeByCookie = Sets.newHashSet();
            ArrayList needSaveList = Lists.newArrayList();
            NewHopeRespVo respVo = NewHopeUtils.getNewHopeRespVo(this.newHopeReqVo);
            Map<String, String> headers = this.getStringStringMap(respVo);
            Result result = HttpClientUtils.doGet((String)respVo.getUrl(), headers);
            hopeResult = (HopeResult)JsonPropertyUtil.toObject((String)((String)ApiResultUtil.objResult((Result)result, (boolean)true)).replace("-", ""), HopeResult.class);
            if (hopeResult == null) {
                return;
            }
            if (hopeResult.getBody() == null) {
                return;
            }
            if (CollectionUtils.isEmpty(hopeResult.getBody().getUsers())) {
                return;
            }
            hopeResult.getBody().getUsers().forEach(x -> {
                if (StringUtils.isNotBlank((CharSequence)x.getCustomizedhrregion()) && StringUtils.isNotBlank((CharSequence)x.getCustomizedhrregiontxt())) {
                    MdmCustomerEntity entity = new MdmCustomerEntity();
                    entity.setCustomerCode(x.getUserId());
                    entity.setCustomerName(x.getUserCn());
                    entity.setOrgCode(x.getUserOrgId());
                    entity.setId(x.getUserId());
                    needSaveList.add(entity);
                }
                if (StringUtils.isNotBlank((CharSequence)x.getUserId())) {
                    if (cusCodes.contains(x.getUserId())) {
                        throw new BusinessException("\u7528\u6237\u7f16\u7801\u91cd\u590d");
                    }
                    cusCodeByCookie.add(x.getUserId());
                    cusCodes.add(x.getUserId());
                }
            });
            reqVo.setCookie(hopeResult.getBody().getCookie());
            if (!CollectionUtils.isNotEmpty((Collection)needSaveList)) continue;
            List entitiesByDb = this.customerMsgMapper.selectList((Wrapper)Wrappers.lambdaQuery().in(MdmCustomerEntity::getCustomerCode, (Collection)cusCodeByCookie));
            this.saveOrUpdateCusList(needSaveList, entitiesByDb);
        } while (!StringUtils.isBlank((CharSequence)hopeResult.getBody().getCookie()));
    }

    private void saveOrUpdateCusList(List<MdmCustomerEntity> needSaveList, List<MdmCustomerEntity> entitiesByDb) {
        List<Object> saveEntities = Lists.newArrayList();
        ArrayList updateEntities = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(entitiesByDb)) {
            saveEntities = needSaveList;
            this.customerMsgService.saveBatch(saveEntities);
            return;
        }
        Set codeSet = entitiesByDb.stream().map(MdmCustomerEntity::getCustomerCode).collect(Collectors.toSet());
        List<Object> finalSaveEntities = saveEntities;
        needSaveList.forEach(x -> {
            if (codeSet.contains(x.getCustomerCode())) {
                updateEntities.add(x);
            } else {
                finalSaveEntities.add(x);
            }
        });
        this.customerMsgService.saveBatch(saveEntities);
        this.customerMsgService.updateBatchById(updateEntities);
    }

    private Map<String, String> getStringStringMap(NewHopeRespVo respVo) {
        HashMap headers = Maps.newHashMap();
        headers.put("sign", respVo.getSign());
        headers.put("encodekey", respVo.getEncodekey());
        headers.put("randomcode", respVo.getRandomcode());
        headers.put("appuser", respVo.getAppuser());
        headers.put("timestamp", respVo.getTimestamp());
        return headers;
    }
}

