/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.newhope.util;

import com.biz.crm.base.BusinessException;
import com.biz.crm.eunm.mdm.FilterEnum;
import com.biz.crm.newhope.config.NewHopeConfig;
import com.biz.crm.newhope.vo.req.NewHopeReqVo;
import com.biz.crm.newhope.vo.resp.NewHopeRespVo;
import com.biz.crm.utils.VerificationUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class NewHopeUtils {
    private static final Logger log = LoggerFactory.getLogger(NewHopeUtils.class);
    @Resource
    private NewHopeConfig newHopeConfig;
    private static final NewHopeUtils instance = new NewHopeUtils();

    @PostConstruct
    public void init() {
        NewHopeUtils.instance.newHopeConfig = this.newHopeConfig;
    }

    public static NewHopeRespVo getNewHopeRespVo(NewHopeReqVo reqVo) throws UnsupportedEncodingException {
        NewHopeRespVo vo = new NewHopeRespVo();
        if (NewHopeUtils.instance.newHopeConfig == null) {
            throw new BusinessException("\u914d\u7f6e\u5f02\u5e38");
        }
        if (!FilterEnum.getFilters().containsKey(reqVo.getFilter())) {
            return vo;
        }
        String replaceStr = StringUtils.replace((String)((String)FilterEnum.getFilters().get(reqVo.getFilter())), (String)"incrementTime", (String)reqVo.getIncrementTime());
        String filterStr = URLEncoder.encode(replaceStr, "utf-8");
        if (FilterEnum.needOrgUrlSet().contains(reqVo.getFilter())) {
            vo.setUrl(MessageFormat.format(NewHopeUtils.instance.newHopeConfig.getHost() + NewHopeUtils.instance.newHopeConfig.getOrguri(), filterStr, reqVo.getCookie()));
            vo.setSign(DigestUtils.md5Hex((String)StringUtils.join((Object[])new String[]{MessageFormat.format(NewHopeUtils.instance.newHopeConfig.getOrguri(), filterStr, reqVo.getCookie()), "&", reqVo.getBody(), "&", NewHopeUtils.instance.newHopeConfig.getPrivatekey()})));
        } else {
            vo.setUrl(MessageFormat.format(NewHopeUtils.instance.newHopeConfig.getHost() + NewHopeUtils.instance.newHopeConfig.getUseruri(), filterStr, reqVo.getCookie()));
            vo.setSign(DigestUtils.md5Hex((String)StringUtils.join((Object[])new String[]{MessageFormat.format(NewHopeUtils.instance.newHopeConfig.getUseruri(), filterStr, reqVo.getCookie()), "&", reqVo.getBody(), "&", NewHopeUtils.instance.newHopeConfig.getPrivatekey()})));
        }
        vo.setAppuser(NewHopeUtils.instance.newHopeConfig.getAppuser());
        if (StringUtils.isNotBlank((CharSequence)reqVo.getOperator())) {
            vo.setOperator(reqVo.getOperator());
        } else {
            vo.setOperator(vo.getAppuser());
        }
        vo.setPrivatekey(NewHopeUtils.instance.newHopeConfig.getPrivatekey());
        vo.setRandomcode(VerificationUtil.generateRandomStr());
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss'Z'");
        String date = df.format(new Date());
        vo.setTimestamp(date);
        vo.setEncodekey(DigestUtils.sha256Hex((String)StringUtils.join((Object[])new String[]{vo.getAppuser(), vo.getRandomcode(), vo.getTimestamp(), "{", vo.getPrivatekey(), "}"})));
        return vo;
    }
}

