/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.function.controller;

import com.biz.crm.aop.CrmGlobalLog;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.function.service.MdmFunctionService;
import com.biz.crm.nebular.mdm.function.MdmFunctionPermissionVo;
import com.biz.crm.nebular.mdm.function.MdmFunctionReqVo;
import com.biz.crm.nebular.mdm.function.MdmFunctionRespVo;
import com.biz.crm.nebular.mdm.function.MdmFunctionSearchReqVo;
import com.biz.crm.nebular.mdm.sync.MdmFunctionEngineSyncVo;
import com.biz.crm.nebular.mdm.sync.MdmSyncStandardFunctionReqVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mdmfunction"})
@Api(tags={"\u83dc\u5355\u8868"})
@CrmGlobalLog
public class MdmFunctionController {
    private static final Logger log = LoggerFactory.getLogger(MdmFunctionController.class);
    @Autowired
    private MdmFunctionService mdmFunctionService;

    @ApiOperation(value="\u5168\u90e8\u83dc\u5355\u5217\u8868")
    @PostMapping(value={"/list"})
    public Result<List<MdmFunctionRespVo>> listCondition(@RequestBody MdmFunctionReqVo mdmFunctionReqVo) {
        return Result.ok(this.mdmFunctionService.listCondition(mdmFunctionReqVo));
    }

    @ApiOperation(value="\u7cfb\u7edf\u83dc\u5355\u5217\u8868")
    @PostMapping(value={"/system_list"})
    public Result<List<MdmFunctionRespVo>> systemList(@RequestBody MdmFunctionReqVo mdmFunctionReqVo) {
        return Result.ok(this.mdmFunctionService.systemList(mdmFunctionReqVo));
    }

    @ApiOperation(value="\u67e5\u8be2\u6743\u9650\u5185\u7684\u83dc\u5355\u5217\u8868")
    @PostMapping(value={"/findPermissionFunctionList"})
    public Result<List<MdmFunctionRespVo>> findPermissionFunctionList(MdmFunctionReqVo mdmFunctionReqVo) {
        return Result.ok(this.mdmFunctionService.findPermissionFunctionList(mdmFunctionReqVo));
    }

    @ApiOperation(value="\u7cfb\u7edf\u5de6\u4fa7\u83dc\u5355\u6811")
    @PostMapping(value={"/system_tree"})
    public Result<List<MdmFunctionRespVo>> systemTree(@RequestBody MdmFunctionReqVo mdmFunctionReqVo) {
        return Result.ok(this.mdmFunctionService.systemTree(mdmFunctionReqVo));
    }

    @ApiModelProperty(value="\u9875\u9762\u5f15\u64ce\u83dc\u5355\u6811")
    @PostMapping(value={"/pageEngineTree"})
    @CrmDictMethod
    public Result<List<MdmFunctionPermissionVo>> pageEngineTree(@RequestBody MdmFunctionReqVo mdmFunctionReqVo) {
        return Result.ok(this.mdmFunctionService.pageEngineTree(mdmFunctionReqVo));
    }

    @ApiModelProperty(value="\u83dc\u5355\u7ba1\u7406\u6811\uff08\u67e5\u8be2\u5df2\u7981\u7528\u7684\uff09")
    @PostMapping(value={"/allFunctionTree"})
    @CrmDictMethod
    public Result<List<MdmFunctionRespVo>> allFunctionTree(@RequestBody MdmFunctionReqVo mdmFunctionReqVo) {
        List<MdmFunctionRespVo> data = this.mdmFunctionService.allFunctionTree(mdmFunctionReqVo);
        return Result.ok(data);
    }

    @ApiOperation(value="\u83dc\u5355\u6811")
    @PostMapping(value={"/tree"})
    public Result<List<MdmFunctionRespVo>> functionTree(@RequestBody MdmFunctionReqVo mdmFunctionReqVo) {
        return Result.ok(this.mdmFunctionService.functionTree(mdmFunctionReqVo));
    }

    @ApiOperation(value="\u83dc\u5355\u6811\uff08\u5b50\u8282\u70b9\u67e5\u8be2\uff09")
    @PostMapping(value={"/functionSearchTree"})
    public Result<List<MdmFunctionRespVo>> functionSearchTree(@RequestBody MdmFunctionSearchReqVo mdmFunctionSearchReqVo) {
        return Result.ok(this.mdmFunctionService.functionSearchTree(mdmFunctionSearchReqVo));
    }

    @ApiOperation(value="\u67e5\u8be2")
    @PostMapping(value={"/query"})
    public Result<MdmFunctionRespVo> query(@RequestBody MdmFunctionReqVo mdmFunctionReqVo) {
        MdmFunctionRespVo respVo = this.mdmFunctionService.query(mdmFunctionReqVo);
        return Result.ok((Object)respVo);
    }

    @ApiOperation(value="\u65b0\u589e")
    @PostMapping(value={"/save"})
    public Result<Object> save(@RequestBody MdmFunctionReqVo mdmFunctionReqVo) {
        this.mdmFunctionService.save(mdmFunctionReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u67e5\u8be2\u53ef\u914d\u7f6e\u5de5\u4f5c\u6d41\u7684\u83dc\u5355")
    @PostMapping(value={"/getListMdmFunctionByMenuConfig"})
    public Result<Object> listMdmFunctionByMenuConfig(@RequestBody MdmFunctionReqVo mdmFunctionReqVo) {
        return Result.ok(this.mdmFunctionService.listMdmFunctionByMenuConfig(mdmFunctionReqVo));
    }

    @ApiOperation(value="\u66f4\u65b0")
    @PostMapping(value={"/update"})
    public Result<Object> update(@RequestBody MdmFunctionReqVo mdmFunctionReqVo) {
        this.mdmFunctionService.update(mdmFunctionReqVo);
        return Result.ok((String)"\u4fee\u6539\u6210\u529f");
    }

    @ApiOperation(value="\u67e5\u8be2\u914d\u7f6e\u6570\u636e\u6743\u9650\u7684\u83dc\u5355\u6811(\u6570\u636e\u6743\u9650\u4e13\u7528)")
    @PostMapping(value={"/findDataPermissionFunctionTree"})
    public Result<List<MdmFunctionPermissionVo>> findDataPermissionFunctionTree(@RequestBody MdmFunctionReqVo mdmFunctionReqVo) {
        return Result.ok(this.mdmFunctionService.findDataPermissionFunctionTree(mdmFunctionReqVo));
    }

    @ApiOperation(value="\u5220\u9664")
    @PostMapping(value={"/delete"})
    public Result<Object> delete(@RequestBody MdmFunctionReqVo mdmFunctionReqVo) {
        this.mdmFunctionService.deleteBatch(mdmFunctionReqVo.getFunctionCode());
        return Result.ok((String)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u542f\u7528")
    @PostMapping(value={"/enable"})
    public Result<Object> enable(@RequestBody MdmFunctionReqVo mdmFunctionReqVo) {
        this.mdmFunctionService.enableBatch(mdmFunctionReqVo.getFunctionCode());
        return Result.ok((String)"\u542f\u7528\u6210\u529f");
    }

    @ApiOperation(value="\u7981\u7528")
    @PostMapping(value={"/disable"})
    public Result<Object> disable(@RequestBody MdmFunctionReqVo mdmFunctionReqVo) {
        this.mdmFunctionService.disableBatch(mdmFunctionReqVo.getFunctionCode());
        return Result.ok((String)"\u7981\u7528\u6210\u529f");
    }

    @PostMapping(value={"/syncList"})
    public Result<MdmFunctionEngineSyncVo> syncList(@RequestBody MdmSyncStandardFunctionReqVo mdmSyncStandardFunctionReqVo) {
        return Result.ok((Object)this.mdmFunctionService.syncList(mdmSyncStandardFunctionReqVo));
    }
}

