/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.availablelist.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.annotation.Klock;
import com.biz.crm.availablelist.entity.CusAvailablelistEntity;
import com.biz.crm.availablelist.repositories.CusAvailablelistRepositories;
import com.biz.crm.availablelist.service.CusAvailablelistService;
import com.biz.crm.availablelist.utils.CusAvailablelistUtil;
import com.biz.crm.availablelistrule.advise.Advise;
import com.biz.crm.availablelistrule.advise.strategy.CustomerChangeAdviseTargetStrategy;
import com.biz.crm.availablelistrule.service.AvailableListRuleService;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.config.SpringApplicationContextUtil;
import com.biz.crm.customer.service.MdmCustomerMsgService;
import com.biz.crm.dms.promotion.PromotionFeign;
import com.biz.crm.dms.promotion.PromotionPolicyFeign;
import com.biz.crm.dms.promotion.PromotionV2Feign;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.nebular.dms.npromotion.vo.PromotionQueryReq;
import com.biz.crm.nebular.dms.npromotion.vo.PromotionSaleProductVo;
import com.biz.crm.nebular.mdm.availablelist.AvalibleListProductLevelChangeDto;
import com.biz.crm.nebular.mdm.availablelist.CusAvailablelistVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.mdm.pricesetting.req.MdmPriceSearchReqVo;
import com.biz.crm.nebular.mdm.pricesetting.resp.MdmPriceResp;
import com.biz.crm.nebular.mdm.product.resp.MdmProductAdviseRespVo;
import com.biz.crm.pricesetting.service.IMdmPriceSettingService;
import com.biz.crm.product.service.MdmProductService;
import com.biz.crm.productlevel.service.MdmProductLevelService;
import com.biz.crm.util.ContextUtil;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.EsUtil;
import com.biz.crm.util.RedissonUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.ValidateUtils;
import com.bizunited.platform.common.vo.UuidVo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.core.ElasticsearchTemplate;
import org.springframework.data.elasticsearch.core.aggregation.AggregatedPage;
import org.springframework.data.elasticsearch.core.query.DeleteQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.SearchQuery;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@ConditionalOnMissingBean(name={"cusAvailablelistServiceExpandImpl"})
@Service(value="cusAvailablelistService")
public class CusAvailablelistServiceImpl<M extends BaseMapper<T>, T>
implements CusAvailablelistService {
    private static final Logger log = LoggerFactory.getLogger(CusAvailablelistServiceImpl.class);
    @Autowired
    private ElasticsearchTemplate elasticsearchTemplate;
    @Autowired
    private RedissonUtil redissonUtil;
    @Autowired
    private CusAvailablelistRepositories cusAvailablelistRepositories;
    @Resource
    private MdmCustomerMsgService mdmCustomerMsgService;
    @Resource
    private AvailableListRuleService availableListRuleService;
    @Resource
    private MdmProductService mdmProductService;
    @Resource
    private Advise advise;
    @Resource
    private CustomerChangeAdviseTargetStrategy customerChangeAdviseTargetStrategy;
    @Autowired
    private ContextUtil contextUtil;
    @Resource
    private IMdmPriceSettingService iMdmPriceSettingService;
    @Autowired
    private PromotionPolicyFeign promotionPolicyFeign;
    @Autowired
    private MdmProductLevelService mdmProductLevelService;
    @Autowired
    private PromotionV2Feign promotionV2Feign;
    @Autowired
    private PromotionFeign promotionFeign;

    @Override
    public void reFresh(List<MdmProductAdviseRespVo> goods, String cusCode) {
        ValidateUtils.validate((Object)cusCode, (String)"\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        MdmCustomerMsgRespVo customerMsgRespVo = this.mdmCustomerMsgService.query(null, cusCode);
        ValidateUtils.validate((Object)customerMsgRespVo, (String)("\u8be5\u5ba2\u6237\u4e0d\u5b58\u5728,\u5ba2\u6237\u7f16\u7801:" + cusCode));
        ArrayList<String> ofenGoodsCodes = new ArrayList();
        if (EsUtil.indexExsit((ElasticsearchTemplate)this.elasticsearchTemplate, CusAvailablelistEntity.class, (RedissonUtil)this.redissonUtil)) {
            List<CusAvailablelistEntity> ofenGoods = this.cusAvailablelistRepositories.findByCusCodeAndOfenFlag(cusCode, YesNoEnum.YesNoCodeNumberEnum.YES.getCode());
            if (!CollectionUtils.isEmpty(ofenGoods)) {
                ofenGoodsCodes = ofenGoods.stream().map(MdmProductAdviseRespVo::getProductCode).collect(Collectors.toList());
            }
            DeleteQuery deleteQuery = new DeleteQuery();
            BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"cusCode.keyword", (String)cusCode));
            deleteQuery.setQuery((QueryBuilder)boolQueryBuilder);
            this.elasticsearchTemplate.delete(deleteQuery, CusAvailablelistEntity.class);
            this.elasticsearchTemplate.refresh("cusavailablelistindex");
        }
        if (CollectionUtils.isEmpty(goods)) {
            return;
        }
        Map promotionMap = (Map)ApiResultUtil.objResult((Result)this.promotionPolicyFeign.custProductsHasPromotionPolicy(cusCode, goods.stream().map(MdmProductAdviseRespVo::getProductCode).collect(Collectors.toList())), (boolean)true);
        this.cusAvailablelistRepositories.saveAll(CusAvailablelistUtil.packageEntities(goods, customerMsgRespVo, ofenGoodsCodes, promotionMap));
        this.elasticsearchTemplate.refresh("cusavailablelistindex");
    }

    @Override
    @Klock(keys={"cusallock", "#cusCode"}, waitTime=30L, leaseTime=10L)
    public void reFresh(String cusCode) {
        Map<String, List<String>> cusList = this.mdmCustomerMsgService.findOrgCodeListByCustomerCodeList(Lists.newArrayList((Object[])new String[]{cusCode}));
        if (CollectionUtils.isEmpty(cusList)) {
            log.info("\u8be5\u6b21\u4ea7\u54c1\u5c42\u7ea7\u53d8\u52a8\u6ca1\u6709\u6d89\u53ca\u5230\u7684\u7ecf\u9500\u5546\uff0133333");
            return;
        }
        List<String> goodsCodes = this.availableListRuleService.findGoodsByCusCodeAndOrgCode(cusCode, cusList.get(cusCode));
        ArrayList<MdmProductAdviseRespVo> goods = new ArrayList();
        if (!CollectionUtils.isEmpty(goodsCodes)) {
            ArrayList<String> currentGoodsCodes = new ArrayList<String>();
            int i = 0;
            for (String goodsCode : goodsCodes) {
                currentGoodsCodes.add(goodsCode);
                if (currentGoodsCodes.size() != 500 && ++i != goodsCodes.size()) continue;
                goods.addAll(this.mdmProductService.adviseQuery(currentGoodsCodes));
                currentGoodsCodes.clear();
            }
        } else {
            log.info("\u6539\u7ecf\u9500\u5546\u6ca1\u6709\u53ef\u591f\u5546\u54c1\uff01");
        }
        goods = goods.stream().filter(vo -> !StringUtils.isEmpty((Object)vo.getProductCode())).collect(Collectors.toList());
        this.reFresh(goods, cusCode);
    }

    @Override
    public void reFresh(List<String> cusCodes) {
        if (CollectionUtils.isEmpty(cusCodes)) {
            log.info("\u8be5\u6b21\u4ea7\u54c1\u5c42\u7ea7\u53d8\u52a8\u6ca1\u6709\u6d89\u53ca\u5230\u7684\u7ecf\u9500\u55462222\uff01");
            return;
        }
        CusAvailablelistService cusAvailablelistService = (CusAvailablelistService)SpringApplicationContextUtil.getApplicationContext().getBean(CusAvailablelistService.class);
        for (String cusCode : cusCodes) {
            try {
                cusAvailablelistService.reFresh(cusCode);
            }
            catch (Exception e) {
                log.error("\u53ef\u591f\u6e05\u5355\u5237\u65b0\u5931\u8d25\uff0c\u5ba2\u6237:" + cusCode, (Throwable)e);
            }
        }
    }

    @Override
    @Klock(keys={"cusallock", "#cusCode"}, waitTime=30L, leaseTime=10L)
    public void reFreshPromotion(String cusCode) {
        if (StringUtils.isEmpty((Object)cusCode)) {
            log.info("\u5ba2\u6237\u5217\u8868\u4e3a\u7a7a222222");
            return;
        }
        if (!EsUtil.indexExsit((ElasticsearchTemplate)this.elasticsearchTemplate, CusAvailablelistEntity.class, (RedissonUtil)this.redissonUtil)) {
            log.info("\u6682\u65e0es\u7d22\u5f15");
            return;
        }
        List<CusAvailablelistEntity> entities = this.cusAvailablelistRepositories.findByCusCode(cusCode);
        if (CollectionUtils.isEmpty(entities)) {
            log.info("\u8be5\u5ba2\u6237\u65e0\u53ef\u591f\u6e05\u5355");
            return;
        }
        PromotionQueryReq req = new PromotionQueryReq();
        req.setAccountType("customer");
        req.setAccountCode(cusCode);
        Result result = this.promotionFeign.findAvailablePromotionMapByCus(req);
        if (!result.isSuccess()) {
            throw new BusinessException("\u5546\u54c1\u670d\u52a1\u6b63\u5728\u91cd\u542f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        HashMap promotionMap = (HashMap)result.getResult();
        if (CollectionUtils.isEmpty((Map)promotionMap)) {
            promotionMap = new HashMap();
        }
        for (CusAvailablelistEntity cusAvailablelistEntity : entities) {
            if (null == promotionMap.get(cusAvailablelistEntity.getProductCode())) {
                log.info("{}\u7684\u5546\u54c1{}\u6ca1\u6709\u4fc3\u9500", (Object)cusCode, (Object)cusAvailablelistEntity.getProductCode());
                cusAvailablelistEntity.setPromotionFlag(YesNoEnum.YesNoCodeNumberEnum.NO.getCode());
                continue;
            }
            cusAvailablelistEntity.setPromotionFlag(YesNoEnum.YesNoCodeNumberEnum.YES.getCode());
        }
        this.cusAvailablelistRepositories.saveAll(entities);
    }

    @Override
    public void reFreshPromotion(List<String> cusCodes) {
        if (CollectionUtils.isEmpty(cusCodes)) {
            log.info("\u5ba2\u6237\u5217\u8868\u4e3a\u7a7a11111");
            return;
        }
        CusAvailablelistService cusAvailablelistService = (CusAvailablelistService)ContextUtil.getBean(CusAvailablelistService.class);
        for (String cusCode : cusCodes) {
            try {
                cusAvailablelistService.reFreshPromotion(cusCode);
            }
            catch (Exception e) {
                log.error("\u53ef\u591f\u6e05\u5355\u4fc3\u9500\u6807\u5fd7\u5237\u65b0\u5931\u8d25\uff0c\u5ba2\u6237:" + cusCode, (Throwable)e);
            }
        }
    }

    @Override
    public void reFreshByProductLevel(List<String> productLevelCode) {
        if (CollectionUtils.isEmpty(productLevelCode)) {
            log.info("\u4ea7\u54c1\u5c42\u7ea7\u4e3a\u7a7a\uff01");
            return;
        }
        List<String> cusCodes = this.availableListRuleService.listCusCodesByProductLevel(productLevelCode);
        if (CollectionUtils.isEmpty(cusCodes)) {
            log.info("\u8be5\u6b21\u4ea7\u54c1\u5c42\u7ea7\u53d8\u52a8\u6ca1\u6709\u6d89\u53ca\u5230\u7684\u7ecf\u9500\u5546\uff01");
            return;
        }
        this.reFresh(cusCodes);
    }

    @Override
    public void reFreshProductLevel(Map<String, AvalibleListProductLevelChangeDto> dtoMap) {
        if (CollectionUtils.isEmpty(dtoMap)) {
            return;
        }
        List<CusAvailablelistEntity> entityList = this.cusAvailablelistRepositories.findByProductCodeIn(new ArrayList<String>(dtoMap.keySet()));
        if (CollectionUtils.isEmpty(entityList)) {
            log.info("\u6682\u65e0\u8bbe\u8ba1\u5230\u8be5\u5546\u54c1\u7684\u53ef\u591f\u6e05\u5355");
            return;
        }
        CusAvailablelistService cusAvailablelistService = (CusAvailablelistService)ContextUtil.getBean(CusAvailablelistService.class);
        for (CusAvailablelistEntity entity : entityList) {
            try {
                cusAvailablelistService.reFreshProductLevelByCus(entity.getCusCode(), dtoMap);
            }
            catch (Exception e) {
                log.error("\u53ef\u591f\u6e05\u5355\u5546\u54c1\u5c42\u7ea7\u5237\u65b0\u5931\u8d25\uff0c\u4ea7\u54c1:" + entity.getProductCode(), (Throwable)e);
            }
        }
    }

    @Override
    @Klock(keys={"cusallock", "#cusCode"}, waitTime=30L, leaseTime=10L)
    public void reFreshProductLevelByCus(String cusCode, Map<String, AvalibleListProductLevelChangeDto> dtoMap) {
        List<CusAvailablelistEntity> entityList = this.cusAvailablelistRepositories.findByCusCodeAndProductCodeIn(cusCode, new ArrayList<String>(dtoMap.keySet()));
        if (CollectionUtils.isEmpty(entityList)) {
            return;
        }
        ArrayList<CusAvailablelistEntity> saveList = new ArrayList<CusAvailablelistEntity>();
        for (CusAvailablelistEntity entity : entityList) {
            AvalibleListProductLevelChangeDto dto = dtoMap.get(entity.getProductCode());
            if (null == dto) continue;
            entity.setProductLevelCode(dto.getNewLevelCode());
            entity.setProductLevelName(dto.getNewLevelName());
            saveList.add(entity);
        }
        if (!CollectionUtils.isEmpty(saveList)) {
            this.cusAvailablelistRepositories.saveAll(saveList);
            this.elasticsearchTemplate.refresh("cusavailablelistindex");
        }
    }

    public BoolQueryBuilder buildBoolQueryBuilder(CusAvailablelistVo cusAvailablelistVo) {
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (!StringUtils.isEmpty((Object)cusAvailablelistVo.getCusCode())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"cusCode.keyword", (String)cusAvailablelistVo.getCusCode()));
        }
        if (!StringUtils.isEmpty((Object)cusAvailablelistVo.getIsShelf())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"isShelf.keyword", (String)cusAvailablelistVo.getIsShelf()));
        }
        if (!StringUtils.isEmpty((Object)cusAvailablelistVo.getCusName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"cusName", (Object)cusAvailablelistVo.getCusName()));
        }
        if (!StringUtils.isEmpty((Object)cusAvailablelistVo.getCusOrgCode())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"cusOrgCode.keyword", (String)cusAvailablelistVo.getCusOrgCode()));
        }
        if (!StringUtils.isEmpty((Object)cusAvailablelistVo.getCusOrgName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"cusOrgName", (Object)cusAvailablelistVo.getCusOrgName()));
        }
        if (!StringUtils.isEmpty((Object)cusAvailablelistVo.getCusChannelCode())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"cusChannelCode.keyword", (String)cusAvailablelistVo.getCusChannelCode()));
        }
        if (!StringUtils.isEmpty((Object)cusAvailablelistVo.getCusChannelName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"cusChannelName", (Object)cusAvailablelistVo.getCusChannelName()));
        }
        if (!StringUtils.isEmpty((Object)cusAvailablelistVo.getProductType())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"productType.keyword", (String)cusAvailablelistVo.getProductType()));
        }
        if (!StringUtils.isEmpty((Object)cusAvailablelistVo.getPromotionFlag())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"promotionFlag", (Object)cusAvailablelistVo.getPromotionFlag()));
        }
        return boolQueryBuilder;
    }

    @Override
    @CrmDictMethod
    public PageResult<CusAvailablelistVo> list(CusAvailablelistVo cusAvailablelistVo) {
        NativeSearchQuery searchQuery;
        AggregatedPage scroll;
        List list;
        PageResult pageResult = new PageResult();
        pageResult.setCount(Long.valueOf(Long.parseLong("0")));
        pageResult.setData(new ArrayList());
        if (!EsUtil.indexExsit((ElasticsearchTemplate)this.elasticsearchTemplate, CusAvailablelistEntity.class, (RedissonUtil)this.redissonUtil)) {
            return pageResult;
        }
        BoolQueryBuilder boolQueryBuilder = this.buildBoolQueryBuilder(cusAvailablelistVo);
        if (!StringUtils.isEmpty((Object)cusAvailablelistVo.getProductLevelCode())) {
            List<String> productLevelCodes = this.mdmProductLevelService.getAllChildrenProductLevelCodeList(null, cusAvailablelistVo.getProductLevelCode());
            if (CollectionUtils.isEmpty(productLevelCodes)) {
                return pageResult;
            }
            BoolQueryBuilder productLevelCodeBoolQueryBuilder = QueryBuilders.boolQuery();
            for (String productLevelCode : productLevelCodes) {
                productLevelCodeBoolQueryBuilder.should((QueryBuilder)QueryBuilders.termQuery((String)"productLevelCode.keyword", (String)productLevelCode));
            }
            boolQueryBuilder.must((QueryBuilder)productLevelCodeBoolQueryBuilder);
        }
        if (!StringUtils.isEmpty((Object)cusAvailablelistVo.getProductCode())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"productCode", (Object)cusAvailablelistVo.getProductCode()));
        }
        if (!StringUtils.isEmpty((Object)cusAvailablelistVo.getProductName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"productName", (Object)cusAvailablelistVo.getProductName()));
        }
        if (null != cusAvailablelistVo.getOfenFlag()) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"ofenFlag", (String)cusAvailablelistVo.getOfenFlag().toString()));
        }
        if (CollectionUtils.isEmpty((Collection)(list = (scroll = this.elasticsearchTemplate.queryForPage((SearchQuery)(searchQuery = new NativeSearchQueryBuilder().withIndices(new String[]{"cusavailablelistindex"}).withQuery((QueryBuilder)boolQueryBuilder).withSort(SortBuilders.fieldSort((String)"promotionFlag").unmappedType("keyword").order(SortOrder.DESC)).withPageable((Pageable)PageRequest.of((int)(cusAvailablelistVo.getPageNum() - 1), (int)cusAvailablelistVo.getPageSize())).build()), CusAvailablelistEntity.class)).getContent()))) {
            return pageResult;
        }
        ArrayList<CusAvailablelistVo> reList = new ArrayList<CusAvailablelistVo>(list.size());
        for (CusAvailablelistEntity entity : list) {
            CusAvailablelistVo vo = new CusAvailablelistVo();
            BeanUtils.copyProperties((Object)((Object)entity), (Object)vo);
            reList.add(vo);
        }
        if (!StringUtils.isEmpty((Object)cusAvailablelistVo.getCusCode())) {
            MdmPriceSearchReqVo mdmPriceSearchReqVo = new MdmPriceSearchReqVo();
            mdmPriceSearchReqVo.setProductCodeList(reList.stream().map(MdmProductAdviseRespVo::getProductCode).collect(Collectors.toList()));
            mdmPriceSearchReqVo.setCustomerCode(cusAvailablelistVo.getCusCode());
            mdmPriceSearchReqVo.setConditionTypeCodeList((List)new ArrayList<String>(){
                {
                    this.add("sale_price");
                }
            });
            Map<String, Map<String, MdmPriceResp>> priceMap = this.iMdmPriceSettingService.search(mdmPriceSearchReqVo);
            for (CusAvailablelistVo vo : reList) {
                vo.setPrice(null);
                if (null == priceMap.get(vo.getProductCode()) || null == priceMap.get(vo.getProductCode()).get("sale_price")) continue;
                vo.setPrice(priceMap.get(vo.getProductCode()).get("sale_price").getPrice());
            }
        }
        pageResult.setData(reList);
        pageResult.setCount(Long.valueOf(scroll.getTotalElements()));
        return pageResult;
    }

    @Override
    public void delById(String id) {
        if (StringUtils.isEmpty((Object)id)) {
            return;
        }
        if (!EsUtil.indexExsit((ElasticsearchTemplate)this.elasticsearchTemplate, CusAvailablelistEntity.class, (RedissonUtil)this.redissonUtil)) {
            return;
        }
        Optional optionalCusAvailablelistEntity = this.cusAvailablelistRepositories.findById(id);
        if (!optionalCusAvailablelistEntity.isPresent()) {
            return;
        }
        CusAvailablelistService cusAvailablelistService = (CusAvailablelistService)ContextUtil.getBean(CusAvailablelistService.class);
        cusAvailablelistService.delByIdAndCusCode(id, ((CusAvailablelistEntity)((Object)optionalCusAvailablelistEntity.get())).getCusCode());
    }

    @Override
    @Klock(keys={"cusallock", "#cusCode"}, waitTime=30L, leaseTime=10L)
    public void delByIdAndCusCode(String id, String cusCode) {
        this.cusAvailablelistRepositories.deleteById(id);
    }

    @Override
    public void delByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        if (!EsUtil.indexExsit((ElasticsearchTemplate)this.elasticsearchTemplate, CusAvailablelistEntity.class, (RedissonUtil)this.redissonUtil)) {
            return;
        }
        List<CusAvailablelistEntity> entities = this.cusAvailablelistRepositories.findByIdIn(ids);
        Map<String, List<CusAvailablelistEntity>> entityMap = entities.stream().collect(Collectors.groupingBy(CusAvailablelistEntity::getCusCode));
        CusAvailablelistService cusAvailablelistService = (CusAvailablelistService)ContextUtil.getBean(CusAvailablelistService.class);
        for (Map.Entry<String, List<CusAvailablelistEntity>> entry : entityMap.entrySet()) {
            List<CusAvailablelistEntity> handleEntities = entry.getValue();
            if (CollectionUtils.isEmpty(handleEntities)) continue;
            try {
                cusAvailablelistService.delByIdsAndCusCode(handleEntities.stream().map(UuidVo::getId).collect(Collectors.toList()), entry.getKey());
            }
            catch (Exception e) {
                log.error("\u53ef\u591f\u6e05\u5355\u5220\u9664\u5931\u8d25\uff0c\u5ba2\u6237:" + entry.getKey(), (Throwable)e);
            }
        }
    }

    @Override
    @Klock(keys={"cusallock", "#cusCode"}, waitTime=30L, leaseTime=10L)
    public void delByIdsAndCusCode(List<String> ids, String cusCode) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        this.cusAvailablelistRepositories.deleteByIdIn(ids);
    }

    @Override
    public void updateByGoodsCodes(List<MdmProductAdviseRespVo> mdmProductAdviseRespVos) {
        if (CollectionUtils.isEmpty(mdmProductAdviseRespVos)) {
            log.info("\u53c2\u6570\u4e3a\u7a7a");
            return;
        }
        if (!EsUtil.indexExsit((ElasticsearchTemplate)this.elasticsearchTemplate, CusAvailablelistEntity.class, (RedissonUtil)this.redissonUtil)) {
            log.info("\u6682\u65e0es\u7d22\u5f15");
            return;
        }
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        List goodsCodes = mdmProductAdviseRespVos.stream().map(MdmProductAdviseRespVo::getProductCode).collect(Collectors.toList());
        boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"productCode.keyword", goodsCodes));
        TermsAggregationBuilder aggregationBuilder = ((TermsAggregationBuilder)AggregationBuilders.terms((String)"cusCodes").field("cusCode.keyword")).size(10000);
        NativeSearchQuery searchQuery = new NativeSearchQueryBuilder().withIndices(new String[]{"cusavailablelistindex"}).withQuery((QueryBuilder)boolQueryBuilder).withPageable((Pageable)PageRequest.of((int)0, (int)10)).addAggregation((AbstractAggregationBuilder)aggregationBuilder).build();
        Aggregations aggregations = (Aggregations)this.elasticsearchTemplate.query((SearchQuery)searchQuery, response -> response.getAggregations());
        Aggregation tags = (Aggregation)aggregations.asMap().get("cusCodes");
        Terms teamSum = (Terms)tags;
        List buckets = teamSum.getBuckets();
        ArrayList<String> cusCodes = new ArrayList<String>();
        for (Terms.Bucket bucket : buckets) {
            cusCodes.add(bucket.getKeyAsString());
        }
        if (CollectionUtils.isEmpty(cusCodes)) {
            log.info("\u6682\u65e0\u6d89\u53ca\u5230\u7684\u5ba2\u6237");
            return;
        }
        CusAvailablelistService cusAvailablelistService = (CusAvailablelistService)ContextUtil.getBean(CusAvailablelistService.class);
        for (String cusCode : cusCodes) {
            try {
                cusAvailablelistService.updateGoodsByCusCode(mdmProductAdviseRespVos, cusCode);
            }
            catch (Exception e) {
                log.error("\u53ef\u591f\u6e05\u5355\u66f4\u65b0\u5546\u54c1\u5931\u8d25\uff0c\u5ba2\u6237:" + cusCode, (Throwable)e);
            }
        }
    }

    @Override
    public void delByGoodsCodes(List<String> goodsCodes) {
        if (CollectionUtils.isEmpty(goodsCodes)) {
            log.info("\u53c2\u6570\u4e3a\u7a7a");
            return;
        }
        if (!EsUtil.indexExsit((ElasticsearchTemplate)this.elasticsearchTemplate, CusAvailablelistEntity.class, (RedissonUtil)this.redissonUtil)) {
            log.info("es\u7d22\u5f15\u4e3a\u7a7a");
            return;
        }
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"productCode.keyword", goodsCodes));
        TermsAggregationBuilder aggregationBuilder = ((TermsAggregationBuilder)AggregationBuilders.terms((String)"cusCodes").field("cusCode.keyword")).size(10000);
        NativeSearchQuery searchQuery = new NativeSearchQueryBuilder().withIndices(new String[]{"cusavailablelistindex"}).withQuery((QueryBuilder)boolQueryBuilder).withPageable((Pageable)PageRequest.of((int)0, (int)10)).addAggregation((AbstractAggregationBuilder)aggregationBuilder).build();
        Aggregations aggregations = (Aggregations)this.elasticsearchTemplate.query((SearchQuery)searchQuery, response -> response.getAggregations());
        Aggregation tags = (Aggregation)aggregations.asMap().get("cusCodes");
        Terms teamSum = (Terms)tags;
        List buckets = teamSum.getBuckets();
        ArrayList<String> cusCodes = new ArrayList<String>();
        for (Terms.Bucket bucket : buckets) {
            cusCodes.add(bucket.getKeyAsString());
        }
        if (CollectionUtils.isEmpty(cusCodes)) {
            log.info("\u6682\u65e0\u76f8\u5173\u5ba2\u6237");
        }
        CusAvailablelistService cusAvailablelistService = (CusAvailablelistService)ContextUtil.getBean(CusAvailablelistService.class);
        for (String cusCode : cusCodes) {
            try {
                cusAvailablelistService.delByGoodsCodesAndCusCode(goodsCodes, cusCode);
            }
            catch (Exception e) {
                log.error("\u53ef\u591f\u6e05\u5355\u5220\u9664\u5931\u8d25\uff0c\u5ba2\u6237:" + cusCode, (Throwable)e);
            }
        }
    }

    @Override
    @Klock(keys={"cusallock", "#cusCode"}, waitTime=30L, leaseTime=10L)
    public void delByGoodsCodesAndCusCode(List<String> goodsCodes, String cusCode) {
        this.cusAvailablelistRepositories.deleteByCusCodeAndProductCodeIn(cusCode, goodsCodes);
    }

    @Override
    public PageResult<CusAvailablelistVo> listForM(CusAvailablelistVo cusAvailablelistVo) {
        NativeSearchQuery searchQuery;
        AggregatedPage scroll;
        List list;
        PageResult pageResult = new PageResult();
        pageResult.setCount(Long.valueOf(Long.parseLong("0")));
        pageResult.setData(new ArrayList());
        if (!EsUtil.indexExsit((ElasticsearchTemplate)this.elasticsearchTemplate, CusAvailablelistEntity.class, (RedissonUtil)this.redissonUtil)) {
            return pageResult;
        }
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (!StringUtils.isEmpty((Object)cusAvailablelistVo.getCusCode())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"cusCode.keyword", (String)("*" + cusAvailablelistVo.getCusCode() + "*")));
        }
        if (!StringUtils.isEmpty((Object)cusAvailablelistVo.getCusName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"cusName", (Object)cusAvailablelistVo.getCusName()));
        }
        if (!StringUtils.isEmpty((Object)cusAvailablelistVo.getCusOrgCode())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"cusOrgCode.keyword", (String)("*" + cusAvailablelistVo.getCusOrgCode() + "*")));
        }
        if (!StringUtils.isEmpty((Object)cusAvailablelistVo.getCusOrgName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"cusOrgName", (Object)cusAvailablelistVo.getCusOrgName()));
        }
        if (!StringUtils.isEmpty((Object)cusAvailablelistVo.getCusChannelCode())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"cusChannelCode.keyword", (String)cusAvailablelistVo.getCusChannelCode()));
        }
        if (!StringUtils.isEmpty((Object)cusAvailablelistVo.getCusChannelName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"cusChannelName", (Object)cusAvailablelistVo.getCusChannelName()));
        }
        if (!StringUtils.isEmpty((Object)cusAvailablelistVo.getProductType())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"productType.keyword", (String)cusAvailablelistVo.getProductType()));
        }
        if (!StringUtils.isEmpty((Object)cusAvailablelistVo.getPromotionFlag())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"promotionFlag", (Object)cusAvailablelistVo.getPromotionFlag()));
        }
        if (!StringUtils.isEmpty((Object)cusAvailablelistVo.getProductLevelCode())) {
            List<String> productLevelCodes = this.mdmProductLevelService.getAllChildrenProductLevelCodeList(null, cusAvailablelistVo.getProductLevelCode());
            if (CollectionUtils.isEmpty(productLevelCodes)) {
                return pageResult;
            }
            BoolQueryBuilder productLevelCodeBoolQueryBuilder = QueryBuilders.boolQuery();
            for (String productLevelCode : productLevelCodes) {
                productLevelCodeBoolQueryBuilder.should((QueryBuilder)QueryBuilders.termQuery((String)"productLevelCode.keyword", (String)productLevelCode));
            }
            boolQueryBuilder.must((QueryBuilder)productLevelCodeBoolQueryBuilder);
        }
        if (!StringUtils.isEmpty((Object)cusAvailablelistVo.getProductCode())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"productCode", (Object)cusAvailablelistVo.getProductCode()));
        }
        if (!StringUtils.isEmpty((Object)cusAvailablelistVo.getProductName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"productName", (Object)cusAvailablelistVo.getProductName()));
        }
        if (null != cusAvailablelistVo.getOfenFlag()) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"ofenFlag", (String)cusAvailablelistVo.getOfenFlag().toString()));
        }
        if (CollectionUtils.isEmpty((Collection)(list = (scroll = this.elasticsearchTemplate.queryForPage((SearchQuery)(searchQuery = new NativeSearchQueryBuilder().withIndices(new String[]{"cusavailablelistindex"}).withQuery((QueryBuilder)boolQueryBuilder).withSort(SortBuilders.fieldSort((String)"promotionFlag").unmappedType("keyword").order(SortOrder.DESC)).withPageable((Pageable)PageRequest.of((int)(cusAvailablelistVo.getPageNum() - 1), (int)cusAvailablelistVo.getPageSize())).build()), CusAvailablelistEntity.class)).getContent()))) {
            return pageResult;
        }
        ArrayList<CusAvailablelistVo> reList = new ArrayList<CusAvailablelistVo>(list.size());
        for (CusAvailablelistEntity entity : list) {
            CusAvailablelistVo vo = new CusAvailablelistVo();
            BeanUtils.copyProperties((Object)((Object)entity), (Object)vo);
            reList.add(vo);
        }
        if (reList.size() > 0) {
            Collections.sort(reList, new Comparator<CusAvailablelistVo>(){

                @Override
                public int compare(CusAvailablelistVo o1, CusAvailablelistVo o2) {
                    if (DateUtil.str2Timestamp((String)o1.getCreateDateAll()).compareTo(DateUtil.str2Timestamp((String)o2.getCreateDateAll())) > 0) {
                        return 1;
                    }
                    if (DateUtil.str2Timestamp((String)o1.getCreateDateAll()).compareTo(DateUtil.str2Timestamp((String)o2.getCreateDateAll())) == 0) {
                        return 0;
                    }
                    return -1;
                }
            });
        }
        pageResult.setData(reList);
        pageResult.setCount(Long.valueOf(scroll.getTotalElements()));
        return pageResult;
    }

    @Override
    @Klock(keys={"cusallock", "#cusCode"}, waitTime=30L, leaseTime=10L)
    public void ofenIds(List<String> ids, YesNoEnum.YesNoCodeNumberEnum ofenflag, String cusCode) {
        List<CusAvailablelistEntity> entities = this.cusAvailablelistRepositories.findByIdIn(ids);
        if (CollectionUtils.isEmpty(entities)) {
            return;
        }
        for (CusAvailablelistEntity entity : entities) {
            entity.setOfenFlag(ofenflag.getCode());
        }
        this.cusAvailablelistRepositories.saveAll(entities);
    }

    @Override
    public Map<String, CusAvailablelistVo> findGoodsByCusAndGoodsCodes(List<String> goodsCodes, String cusCode) {
        if (StringUtils.isEmpty((Object)cusCode) || CollectionUtils.isEmpty(goodsCodes)) {
            return new HashMap<String, CusAvailablelistVo>();
        }
        List<CusAvailablelistEntity> entities = this.cusAvailablelistRepositories.findByCusCodeAndProductCodeIn(cusCode, goodsCodes);
        Map<Object, Object> entityMap = new HashMap();
        Map<Object, Object> priceMap = new HashMap();
        if (!CollectionUtils.isEmpty(entities)) {
            MdmPriceSearchReqVo mdmPriceSearchReqVo = new MdmPriceSearchReqVo();
            mdmPriceSearchReqVo.setProductCodeList(entities.stream().map(MdmProductAdviseRespVo::getProductCode).collect(Collectors.toList()));
            mdmPriceSearchReqVo.setCustomerCode(cusCode);
            mdmPriceSearchReqVo.setConditionTypeCodeList((List)new ArrayList<String>(){
                {
                    this.add("sale_price");
                }
            });
            priceMap = this.iMdmPriceSettingService.search(mdmPriceSearchReqVo);
        }
        entityMap = entities.stream().collect(Collectors.toMap(MdmProductAdviseRespVo::getProductCode, Function.identity(), (key1, key2) -> key2));
        HashMap<String, CusAvailablelistVo> reMap = new HashMap<String, CusAvailablelistVo>(goodsCodes.size());
        for (String goodsCode : goodsCodes) {
            CusAvailablelistEntity entity = (CusAvailablelistEntity)((Object)entityMap.get(goodsCode));
            CusAvailablelistVo vo = null;
            if (entity != null) {
                vo = new CusAvailablelistVo();
                BeanUtils.copyProperties((Object)((Object)entity), (Object)vo);
                if (priceMap.get(goodsCode) == null || null == ((Map)priceMap.get(goodsCode)).get("sale_price")) {
                    vo.setPrice(null);
                } else {
                    vo.setPrice(((MdmPriceResp)((Map)priceMap.get(goodsCode)).get("sale_price")).getPrice());
                }
            }
            reMap.put(goodsCode, vo);
        }
        return reMap;
    }

    @Override
    public CusAvailablelistVo findById(String id) {
        Optional optionalCusAvailablelistEntity = this.cusAvailablelistRepositories.findById(id);
        if (!optionalCusAvailablelistEntity.isPresent()) {
            return null;
        }
        CusAvailablelistEntity entity = (CusAvailablelistEntity)((Object)optionalCusAvailablelistEntity.get());
        CusAvailablelistVo vo = new CusAvailablelistVo();
        BeanUtils.copyProperties((Object)((Object)entity), (Object)vo);
        return vo;
    }

    @Override
    public Map<String, Object> findGoodsDetailAndPromotionByCode(String goodsCode, String cusCode) {
        ValidateUtils.validate((Object)cusCode, (String)"\u8bf7\u767b\u5f55!");
        HashMap<String, Object> reMap = new HashMap<String, Object>();
        reMap.put("goods", null);
        reMap.put("promotion", null);
        if (StringUtils.isEmpty((Object)goodsCode)) {
            return reMap;
        }
        List<CusAvailablelistEntity> entities = this.cusAvailablelistRepositories.findByCusCodeAndProductCode(cusCode, goodsCode);
        if (CollectionUtils.isEmpty(entities)) {
            return reMap;
        }
        CusAvailablelistVo vo = new CusAvailablelistVo();
        BeanUtils.copyProperties((Object)((Object)entities.get(0)), (Object)vo);
        vo.setSaleUnitName(DictUtil.dictValue((String)"product_sale_unit", (String)vo.getSaleUnit()));
        reMap.put("goods", vo);
        MdmPriceSearchReqVo mdmPriceSearchReqVo = new MdmPriceSearchReqVo();
        mdmPriceSearchReqVo.setProductCodeList(Arrays.asList(goodsCode));
        mdmPriceSearchReqVo.setCustomerCode(cusCode);
        mdmPriceSearchReqVo.setConditionTypeCodeList((List)new ArrayList<String>(){
            {
                this.add("sale_price");
            }
        });
        Map<String, Map<String, MdmPriceResp>> priceMap = this.iMdmPriceSettingService.search(mdmPriceSearchReqVo);
        vo.setPrice(null);
        if (null != priceMap.get(goodsCode) && null != priceMap.get(goodsCode).get("sale_price")) {
            vo.setPrice(priceMap.get(goodsCode).get("sale_price").getPrice());
        }
        PromotionQueryReq req = new PromotionQueryReq();
        req.setAccountType("customer");
        req.setAccountCode(cusCode);
        ArrayList<PromotionSaleProductVo> saleProductVos = new ArrayList<PromotionSaleProductVo>();
        PromotionSaleProductVo product = new PromotionSaleProductVo();
        product.setProductCode(goodsCode);
        saleProductVos.add(product);
        req.setSaleProductVos(saleProductVos);
        reMap.put("promotion", ApiResultUtil.objResult((Result)this.promotionV2Feign.findAvailablePromotionsByAccount(req)));
        return reMap;
    }

    @Override
    public CusAvailablelistVo findGoodsDetailByCode(String goodsCode, String cusCode) {
        ValidateUtils.validate((Object)cusCode, (String)"\u8bf7\u767b\u5f55!");
        if (StringUtils.isEmpty((Object)goodsCode)) {
            return null;
        }
        List<CusAvailablelistEntity> entities = this.cusAvailablelistRepositories.findByCusCodeAndProductCode(cusCode, goodsCode);
        if (CollectionUtils.isEmpty(entities)) {
            return null;
        }
        CusAvailablelistVo vo = new CusAvailablelistVo();
        BeanUtils.copyProperties((Object)((Object)entities.get(0)), (Object)vo);
        vo.setSaleUnitName(DictUtil.dictValue((String)"product_sale_unit", (String)vo.getSaleUnit()));
        MdmPriceSearchReqVo mdmPriceSearchReqVo = new MdmPriceSearchReqVo();
        mdmPriceSearchReqVo.setProductCodeList(Arrays.asList(goodsCode));
        mdmPriceSearchReqVo.setCustomerCode(cusCode);
        mdmPriceSearchReqVo.setConditionTypeCodeList((List)new ArrayList<String>(){
            {
                this.add("sale_price");
            }
        });
        Map<String, Map<String, MdmPriceResp>> priceMap = this.iMdmPriceSettingService.search(mdmPriceSearchReqVo);
        vo.setPrice(null);
        if (null != priceMap.get(goodsCode) && priceMap.get(goodsCode).get("sale_price") != null) {
            vo.setPrice(priceMap.get(goodsCode).get("sale_price").getPrice());
        }
        return vo;
    }

    @Override
    @Klock(keys={"cusallock", "#cusCode"}, waitTime=30L, leaseTime=10L)
    public void updateGoodsByCusCode(List<MdmProductAdviseRespVo> mdmProductAdviseRespVos, String cusCode) {
        if (!EsUtil.indexExsit((ElasticsearchTemplate)this.elasticsearchTemplate, CusAvailablelistEntity.class, (RedissonUtil)this.redissonUtil)) {
            log.info("\u6682\u65e0es\u7d22\u5f15");
            return;
        }
        List<CusAvailablelistEntity> cusAvailablelistEntities = this.cusAvailablelistRepositories.findByProductCodeInAndCusCode((mdmProductAdviseRespVos = mdmProductAdviseRespVos.stream().filter(vo -> !StringUtils.isEmpty((Object)vo.getProductCode())).collect(Collectors.toList())).stream().map(MdmProductAdviseRespVo::getProductCode).collect(Collectors.toList()), cusCode);
        if (CollectionUtils.isEmpty(cusAvailablelistEntities)) {
            log.info("\u6682\u65e0\u8bbe\u8ba1\u5230\u7684\u53ef\u591f\u6e05\u5355");
            return;
        }
        Map<String, MdmProductAdviseRespVo> goodsMap = mdmProductAdviseRespVos.stream().collect(Collectors.toMap(MdmProductAdviseRespVo::getProductCode, a -> a, (k1, k2) -> k1));
        int pageSize = 500;
        int total = cusAvailablelistEntities.size();
        ArrayList<CusAvailablelistEntity> entities = new ArrayList<CusAvailablelistEntity>(pageSize);
        for (int i = 0; i < total; ++i) {
            CusAvailablelistEntity entity = cusAvailablelistEntities.get(i);
            MdmProductAdviseRespVo vo2 = goodsMap.get(entity.getProductCode());
            if (null != vo2) {
                entity = CusAvailablelistUtil.copyGoodsVo(entity, vo2);
                entities.add(entity);
            } else {
                log.info("{}\u4ea7\u54c1\u6ca1\u6709\u67e5\u8be2\u5230", (Object)entity.getProductCode());
            }
            if (entities.size() <= 0 || entities.size() != pageSize && i != total - 1) continue;
            this.cusAvailablelistRepositories.deleteByIdIn(entities.stream().map(UuidVo::getId).collect(Collectors.toList()));
            this.cusAvailablelistRepositories.saveAll(entities);
            entities.clear();
        }
        this.elasticsearchTemplate.refresh("cusavailablelistindex");
    }
}

