/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.function.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.biz.crm.function.mapper.MdmFunctionRoleMapper;
import com.biz.crm.function.model.MdmFunctionRoleEntity;
import com.biz.crm.function.service.MdmFunctionRoleService;
import com.biz.crm.nebular.mdm.functionrole.MdmFunctionRoleReqVo;
import com.biz.crm.nebular.mdm.functionrole.MdmFunctionRoleRespVo;
import com.biz.crm.util.CrmBeanUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
@ConditionalOnMissingBean(name={"MdmFunctionRoleServiceExpandImpl"})
public class MdmFunctionRoleServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmFunctionRoleMapper, MdmFunctionRoleEntity>
implements MdmFunctionRoleService {
    private static final Logger log = LoggerFactory.getLogger(MdmFunctionRoleServiceImpl.class);
    @Resource
    private MdmFunctionRoleMapper mdmFunctionRoleMapper;

    @Override
    public PageResult<MdmFunctionRoleRespVo> findList(MdmFunctionRoleReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<MdmFunctionRoleRespVo> list = this.mdmFunctionRoleMapper.findList((Page<MdmFunctionRoleRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public MdmFunctionRoleRespVo query(MdmFunctionRoleReqVo reqVo) {
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(MdmFunctionRoleReqVo reqVo) {
        MdmFunctionRoleEntity entity = (MdmFunctionRoleEntity)CrmBeanUtil.copy((Object)reqVo, MdmFunctionRoleEntity.class);
        this.save(entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(MdmFunctionRoleReqVo reqVo) {
        MdmFunctionRoleEntity entity = (MdmFunctionRoleEntity)this.getById((Serializable)((Object)reqVo.getId()));
        this.updateById(entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByRoleCodeList(List<String> roleCodeList) {
        if (CollectionUtils.isEmpty(roleCodeList)) {
            return;
        }
        ((LambdaUpdateChainWrapper)this.lambdaUpdate().in(MdmFunctionRoleEntity::getRoleCode, roleCodeList)).remove();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(MdmFunctionRoleReqVo reqVo) {
        this.removeById((Serializable)((Object)reqVo.getId()));
    }

    @Override
    public List<String> findFunctionCodeByRole(String roleCode) {
        Assert.hasText((String)roleCode, (String)"\u89d2\u8272\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        return ((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmFunctionRoleEntity::getRoleCode, (Object)roleCode)).list().stream().filter(x -> x != null && !StringUtils.isEmpty((Object)x.getFunctionCode())).map(MdmFunctionRoleEntity::getFunctionCode).collect(Collectors.toList());
    }

    @Override
    public List<String> findFunctionCodeByRole(List<String> roleCodeList) {
        if (CollectionUtils.isEmpty(roleCodeList)) {
            return new ArrayList<String>();
        }
        return ((LambdaQueryChainWrapper)this.lambdaQuery().in(MdmFunctionRoleEntity::getRoleCode, roleCodeList)).list().stream().filter(x -> !StringUtils.isEmpty((Object)x.getFunctionCode())).map(MdmFunctionRoleEntity::getFunctionCode).collect(Collectors.toList());
    }

    @Override
    public List<String> findRoleCodeByFunction(String functionCode) {
        Assert.hasText((String)functionCode, (String)"\u83dc\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        return ((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmFunctionRoleEntity::getFunctionCode, (Object)functionCode)).list().stream().filter(x -> !StringUtils.isEmpty((Object)x.getRoleCode())).map(MdmFunctionRoleEntity::getRoleCode).collect(Collectors.toList());
    }

    @Override
    public void update(String roleCode, List<String> functionCodeList) {
        Assert.hasText((String)roleCode, (String)"\u89d2\u8272\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        ((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmFunctionRoleEntity::getRoleCode, (Object)roleCode)).remove();
        if (CollectionUtils.isEmpty(functionCodeList)) {
            return;
        }
        List collect = functionCodeList.stream().map(x -> {
            MdmFunctionRoleEntity mdmFunctionRoleEntity = new MdmFunctionRoleEntity();
            mdmFunctionRoleEntity.setFunctionCode(x);
            mdmFunctionRoleEntity.setRoleCode(roleCode);
            mdmFunctionRoleEntity.setId(UUID.randomUUID().toString());
            return mdmFunctionRoleEntity;
        }).collect(Collectors.toList());
        this.saveBatch(collect);
    }

    @Override
    public List<MdmFunctionRoleEntity> findFunctionCodeByPositionCode(String positionCode) {
        if (StringUtils.isEmpty((Object)positionCode)) {
            return new ArrayList<MdmFunctionRoleEntity>();
        }
        return this.mdmFunctionRoleMapper.findFunctionCodeByPositionCode(positionCode);
    }
}

