/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.pricesetting.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.crmlog.handle.util.CrmLogSendUtil;
import com.biz.crm.customer.service.MdmCustomerMsgService;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.mdm.PriceSettingFieldEnum;
import com.biz.crm.eunm.mdm.PriceSettingStatusEnum;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgSelectRespVo;
import com.biz.crm.nebular.mdm.pricesetting.req.MdmPriceSearchQueryVo;
import com.biz.crm.nebular.mdm.pricesetting.req.MdmPriceSearchReqVo;
import com.biz.crm.nebular.mdm.pricesetting.req.MdmPriceSettingReqVo;
import com.biz.crm.nebular.mdm.pricesetting.resp.MdmPriceConditionGroupRelFieldRespVo;
import com.biz.crm.nebular.mdm.pricesetting.resp.MdmPriceResp;
import com.biz.crm.nebular.mdm.pricesetting.resp.MdmPriceSettingRespVo;
import com.biz.crm.nebular.mdm.product.req.MdmProductReqVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductRespVo;
import com.biz.crm.pricesetting.mapper.MdmPriceSettingMapper;
import com.biz.crm.pricesetting.model.MdmPriceConditionGroupRelFieldEntity;
import com.biz.crm.pricesetting.model.MdmPriceSettingEntity;
import com.biz.crm.pricesetting.service.IMdmPriceSettingService;
import com.biz.crm.pricesetting.service.MdmPriceConditionGroupRelFieldService;
import com.biz.crm.pricesetting.service.MdmPriceConditionTypeRelGroupService;
import com.biz.crm.pricesetting.service.impl.MdmPriceSettingServiceHelper;
import com.biz.crm.product.service.MdmProductService;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.StringUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

@Service
@ConditionalOnMissingBean(name={"MdmPriceSettingServiceExpandImpl"})
public class MdmPriceSettingServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmPriceSettingMapper, MdmPriceSettingEntity>
implements IMdmPriceSettingService {
    private static final Logger log = LoggerFactory.getLogger(MdmPriceSettingServiceImpl.class);
    @Resource
    private MdmPriceSettingMapper mdmPriceSettingMapper;
    @Resource
    private MdmPriceSettingServiceHelper mdmPriceSettingServiceHelper;
    @Resource
    private MdmProductService mdmProductService;
    @Resource
    private MdmCustomerMsgService mdmCustomerMsgService;
    @Resource
    private MdmPriceConditionGroupRelFieldService mdmPriceConditionGroupRelFieldService;
    private final String DATE_REGEX = "^((([0-9]{3}[1-9]|[0-9]{2}[1-9][0-9]{1}|[0-9]{1}[1-9][0-9]{2}|[1-9][0-9]{3})-(((0[13578]|1[02])-(0[1-9]|[12][0-9]|3[01]))|((0[469]|11)-(0[1-9]|[12][0-9]|30))|(02-(0[1-9]|[1][0-9]|2[0-8]))))|((([0-9]{2})(0[48]|[2468][048]|[13579][26])|((0[48]|[2468][048]|[3579][26])00))-02-29))$";
    @Resource
    private MdmPriceConditionTypeRelGroupService mdmPriceConditionTypeRelGroupService;
    @Resource
    private IMdmPriceSettingService mdmPriceSettingService;
    @Resource
    private CrmLogSendUtil crmLogSendUtil;

    @Override
    @CrmDictMethod
    public PageResult<MdmPriceSettingRespVo> findList(MdmPriceSettingReqVo reqVo) {
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<MdmPriceSettingRespVo> list = this.mdmPriceSettingMapper.findList((Page<MdmPriceSettingRespVo>)page, reqVo);
        if (!CollectionUtils.isEmpty(list)) {
            String now = LocalDate.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
            for (MdmPriceSettingRespVo mdmPriceSettingRespVo : list) {
                String beginDate = mdmPriceSettingRespVo.getBeginDate();
                String endDate = mdmPriceSettingRespVo.getEndDate();
                if (StringUtils.isEmpty((String)beginDate) || StringUtils.isEmpty((String)endDate)) continue;
                if (endDate.compareTo(now) < 0 && beginDate.compareTo(now) < 0) {
                    mdmPriceSettingRespVo.setPriceStateName(PriceSettingStatusEnum.EXPIRED.getDes());
                }
                if (endDate.compareTo(now) > 0 && endDate.compareTo(now) > 0) {
                    mdmPriceSettingRespVo.setPriceStateName(PriceSettingStatusEnum.TO_BE_EFFECTIVE.getDes());
                }
                if (endDate.compareTo(now) < 0 || beginDate.compareTo(now) > 0) continue;
                mdmPriceSettingRespVo.setPriceStateName(PriceSettingStatusEnum.IN_EFFECT.getDes());
            }
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public Boolean checkTimeTruncation(MdmPriceSettingReqVo reqVo) {
        Integer count;
        String priceSettingCode = reqVo.getPriceSettingCode();
        if (!StringUtils.isEmpty((String)priceSettingCode) && (count = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmPriceSettingEntity::getPriceSettingCode, (Object)reqVo.getPriceSettingCode())).count()) != null && count > 0) {
            return true;
        }
        return this.mdmPriceSettingServiceHelper.checkTimeTruncation(reqVo);
    }

    @Override
    @CrmDictMethod
    public MdmPriceSettingRespVo query(MdmPriceSettingReqVo reqVo) {
        List list;
        MdmProductRespVo mdmProductRespVo;
        AssertUtils.isNotEmpty((String)reqVo.getId(), (String)"\u67e5\u8be2\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        MdmPriceSettingEntity mdmPriceSettingEntity = (MdmPriceSettingEntity)this.mdmPriceSettingMapper.selectById((Serializable)((Object)reqVo.getId()));
        if (ObjectUtils.isEmpty((Object)mdmPriceSettingEntity)) {
            return null;
        }
        MdmPriceSettingRespVo mdmPriceSettingRespVo = (MdmPriceSettingRespVo)CrmBeanUtil.copy((Object)mdmPriceSettingEntity, MdmPriceSettingRespVo.class);
        if (StringUtils.isNotEmpty((String)mdmPriceSettingRespVo.getProductCode()) && !ObjectUtils.isEmpty((Object)(mdmProductRespVo = this.mdmProductService.detail(null, mdmPriceSettingRespVo.getProductCode())))) {
            mdmPriceSettingRespVo.setMdmProductRespVo(mdmProductRespVo);
        }
        ArrayList mdmPriceConditionGroupRelFieldRespVoList = new ArrayList();
        if (StringUtils.isNotEmpty((String)mdmPriceSettingEntity.getConditionGroupCode()) && (list = ((LambdaQueryChainWrapper)this.mdmPriceConditionGroupRelFieldService.lambdaQuery().eq(MdmPriceConditionGroupRelFieldEntity::getConditionGroupCode, (Object)mdmPriceSettingEntity.getConditionGroupCode())).select(new SFunction[]{MdmPriceConditionGroupRelFieldEntity::getConditionGroupCode, MdmPriceConditionGroupRelFieldEntity::getFieldCode, MdmPriceConditionGroupRelFieldEntity::getFieldName}).list()) != null) {
            mdmPriceConditionGroupRelFieldRespVoList.addAll(CrmBeanUtil.copyList((List)list, MdmPriceConditionGroupRelFieldRespVo.class));
        }
        mdmPriceSettingRespVo.setMdmPriceConditionGroupRelFieldRespVos(mdmPriceConditionGroupRelFieldRespVoList);
        return mdmPriceSettingRespVo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(MdmPriceSettingReqVo reqVo) {
        this.mdmPriceSettingServiceHelper.saveCheck(reqVo);
        this.mdmPriceSettingServiceHelper.dataUniqueSaveOrUpdate(reqVo);
    }

    @Override
    public Boolean checkDate(MdmPriceSettingReqVo mdmPriceSettingReqVo) {
        this.mdmPriceSettingServiceHelper.saveCheck(mdmPriceSettingReqVo);
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"condition_type_code", (Object)mdmPriceSettingReqVo.getConditionTypeCode());
        wrapper.eq((Object)"condition_group_code", (Object)mdmPriceSettingReqVo.getConditionGroupCode());
        this.mdmPriceSettingServiceHelper.setFieldCondition((QueryWrapper<MdmPriceSettingEntity>)wrapper, mdmPriceSettingReqVo);
        List mdmPriceSettingEntities = this.mdmPriceSettingMapper.selectList((Wrapper)wrapper);
        boolean flag = false;
        if (CollectionUtil.listNotEmpty((List)mdmPriceSettingEntities)) {
            long dateStart = DateUtil.str2Date((String)mdmPriceSettingReqVo.getBeginDate().trim().concat(" ").concat(mdmPriceSettingReqVo.getBeginDateSecond()), (SimpleDateFormat)DateUtil.datetimeFormat).getTime();
            long dateEnd = DateUtil.str2Date((String)mdmPriceSettingReqVo.getEndDate().trim().concat(" ").concat(mdmPriceSettingReqVo.getEndDateSecond()), (SimpleDateFormat)DateUtil.datetimeFormat).getTime();
            for (MdmPriceSettingEntity entity : mdmPriceSettingEntities) {
                if (StringUtils.isNotEmpty((String)mdmPriceSettingReqVo.getId()) && mdmPriceSettingReqVo.getId().equalsIgnoreCase(entity.getId())) continue;
                long oldStart = DateUtil.str2Date((String)entity.getBeginDate().trim().concat(" ").concat(entity.getBeginDateSecond()), (SimpleDateFormat)DateUtil.datetimeFormat).getTime();
                long oldEnd = DateUtil.str2Date((String)entity.getEndDate().trim().concat(" ").concat(entity.getEndDateSecond()), (SimpleDateFormat)DateUtil.datetimeFormat).getTime();
                if (dateEnd < oldStart || dateStart > oldEnd) continue;
                flag = true;
                break;
            }
        }
        return flag;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(MdmPriceSettingReqVo reqVo) {
        this.mdmPriceSettingServiceHelper.saveCheck(reqVo);
        this.mdmPriceSettingServiceHelper.dataUniqueSaveOrUpdate(reqVo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(MdmPriceSettingReqVo reqVo) {
        AssertUtils.isNotEmpty((Collection)reqVo.getIds(), (String)"\u5220\u9664\u7f16\u7801\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        List mdmPriceSettingEntities = this.mdmPriceSettingMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)mdmPriceSettingEntities)) {
            this.mdmPriceSettingMapper.deleteBatchIds(reqVo.getIds());
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(MdmPriceSettingReqVo reqVo) {
        List ids = reqVo.getIds();
        Assert.notEmpty((Collection)ids, (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(BaseIdEntity::getId, (Collection)ids)).list();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        List collect = list.stream().filter(x -> !CrmEnableStatusEnum.ENABLE.getCode().equals(x.getEnableStatus())).map(BaseIdEntity::getId).collect(Collectors.toList());
        List entities = list.stream().filter(x -> !CrmEnableStatusEnum.ENABLE.getCode().equals(x.getEnableStatus())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(collect)) {
            return;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(BaseIdEntity::getId, collect)).set(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).update();
        Object menuCodeObj = ThreadLocalUtil.getObj((String)"menuCode");
        if (menuCodeObj != null) {
            for (MdmPriceSettingEntity entity : entities) {
                MdmPriceSettingEntity newEntity = (MdmPriceSettingEntity)CrmBeanUtil.copy(entities, MdmPriceSettingEntity.class);
                newEntity.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
                this.crmLogSendUtil.sendForUpdate(menuCodeObj.toString(), entity.getId(), entity.getId(), (Object)entity, (Object)newEntity);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(MdmPriceSettingReqVo reqVo) {
        List ids = reqVo.getIds();
        Assert.notEmpty((Collection)ids, (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(BaseIdEntity::getId, (Collection)ids)).list();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        List collect = list.stream().filter(x -> !CrmEnableStatusEnum.DISABLE.getCode().equals(x.getEnableStatus())).map(BaseIdEntity::getId).collect(Collectors.toList());
        List entities = list.stream().filter(x -> !CrmEnableStatusEnum.DISABLE.getCode().equals(x.getEnableStatus())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(collect)) {
            return;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(BaseIdEntity::getId, collect)).set(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.DISABLE.getCode())).update();
        Object menuCodeObj = ThreadLocalUtil.getObj((String)"menuCode");
        if (menuCodeObj != null) {
            for (MdmPriceSettingEntity entity : entities) {
                MdmPriceSettingEntity newEntity = (MdmPriceSettingEntity)CrmBeanUtil.copy(entities, MdmPriceSettingEntity.class);
                newEntity.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
                this.crmLogSendUtil.sendForUpdate(menuCodeObj.toString(), entity.getId(), entity.getId(), (Object)entity, (Object)newEntity);
            }
        }
    }

    @Override
    public Map<String, BigDecimal> findPriceByGoodsAndCusCode(List<String> goodsCodes, String cusCodes) {
        HashMap<String, BigDecimal> reMap = new HashMap<String, BigDecimal>();
        if (org.springframework.util.CollectionUtils.isEmpty(goodsCodes)) {
            return reMap;
        }
        for (String goodsCode : goodsCodes) {
            reMap.put(goodsCode, BigDecimal.ONE);
        }
        String salePrice = "sale_price";
        MdmPriceSearchReqVo searchReqVo = new MdmPriceSearchReqVo();
        searchReqVo.setCustomerCode(cusCodes);
        searchReqVo.setProductCodeList(goodsCodes);
        searchReqVo.setSearchTime(DateUtil.dateNow2Str());
        searchReqVo.setConditionTypeCodeList(Collections.singletonList("sale_price"));
        Map<String, Map<String, MdmPriceResp>> productMap = this.mdmPriceSettingService.search(searchReqVo);
        for (Map.Entry<String, Map<String, MdmPriceResp>> entry : productMap.entrySet()) {
            BigDecimal price = BigDecimal.ZERO;
            Map<String, MdmPriceResp> priceTypeMap = entry.getValue();
            if (priceTypeMap != null && priceTypeMap.get("sale_price") != null) {
                price = priceTypeMap.get("sale_price").getPrice();
            }
            reMap.put(entry.getKey(), price);
        }
        return reMap;
    }

    @Override
    public List<MdmCustomerMsgSelectRespVo> findCustomerSelectList(MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        mdmCustomerMsgReqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        return this.mdmCustomerMsgService.list(mdmCustomerMsgReqVo);
    }

    @Override
    public List<MdmProductRespVo> findProductSelectList(MdmProductReqVo mdmProductReqVo) {
        return CrmBeanUtil.copyList((List)this.mdmProductService.list(), MdmProductRespVo.class);
    }

    @Override
    public Map<String, Map<String, MdmPriceResp>> search(MdmPriceSearchReqVo mdmPriceSearchReqVo) {
        String customerCode = mdmPriceSearchReqVo.getCustomerCode();
        Assert.hasText((String)customerCode, (String)"\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        MdmCustomerMsgRespVo mdmCustomerMsgRespVo = this.mdmCustomerMsgService.query(null, customerCode);
        if (mdmCustomerMsgRespVo == null) {
            return Collections.emptyMap();
        }
        String orgCode = mdmCustomerMsgRespVo.getOrgCode();
        if (!StringUtils.isEmpty((String)orgCode)) {
            mdmPriceSearchReqVo.setOrgCode(orgCode.split(",")[0]);
        }
        mdmPriceSearchReqVo.setChannel(mdmCustomerMsgRespVo.getChannel());
        mdmPriceSearchReqVo.setPriceGroup(mdmCustomerMsgRespVo.getPriceGroup());
        return this.inquiry(mdmPriceSearchReqVo);
    }

    @Override
    public MdmPriceSettingRespVo queryUnique(MdmPriceSettingReqVo mdmPriceSettingReqVo) {
        MdmPriceSettingRespVo mdmPriceSettingRespVo = new MdmPriceSettingRespVo();
        QueryWrapper<MdmPriceSettingEntity> wrapper = this.mdmPriceSettingServiceHelper.wrapperCondition(mdmPriceSettingReqVo);
        if (wrapper.isEmptyOfWhere()) {
            mdmPriceSettingRespVo.setErrorMsg("\u5f53\u524d\u7ef4\u5ea6\u5305\u542b\u591a\u6761\u4ef7\u683c\u6570\u636e");
            return mdmPriceSettingRespVo;
        }
        List mdmPriceSettingEntities = this.mdmPriceSettingMapper.selectList((Wrapper)wrapper);
        if (CollectionUtils.isEmpty((Collection)mdmPriceSettingEntities)) {
            mdmPriceSettingRespVo.setErrorMsg("\u5f53\u524d\u7ef4\u5ea6\u4e0d\u5b58\u5728\u4ef7\u683c\u6570\u636e");
            return mdmPriceSettingRespVo;
        }
        if (mdmPriceSettingEntities.size() > 1) {
            mdmPriceSettingRespVo.setErrorMsg("\u5f53\u524d\u7ef4\u5ea6\u5305\u542b\u591a\u6761\u4ef7\u683c\u6570\u636e");
            return mdmPriceSettingRespVo;
        }
        return (MdmPriceSettingRespVo)CrmBeanUtil.copy(mdmPriceSettingEntities.get(0), MdmPriceSettingRespVo.class);
    }

    protected boolean conditionTypeMatch(MdmCustomerMsgRespVo mdmCustomerMsgRespVo, MdmPriceResp priceResp, String field) {
        switch (PriceSettingFieldEnum.match((String)field)) {
            case CUSTOMER_CODE: {
                String priceCustomerCode = priceResp.getCustomerCode();
                return !StringUtils.isEmpty((String)priceCustomerCode) && priceCustomerCode.equals(mdmCustomerMsgRespVo.getCustomerCode());
            }
            case ORG_CODE: {
                String priceOrgCode = priceResp.getOrgCode();
                return !StringUtils.isEmpty((String)priceOrgCode) && priceOrgCode.equals(mdmCustomerMsgRespVo.getOrgCode());
            }
            case CHANNEL: {
                String priceChannel = priceResp.getChannel();
                return !StringUtils.isEmpty((String)priceChannel) && priceChannel.equals(mdmCustomerMsgRespVo.getChannel());
            }
            case PRODUCT_CODE: {
                return true;
            }
        }
        return false;
    }

    protected boolean conditionTypeMatch(MdmPriceSearchReqVo mdmPriceSearchReqVo, MdmPriceResp priceResp, String field) {
        switch (PriceSettingFieldEnum.match((String)field)) {
            case CUSTOMER_CODE: {
                return !StringUtils.isEmpty((String)priceResp.getCustomerCode()) && priceResp.getCustomerCode().equals(mdmPriceSearchReqVo.getCustomerCode());
            }
            case ORG_CODE: {
                return !StringUtils.isEmpty((String)priceResp.getOrgCode()) && priceResp.getOrgCode().equals(mdmPriceSearchReqVo.getOrgCode());
            }
            case CHANNEL: {
                return !StringUtils.isEmpty((String)priceResp.getChannel()) && priceResp.getChannel().equals(mdmPriceSearchReqVo.getChannel());
            }
            case PRODUCT_CODE: {
                return true;
            }
            case TERMINAL: {
                return !StringUtils.isEmpty((String)priceResp.getTerminalCode()) && priceResp.getTerminalCode().equals(mdmPriceSearchReqVo.getTerminalCode());
            }
            case PRICE_GROUP: {
                return !StringUtils.isEmpty((String)priceResp.getPriceGroup()) && priceResp.getPriceGroup().equals(mdmPriceSearchReqVo.getPriceGroup());
            }
        }
        return false;
    }

    @Override
    public Map<String, Map<String, MdmPriceResp>> inquiry(MdmPriceSearchReqVo mdmPriceSearchReqVo) {
        List productCodeList = mdmPriceSearchReqVo.getProductCodeList();
        if (CollectionUtils.isEmpty((Collection)productCodeList)) {
            return Collections.emptyMap();
        }
        List conditionTypeCodeList = mdmPriceSearchReqVo.getConditionTypeCodeList();
        if (CollectionUtils.isEmpty((Collection)conditionTypeCodeList)) {
            return Collections.emptyMap();
        }
        String searchTime = mdmPriceSearchReqVo.getSearchTime();
        if (StringUtils.isEmpty((String)searchTime)) {
            mdmPriceSearchReqVo.setSearchTime(LocalDate.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        } else {
            Assert.isTrue((boolean)searchTime.matches("^((([0-9]{3}[1-9]|[0-9]{2}[1-9][0-9]{1}|[0-9]{1}[1-9][0-9]{2}|[1-9][0-9]{3})-(((0[13578]|1[02])-(0[1-9]|[12][0-9]|3[01]))|((0[469]|11)-(0[1-9]|[12][0-9]|30))|(02-(0[1-9]|[1][0-9]|2[0-8]))))|((([0-9]{2})(0[48]|[2468][048]|[13579][26])|((0[48]|[2468][048]|[3579][26])00))-02-29))$"), (String)"\u65f6\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
        Map<String, Map<String, MdmPriceResp>> priceMap = productCodeList.stream().filter(x -> !StringUtils.isEmpty((String)x)).distinct().collect(Collectors.toMap(x -> x, x -> new HashMap()));
        List<MdmPriceResp> list = this.searchProductList(mdmPriceSearchReqVo);
        log.info("[\u4ef7\u683c\u7ef4\u62a4][\u4ef7\u683c\u6570\u636e]:{}", list);
        if (CollectionUtils.isEmpty(list)) {
            return priceMap;
        }
        Map<String, List<List<String>>> fieldListMap = this.mdmPriceConditionTypeRelGroupService.groupList(conditionTypeCodeList);
        log.info("[\u4ef7\u683c\u7ef4\u62a4][\u9ad8\u4f18\u5148\u7ea7\u5206\u7c7b\u7f16\u7801]:{}", fieldListMap);
        if (ObjectUtils.isEmpty(fieldListMap)) {
            return priceMap;
        }
        return list.stream().collect(Collectors.groupingBy(MdmPriceResp::getProductCode, Collectors.collectingAndThen(Collectors.toList(), x -> {
            if (CollectionUtils.isEmpty((Collection)x)) {
                return null;
            }
            return x.stream().filter(k -> k != null && !StringUtils.isEmpty((String)k.getConditionTypeCode())).filter(k -> fieldListMap.containsKey(k.getConditionTypeCode())).collect(Collectors.groupingBy(MdmPriceResp::getConditionTypeCode, Collectors.collectingAndThen(Collectors.toList(), conditionTypePriceList -> {
                if (CollectionUtils.isEmpty((Collection)conditionTypePriceList)) {
                    return null;
                }
                return conditionTypePriceList.stream().filter(priceResp -> {
                    String conditionTypeCode = priceResp.getConditionTypeCode();
                    List typeFieldList = (List)fieldListMap.get(conditionTypeCode);
                    if (!CollectionUtils.isEmpty((Collection)typeFieldList)) {
                        for (int i = 0; i < typeFieldList.size(); ++i) {
                            boolean b;
                            List fieldList = (List)typeFieldList.get(i);
                            if (CollectionUtils.isEmpty((Collection)fieldList) || !(b = fieldList.stream().allMatch(field -> this.conditionTypeMatch(mdmPriceSearchReqVo, (MdmPriceResp)priceResp, (String)field)))) continue;
                            priceResp.setFilterSort(Integer.valueOf(i));
                            return true;
                        }
                    }
                    return false;
                }).min(Comparator.comparing(p -> Optional.ofNullable(p.getFilterSort()).orElse(100))).orElse(null);
            })));
        })));
    }

    protected List<MdmPriceResp> searchProductList(MdmPriceSearchReqVo mdmPriceSearchReqVo) {
        MdmPriceSearchQueryVo mdmPriceSearchQueryVo = new MdmPriceSearchQueryVo();
        mdmPriceSearchQueryVo.setProductCodeList(mdmPriceSearchReqVo.getProductCodeList());
        mdmPriceSearchQueryVo.setConditionTypeCodeList(mdmPriceSearchReqVo.getConditionTypeCodeList());
        mdmPriceSearchQueryVo.setSearchTime(mdmPriceSearchReqVo.getSearchTime());
        mdmPriceSearchQueryVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        return this.mdmPriceSettingMapper.search(mdmPriceSearchQueryVo);
    }
}

