/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.user.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BusinessException;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.nebular.mdm.user.resp.MdmUserRelCustomerRespVo;
import com.biz.crm.user.mapper.MdmUserRelCustomerMapper;
import com.biz.crm.user.model.MdmUserRelCustomerEntity;
import com.biz.crm.user.service.MdmUserRelCustomerService;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.StringUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"MdmUserRelCustomerServiceExpandImpl"})
public class MdmUserRelCustomerServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmUserRelCustomerMapper, MdmUserRelCustomerEntity>
implements MdmUserRelCustomerService {
    private static final Logger log = LoggerFactory.getLogger(MdmUserRelCustomerServiceImpl.class);
    @Resource
    private MdmUserRelCustomerMapper mdmUserRelCustomerMapper;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void add(String userName, String customerCode) {
        if (StringUtils.isNotEmpty((String)userName) && StringUtils.isNotEmpty((String)customerCode)) {
            this.add(userName, Collections.singletonList(customerCode));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void add(String userName, String customerCode, String currentFlag) {
        if (StringUtils.isNotEmpty((String)userName) && StringUtils.isNotEmpty((String)customerCode)) {
            if (StringUtils.isEmpty((String)currentFlag)) {
                currentFlag = YesNoEnum.yesNoEnum.ZERO.getValue();
            } else if (!YesNoEnum.yesNoEnum.ONE.getValue().equals(currentFlag) && !YesNoEnum.yesNoEnum.ZERO.getValue().equals(currentFlag)) {
                throw new BusinessException("currentFlag\u53c2\u6570\u4e0d\u5408\u6cd5");
            }
            MdmUserRelCustomerEntity one = (MdmUserRelCustomerEntity)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmUserRelCustomerEntity::getUserName, (Object)userName)).eq(MdmUserRelCustomerEntity::getCustomerCode, (Object)customerCode)).one();
            if (one == null) {
                MdmUserRelCustomerEntity entity = new MdmUserRelCustomerEntity();
                entity.setUserName(userName);
                entity.setCustomerCode(customerCode);
                entity.setCurrentFlag(currentFlag);
                this.save(entity);
            } else if (currentFlag.equals(one.getCurrentFlag())) {
                ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmUserRelCustomerEntity::getUserName, (Object)userName)).eq(MdmUserRelCustomerEntity::getCustomerCode, (Object)customerCode)).set(MdmUserRelCustomerEntity::getCurrentFlag, (Object)currentFlag)).update();
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void add(String userName, List<String> customerCodeList) {
        if (StringUtils.isNotEmpty((String)userName) && CollectionUtil.listNotEmptyNotSizeZero(customerCodeList)) {
            Set existCodeSet = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmUserRelCustomerEntity::getUserName, (Object)userName)).in(MdmUserRelCustomerEntity::getCustomerCode, customerCodeList)).select(new SFunction[]{MdmUserRelCustomerEntity::getCustomerCode}).list().stream().map(MdmUserRelCustomerEntity::getCustomerCode).collect(Collectors.toSet());
            HashSet<String> customerCodeSet = new HashSet<String>(customerCodeList);
            ArrayList<MdmUserRelCustomerEntity> entityList = new ArrayList<MdmUserRelCustomerEntity>();
            for (String customerCode : customerCodeSet) {
                if (existCodeSet.contains(customerCode)) continue;
                MdmUserRelCustomerEntity entity = new MdmUserRelCustomerEntity();
                entity.setUserName(userName);
                entity.setCustomerCode(customerCode);
                entity.setCurrentFlag(YesNoEnum.yesNoEnum.ZERO.getValue());
                entityList.add(entity);
            }
            if (entityList.size() > 0) {
                this.saveBatch(entityList);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void add(List<String> userNameList, String customerCode) {
        if (CollectionUtil.listNotEmptyNotSizeZero(userNameList) && StringUtils.isNotEmpty((String)customerCode)) {
            Set existCodeSet = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmUserRelCustomerEntity::getCustomerCode, (Object)customerCode)).in(MdmUserRelCustomerEntity::getUserName, userNameList)).select(new SFunction[]{MdmUserRelCustomerEntity::getUserName}).list().stream().map(MdmUserRelCustomerEntity::getUserName).collect(Collectors.toSet());
            HashSet<String> userNameSet = new HashSet<String>(userNameList);
            ArrayList<MdmUserRelCustomerEntity> entityList = new ArrayList<MdmUserRelCustomerEntity>();
            for (String userName : userNameSet) {
                if (existCodeSet.contains(userName)) continue;
                MdmUserRelCustomerEntity entity = new MdmUserRelCustomerEntity();
                entity.setUserName(userName);
                entity.setCustomerCode(customerCode);
                entity.setCurrentFlag(YesNoEnum.yesNoEnum.ZERO.getValue());
                entityList.add(entity);
            }
            if (entityList.size() > 0) {
                this.saveBatch(entityList);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void del(String userName, String customerCode) {
        if (StringUtils.isNotEmpty((String)userName) && StringUtils.isNotEmpty((String)customerCode)) {
            this.del(userName, Collections.singletonList(customerCode));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void del(String userName, List<String> customerCodeList) {
        if (StringUtils.isNotEmpty((String)userName) && CollectionUtil.listNotEmptyNotSizeZero(customerCodeList)) {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmUserRelCustomerEntity::getUserName, (Object)userName)).in(MdmUserRelCustomerEntity::getCustomerCode, customerCodeList)).remove();
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void del(List<String> userNameList, String customerCode) {
        if (CollectionUtil.listNotEmptyNotSizeZero(userNameList) && StringUtils.isNotEmpty((String)customerCode)) {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmUserRelCustomerEntity::getCustomerCode, (Object)customerCode)).in(MdmUserRelCustomerEntity::getUserName, userNameList)).remove();
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delByUserName(String userName) {
        if (StringUtils.isNotEmpty((String)userName)) {
            this.delByUserName(Collections.singletonList(userName));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delByUserName(List<String> userNameList) {
        if (CollectionUtil.listNotEmptyNotSizeZero(userNameList)) {
            ((LambdaUpdateChainWrapper)this.lambdaUpdate().in(MdmUserRelCustomerEntity::getUserName, userNameList)).remove();
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delByCustomerCode(String customerCode) {
        if (StringUtils.isNotEmpty((String)customerCode)) {
            this.delByCustomerCode(Collections.singletonList(customerCode));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delByCustomerCode(List<String> customerCodeList) {
        if (CollectionUtil.listNotEmptyNotSizeZero(customerCodeList)) {
            ((LambdaUpdateChainWrapper)this.lambdaUpdate().in(MdmUserRelCustomerEntity::getCustomerCode, customerCodeList)).remove();
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void setUniqueCurrentCustomerIfExist(String userName, String customerCode) {
        if (StringUtils.isNotEmpty((String)userName) && StringUtils.isNotEmpty((String)customerCode)) {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmUserRelCustomerEntity::getUserName, (Object)userName)).set(MdmUserRelCustomerEntity::getCurrentFlag, (Object)YesNoEnum.yesNoEnum.ZERO.getValue())).update();
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmUserRelCustomerEntity::getUserName, (Object)userName)).eq(MdmUserRelCustomerEntity::getCustomerCode, (Object)customerCode)).set(MdmUserRelCustomerEntity::getCurrentFlag, (Object)YesNoEnum.yesNoEnum.ONE.getValue())).update();
        }
    }

    @Override
    public List<String> findCustomerCodeListByUserName(String userName) {
        if (StringUtils.isNotEmpty((String)userName)) {
            return ((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmUserRelCustomerEntity::getUserName, (Object)userName)).select(new SFunction[]{MdmUserRelCustomerEntity::getCustomerCode}).list().stream().map(MdmUserRelCustomerEntity::getCustomerCode).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }

    @Override
    public List<MdmUserRelCustomerRespVo> findCustomerListByUserName(String userName) {
        if (StringUtils.isNotEmpty((String)userName)) {
            return ((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmUserRelCustomerEntity::getUserName, (Object)userName)).list().stream().map(x -> (MdmUserRelCustomerRespVo)CrmBeanUtil.copy((Object)x, MdmUserRelCustomerRespVo.class)).collect(Collectors.toList());
        }
        return new ArrayList<MdmUserRelCustomerRespVo>();
    }

    @Override
    public Map<String, List<String>> getCustomerCodeListGroupByUserNameList(List<String> userNameList) {
        if (CollectionUtil.listNotEmptyNotSizeZero(userNameList)) {
            HashMap<String, List<String>> map = new HashMap<String, List<String>>(16);
            List listGroup = Lists.partition(userNameList, (int)500);
            for (List group : listGroup) {
                List list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(MdmUserRelCustomerEntity::getUserName, (Collection)group)).select(new SFunction[]{MdmUserRelCustomerEntity::getUserName, MdmUserRelCustomerEntity::getCustomerCode}).list();
                if (list.size() <= 0) continue;
                map.putAll(list.stream().collect(Collectors.groupingBy(MdmUserRelCustomerEntity::getUserName, Collectors.mapping(MdmUserRelCustomerEntity::getCustomerCode, Collectors.toList()))));
            }
            return map;
        }
        return Collections.emptyMap();
    }

    @Override
    public List<String> findUserNameListByCustomerCode(String customerCode) {
        if (StringUtils.isNotEmpty((String)customerCode)) {
            return ((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmUserRelCustomerEntity::getCustomerCode, (Object)customerCode)).select(new SFunction[]{MdmUserRelCustomerEntity::getUserName}).list().stream().map(MdmUserRelCustomerEntity::getUserName).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }
}

