/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.newhope.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.base.BusinessException;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.mdm.FilterEnum;
import com.biz.crm.nebular.mdm.constant.UserTypeEnum;
import com.biz.crm.nebular.mdm.newhope.req.NewHopeReqVo;
import com.biz.crm.nebular.mdm.newhope.resp.NewHopeRespVo;
import com.biz.crm.newhope.service.UserSyncService;
import com.biz.crm.newhope.util.Body;
import com.biz.crm.newhope.util.HopeResult;
import com.biz.crm.newhope.util.NewHopeUtils;
import com.biz.crm.user.mapper.MdmUserMapper;
import com.biz.crm.user.model.MdmUserEntity;
import com.biz.crm.user.service.MdmUserService;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.HttpClientUtils;
import com.biz.crm.util.JsonPropertyUtil;
import com.biz.crm.util.Result;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.util.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UserSyncServiceImpl
implements UserSyncService {
    private static final Logger log = LoggerFactory.getLogger(UserSyncServiceImpl.class);
    @Autowired
    private MdmUserService mdmUserService;
    @Resource
    private MdmUserMapper mdmUserMapper;
    private static AtomicInteger count = new AtomicInteger();

    @Override
    public Body userSyncWithCookie(NewHopeReqVo reqVo) throws UnsupportedEncodingException {
        AssertUtils.isNotEmpty((String)reqVo.getFilter(), (String)"\u540c\u6b65\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isTrue((!FilterEnum.needOrgUrlSet().contains(reqVo.getFilter()) ? 1 : 0) != 0, (String)"\u7528\u6237\u540c\u6b65\u65b9\u5f0f\u4e0eUrl\u4e0d\u5339\u914d");
        if (StringUtils.equals((CharSequence)reqVo.getFilter(), (CharSequence)FilterEnum.INCREMENT_USER.getCode())) {
            AssertUtils.isNotEmpty((String)reqVo.getIncrementTime(), (String)"\u67e5\u8be2\u7528\u6237\u589e\u91cf\uff0c\u589e\u91cf\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        NewHopeRespVo respVo = NewHopeUtils.getNewHopeRespVo(reqVo);
        Map<String, String> headers = this.getStringStringMap(respVo);
        Result result = HttpClientUtils.doGet((String)respVo.getUrl(), headers);
        HopeResult hopeResult = (HopeResult)JsonPropertyUtil.toObject((String)((String)result.getResult()), HopeResult.class);
        if (hopeResult == null) {
            return new Body();
        }
        return hopeResult.getBody();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void userSync(NewHopeReqVo reqVo) throws UnsupportedEncodingException {
        HopeResult hopeResult;
        log.info("\u7528\u6237\u5168\u91cf\u540c\u6b65\u5f00\u59cb");
        reqVo.setFilter(FilterEnum.USER.getCode());
        HashSet userNameSet = Sets.newHashSet();
        do {
            HashSet userNameSetByCookie = Sets.newHashSet();
            ArrayList needSaveList = Lists.newArrayList();
            NewHopeRespVo respVo = NewHopeUtils.getNewHopeRespVo(reqVo);
            Map<String, String> headers = this.getStringStringMap(respVo);
            Result result = HttpClientUtils.doGet((String)respVo.getUrl(), headers);
            hopeResult = (HopeResult)JsonPropertyUtil.toObject((String)((String)ApiResultUtil.objResult((Result)result, (boolean)true)).replace("-", ""), HopeResult.class);
            if (hopeResult == null) {
                return;
            }
            if (hopeResult.getBody() == null) {
                return;
            }
            if (CollectionUtils.isEmpty(hopeResult.getBody().getUsers())) {
                return;
            }
            hopeResult.getBody().getUsers().forEach(x -> {
                if (StringUtils.isBlank((CharSequence)x.getUserId())) {
                    return;
                }
                if (StringUtils.isNotBlank((CharSequence)x.getCustomizedhrregion()) && StringUtils.isNotBlank((CharSequence)x.getCustomizedhrregiontxt())) {
                    MdmUserEntity entity = new MdmUserEntity();
                    entity.setFullName(x.getUserCn());
                    entity.setUserName(x.getUserId());
                    entity.setUserPassword(x.getUserpassword());
                    entity.setId(x.getUserId());
                    entity.setUserCode(x.getUserId());
                    entity.setUserType(UserTypeEnum.USER.getCode());
                    entity.setLockState(CrmEnableStatusEnum.ENABLE.getCode());
                    entity.setForceChangePassword(YesNoEnum.yesNoEnum.ONE.getValue());
                    entity.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
                    entity.setUserPhone(x.getMobile());
                    entity.setStartTime(DateUtil.formatDate() + " " + DateUtil.formatShortTime());
                    entity.setEndTime("9999-12-31 23:59:59");
                    needSaveList.add(entity);
                    if (userNameSet.contains(x.getUserId())) {
                        throw new BusinessException("\u7528\u6237\u8d26\u53f7\u91cd\u590d");
                    }
                    userNameSetByCookie.add(x.getUserId());
                    userNameSet.add(x.getUserId());
                }
            });
            reqVo.setCookie(hopeResult.getBody().getCookie());
            if (!CollectionUtils.isNotEmpty((Collection)userNameSetByCookie)) continue;
            List entitiesByDb = this.mdmUserMapper.selectList((Wrapper)Wrappers.lambdaQuery().in(MdmUserEntity::getUserName, (Collection)userNameSetByCookie));
            this.saveOrUpdateUserList(needSaveList, entitiesByDb);
        } while (!StringUtils.isBlank((CharSequence)hopeResult.getBody().getCookie()));
        log.info("\u7528\u6237\u5168\u91cf\u7ed3\u675f");
        log.info("\u5171\u540c\u6b65" + count.get() + "\u6761\u7528\u6237\u6570\u636e");
    }

    private void saveOrUpdateUserList(List<MdmUserEntity> needSaveList, List<MdmUserEntity> entitiesByDb) {
        if (CollectionUtils.isEmpty(needSaveList)) {
            return;
        }
        List<Object> saveEntities = Lists.newArrayList();
        ArrayList updateEntities = Lists.newArrayList();
        if (CollectionUtils.isEmpty(entitiesByDb)) {
            saveEntities = needSaveList;
            this.mdmUserService.saveBatch(saveEntities);
            count.getAndAdd(saveEntities.size());
            return;
        }
        Set codeSet = entitiesByDb.stream().map(MdmUserEntity::getUserName).collect(Collectors.toSet());
        ArrayList finalSaveEntities = Lists.newArrayList();
        needSaveList.forEach(x -> {
            if (codeSet.contains(x.getUserName())) {
                updateEntities.add(x);
            } else {
                finalSaveEntities.add(x);
            }
        });
        this.mdmUserService.saveBatch(finalSaveEntities);
        count.getAndAdd(finalSaveEntities.size());
        this.mdmUserService.updateBatchById(updateEntities);
        count.getAndAdd(updateEntities.size());
    }

    private Map<String, String> getStringStringMap(NewHopeRespVo respVo) {
        HashMap headers = Maps.newHashMap();
        headers.put("sign", respVo.getSign());
        headers.put("encodekey", respVo.getEncodekey());
        headers.put("randomcode", respVo.getRandomcode());
        headers.put("appuser", respVo.getAppuser());
        headers.put("timestamp", respVo.getTimestamp());
        return headers;
    }

    @Override
    public void userSyncIncrement(NewHopeReqVo reqVo) throws UnsupportedEncodingException {
        log.info("\u7528\u6237\u589e\u91cf\u540c\u6b65\u5f00\u59cb");
        reqVo.setFilter(FilterEnum.INCREMENT_USER.getCode());
        if (StringUtils.isBlank((CharSequence)reqVo.getIncrementTime())) {
            reqVo.setIncrementTime(new SimpleDateFormat("yyyy-MM-dd").format(DateUtil.yesterday()) + " " + "00:00:00");
        }
        reqVo.setIncrementTime(UserSyncServiceImpl.format(reqVo.getIncrementTime()) + "Z");
        HashSet codesAll = Sets.newHashSet();
        while (true) {
            ArrayList mdmUserEntities = Lists.newArrayList();
            HashSet codesByCookie = Sets.newHashSet();
            NewHopeRespVo respVo = NewHopeUtils.getNewHopeRespVo(reqVo);
            Map<String, String> headers = this.getStringStringMap(respVo);
            Result result = HttpClientUtils.doGet((String)respVo.getUrl(), headers);
            HopeResult hopeResult = (HopeResult)JsonPropertyUtil.toObject((String)((String)ApiResultUtil.objResult((Result)result, (boolean)true)).replace("-", ""), HopeResult.class);
            if (hopeResult == null) {
                return;
            }
            if (hopeResult.getBody() == null) {
                return;
            }
            if (CollectionUtils.isEmpty(hopeResult.getBody().getUsers())) {
                return;
            }
            hopeResult.getBody().getUsers().forEach(x -> {
                if (StringUtils.isBlank((CharSequence)x.getUserId())) {
                    return;
                }
                if (StringUtils.isNotBlank((CharSequence)x.getCustomizedhrregion()) && StringUtils.isNotBlank((CharSequence)x.getCustomizedhrregiontxt())) {
                    return;
                }
                if (codesByCookie.contains(x.getUserId())) {
                    throw new BusinessException(x.getUserId() + "\u5f85\u5bfc\u5165\u6570\u636e\u91cd\u590d");
                }
                MdmUserEntity entity = new MdmUserEntity();
                entity.setFullName(x.getUserCn());
                entity.setUserName(x.getUserId());
                entity.setUserPassword(x.getUserpassword());
                entity.setId(x.getUserId());
                entity.setUserCode(x.getUserId());
                entity.setUserType(UserTypeEnum.USER.getCode());
                entity.setLockState(CrmEnableStatusEnum.ENABLE.getCode());
                entity.setForceChangePassword(YesNoEnum.yesNoEnum.ONE.getValue());
                entity.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
                entity.setUserPhone(x.getMobile());
                entity.setStartTime(DateUtil.formatDate() + " " + DateUtil.formatShortTime());
                entity.setEndTime("9999-12-31 23:59:59");
                mdmUserEntities.add(entity);
                codesByCookie.add(x.getUserId());
            });
            if (CollectionUtils.isNotEmpty((Collection)codesByCookie)) {
                List entitiesByDb = this.mdmUserMapper.selectList((Wrapper)Wrappers.lambdaQuery().in(MdmUserEntity::getUserName, (Collection)codesByCookie));
                this.saveOrUpdateUserList(mdmUserEntities, entitiesByDb);
            }
            if (StringUtils.isBlank((CharSequence)hopeResult.getBody().getCookie())) break;
            reqVo.setCookie(hopeResult.getBody().getCookie());
        }
        log.info("\u7528\u6237\u5168\u91cf\u7ed3\u675f");
        log.info("\u5171\u540c\u6b65" + count.get() + "\u6761\u7528\u6237\u6570\u636e");
    }

    public static String format(String s) {
        String str = s.replaceAll("[`qwertyuiopasdfghjklzxcvbnmQWERTYUIOPASDFGHJKLZXCVBNM~!@#$%^&*()+=|{}':;',\\[\\].<>/?~\uff01@#\uffe5%\u2026\u2026& amp;*\uff08\uff09\u2014\u2014+|{}\u3010\u3011\u2018\uff1b\uff1a\u201d\u201c\u2019\u3002\uff0c\u3001\uff1f|-]", "");
        return str;
    }
}

