/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.customer.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.activiti.act.TaActBaseFeign;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.common.PageResult;
import com.biz.crm.crmlog.handle.util.CrmLogSendUtil;
import com.biz.crm.customer.manager.MdmCustomerMsgBuilder;
import com.biz.crm.customer.mapper.MdmCustomerMsgMapper;
import com.biz.crm.customer.model.MdmCustomerContactEntity;
import com.biz.crm.customer.model.MdmCustomerEntity;
import com.biz.crm.customer.model.MdmCustomerROrgEntity;
import com.biz.crm.customer.model.MdmCustomerSaleAreaEntity;
import com.biz.crm.customer.service.MdmCustomerBillService;
import com.biz.crm.customer.service.MdmCustomerContactService;
import com.biz.crm.customer.service.MdmCustomerMediaService;
import com.biz.crm.customer.service.MdmCustomerMsgService;
import com.biz.crm.customer.service.MdmCustomerROrgService;
import com.biz.crm.customer.service.MdmCustomerSaleAreaService;
import com.biz.crm.customer.service.MdmCustomerSupplyService;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.activiti.Indicator;
import com.biz.crm.eunm.mdm.ApprovalType;
import com.biz.crm.eunm.mdm.MdmBpmStatusEnum;
import com.biz.crm.eunm.sfa.WorkSignEnum;
import com.biz.crm.eunm.tpm.ActApproveStatusEnum;
import com.biz.crm.mq.RocketMQMessageBody;
import com.biz.crm.mq.RocketMQProducer;
import com.biz.crm.nebular.activiti.act.ActivitiCallBackVo;
import com.biz.crm.nebular.activiti.act.req.StartProcessReqVo;
import com.biz.crm.nebular.mdm.approval.resp.MdmApprovalConfigVo;
import com.biz.crm.nebular.mdm.cusorg.CusOrgVo;
import com.biz.crm.nebular.mdm.customer.CustomerCodeConditionReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerAndOrgReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerContactPageReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerContactPageRespVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerContactReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerCountReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerCountRespVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerDistanceContactPageReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerDockingReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerDockingRespVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgSelectReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgSelectRespVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerSaleAreaReqVo;
import com.biz.crm.nebular.mdm.customer.MdmPositionCustomerSearchReqVo;
import com.biz.crm.nebular.mdm.customer.MdmUpdateCusOrgCodeReqVo;
import com.biz.crm.nebular.mdm.humanarea.MdmCustomerOrgSearchReqVo;
import com.biz.crm.nebular.mdm.humanarea.MdmOrgCustomerUpdateReqVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.mdm.poi.resp.MdmTerminalStatisticianTypeVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionRespVo;
import com.biz.crm.nebular.mdm.user.resp.MdmCustomerRelUserRespVo;
import com.biz.crm.nebular.mdm.user.resp.MdmUserRelCustomerRespVo;
import com.biz.crm.org.service.MdmOrgService;
import com.biz.crm.position.model.MdmCustomerSupplyEntity;
import com.biz.crm.position.service.MdmPositionService;
import com.biz.crm.sfa.visitdealer.SfaVisitDealerDetailFeign;
import com.biz.crm.terminal.mapper.MdmTerminalMapper;
import com.biz.crm.terminal.service.MdmTerminalElasticsearchService;
import com.biz.crm.user.service.MdmUserRelCustomerService;
import com.biz.crm.user.service.MdmUserService;
import com.biz.crm.util.ActivityUtils;
import com.biz.crm.util.ApprovalConfigUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CustomerOrgUtil;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.JsonPropertyUtil;
import com.biz.crm.util.OrgUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.ParamUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

@Service
@ConditionalOnMissingBean(name={"MdmCustomerMsgServiceExpandImpl"})
public class MdmCustomerMsgServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmCustomerMsgMapper, MdmCustomerEntity>
implements MdmCustomerMsgService {
    private static final Logger log = LoggerFactory.getLogger(MdmCustomerMsgServiceImpl.class);
    private static final int INITIAL_CAPACITY = 16;
    private static final int PARTITION_SIZE = 500;
    @Autowired
    private MdmCustomerMsgMapper mdmCustomerMsgMapper;
    @Autowired
    private MdmCustomerContactService mdmCustomerContactService;
    @Autowired
    private MdmOrgService mdmOrgService;
    @Autowired
    private MdmCustomerSaleAreaService mdmCustomerSaleAreaService;
    @Autowired
    private MdmPositionService mdmPositionService;
    @Autowired
    private MdmCustomerSupplyService mdmCustomerSupplyService;
    @Value(value="${rocketmq.topic}${rocketmq.environment-variable}")
    private String topic;
    @Autowired
    private RocketMQProducer rocketMQProducer;
    @Autowired
    private MdmUserService mdmUserService;
    @Autowired
    private MdmCustomerROrgService mdmCustomerROrgService;
    @Autowired
    private MdmCustomerBillService mdmCustomerBillService;
    @Autowired
    private SfaVisitDealerDetailFeign sfaVisitDealerDetailFeign;
    @Autowired
    private TaActBaseFeign taActBaseFeign;
    @Autowired
    private CrmLogSendUtil crmLogSendUtil;
    @Autowired
    private MdmTerminalElasticsearchService elasticsearchService;
    @Autowired
    private MdmTerminalMapper mdmTerminalMapper;
    @Autowired
    private MdmUserRelCustomerService mdmUserRelCustomerService;
    @Autowired
    private MdmCustomerMediaService mdmCustomerMediaService;

    @Override
    public PageResult<MdmCustomerMsgRespVo> findList(MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        List listIncludeSelf;
        Page page = PageUtil.buildPage((Integer)mdmCustomerMsgReqVo.getPageNum(), (Integer)mdmCustomerMsgReqVo.getPageSize());
        if (!StringUtils.isEmpty((String)mdmCustomerMsgReqVo.getCode())) {
            List<String> orgCodeList = this.mdmOrgService.findAllChildrenOrgCodeList(null, mdmCustomerMsgReqVo.getCode());
            mdmCustomerMsgReqVo.setOrgCodeList(orgCodeList);
        } else if (!StringUtils.isEmpty((String)mdmCustomerMsgReqVo.getOrgCode())) {
            mdmCustomerMsgReqVo.setOrgCodeList(Collections.singletonList(mdmCustomerMsgReqVo.getOrgCode()));
        }
        if (CollectionUtil.listNotEmptyNotSizeZero((List)mdmCustomerMsgReqVo.getAllUnderOrgCodeListIncludeSelf()) && CollectionUtil.listNotEmptyNotSizeZero((List)(listIncludeSelf = OrgUtil.getChildrenOrgCodeListIncludeSelf((List)mdmCustomerMsgReqVo.getAllUnderOrgCodeListIncludeSelf())))) {
            mdmCustomerMsgReqVo.setAllUnderOrgCodeListIncludeSelf(listIncludeSelf);
        }
        List<MdmCustomerMsgRespVo> list = this.mdmCustomerMsgMapper.findList((Page<MdmCustomerMsgRespVo>)page, mdmCustomerMsgReqVo);
        this.setUpOrgName(list);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    protected void setUpOrgName(List<MdmCustomerMsgRespVo> list) {
        List<String> orgCodeList;
        Map<String, String> orgNameMap;
        Map<String, List<String>> customerOrgMap;
        List<String> customerCodeList;
        if (!(CollectionUtils.isEmpty(list) || CollectionUtils.isEmpty(customerCodeList = list.stream().filter(x -> !StringUtils.isEmpty((String)x.getCustomerCode())).map(MdmCustomerMsgRespVo::getCustomerCode).collect(Collectors.toList())) || ObjectUtils.isEmpty(customerOrgMap = this.mdmCustomerROrgService.findOrgCodeList(customerCodeList)) || ObjectUtils.isEmpty(orgNameMap = this.mdmOrgService.findOrgNameMap(orgCodeList = customerOrgMap.values().stream().flatMap(Collection::stream).distinct().collect(Collectors.toList()))))) {
            for (MdmCustomerMsgRespVo mdmCustomerMsgRespVo : list) {
                List<String> currentOrgCodeList = customerOrgMap.get(mdmCustomerMsgRespVo.getCustomerCode());
                if (CollectionUtils.isEmpty(currentOrgCodeList)) continue;
                String orgName = currentOrgCodeList.stream().filter(x -> !StringUtils.isEmpty((String)x)).distinct().map(orgNameMap::get).collect(Collectors.joining(","));
                mdmCustomerMsgRespVo.setOrgName(orgName);
                mdmCustomerMsgRespVo.setOrgCode(currentOrgCodeList.stream().filter(x -> !StringUtils.isEmpty((String)x)).distinct().collect(Collectors.joining(",")));
            }
        }
    }

    @Override
    public List<MdmCustomerMsgSelectRespVo> list(MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        Map<String, List<MdmOrgRespVo>> orgGroupByCustomerCodeList;
        Page page = PageUtil.buildPage((Integer)mdmCustomerMsgReqVo.getPageNum(), (Integer)mdmCustomerMsgReqVo.getPageSize());
        page.setSearchCount(false);
        List<MdmCustomerMsgSelectRespVo> list = this.mdmCustomerMsgMapper.list(mdmCustomerMsgReqVo, (Page<MdmCustomerMsgSelectRespVo>)page);
        if (list.size() > 0 && YesNoEnum.yesNoEnum.Y.getValue().equals(mdmCustomerMsgReqVo.getIsQueryCustomerOrgList()) && !(orgGroupByCustomerCodeList = this.mdmCustomerROrgService.findOrgGroupByCustomerCodeList(list.stream().map(MdmCustomerMsgSelectRespVo::getCustomerCode).collect(Collectors.toList()))).isEmpty()) {
            list.forEach(x -> x.setOrgList((List)orgGroupByCustomerCodeList.get(x.getCustomerCode())));
        }
        return list;
    }

    @Override
    public List<MdmCustomerMsgSelectRespVo> findCustomerSelectList(MdmCustomerMsgSelectReqVo reqVo) {
        Integer pageSize = reqVo.getPageSize();
        if (pageSize == null || pageSize == 0) {
            pageSize = Integer.valueOf(ParamUtil.getParameterValue((String)"select_box_option_size"));
        }
        ArrayList<MdmCustomerMsgSelectRespVo> list = new ArrayList<MdmCustomerMsgSelectRespVo>();
        HashSet<String> codeList = new HashSet<String>(16);
        if (StringUtils.isNotEmpty((String)reqVo.getSelectedCode())) {
            codeList.add(reqVo.getSelectedCode());
        }
        if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getSelectedCodeList())) {
            codeList.addAll(reqVo.getSelectedCodeList());
        }
        if (!codeList.isEmpty()) {
            reqVo.setSelectedCodeList(new ArrayList(codeList));
        }
        reqVo.setActApproveStatus(MdmBpmStatusEnum.PASS.getValue());
        if (pageSize > 0) {
            list.addAll(this.mdmCustomerMsgMapper.findCustomerSelectList((Page<MdmCustomerMsgSelectRespVo>)new Page(1L, (long)pageSize.intValue(), false), reqVo, null, null));
        }
        return list;
    }

    @Override
    public List<MdmCustomerMsgSelectRespVo> findCustomerNotRelateUserSelectList(MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        mdmCustomerMsgReqVo.setActApproveStatus(MdmBpmStatusEnum.PASS.getValue());
        return this.mdmCustomerMsgMapper.findCustomerNotRelateUserSelectList(null, mdmCustomerMsgReqVo);
    }

    @Override
    public List<String> findByOrgCodeList(List<String> list) {
        if (CollectionUtils.isEmpty(list)) {
            return new ArrayList<String>();
        }
        return this.mdmCustomerMsgMapper.findByOrgCodeList(list);
    }

    @Override
    public List<String> findByPositionCodeList(List<String> list) {
        if (CollectionUtils.isEmpty(list)) {
            return new ArrayList<String>();
        }
        return this.mdmCustomerMsgMapper.findByPositionCodeList(list);
    }

    @Override
    public MdmCustomerMsgRespVo query(String id, String customerCode) {
        if (StringUtils.isEmpty((String)id) && StringUtils.isEmpty((String)customerCode)) {
            return null;
        }
        MdmCustomerMsgReqVo mdmCustomerMsgReqVo = new MdmCustomerMsgReqVo();
        mdmCustomerMsgReqVo.setCustomerCode(customerCode);
        mdmCustomerMsgReqVo.setId(id);
        MdmCustomerMsgRespVo mdmCustomerMsgRespVo = this.mdmCustomerMsgMapper.query(mdmCustomerMsgReqVo);
        return Optional.ofNullable(mdmCustomerMsgRespVo).map(x -> {
            this.setUpCustomer(mdmCustomerMsgRespVo);
            this.setUpOrgName(Collections.singletonList(mdmCustomerMsgRespVo));
            this.setCustomerUserList(mdmCustomerMsgRespVo);
            return mdmCustomerMsgRespVo;
        }).orElse(null);
    }

    @Override
    public MdmCustomerMsgRespVo queryByCustomerCode(String customerCode) {
        MdmCustomerEntity one;
        if (StringUtils.isNotEmpty((String)customerCode) && (one = (MdmCustomerEntity)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmCustomerEntity::getCustomerCode, (Object)customerCode)).one()) != null) {
            return (MdmCustomerMsgRespVo)CrmBeanUtil.copy((Object)one, MdmCustomerMsgRespVo.class);
        }
        return null;
    }

    protected void setUpCustomer(MdmCustomerMsgRespVo mdmCustomerMsgRespVo) {
        String customerCode = mdmCustomerMsgRespVo.getCustomerCode();
        mdmCustomerMsgRespVo.setMdmCustomerContactVos(this.mdmCustomerContactService.list(new MdmCustomerContactReqVo().setCustomerCode(customerCode)));
        mdmCustomerMsgRespVo.setMdmCustomerDockingVos(this.mdmCustomerSupplyService.findDockingListByCustomerCode(new MdmCustomerDockingReqVo().setCustomerCode(customerCode)));
        mdmCustomerMsgRespVo.setMdmCustomerSaleAreaVos(this.mdmCustomerSaleAreaService.listCondition(new MdmCustomerSaleAreaReqVo().setCustomerCode(customerCode)));
        mdmCustomerMsgRespVo.setMdmCustomerBillVos(this.mdmCustomerBillService.listCondition(customerCode));
        this.mdmCustomerMediaService.setUpCustomer(mdmCustomerMsgRespVo);
    }

    protected void setCustomerUserList(MdmCustomerMsgRespVo mdmCustomerMsgRespVo) {
        String customerCode = mdmCustomerMsgRespVo.getCustomerCode();
        List<String> userNameList = this.mdmUserRelCustomerService.findUserNameListByCustomerCode(customerCode);
        if (CollectionUtil.listNotEmptyNotSizeZero(userNameList)) {
            mdmCustomerMsgRespVo.setCustomerUserList(this.mdmUserService.queryBatchByUserNameList(userNameList).stream().filter(x -> CrmEnableStatusEnum.ENABLE.getCode().equals(x.getEnableStatus())).map(x -> (MdmCustomerRelUserRespVo)CrmBeanUtil.copy((Object)x, MdmCustomerRelUserRespVo.class)).collect(Collectors.toList()));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void setUpCollateral(MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        this.mdmCustomerContactService.setUpContact(mdmCustomerMsgReqVo.getMdmCustomerContactVos(), mdmCustomerMsgReqVo.getCustomerCode());
        this.mdmCustomerSupplyService.setUpDocking(mdmCustomerMsgReqVo);
        this.mdmCustomerSaleAreaService.setUpArea(mdmCustomerMsgReqVo.getMdmCustomerSaleAreaVos(), mdmCustomerMsgReqVo.getCustomerCode());
        this.mdmCustomerBillService.setUp(mdmCustomerMsgReqVo);
        this.mdmCustomerROrgService.setUpOrg(mdmCustomerMsgReqVo);
        this.mdmCustomerMediaService.setUpMedia(mdmCustomerMsgReqVo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String save(MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        if (StringUtils.isNotEmpty((String)mdmCustomerMsgReqVo.getActApproveStatus())) {
            if (ActApproveStatusEnum.CREATE.getCode().equals(mdmCustomerMsgReqVo.getActApproveStatus())) {
                mdmCustomerMsgReqVo.setActApproveStatus(MdmBpmStatusEnum.SUBMIT.getValue());
            }
            if (ActApproveStatusEnum.APPROVING.getCode().equals(mdmCustomerMsgReqVo.getActApproveStatus())) {
                mdmCustomerMsgReqVo.setActApproveStatus(MdmBpmStatusEnum.APPROVAL.getValue());
            }
            if (ActApproveStatusEnum.APPROVED.getCode().equals(mdmCustomerMsgReqVo.getActApproveStatus())) {
                mdmCustomerMsgReqVo.setActApproveStatus(MdmBpmStatusEnum.PASS.getValue());
            }
            if (ActApproveStatusEnum.REJECTED.getCode().equals(mdmCustomerMsgReqVo.getActApproveStatus())) {
                mdmCustomerMsgReqVo.setActApproveStatus(MdmBpmStatusEnum.REJECT.getValue());
            }
            if (ActApproveStatusEnum.INTERRUPT.getCode().equals(mdmCustomerMsgReqVo.getActApproveStatus())) {
                mdmCustomerMsgReqVo.setActApproveStatus(MdmBpmStatusEnum.RECOVER.getValue());
            }
            if (ActApproveStatusEnum.CLOSED.getCode().equals(mdmCustomerMsgReqVo.getActApproveStatus())) {
                mdmCustomerMsgReqVo.setActApproveStatus(MdmBpmStatusEnum.CLOSE.getValue());
            }
        }
        if ((StringUtils.isEmpty((String)mdmCustomerMsgReqVo.getActApproveStatus()) || !MdmBpmStatusEnum.PASS.getValue().equals(mdmCustomerMsgReqVo.getActApproveStatus())) && StringUtils.isNotEmpty((String)mdmCustomerMsgReqVo.getApprovalBusinessCode())) {
            ApprovalType approvalType = ApprovalConfigUtil.checkAndGet((String)mdmCustomerMsgReqVo.getApprovalBusinessCode(), (Object)mdmCustomerMsgReqVo);
            mdmCustomerMsgReqVo.setApprovalType(approvalType.getValue());
            if (approvalType == ApprovalType.NULL) {
                mdmCustomerMsgReqVo.setActApproveStatus(MdmBpmStatusEnum.PASS.getValue());
            } else {
                mdmCustomerMsgReqVo.setActApproveStatus(MdmBpmStatusEnum.SUBMIT.getValue());
            }
        }
        if (StringUtils.isEmpty((String)mdmCustomerMsgReqVo.getApprovalType())) {
            mdmCustomerMsgReqVo.setApprovalType(ApprovalType.NULL.getValue());
            mdmCustomerMsgReqVo.setActApproveStatus(MdmBpmStatusEnum.PASS.getValue());
        }
        MdmCustomerMsgBuilder.builder(true, this, this.mdmUserService).init(mdmCustomerMsgReqVo).valid().convert().persistence().after();
        Object menuCodeObj = ThreadLocalUtil.getObj((String)"menuCode");
        if (menuCodeObj != null) {
            this.crmLogSendUtil.sendForAdd(menuCodeObj.toString(), mdmCustomerMsgReqVo.getCustomerCode(), mdmCustomerMsgReqVo.getCustomerCode(), CrmBeanUtil.copy((Object)mdmCustomerMsgReqVo, MdmCustomerMsgRespVo.class));
        }
        if (MdmBpmStatusEnum.PASS.getValue().equals(mdmCustomerMsgReqVo.getActApproveStatus())) {
            this.elasticsearchService.add(mdmCustomerMsgReqVo);
        }
        return mdmCustomerMsgReqVo.getCustomerCode();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String saveAndSubmit(MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        String approvalBusinessCode = mdmCustomerMsgReqVo.getApprovalBusinessCode();
        Assert.hasText((String)approvalBusinessCode, (String)"\u7f3a\u5931\u5ba1\u6279\u914d\u7f6e\u4e1a\u52a1\u7f16\u7801\uff0c\u4e0d\u80fd\u81ea\u52a8\u53d1\u8d77");
        MdmApprovalConfigVo config = ApprovalConfigUtil.getConfig((String)approvalBusinessCode);
        String customerCode = this.save(mdmCustomerMsgReqVo);
        MdmCustomerEntity customer = (MdmCustomerEntity)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmCustomerEntity::getCustomerCode, (Object)customerCode)).one();
        if (MdmBpmStatusEnum.SUBMIT.getValue().equals(customer.getActApproveStatus())) {
            if (ApprovalType.STATUS.getValue().equals(customer.getApprovalType())) {
                ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmCustomerEntity::getCustomerCode, (Object)customerCode)).set(MdmCustomerEntity::getActApproveStatus, (Object)MdmBpmStatusEnum.APPROVAL.getValue())).update();
            }
            if (ApprovalType.BPM.getValue().equals(customer.getApprovalType())) {
                String workFlowKey = mdmCustomerMsgReqVo.getWorkFlowKey();
                if (StringUtils.isEmpty((String)workFlowKey)) {
                    Assert.notNull((Object)config, (String)"\u672a\u627e\u5230\u5ba1\u6279\u914d\u7f6e");
                    Assert.hasText((String)config.getDefaultWorkFlowKey(), (String)"\u5ba1\u6279\u914d\u7f6e\u7f3a\u5931\u6d41\u7a0bkey");
                    workFlowKey = config.getDefaultWorkFlowKey();
                }
                UserRedis user = UserUtils.getUser();
                StartProcessReqVo startProcessReqVo = new StartProcessReqVo();
                startProcessReqVo.setCallBackFeign("MdmCustomerCallBackFeign");
                startProcessReqVo.setProcessKey(workFlowKey);
                startProcessReqVo.setUserCode(user.getUsername());
                startProcessReqVo.setPosCode(user.getPoscode());
                startProcessReqVo.setTitle(StringUtils.isNotEmpty((String)mdmCustomerMsgReqVo.getTitle()) ? mdmCustomerMsgReqVo.getTitle() : "\u5ba2\u6237\u65b0\u589e\u9ed8\u8ba4\u63d0\u4ea4\u6d41\u7a0b");
                startProcessReqVo.setFormNo(customer.getId());
                startProcessReqVo.setRemark(StringUtils.isNotEmpty((String)mdmCustomerMsgReqVo.getApproveRemarks()) ? mdmCustomerMsgReqVo.getApproveRemarks() : "");
                startProcessReqVo.setFormType(StringUtils.isNotEmpty((String)mdmCustomerMsgReqVo.getFromType()) ? mdmCustomerMsgReqVo.getFromType() : "MDM");
                startProcessReqVo.setCostType("customer");
                startProcessReqVo.setSignTicket(System.currentTimeMillis() + "");
                startProcessReqVo.setBusinessCode(customer.getCustomerCode());
                startProcessReqVo.setFileList(CollectionUtil.listNotEmptyNotSizeZero((List)mdmCustomerMsgReqVo.getActivityFileList()) ? mdmCustomerMsgReqVo.getActivityFileList() : null);
                String processNo = ActivityUtils.startProcess((StartProcessReqVo)startProcessReqVo);
                ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmCustomerEntity::getCustomerCode, (Object)customerCode)).set(MdmCustomerEntity::getActApproveStatus, (Object)MdmBpmStatusEnum.APPROVAL.getValue())).set(MdmCustomerEntity::getProcessCode, (Object)processNo)).update();
            }
        }
        return customerCode;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        MdmCustomerMsgRespVo oldObject = this.query(mdmCustomerMsgReqVo.getId(), mdmCustomerMsgReqVo.getCustomerCode());
        Assert.notNull((Object)oldObject, (String)"\u672a\u627e\u5230\u6307\u5b9a\u6570\u636e");
        MdmCustomerMsgBuilder.builder(false, this, this.mdmUserService).init(mdmCustomerMsgReqVo).valid().convert().persistence().after();
        Object menuCodeObj = ThreadLocalUtil.getObj((String)"menuCode");
        MdmCustomerMsgRespVo newObject = this.query(mdmCustomerMsgReqVo.getId(), mdmCustomerMsgReqVo.getCustomerCode());
        if (menuCodeObj != null) {
            this.crmLogSendUtil.sendForUpdate(menuCodeObj.toString(), mdmCustomerMsgReqVo.getId(), mdmCustomerMsgReqVo.getId(), (Object)oldObject, (Object)newObject);
        }
        if (MdmBpmStatusEnum.PASS.getValue().equals(mdmCustomerMsgReqVo.getActApproveStatus())) {
            this.elasticsearchService.add(mdmCustomerMsgReqVo);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateAndSubmit(MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        this.update(mdmCustomerMsgReqVo);
        String terminalCode = mdmCustomerMsgReqVo.getCustomerCode();
        MdmCustomerEntity terminal = (MdmCustomerEntity)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmCustomerEntity::getCustomerCode, (Object)terminalCode)).one();
        if (MdmBpmStatusEnum.SUBMIT.getValue().equals(terminal.getActApproveStatus()) || MdmBpmStatusEnum.RECOVER.getValue().equals(terminal.getActApproveStatus()) || MdmBpmStatusEnum.REJECT.getValue().equals(terminal.getActApproveStatus())) {
            if (ApprovalType.STATUS.getValue().equals(terminal.getActApproveStatus())) {
                ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmCustomerEntity::getCustomerCode, (Object)terminalCode)).set(MdmCustomerEntity::getActApproveStatus, (Object)MdmBpmStatusEnum.APPROVAL.getValue())).update();
            } else if (ApprovalType.BPM.getValue().equals(terminal.getActApproveStatus())) {
                Assert.hasText((String)mdmCustomerMsgReqVo.getApprovalBusinessCode(), (String)"\u7f3a\u5931\u5ba1\u6279\u914d\u7f6e\u7f16\u7801");
                String workFlowKey = mdmCustomerMsgReqVo.getWorkFlowKey();
                if (StringUtils.isEmpty((String)workFlowKey)) {
                    MdmApprovalConfigVo config = ApprovalConfigUtil.getConfig((String)mdmCustomerMsgReqVo.getApprovalBusinessCode());
                    Assert.notNull((Object)config, (String)("\u672a\u627e\u5230\u5ba1\u6279\u914d\u7f6e\u7f16\u7801" + mdmCustomerMsgReqVo.getApprovalBusinessCode()));
                    Assert.hasText((String)config.getDefaultWorkFlowKey(), (String)"\u5ba1\u6279\u914d\u7f6e\u672a\u914d\u7f6e\u9ed8\u8ba4\u6d41\u7a0bkey");
                    workFlowKey = config.getDefaultWorkFlowKey();
                }
                UserRedis user = UserUtils.getUser();
                StartProcessReqVo startProcessReqVo = new StartProcessReqVo();
                startProcessReqVo.setCallBackFeign("MdmCustomerCallBackFeign");
                startProcessReqVo.setProcessKey(workFlowKey);
                startProcessReqVo.setUserCode(user.getUsername());
                startProcessReqVo.setPosCode(user.getPoscode());
                startProcessReqVo.setTitle(StringUtils.isNotEmpty((String)mdmCustomerMsgReqVo.getTitle()) ? mdmCustomerMsgReqVo.getTitle() : "\u5ba2\u6237\u7f16\u8f91\u9ed8\u8ba4\u63d0\u4ea4\u6d41\u7a0b");
                startProcessReqVo.setFormNo(terminal.getId());
                startProcessReqVo.setRemark(StringUtils.isNotEmpty((String)mdmCustomerMsgReqVo.getApproveRemarks()) ? mdmCustomerMsgReqVo.getApproveRemarks() : "");
                startProcessReqVo.setFormType(StringUtils.isNotEmpty((String)mdmCustomerMsgReqVo.getFromType()) ? mdmCustomerMsgReqVo.getFromType() : "MDM");
                startProcessReqVo.setCostType("customer");
                startProcessReqVo.setSignTicket(System.currentTimeMillis() + "");
                startProcessReqVo.setBusinessCode(terminal.getCustomerCode());
                startProcessReqVo.setFileList(CollectionUtil.listNotEmptyNotSizeZero((List)mdmCustomerMsgReqVo.getActivityFileList()) ? mdmCustomerMsgReqVo.getActivityFileList() : null);
                String no = ActivityUtils.startProcess((StartProcessReqVo)startProcessReqVo);
                ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmCustomerEntity::getCustomerCode, (Object)terminalCode)).set(MdmCustomerEntity::getActApproveStatus, (Object)MdmBpmStatusEnum.APPROVAL.getValue())).set(MdmCustomerEntity::getProcessCode, (Object)no)).update();
            } else {
                ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmCustomerEntity::getCustomerCode, (Object)terminalCode)).set(MdmCustomerEntity::getActApproveStatus, (Object)MdmBpmStatusEnum.PASS.getValue())).update();
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        Object menuCodeObj;
        List ids = mdmCustomerMsgReqVo.getIds();
        Assert.notEmpty((Collection)ids, (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(BaseIdEntity::getId, (Collection)ids)).list();
        Assert.notEmpty((Collection)list, (String)"\u5ba2\u6237\u4e0d\u5b58\u5728");
        List<String> customerCodeList = list.stream().filter(x -> x != null && !StringUtils.isEmpty((String)x.getCustomerCode())).map(MdmCustomerEntity::getCustomerCode).collect(Collectors.toList());
        List<String> sendCustomerCodeList = list.stream().filter(x -> x != null && !StringUtils.isEmpty((String)x.getCustomerCode()) && MdmBpmStatusEnum.PASS.getValue().equals(x.getActApproveStatus())).map(MdmCustomerEntity::getCustomerCode).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(customerCodeList)) {
            ((LambdaUpdateChainWrapper)this.mdmCustomerROrgService.lambdaUpdate().in(MdmCustomerROrgEntity::getCustomerCode, customerCodeList)).remove();
            ((LambdaUpdateChainWrapper)this.mdmCustomerSaleAreaService.lambdaUpdate().in(MdmCustomerSaleAreaEntity::getCustomerCode, customerCodeList)).remove();
            this.mdmCustomerSupplyService.removeByCustomerCodeList(customerCodeList);
            ((LambdaUpdateChainWrapper)this.mdmCustomerContactService.lambdaUpdate().in(MdmCustomerContactEntity::getCustomerCode, customerCodeList)).remove();
        }
        if ((menuCodeObj = ThreadLocalUtil.getObj((String)"menuCode")) != null) {
            list.forEach(item -> this.crmLogSendUtil.sendForDel(menuCodeObj.toString(), item.getId(), mdmCustomerMsgReqVo.getCustomerCode(), item));
        }
        this.removeByIds(ids);
        this.elasticsearchService.delete(ids);
        this.sendCustomerChangeMsg(sendCustomerCodeList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        Object menuCodeObj;
        List ids = mdmCustomerMsgReqVo.getIds();
        Assert.notEmpty((Collection)ids, (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(BaseIdEntity::getId, (Collection)ids)).eq(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.DISABLE.getCode())).select(new SFunction[]{BaseIdEntity::getId, MdmCustomerEntity::getCustomerCode, MdmCustomerEntity::getActApproveStatus}).list();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(BaseIdEntity::getId, (Collection)mdmCustomerMsgReqVo.getIds())).set(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).update();
            this.sendCustomerChangeMsg(list.stream().filter(x -> MdmBpmStatusEnum.PASS.getValue().equals(x.getActApproveStatus())).map(MdmCustomerEntity::getCustomerCode).collect(Collectors.toList()));
        }
        if ((menuCodeObj = ThreadLocalUtil.getObj((String)"menuCode")) != null) {
            list.forEach(item -> {
                MdmCustomerMsgRespVo oldObject = (MdmCustomerMsgRespVo)CrmBeanUtil.copy((Object)item, MdmCustomerMsgRespVo.class);
                oldObject.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
                MdmCustomerMsgRespVo newObject = (MdmCustomerMsgRespVo)CrmBeanUtil.copy((Object)item, MdmCustomerMsgRespVo.class);
                newObject.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
                this.crmLogSendUtil.sendForUpdate(menuCodeObj.toString(), item.getId(), item.getCustomerCode(), (Object)oldObject, (Object)newObject);
            });
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        Object menuCodeObj;
        List ids = mdmCustomerMsgReqVo.getIds();
        Assert.notEmpty((Collection)ids, (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(BaseIdEntity::getId, (Collection)ids)).eq(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).select(new SFunction[]{BaseIdEntity::getId, MdmCustomerEntity::getCustomerCode, MdmCustomerEntity::getActApproveStatus}).list();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(BaseIdEntity::getId, (Collection)mdmCustomerMsgReqVo.getIds())).set(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.DISABLE.getCode())).update();
            this.sendCustomerChangeMsg(list.stream().filter(x -> MdmBpmStatusEnum.PASS.getValue().equals(x.getActApproveStatus())).map(MdmCustomerEntity::getCustomerCode).collect(Collectors.toList()));
        }
        if ((menuCodeObj = ThreadLocalUtil.getObj((String)"menuCode")) != null) {
            list.forEach(item -> {
                MdmCustomerMsgRespVo oldObject = (MdmCustomerMsgRespVo)CrmBeanUtil.copy((Object)item, MdmCustomerMsgRespVo.class);
                oldObject.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
                MdmCustomerMsgRespVo newObject = (MdmCustomerMsgRespVo)CrmBeanUtil.copy((Object)item, MdmCustomerMsgRespVo.class);
                newObject.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
                this.crmLogSendUtil.sendForUpdate(menuCodeObj.toString(), item.getId(), item.getCustomerCode(), (Object)oldObject, (Object)newObject);
            });
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addOrUpdateBatch(List<MdmCustomerContactReqVo> mdmCustomerContactReqVos) {
        if (!CollectionUtils.isEmpty(mdmCustomerContactReqVos)) {
            this.mdmCustomerContactService.saveOrUpdateBatch(CrmBeanUtil.copyList(mdmCustomerContactReqVos, MdmCustomerContactEntity.class));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateOrgCodeByCondition(MdmUpdateCusOrgCodeReqVo mdmUpdateCusOrgCodeReqVo) {
        List customerCodeList = mdmUpdateCusOrgCodeReqVo.getCustomerCodeList();
        String customerOrgCode = mdmUpdateCusOrgCodeReqVo.getCustomerOrgCode();
        if (CollectionUtils.isEmpty((Collection)customerCodeList) || StringUtils.isEmpty((String)customerOrgCode)) {
            throw new BusinessException("\u5ba2\u6237\u7f16\u7801\u96c6\u5408\u6216\u5ba2\u6237\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(MdmCustomerEntity::getCustomerCode, (Collection)customerCodeList)).set(MdmCustomerEntity::getCustomerOrgCode, (Object)customerOrgCode)).update();
        List<String> sendCustomerCodeList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmCustomerEntity::getActApproveStatus, (Object)MdmBpmStatusEnum.PASS.getValue())).in(MdmCustomerEntity::getCustomerCode, (Collection)customerCodeList)).select(new SFunction[]{MdmCustomerEntity::getCustomerCode}).list().stream().map(MdmCustomerEntity::getCustomerCode).collect(Collectors.toList());
        this.sendCustomerChangeMsg(sendCustomerCodeList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchUpdateCustomerOrg(MdmOrgCustomerUpdateReqVo reqVo) {
        Assert.notEmpty((Collection)reqVo.getCustomerCodeList(), (String)"\u7f3a\u5931\u5ba2\u6237\u7f16\u7801");
        Assert.hasText((String)reqVo.getOrgCode(), (String)"\u7f3a\u5931\u7ec4\u7ec7\u7f16\u7801");
        if (StringUtils.isNotEmpty((String)reqVo.getOriginOrgCode())) {
            this.mdmCustomerROrgService.replaceOrg(reqVo.getCustomerCodeList(), reqVo.getOriginOrgCode(), reqVo.getOrgCode());
        } else {
            this.mdmCustomerROrgService.setUpOrg(reqVo.getCustomerCodeList(), reqVo.getOrgCode());
        }
        List<String> sendCustomerCodeList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmCustomerEntity::getActApproveStatus, (Object)MdmBpmStatusEnum.PASS.getValue())).in(MdmCustomerEntity::getCustomerCode, (Collection)reqVo.getCustomerCodeList())).select(new SFunction[]{MdmCustomerEntity::getCustomerCode}).list().stream().map(MdmCustomerEntity::getCustomerCode).collect(Collectors.toList());
        this.sendCustomerChangeMsg(sendCustomerCodeList);
    }

    @Override
    public Map<String, String> findOrgCodeByCustomerCodeList(List<String> customerCodeList) {
        if (CollectionUtils.isEmpty(customerCodeList)) {
            return Collections.emptyMap();
        }
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmCustomerEntity::getActApproveStatus, (Object)MdmBpmStatusEnum.PASS.getValue())).in(MdmCustomerEntity::getCustomerCode, customerCodeList)).select(new SFunction[]{MdmCustomerEntity::getCustomerCode, MdmCustomerEntity::getOrgCode}).list();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Collections.emptyMap();
        }
        return list.stream().collect(Collectors.toMap(MdmCustomerEntity::getCustomerCode, MdmCustomerEntity::getOrgCode));
    }

    @Override
    public Map<String, String> findCustomerCodeNameMapByCustomerCodeList(List<String> customerCodeList) {
        if (CollectionUtil.listNotEmptyNotSizeZero(customerCodeList)) {
            HashMap<String, String> map = new HashMap<String, String>(16);
            List codeList = Lists.partition(customerCodeList, (int)500);
            for (List list : codeList) {
                map.putAll(((LambdaQueryChainWrapper)this.lambdaQuery().in(MdmCustomerEntity::getCustomerCode, (Collection)list)).select(new SFunction[]{MdmCustomerEntity::getCustomerCode, MdmCustomerEntity::getCustomerName}).list().stream().collect(Collectors.toMap(MdmCustomerEntity::getCustomerCode, MdmCustomerEntity::getCustomerName)));
            }
            return map;
        }
        return Collections.emptyMap();
    }

    @Override
    public Map<String, List<String>> findOrgCodeListByCustomerCodeList(List<String> customerCodeList) {
        return this.mdmCustomerROrgService.findOrgCodeList(customerCodeList);
    }

    @Override
    public List<String> findAllCustomerCodeByUser(String userAccount) {
        if (StringUtils.isEmpty((String)userAccount)) {
            return new ArrayList<String>();
        }
        return this.mdmCustomerMsgMapper.findAllCustomerApprovedCodeByUser(userAccount, MdmBpmStatusEnum.PASS.getValue());
    }

    @Override
    public List<MdmCustomerMsgRespVo> findCurrentAndSubCustomerList(MdmCustomerAndOrgReqVo mdmCustomerOrgSearchReqVo) {
        Map<String, List<String>> groupOrgCodeMap;
        List orgCodeList = mdmCustomerOrgSearchReqVo.getOrgCodeList();
        List customerCodeList = mdmCustomerOrgSearchReqVo.getCustomerCodeList();
        if (CollectionUtils.isEmpty((Collection)orgCodeList) && CollectionUtils.isEmpty((Collection)customerCodeList)) {
            return new ArrayList<MdmCustomerMsgRespVo>();
        }
        List children = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)orgCodeList)) {
            children = OrgUtil.getChildrenOrgListIncludeSelfEnable((List)orgCodeList);
            orgCodeList = CollectionUtils.isEmpty(children) ? null : children.stream().map(MdmOrgRespVo::getOrgCode).collect(Collectors.toList());
            mdmCustomerOrgSearchReqVo.setOrgCodeList(orgCodeList);
        }
        List<Object> currentAndSubCustomerList = this.mdmCustomerMsgMapper.findCurrentAndSubCustomerList(mdmCustomerOrgSearchReqVo);
        if (CollectionUtils.isEmpty(currentAndSubCustomerList = currentAndSubCustomerList.stream().filter(x -> MdmBpmStatusEnum.PASS.getValue().equals(x.getActApproveStatus())).collect(Collectors.toList()))) {
            return new ArrayList<MdmCustomerMsgRespVo>();
        }
        List<String> searchCustomerCodeList = currentAndSubCustomerList.stream().map(MdmCustomerMsgRespVo::getCustomerCode).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(searchCustomerCodeList) && (groupOrgCodeMap = this.mdmCustomerROrgService.findOrgCodeList(searchCustomerCodeList)) != null && !groupOrgCodeMap.isEmpty()) {
            List allOrgCodeList = groupOrgCodeMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
            List mdmOrgRespVos = OrgUtil.getOrgByCodeList(allOrgCodeList);
            for (MdmCustomerMsgRespVo mdmCustomerMsgRespVo : currentAndSubCustomerList) {
                List<String> currentOrgCodeList = groupOrgCodeMap.get(mdmCustomerMsgRespVo.getCustomerCode());
                if (CollectionUtils.isEmpty(currentOrgCodeList)) continue;
                mdmCustomerMsgRespVo.setOrgCode(String.join((CharSequence)",", currentOrgCodeList));
                String orgName = mdmOrgRespVos.stream().filter(x -> currentOrgCodeList.contains(x.getOrgCode())).map(MdmOrgRespVo::getOrgName).collect(Collectors.joining(","));
                mdmCustomerMsgRespVo.setOrgName(orgName);
            }
        }
        return currentAndSubCustomerList;
    }

    @Override
    public List<MdmCustomerMsgRespVo> findCurrentAndSubCustomerList(MdmCustomerOrgSearchReqVo mdmCustomerOrgSearchReqVo) {
        Integer pageSize;
        Integer pageNum = mdmCustomerOrgSearchReqVo.getPageNum();
        if (pageNum == null) {
            pageNum = 0;
        }
        if ((pageSize = mdmCustomerOrgSearchReqVo.getPageSize()) == null) {
            pageSize = 5000;
        }
        if (StringUtils.isEmpty((String)mdmCustomerOrgSearchReqVo.getCustomerOrgCode())) {
            List orgCodeList = mdmCustomerOrgSearchReqVo.getOrgCodeList();
            if (CollectionUtils.isEmpty((Collection)orgCodeList)) {
                return new ArrayList<MdmCustomerMsgRespVo>();
            }
            List subOrgCodeList = OrgUtil.getChildrenOrgCodeListIncludeSelf((List)orgCodeList);
            if (CollectionUtils.isEmpty((Collection)subOrgCodeList)) {
                return new ArrayList<MdmCustomerMsgRespVo>();
            }
            mdmCustomerOrgSearchReqVo.setOrgCodeList(subOrgCodeList);
            mdmCustomerOrgSearchReqVo.setOrgCodeList(subOrgCodeList);
        } else {
            mdmCustomerOrgSearchReqVo.setOrgCodeList(null);
            List childrenCustomerOrgList = CustomerOrgUtil.getChildrenCustomerOrgListIncludeSelf((String)mdmCustomerOrgSearchReqVo.getCustomerOrgCode());
            if (StringUtils.isNotEmpty((String)mdmCustomerOrgSearchReqVo.getCustomerOrgLevel())) {
                childrenCustomerOrgList = childrenCustomerOrgList.stream().filter(x -> mdmCustomerOrgSearchReqVo.getCustomerOrgLevel().equals(x.getCustomerOrgLevel())).collect(Collectors.toList());
            }
            if (CollectionUtil.listEmpty((List)childrenCustomerOrgList)) {
                return new ArrayList<MdmCustomerMsgRespVo>();
            }
            mdmCustomerOrgSearchReqVo.setCustomerOrgCodeList(childrenCustomerOrgList.stream().map(CusOrgVo::getCustomerOrgCode).collect(Collectors.toList()));
        }
        Page page = new Page((long)pageNum.intValue(), (long)pageSize.intValue());
        mdmCustomerOrgSearchReqVo.setActApproveStatus(MdmBpmStatusEnum.PASS.getValue());
        return this.mdmCustomerMsgMapper.findListByOrgCodeList((Page<MdmCustomerMsgRespVo>)page, mdmCustomerOrgSearchReqVo);
    }

    @Override
    public List<String> findCustomerCodeConditionList(CustomerCodeConditionReqVo customerCodeConditionReqVo) {
        if (CollectionUtil.listEmpty((List)customerCodeConditionReqVo.getChannelList()) && CollectionUtil.listEmpty((List)customerCodeConditionReqVo.getOrgCodeList())) {
            return Lists.newArrayList();
        }
        ArrayList merge = Lists.newArrayList();
        if (!CollectionUtil.listEmpty((List)customerCodeConditionReqVo.getChannelList())) {
            merge.addAll(((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmCustomerEntity::getActApproveStatus, (Object)MdmBpmStatusEnum.PASS.getValue())).in(MdmCustomerEntity::getChannel, (Collection)customerCodeConditionReqVo.getChannelList())).select(new SFunction[]{MdmCustomerEntity::getCustomerCode}).list());
        }
        if (!CollectionUtil.listEmpty((List)customerCodeConditionReqVo.getOrgCodeList())) {
            merge.addAll(((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmCustomerEntity::getActApproveStatus, (Object)MdmBpmStatusEnum.PASS.getValue())).in(MdmCustomerEntity::getOrgCode, (Collection)customerCodeConditionReqVo.getOrgCodeList())).select(new SFunction[]{MdmCustomerEntity::getCustomerCode}).list());
        }
        return merge.stream().map(MdmCustomerEntity::getCustomerCode).collect(Collectors.toList());
    }

    @Override
    public List<MdmCustomerMsgRespVo> findPositionCustomerList(MdmPositionCustomerSearchReqVo mdmPositionCustomerSearchReqVo) {
        mdmPositionCustomerSearchReqVo.setActApproveStatus(MdmBpmStatusEnum.PASS.getValue());
        return this.mdmCustomerMsgMapper.findPositionCustomerList(mdmPositionCustomerSearchReqVo);
    }

    @Override
    public List<MdmCustomerMsgRespVo> queryBasic(MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(!StringUtils.isEmpty((String)mdmCustomerMsgReqVo.getId()), BaseIdEntity::getId, (Object)mdmCustomerMsgReqVo.getId())).eq(!StringUtils.isEmpty((String)mdmCustomerMsgReqVo.getCustomerCode()), MdmCustomerEntity::getCustomerCode, (Object)mdmCustomerMsgReqVo.getCustomerCode())).eq(!StringUtils.isEmpty((String)mdmCustomerMsgReqVo.getEnableStatus()), CrmBaseEntity::getEnableStatus, (Object)mdmCustomerMsgReqVo.getEnableStatus())).eq(!StringUtils.isEmpty((String)mdmCustomerMsgReqVo.getActApproveStatus()), MdmCustomerEntity::getActApproveStatus, (Object)mdmCustomerMsgReqVo.getActApproveStatus())).list();
        return CrmBeanUtil.copyList((List)list, MdmCustomerMsgRespVo.class);
    }

    @Override
    public List<MdmCustomerMsgRespVo> findCurrentAndSubPositionCustomer(MdmPositionCustomerSearchReqVo mdmPositionCustomerSearchReqVo) {
        String positionCode = mdmPositionCustomerSearchReqVo.getPositionCode();
        Assert.hasText((String)positionCode, (String)"\u804c\u4f4d\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        mdmPositionCustomerSearchReqVo.setPositionCodeList(this.mdmPositionService.findAllChildrenPositionCodeList(null, positionCode));
        return this.findPositionCustomerList(mdmPositionCustomerSearchReqVo);
    }

    @Override
    public void sendCustomerInsertMsg(MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        log.info("\u901a\u77e5\u5ba2\u6237\u4fe1\u606f\u6216\u5ba2\u6237\u7684\u7ec4\u7ec7\u53d1\u751f\u53d8\u5316,\u5ba2\u6237\u7f16\u7801\u96c6\u5408:{}", (Object)mdmCustomerMsgReqVo);
        if (mdmCustomerMsgReqVo == null) {
            return;
        }
        RocketMQMessageBody rocketMQMessageBody = new RocketMQMessageBody();
        rocketMQMessageBody.setTopic(this.topic);
        rocketMQMessageBody.setTag("CUSTOMER_INSERT");
        rocketMQMessageBody.setMsgBody(JsonPropertyUtil.toJsonString((Object)mdmCustomerMsgReqVo));
        this.rocketMQProducer.convertAndSend(rocketMQMessageBody);
    }

    @Override
    public void sendCustomerChangeMsg(List<String> customerCodeList) {
        log.info("\u901a\u77e5\u5ba2\u6237\u4fe1\u606f\u6216\u5ba2\u6237\u7684\u7ec4\u7ec7\u53d1\u751f\u53d8\u5316,\u5ba2\u6237\u7f16\u7801\u96c6\u5408:{}", customerCodeList);
        if (!CollectionUtils.isEmpty(customerCodeList)) {
            RocketMQMessageBody rocketMQMessageBody = new RocketMQMessageBody();
            rocketMQMessageBody.setTopic(this.topic);
            rocketMQMessageBody.setTag("CUS_AVAILBLELIST_REFRSH");
            rocketMQMessageBody.setMsgBody(JsonPropertyUtil.toJsonString(customerCodeList));
            this.rocketMQProducer.convertAndSend(rocketMQMessageBody);
        }
    }

    @Override
    public PageResult<MdmCustomerContactPageRespVo> listAndContactPage(MdmCustomerContactPageReqVo mdmCustomerContactPageReqVo) {
        String positionCode = mdmCustomerContactPageReqVo.getPositionCode();
        if (!StringUtils.isEmpty((String)positionCode) || CollectionUtil.listNotEmptyNotSizeZero((List)mdmCustomerContactPageReqVo.getPositionCodeList())) {
            List positionCodeList;
            List list = positionCodeList = mdmCustomerContactPageReqVo.getPositionCodeList() != null ? mdmCustomerContactPageReqVo.getPositionCodeList() : new ArrayList();
            if (StringUtils.isNotEmpty((String)mdmCustomerContactPageReqVo.getPositionCode())) {
                if (CollectionUtil.listNotEmptyNotSizeZero((List)positionCodeList)) {
                    positionCodeList.retainAll(Collections.singletonList(positionCode));
                } else {
                    positionCodeList.add(positionCode);
                }
            }
            List<String> customerCodeList = this.mdmCustomerSupplyService.findCustomerCodeByPosition(positionCodeList);
            log.info("\u5ba2\u6237\u4fe1\u606f\uff1a\u5173\u8054\u804c\u4f4d\u7684\u5ba2\u6237:{}", customerCodeList);
            if (CollectionUtils.isEmpty(customerCodeList)) {
                return PageResult.builder().data(new ArrayList()).count(Long.valueOf(0L)).build();
            }
            mdmCustomerContactPageReqVo.setCustomerCodeList(customerCodeList);
        }
        Page page = PageUtil.buildPage((Integer)mdmCustomerContactPageReqVo.getPageNum(), (Integer)mdmCustomerContactPageReqVo.getPageSize());
        mdmCustomerContactPageReqVo.setActApproveStatus(MdmBpmStatusEnum.PASS.getValue());
        List<MdmCustomerContactPageRespVo> mdmCustomerMsgRespVos = this.mdmCustomerMsgMapper.listAndContactPage((Page<MdmCustomerMsgRespVo>)page, mdmCustomerContactPageReqVo);
        mdmCustomerMsgRespVos.stream().forEach(mdm -> mdm.setCustomerCategory("\u7ecf\u9500\u5546"));
        return PageResult.builder().data(mdmCustomerMsgRespVos).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public List<MdmCustomerDockingRespVo> dockingList(MdmCustomerDockingReqVo mdmCustomerDockingReqVo) {
        Assert.hasText((String)mdmCustomerDockingReqVo.getCustomerCode(), (String)"\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        List<Object> list = this.mdmCustomerSupplyService.findDockingListByCustomerCode(mdmCustomerDockingReqVo);
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            list = list.stream().filter(item -> StringUtils.isNotEmpty((String)item.getUserName())).collect(Collectors.toList());
        }
        return list;
    }

    @Override
    public PageResult<MdmCustomerContactPageRespVo> customerContactPage(MdmCustomerContactPageReqVo mdmCustomerContactPageReqVo) {
        Page page = PageUtil.buildPage((Integer)mdmCustomerContactPageReqVo.getPageNum(), (Integer)mdmCustomerContactPageReqVo.getPageSize());
        mdmCustomerContactPageReqVo.setActApproveStatus(MdmBpmStatusEnum.PASS.getValue());
        List positionCodeList = mdmCustomerContactPageReqVo.getPositionCodeList();
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)positionCodeList)) {
            ThreadLocalUtil.delObj();
        }
        List<MdmCustomerContactPageRespVo> mdmCustomerMsgRespVos = this.mdmCustomerMsgMapper.listAndContactPage((Page<MdmCustomerMsgRespVo>)page, mdmCustomerContactPageReqVo);
        return PageResult.builder().data(mdmCustomerMsgRespVos).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public void updateCoordinate(List<MdmCustomerMsgReqVo> mdmCustomerMsgReqVos) {
        if (CollectionUtils.isEmpty(mdmCustomerMsgReqVos)) {
            return;
        }
        for (MdmCustomerMsgReqVo mdmCustomerMsgReqVo : mdmCustomerMsgReqVos) {
            String customerCode = mdmCustomerMsgReqVo.getCustomerCode();
            if (StringUtils.isEmpty((String)customerCode)) continue;
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmCustomerEntity::getCustomerCode, (Object)customerCode)).set(MdmCustomerEntity::getLongitude, (Object)mdmCustomerMsgReqVo.getLongitude())).set(MdmCustomerEntity::getLatitude, (Object)mdmCustomerMsgReqVo.getLatitude())).update();
        }
    }

    @Override
    public List<MdmCustomerMsgRespVo> getCustomerListByUserName(String userName) {
        ArrayList<MdmCustomerMsgRespVo> list = new ArrayList<MdmCustomerMsgRespVo>();
        if (StringUtils.isNotEmpty((String)userName)) {
            List<String> customerCodeList = this.mdmUserRelCustomerService.findCustomerCodeListByUserName(userName);
            if (CollectionUtil.listEmpty(customerCodeList)) {
                return new ArrayList<MdmCustomerMsgRespVo>();
            }
            List customerEntityList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(MdmCustomerEntity::getCustomerCode, customerCodeList)).eq(MdmCustomerEntity::getActApproveStatus, (Object)MdmBpmStatusEnum.PASS.getValue())).list();
            if (CollectionUtil.listNotEmptyNotSizeZero((List)customerEntityList)) {
                return CrmBeanUtil.copyList((List)customerEntityList, MdmCustomerMsgRespVo.class);
            }
        }
        return list;
    }

    @Override
    public MdmCustomerMsgRespVo getUserCurrentCustomer(String userName) {
        List<MdmUserRelCustomerRespVo> userRelCustomerList;
        if (StringUtils.isNotEmpty((String)userName) && CollectionUtil.listNotEmptyNotSizeZero(userRelCustomerList = this.mdmUserRelCustomerService.findCustomerListByUserName(userName))) {
            Set collect = userRelCustomerList.stream().map(MdmUserRelCustomerRespVo::getCustomerCode).collect(Collectors.toSet());
            Map<String, MdmCustomerMsgRespVo> customerMap = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).eq(MdmCustomerEntity::getActApproveStatus, (Object)MdmBpmStatusEnum.PASS.getValue())).in(MdmCustomerEntity::getCustomerCode, collect)).list().stream().collect(Collectors.toMap(MdmCustomerEntity::getCustomerCode, v -> (MdmCustomerMsgRespVo)CrmBeanUtil.copy((Object)v, MdmCustomerMsgRespVo.class)));
            List currentCodeList = userRelCustomerList.stream().filter(x -> YesNoEnum.yesNoEnum.ONE.getValue().equals(x.getCurrentFlag())).map(MdmUserRelCustomerRespVo::getCustomerCode).collect(Collectors.toList());
            if (currentCodeList.size() == 1 && customerMap.containsKey(currentCodeList.get(0))) {
                return customerMap.get(currentCodeList.get(0));
            }
            for (MdmUserRelCustomerRespVo userRelCustomer : userRelCustomerList) {
                if (!customerMap.containsKey(userRelCustomer.getCustomerCode())) continue;
                this.mdmUserRelCustomerService.setUniqueCurrentCustomerIfExist(userName, userRelCustomer.getCustomerCode());
                return customerMap.get(userRelCustomer.getCustomerCode());
            }
        }
        return null;
    }

    @Override
    public void frozen(List<String> ids) {
        Assert.notEmpty(ids, (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(BaseIdEntity::getId, ids)).set(MdmCustomerEntity::getLockState, (Object)CrmEnableStatusEnum.DISABLE.getCode())).update();
    }

    @Override
    public void thaw(List<String> ids) {
        Assert.notEmpty(ids, (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(BaseIdEntity::getId, ids)).set(MdmCustomerEntity::getLockState, (Object)CrmEnableStatusEnum.ENABLE.getCode())).update();
    }

    @Override
    public Integer findPositionRelationCustomerCount(String positionCode) {
        if (StringUtils.isEmpty((String)positionCode)) {
            return 0;
        }
        List<MdmPositionRespVo> position = this.mdmPositionService.findAllChildrenPositionList(null, positionCode);
        if (CollectionUtils.isEmpty(position)) {
            return 0;
        }
        List positionCodeList = position.stream().filter(x -> !StringUtils.isEmpty((String)x.getPositionCode())).map(MdmPositionRespVo::getPositionCode).collect(Collectors.toList());
        return ((LambdaQueryChainWrapper)this.mdmCustomerSupplyService.lambdaQuery().in(MdmCustomerSupplyEntity::getPositionCode, positionCodeList)).count();
    }

    @Override
    public Integer findCurrentPositionRelationCustomerCount(String positionCode) {
        if (StringUtils.isEmpty((String)positionCode)) {
            return 0;
        }
        return ((LambdaQueryChainWrapper)this.mdmCustomerSupplyService.lambdaQuery().eq(MdmCustomerSupplyEntity::getPositionCode, (Object)positionCode)).count();
    }

    @Override
    public PageResult<MdmCustomerContactPageRespVo> distanceContactPage(MdmCustomerDistanceContactPageReqVo mdmCustomerDistanceContactPageReqVo) {
        Page page = PageUtil.buildPage((Integer)mdmCustomerDistanceContactPageReqVo.getPageNum(), (Integer)mdmCustomerDistanceContactPageReqVo.getPageSize());
        List<MdmCustomerContactPageRespVo> list = this.mdmCustomerMsgMapper.distanceContactPage((Page<MdmCustomerContactPageRespVo>)page, mdmCustomerDistanceContactPageReqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public MdmCustomerCountRespVo fingCustomerAndVisit(MdmCustomerCountReqVo reqVo) {
        Date thanStart;
        Date end;
        Calendar c;
        MdmCustomerCountRespVo mdmCustomerCountRespVo = new MdmCustomerCountRespVo();
        if (StringUtils.isEmpty((String)reqVo.getUserName())) {
            reqVo.setUserName(UserUtils.getUser().getUsername());
            reqVo.setPosCode(UserUtils.getUser().getPoscode());
        }
        if (StringUtils.isEmpty((String)reqVo.getTimeType())) {
            reqVo.setTimeType(WorkSignEnum.TimeType.JT.getVal());
        }
        if (WorkSignEnum.TimeType.BZ.getVal().equals(reqVo.getTimeType())) {
            this.getWeekOfDate(reqVo);
        } else if (WorkSignEnum.TimeType.BY.getVal().equals(reqVo.getTimeType())) {
            reqVo.setStartDate(DateUtil.yyyy_MM.format(new Date()) + "-01");
            c = Calendar.getInstance();
            c.setTime(new Date());
            c.set(5, c.getActualMaximum(5));
            end = c.getTime();
            reqVo.setEndDate(DateUtil.date_sdf.format(end));
            c.add(2, -1);
            reqVo.setThanStartDate(DateUtil.yyyy_MM.format(c.getTime()) + "-01");
            c.set(5, c.getActualMaximum(5));
            thanStart = c.getTime();
            reqVo.setThanEndDate(DateUtil.date_sdf.format(thanStart));
        } else if (WorkSignEnum.TimeType.SY.getVal().equals(reqVo.getTimeType())) {
            c = Calendar.getInstance();
            c.add(2, -1);
            reqVo.setStartDate(DateUtil.yyyy_MM.format(c.getTime()) + "-01");
            c.set(5, c.getActualMaximum(5));
            end = c.getTime();
            reqVo.setEndDate(DateUtil.date_sdf.format(end));
            c.add(2, -1);
            c.set(5, c.getActualMinimum(5));
            reqVo.setThanStartDate(DateUtil.date_sdf.format(c.getTime()));
            c.set(5, c.getActualMaximum(5));
            thanStart = c.getTime();
            reqVo.setThanEndDate(DateUtil.date_sdf.format(thanStart));
        } else {
            reqVo.setStartDate(DateUtil.date_sdf.format(new Date()));
            reqVo.setEndDate(DateUtil.date_sdf.format(new Date()));
            c = Calendar.getInstance();
            c.setTime(new Date());
            c.add(5, -1);
            Date d = c.getTime();
            reqVo.setThanStartDate(DateUtil.date_sdf.format(d));
            reqVo.setThanEndDate(DateUtil.date_sdf.format(d));
        }
        BigDecimal customerNumber = BigDecimal.valueOf(this.mdmTerminalMapper.countTerminalByPosition(reqVo.getPosCode(), reqVo.getEndDate(), MdmBpmStatusEnum.PASS.getValue())).add(BigDecimal.valueOf(this.mdmCustomerMsgMapper.countCustomerByPosition(reqVo.getPosCode(), reqVo.getEndDate(), MdmBpmStatusEnum.PASS.getValue())));
        if (null == customerNumber) {
            customerNumber = BigDecimal.ZERO;
        }
        mdmCustomerCountRespVo.setCustomerNumber(customerNumber);
        BigDecimal thanCustNumber = BigDecimal.valueOf(this.mdmTerminalMapper.countTerminalByPosition(reqVo.getPosCode(), reqVo.getThanEndDate(), MdmBpmStatusEnum.PASS.getValue())).add(BigDecimal.valueOf(this.mdmCustomerMsgMapper.countCustomerByPosition(reqVo.getPosCode(), reqVo.getThanEndDate(), MdmBpmStatusEnum.PASS.getValue())));
        if (null == thanCustNumber) {
            thanCustNumber = BigDecimal.ZERO;
        }
        mdmCustomerCountRespVo.setThanCustNumber(thanCustNumber);
        BigDecimal fluctuateNumber = customerNumber.subtract(thanCustNumber);
        mdmCustomerCountRespVo.setFluctuateNumber(fluctuateNumber);
        Result result = this.sfaVisitDealerDetailFeign.findVisitNumber(reqVo);
        if (result.isSuccess() && null != result.getResult()) {
            MdmCustomerCountRespVo respVo = (MdmCustomerCountRespVo)result.getResult();
            mdmCustomerCountRespVo.setPlanVisitNumber(respVo.getPlanVisitNumber());
            mdmCustomerCountRespVo.setActualVisitNumber(respVo.getActualVisitNumber());
            mdmCustomerCountRespVo.setVisitCompletionRate(respVo.getVisitCompletionRate());
            mdmCustomerCountRespVo.setPlaceOrderNumber(respVo.getPlaceOrderNumber());
            mdmCustomerCountRespVo.setSalesReachRate(respVo.getSalesReachRate());
            mdmCustomerCountRespVo.setVisitCustNumber(respVo.getVisitCustNumber());
            BigDecimal visitCoverRate = BigDecimal.ZERO;
            if (!BigDecimal.ZERO.equals(customerNumber)) {
                visitCoverRate = mdmCustomerCountRespVo.getVisitCustNumber().compareTo(BigDecimal.ZERO) > 0 ? mdmCustomerCountRespVo.getVisitCustNumber().divide(customerNumber, 4, 4).multiply(new BigDecimal("100").setScale(2)) : BigDecimal.ZERO;
            }
            mdmCustomerCountRespVo.setVisitCoverRate(visitCoverRate);
            mdmCustomerCountRespVo.setVisitTotalNumber(respVo.getVisitTotalNumber());
        }
        return mdmCustomerCountRespVo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void submit(MdmCustomerMsgReqVo reqVo) {
        Assert.hasText((String)reqVo.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)reqVo.getWorkFlowKey(), (String)"\u8bf7\u9009\u62e9\u6d41\u7a0b");
        MdmCustomerEntity entity = (MdmCustomerEntity)this.getById((Serializable)((Object)reqVo.getId()));
        if (!ApprovalType.BPM.getValue().equals(entity.getApprovalType())) {
            throw new BusinessException("\u8be5\u6761\u6570\u636e\u4e0d\u80fd\u53d1\u8d77\u6d41\u7a0b\u5ba1\u6279");
        }
        if (MdmBpmStatusEnum.PASS.getValue().equals(entity.getActApproveStatus())) {
            throw new BusinessException("\u5ba1\u6279\u901a\u8fc7\u7684\u6570\u636e\u4e0d\u80fd\u53d1\u8d77\u6d41\u7a0b");
        }
        if (MdmBpmStatusEnum.APPROVAL.getValue().equals(entity.getActApproveStatus())) {
            throw new BusinessException("\u5ba1\u6279\u4e2d\u7684\u6570\u636e\u4e0d\u80fd\u53d1\u8d77\u6d41\u7a0b");
        }
        UserRedis user = UserUtils.getUser();
        StartProcessReqVo startProcessReqVo = new StartProcessReqVo();
        startProcessReqVo.setCallBackFeign("MdmCustomerCallBackFeign");
        startProcessReqVo.setProcessKey(reqVo.getWorkFlowKey());
        startProcessReqVo.setUserCode(user.getUsername());
        startProcessReqVo.setPosCode(user.getPoscode());
        startProcessReqVo.setTitle(reqVo.getTitle());
        startProcessReqVo.setFormNo(entity.getId());
        startProcessReqVo.setFormType(StringUtils.isNotEmpty((String)reqVo.getFromType()) ? reqVo.getFromType() : "MDM");
        startProcessReqVo.setCostType("customer");
        startProcessReqVo.setRemark(reqVo.getApproveRemarks());
        startProcessReqVo.setSignTicket(System.currentTimeMillis() + "");
        startProcessReqVo.setBusinessCode(entity.getCustomerCode());
        startProcessReqVo.setFileList(reqVo.getActivityFileList());
        String processNo = ActivityUtils.startProcess((StartProcessReqVo)startProcessReqVo);
        entity.setProcessCode(processNo);
        entity.setActApproveStatus(MdmBpmStatusEnum.APPROVAL.getValue());
        this.updateById(entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void callback(ActivitiCallBackVo reqVo) {
        MdmCustomerEntity entity = (MdmCustomerEntity)this.getById((Serializable)((Object)reqVo.getFormNo()));
        boolean sendMq = false;
        if (Indicator.CON_BPM_DOING.getCode() == reqVo.getProcessState().intValue()) {
            entity.setActApproveStatus(MdmBpmStatusEnum.PASS.getValue());
            sendMq = true;
        }
        if (Indicator.CON_BPM_PASS.getCode() == reqVo.getProcessState().intValue()) {
            entity.setActApproveStatus(MdmBpmStatusEnum.REJECT.getValue());
        }
        if (Indicator.CON_BPM_REJECT.getCode() == reqVo.getProcessState().intValue()) {
            entity.setActApproveStatus(MdmBpmStatusEnum.RECOVER.getValue());
        }
        this.updateById(entity);
        if (sendMq) {
            this.sendCustomerChangeMsg(Collections.singletonList(entity.getCustomerCode()));
            this.sendAchievementMsg(entity.getCustomerCode(), entity.getFromType());
            MdmCustomerMsgRespVo query = this.query(reqVo.getFormNo(), null);
            MdmCustomerMsgReqVo copy = (MdmCustomerMsgReqVo)CrmBeanUtil.copy((Object)query, MdmCustomerMsgReqVo.class);
            copy.setMdmCustomerDockingVos(CrmBeanUtil.copyList((List)query.getMdmCustomerDockingVos(), MdmCustomerDockingReqVo.class));
            copy.setMdmCustomerContactVos(CrmBeanUtil.copyList((List)query.getMdmCustomerContactVos(), MdmCustomerContactReqVo.class));
            this.elasticsearchService.add(copy);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void statusApprovalSubmit(List<String> ids) {
        Assert.notEmpty(ids, (String)"\u7a7a\u53c2\u6570");
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(BaseIdEntity::getId, ids)).list();
        Assert.notEmpty((Collection)list, (String)"\u65e0\u6548\u7684id");
        list.forEach(x -> {
            Assert.isTrue((boolean)ApprovalType.STATUS.getValue().equals(x.getApprovalType()), (String)"\u8be5\u6570\u636e\u4e0d\u80fd\u63d0\u4ea4\u72b6\u6001\u5ba1\u6279");
            Assert.isTrue((!MdmBpmStatusEnum.APPROVAL.getValue().equals(x.getActApproveStatus()) ? 1 : 0) != 0, (String)"\u5ba1\u6279\u4e2d\u7684\u6570\u636e\u4e0d\u80fd\u63d0\u4ea4\u72b6\u6001\u5ba1\u6279");
            Assert.isTrue((!MdmBpmStatusEnum.PASS.getValue().equals(x.getActApproveStatus()) ? 1 : 0) != 0, (String)"\u5ba1\u6279\u901a\u8fc7\u7684\u6570\u636e\u4e0d\u80fd\u63d0\u4ea4\u72b6\u6001\u5ba1\u6279");
            x.setActApproveStatus(MdmBpmStatusEnum.APPROVAL.getValue());
        });
        this.updateBatchById(list);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void statusApprovalReject(List<String> ids) {
        Assert.notEmpty(ids, (String)"\u7a7a\u53c2\u6570");
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(BaseIdEntity::getId, ids)).list();
        Assert.notEmpty((Collection)list, (String)"\u65e0\u6548\u7684id");
        list.forEach(x -> {
            Assert.isTrue((boolean)ApprovalType.STATUS.getValue().equals(x.getApprovalType()), (String)"\u8be5\u6570\u636e\u4e0d\u80fd\u63d0\u4ea4\u72b6\u6001\u5ba1\u6279");
            Assert.isTrue((boolean)MdmBpmStatusEnum.APPROVAL.getValue().equals(x.getActApproveStatus()), (String)"\u5ba1\u6279\u4e2d\u7684\u6570\u636e\u624d\u80fd\u9a73\u56de");
            x.setActApproveStatus(MdmBpmStatusEnum.REJECT.getValue());
        });
        this.updateBatchById(list);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void statusApprovalAgree(List<String> ids) {
        Assert.notEmpty(ids, (String)"\u7a7a\u53c2\u6570");
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(BaseIdEntity::getId, ids)).list();
        Assert.notEmpty((Collection)list, (String)"\u65e0\u6548\u7684id");
        list.forEach(x -> {
            Assert.isTrue((boolean)ApprovalType.STATUS.getValue().equals(x.getApprovalType()), (String)"\u8be5\u6570\u636e\u4e0d\u80fd\u63d0\u4ea4\u72b6\u6001\u5ba1\u6279");
            Assert.isTrue((boolean)MdmBpmStatusEnum.APPROVAL.getValue().equals(x.getActApproveStatus()), (String)"\u5ba1\u6279\u4e2d\u7684\u6570\u636e\u624d\u80fd\u901a\u8fc7");
            x.setActApproveStatus(MdmBpmStatusEnum.PASS.getValue());
        });
        this.updateBatchById(list);
    }

    public void getWeekOfDate(MdmCustomerCountReqVo reqVo) {
        String[] weeks = new String[]{"7", "1", "2", "3", "4", "5", "6"};
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        int week_index = cal.get(7) - 1;
        if (week_index < 0) {
            week_index = 0;
        }
        String week = weeks[week_index];
        int days = 0;
        if ("1".equals(week)) {
            days = 0;
        } else if ("2".equals(week)) {
            days = -1;
        } else if ("3".equals(week)) {
            days = -2;
        } else if ("4".equals(week)) {
            days = -3;
        } else if ("5".equals(week)) {
            days = -4;
        } else if ("6".equals(week)) {
            days = -5;
        } else if ("7".equals(week)) {
            days = -6;
        }
        cal.add(5, days);
        Date start = cal.getTime();
        reqVo.setStartDate(DateUtil.date_sdf.format(start));
        cal.add(5, 6);
        Date end = cal.getTime();
        reqVo.setEndDate(DateUtil.date_sdf.format(end));
        cal.add(5, -7);
        Date thanEnd = cal.getTime();
        reqVo.setThanEndDate(DateUtil.date_sdf.format(thanEnd));
        cal.add(5, -6);
        Date thanStart = cal.getTime();
        reqVo.setThanStartDate(DateUtil.date_sdf.format(thanStart));
    }

    @Override
    public List<MdmTerminalStatisticianTypeVo> statisticalType(MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        List<MdmTerminalStatisticianTypeVo> statisticalType = this.mdmCustomerMsgMapper.statisticalType(mdmCustomerMsgReqVo);
        if (!org.springframework.util.CollectionUtils.isEmpty(statisticalType)) {
            Map terminalType = DictUtil.dictMap((String)"customer_type");
            return statisticalType.stream().filter(x -> terminalType.containsKey(x.getStatisticianType())).peek(x -> x.setStatisticianName((String)terminalType.get(x.getStatisticianType()))).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Override
    public void sendAchievementMsg(String clientCode, String fromType) {
        ArrayList list = Lists.newArrayList();
        list.add(clientCode);
        list.add(fromType);
        RocketMQMessageBody rocketMQMessageBody = new RocketMQMessageBody();
        rocketMQMessageBody.setTag("INSERT_CLIENT_TAG");
        rocketMQMessageBody.setMsgBody(JsonPropertyUtil.toJsonStringNotEmptyVal((Object)list));
        this.rocketMQProducer.convertAndSend(rocketMQMessageBody);
    }

    @Override
    public List<MdmCustomerMsgRespVo> findCustomerByCustomerOrgCodeList(List<String> customerOrgCodeList) {
        List entityList;
        List list;
        if (CollectionUtil.listNotEmptyNotSizeZero(customerOrgCodeList) && CollectionUtil.listNotEmptyNotSizeZero((List)(list = CustomerOrgUtil.getChildrenCustomerOrgCodeListIncludeSelfEnable(customerOrgCodeList.stream().filter(x -> StringUtils.isNotEmpty((String)x)).distinct().collect(Collectors.toList())))) && CollectionUtil.listNotEmptyNotSizeZero((List)(entityList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).eq(MdmCustomerEntity::getActApproveStatus, (Object)MdmBpmStatusEnum.PASS.getValue())).in(MdmCustomerEntity::getCustomerOrgCode, (Collection)list)).list()))) {
            return CrmBeanUtil.copyList((List)entityList, MdmCustomerMsgRespVo.class);
        }
        return new ArrayList<MdmCustomerMsgRespVo>();
    }
}

