/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.function.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.mdm.AdminEnum;
import com.biz.crm.function.mapper.MdmFunctionMapper;
import com.biz.crm.function.model.MdmFunctionEntity;
import com.biz.crm.function.service.MdmFunctionRoleService;
import com.biz.crm.function.service.MdmFunctionService;
import com.biz.crm.icon.service.IMdmIconService;
import com.biz.crm.nebular.mdm.constant.UserTypeEnum;
import com.biz.crm.nebular.mdm.function.MdmCheckAdminVo;
import com.biz.crm.nebular.mdm.function.MdmFunctionPermissionVo;
import com.biz.crm.nebular.mdm.function.MdmFunctionReqVo;
import com.biz.crm.nebular.mdm.function.MdmFunctionRespVo;
import com.biz.crm.nebular.mdm.function.MdmFunctionSearchReqVo;
import com.biz.crm.nebular.mdm.icon.MdmIconReqVo;
import com.biz.crm.nebular.mdm.icon.MdmIconRespVo;
import com.biz.crm.nebular.mdm.pageconfig.MdmFunctionSubPermissionVo;
import com.biz.crm.nebular.mdm.pageconfig.MdmFunctionSubReqVo;
import com.biz.crm.nebular.mdm.permission.MdmDataPermissionReqVo;
import com.biz.crm.nebular.mdm.role.req.MdmRoleFunctionReqVo;
import com.biz.crm.nebular.mdm.role.req.MdmRoleFunctionTreeVo;
import com.biz.crm.permission.service.IMdmDataPermissionService;
import com.biz.crm.position.service.MdmPositionRoleService;
import com.biz.crm.tableconfig.service.IMdmFunctionSubService;
import com.biz.crm.user.service.MdmUserRelRoleService;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.util.cache.TableConfigUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Service
@ConditionalOnMissingBean(name={"MdmFunctionServiceExpandImpl"})
public class MdmFunctionServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmFunctionMapper, MdmFunctionEntity>
implements MdmFunctionService {
    private static final Logger log = LoggerFactory.getLogger(MdmFunctionServiceImpl.class);
    @Autowired
    private MdmFunctionMapper mdmFunctionMapper;
    @Autowired
    private MdmFunctionRoleService mdmFunctionRoleService;
    @Autowired
    private IMdmIconService mdmIconService;
    @Autowired
    private MdmPositionRoleService mdmPositionRoleService;
    @Value(value="${whiteFunctionCodeList:}")
    private String whiteFunctionCodeList;
    @Autowired
    private IMdmFunctionSubService mdmFunctionSubService;
    @Autowired
    private IMdmDataPermissionService mdmDataPermissionService;
    @Autowired
    private MdmUserRelRoleService mdmUserRelRoleService;

    @Override
    public MdmFunctionRespVo query(MdmFunctionReqVo mdmFunctionReqVo) {
        MdmFunctionEntity one = (MdmFunctionEntity)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(!StringUtils.isEmpty((Object)mdmFunctionReqVo.getId()), BaseIdEntity::getId, (Object)mdmFunctionReqVo.getId())).eq(!StringUtils.isEmpty((Object)mdmFunctionReqVo.getFunctionCode()), MdmFunctionEntity::getFunctionCode, (Object)mdmFunctionReqVo.getFunctionCode())).in(!CollectionUtils.isEmpty((Collection)mdmFunctionReqVo.getFunctionCodeList()), MdmFunctionEntity::getFunctionCode, (Collection)mdmFunctionReqVo.getFunctionCodeList())).eq(!StringUtils.isEmpty((Object)mdmFunctionReqVo.getParentCode()), MdmFunctionEntity::getFunctionCode, (Object)mdmFunctionReqVo.getParentCode())).eq(!StringUtils.isEmpty((Object)mdmFunctionReqVo.getFunctionModule()), MdmFunctionEntity::getFunctionModule, (Object)mdmFunctionReqVo.getFunctionModule())).one();
        return (MdmFunctionRespVo)CrmBeanUtil.copy((Object)one, MdmFunctionRespVo.class);
    }

    @Override
    public List<String> conditionCodeList(MdmFunctionReqVo mdmFunctionReqVo) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).like(!StringUtils.isEmpty((Object)mdmFunctionReqVo.getFunctionCode()), MdmFunctionEntity::getFunctionCode, (Object)mdmFunctionReqVo.getFunctionCode())).like(!StringUtils.isEmpty((Object)mdmFunctionReqVo.getFunctionName()), MdmFunctionEntity::getFunctionName, (Object)mdmFunctionReqVo.getFunctionName())).eq(!StringUtils.isEmpty((Object)mdmFunctionReqVo.getParentCode()), MdmFunctionEntity::getParentCode, (Object)mdmFunctionReqVo.getParentCode())).eq(!StringUtils.isEmpty((Object)mdmFunctionReqVo.getFunctionModule()), MdmFunctionEntity::getFunctionModule, (Object)mdmFunctionReqVo.getFunctionModule())).eq(!StringUtils.isEmpty((Object)mdmFunctionReqVo.getFunctionConfig()), MdmFunctionEntity::getFunctionConfig, (Object)mdmFunctionReqVo.getFunctionConfig())).eq(!StringUtils.isEmpty((Object)mdmFunctionReqVo.getPageConfig()), MdmFunctionEntity::getPageConfig, (Object)mdmFunctionReqVo.getPageConfig())).eq(!StringUtils.isEmpty((Object)mdmFunctionReqVo.getMenuConfig()), MdmFunctionEntity::getMenuConfig, (Object)mdmFunctionReqVo.getMenuConfig())).select(new SFunction[]{MdmFunctionEntity::getFunctionCode}).list().stream().filter(x -> !StringUtils.isEmpty((Object)x.getFunctionCode())).map(MdmFunctionEntity::getFunctionCode).distinct().collect(Collectors.toList());
    }

    @Override
    public List<MdmFunctionRespVo> listCondition(MdmFunctionReqVo mdmFunctionReqVo) {
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).like(!StringUtils.isEmpty((Object)mdmFunctionReqVo.getFunctionCode()), MdmFunctionEntity::getFunctionCode, (Object)mdmFunctionReqVo.getFunctionCode())).like(!StringUtils.isEmpty((Object)mdmFunctionReqVo.getFunctionName()), MdmFunctionEntity::getFunctionName, (Object)mdmFunctionReqVo.getFunctionName())).eq(!StringUtils.isEmpty((Object)mdmFunctionReqVo.getParentCode()), MdmFunctionEntity::getParentCode, (Object)mdmFunctionReqVo.getParentCode())).eq(!StringUtils.isEmpty((Object)mdmFunctionReqVo.getFunctionModule()), MdmFunctionEntity::getFunctionModule, (Object)mdmFunctionReqVo.getFunctionModule())).eq(!StringUtils.isEmpty((Object)mdmFunctionReqVo.getFunctionConfig()), MdmFunctionEntity::getFunctionConfig, (Object)mdmFunctionReqVo.getFunctionConfig())).eq(!StringUtils.isEmpty((Object)mdmFunctionReqVo.getPageConfig()), MdmFunctionEntity::getPageConfig, (Object)mdmFunctionReqVo.getPageConfig())).eq(!StringUtils.isEmpty((Object)mdmFunctionReqVo.getMenuConfig()), MdmFunctionEntity::getMenuConfig, (Object)mdmFunctionReqVo.getMenuConfig())).orderByAsc(MdmFunctionEntity::getFunctionOrder)).list();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return new ArrayList<MdmFunctionRespVo>();
        }
        List mdmFunctionRespVos = CrmBeanUtil.copyList((List)list, MdmFunctionRespVo.class);
        this.setUpFunctionIcon(mdmFunctionRespVos);
        return mdmFunctionRespVos;
    }

    protected List<MdmFunctionRespVo> findCurrentUserFunctionList(MdmFunctionReqVo mdmFunctionReqVo) {
        List<Object> mdmFunctionRespVos = this.listCondition(mdmFunctionReqVo);
        if (CollectionUtils.isEmpty(mdmFunctionRespVos)) {
            return new ArrayList<MdmFunctionRespVo>();
        }
        MdmCheckAdminVo mdmCheckAdminVo = this.findCurrentUserFunctionCodeList();
        if (!mdmCheckAdminVo.isAuthorized()) {
            List functionCodeList = mdmCheckAdminVo.getFunctionCodeList();
            mdmFunctionRespVos = mdmFunctionRespVos.stream().filter(x -> functionCodeList.contains(x.getFunctionCode())).collect(Collectors.toList());
        }
        return mdmFunctionRespVos;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(MdmFunctionReqVo reqVo) {
        if (StringUtils.isEmpty((Object)reqVo.getFunctionCode())) {
            reqVo.setFunctionCode(CodeUtil.generateCode());
        }
        this.valid(reqVo);
        this.save(CrmBeanUtil.copy((Object)reqVo, MdmFunctionEntity.class));
    }

    private void valid(MdmFunctionReqVo reqVo) {
        String menuConfig;
        if (StringUtils.isEmpty((Object)reqVo.getFunctionOrder())) {
            reqVo.setFunctionOrder("1");
        }
        Assert.hasText((String)reqVo.getFunctionCode(), (String)"\u83dc\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)reqVo.getFunctionName(), (String)"\u83dc\u5355\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)reqVo.getFunctionModule(), (String)"\u83dc\u5355\u6a21\u5757\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)reqVo.getFunctionConfig(), (String)"\u83dc\u5355\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        String pageConfig = reqVo.getPageConfig();
        if (!StringUtils.isEmpty((Object)pageConfig)) {
            reqVo.setPageConfig(pageConfig.toUpperCase());
        }
        if (!StringUtils.isEmpty((Object)(menuConfig = reqVo.getMenuConfig()))) {
            reqVo.setMenuConfig(menuConfig.toUpperCase());
        }
        if (!YesNoEnum.yesNoEnum.Y.getValue().equalsIgnoreCase(reqVo.getMenuConfig())) {
            reqVo.setRelationBillCode(null);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(MdmFunctionReqVo reqVo) {
        this.valid(reqVo);
        Assert.hasText((String)reqVo.getId(), (String)"\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        MdmFunctionEntity entity = (MdmFunctionEntity)this.getById((Serializable)((Object)reqVo.getId()));
        Assert.notNull((Object)entity, (String)"\u83dc\u5355\u4e0d\u5b58\u5728");
        this.updateById(CrmBeanUtil.copy((Object)reqVo, MdmFunctionEntity.class));
        String functionCode = entity.getFunctionCode();
        if (!StringUtils.isEmpty((Object)functionCode)) {
            TableConfigUtil.removeFunction((String)functionCode);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(String functionCode) {
        Assert.hasText((String)functionCode, (String)"\u83dc\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        List<String> allChildFunctionCodeList = this.findAllChildFunctionCodeList(Collections.singletonList(functionCode));
        if (CollectionUtils.isEmpty(allChildFunctionCodeList)) {
            return;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(MdmFunctionEntity::getFunctionCode, allChildFunctionCodeList)).set(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.DISABLE.getCode())).set(CrmBaseEntity::getDelFlag, (Object)CrmEnableStatusEnum.DISABLE.getCode())).update();
        TableConfigUtil.removeAll();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(String functionCode) {
        Assert.hasText((String)functionCode, (String)"\u83dc\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        List<String> allParentFunctionCodeList = this.findAllParentFunctionCodeList(Collections.singletonList(functionCode), CrmEnableStatusEnum.DISABLE.getCode());
        if (allParentFunctionCodeList.size() > 1) {
            throw new BusinessException("\u5b58\u5728\u88ab\u7981\u7528\u7684\u4e0a\u7ea7\u83dc\u5355\uff0c\u65e0\u6cd5\u542f\u7528");
        }
        List<String> allChildFunctionCodeList = this.findAllChildFunctionCodeList(Collections.singletonList(functionCode));
        if (!CollectionUtils.isEmpty(allChildFunctionCodeList)) {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(MdmFunctionEntity::getFunctionCode, allChildFunctionCodeList)).set(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).update();
        }
        TableConfigUtil.removeAll();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(String functionCode) {
        Assert.hasText((String)functionCode, (String)"\u83dc\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        List<String> allChildFunctionCodeList = this.findAllChildFunctionCodeList(Collections.singletonList(functionCode));
        if (CollectionUtils.isEmpty(allChildFunctionCodeList)) {
            return;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(MdmFunctionEntity::getFunctionCode, allChildFunctionCodeList)).set(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.DISABLE.getCode())).update();
        TableConfigUtil.removeAll();
    }

    @Override
    public List<MdmFunctionRespVo> systemList(MdmFunctionReqVo mdmFunctionReqVo) {
        mdmFunctionReqVo.setFunctionConfig("0");
        return this.findCurrentUserFunctionList(mdmFunctionReqVo);
    }

    @Override
    public List<MdmFunctionRespVo> systemTree(MdmFunctionReqVo mdmFunctionReqVo) {
        mdmFunctionReqVo.setFunctionConfig("0");
        return this.functionTree(mdmFunctionReqVo);
    }

    @Override
    public List<String> findUserFunctionCodeList() {
        UserRedis user = UserUtils.getUser();
        Assert.notNull((Object)user, (String)"\u7528\u6237\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
        String username = user.getUsername();
        if (!AdminEnum.ADMIN.name().equalsIgnoreCase(username)) {
            HashSet<String> roleCodeSet = new HashSet<String>(16);
            if (UserTypeEnum.USER.getCode().equals(user.getUsertype())) {
                String positionCode = user.getPoscode();
                Assert.hasText((String)positionCode, (String)"\u5f53\u524d\u7528\u6237\u672a\u6307\u5b9a\u804c\u4f4d");
                List<String> roleCodeList = this.mdmPositionRoleService.findRoleCodeByPosition(Collections.singletonList(positionCode));
                Assert.notEmpty(roleCodeList, (String)("\u5f53\u524d\u804c\u4f4d[" + positionCode + "]\u672a\u5206\u914d\u89d2\u8272"));
                roleCodeSet.addAll(roleCodeList);
            } else if (UserTypeEnum.CUSTOMER.getCode().equals(user.getUsertype()) || UserTypeEnum.CUSTOMER_EMPLOYEE.getCode().equals(user.getUsertype())) {
                List<String> roleCodeList = this.mdmUserRelRoleService.findRoleCodeListByUserName(username);
                Assert.notEmpty(roleCodeList, (String)("\u5f53\u524d\u7528\u6237[" + username + "]\u672a\u5206\u914d\u89d2\u8272"));
                roleCodeSet.addAll(roleCodeList);
            }
            List<String> functionCodeList = this.mdmFunctionRoleService.findFunctionCodeByRole(new ArrayList<String>(roleCodeSet));
            if (CollectionUtils.isEmpty(functionCodeList)) {
                functionCodeList = new ArrayList<String>();
            }
            functionCodeList.addAll(this.functionWhiteList());
            return functionCodeList.stream().distinct().collect(Collectors.toList());
        }
        return this.lambdaQuery().select(new SFunction[]{MdmFunctionEntity::getFunctionCode}).list().stream().filter(x -> x != null && !StringUtils.isEmpty((Object)x.getFunctionCode())).map(MdmFunctionEntity::getFunctionCode).distinct().collect(Collectors.toList());
    }

    @Override
    public MdmCheckAdminVo findCurrentUserFunctionCodeList() {
        MdmCheckAdminVo mdmCheckAdminVo = new MdmCheckAdminVo();
        UserRedis user = UserUtils.getUser();
        Assert.notNull((Object)user, (String)"\u7528\u6237\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
        String username = user.getUsername();
        if (AdminEnum.ADMIN.name().equalsIgnoreCase(username)) {
            mdmCheckAdminVo.setAuthorized(true);
            return mdmCheckAdminVo;
        }
        HashSet<String> roleCodeSet = new HashSet<String>(16);
        if (UserTypeEnum.USER.getCode().equals(user.getUsertype())) {
            String positionCode = user.getPoscode();
            Assert.hasText((String)positionCode, (String)"\u5f53\u524d\u7528\u6237\u672a\u6307\u5b9a\u804c\u4f4d");
            List<String> roleCodeList = this.mdmPositionRoleService.findRoleCodeByPosition(Collections.singletonList(positionCode));
            Assert.notEmpty(roleCodeList, (String)("\u5f53\u524d\u804c\u4f4d[" + positionCode + "]\u672a\u5206\u914d\u89d2\u8272"));
            roleCodeSet.addAll(roleCodeList);
        } else if (UserTypeEnum.CUSTOMER.getCode().equals(user.getUsertype()) || UserTypeEnum.CUSTOMER_EMPLOYEE.getCode().equals(user.getUsertype())) {
            List<String> roleCodeList = this.mdmUserRelRoleService.findRoleCodeListByUserName(username);
            Assert.notEmpty(roleCodeList, (String)("\u5f53\u524d\u7528\u6237[" + username + "]\u672a\u5206\u914d\u89d2\u8272"));
            roleCodeSet.addAll(roleCodeList);
        }
        if (roleCodeSet.stream().anyMatch(x -> AdminEnum.ADMIN.name().equalsIgnoreCase((String)x))) {
            mdmCheckAdminVo.setAuthorized(true);
            return mdmCheckAdminVo;
        }
        List<String> functionCodeList = this.mdmFunctionRoleService.findFunctionCodeByRole(new ArrayList<String>(roleCodeSet));
        Assert.notEmpty(functionCodeList, (String)("\u5f53\u524d\u7528\u6237[" + username + "]\u672a\u5206\u914d\u83dc\u5355"));
        functionCodeList.addAll(this.functionWhiteList());
        functionCodeList = functionCodeList.stream().distinct().collect(Collectors.toList());
        mdmCheckAdminVo.setFunctionCodeList(functionCodeList);
        return mdmCheckAdminVo;
    }

    protected void setUpFunctionIcon(List<MdmFunctionRespVo> list) {
        List iconCodeList = list.stream().filter(x -> !StringUtils.isEmpty((Object)x.getIconCode())).map(MdmFunctionRespVo::getIconCode).distinct().collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(iconCodeList)) {
            MdmIconReqVo mdmIconReqVo = new MdmIconReqVo();
            mdmIconReqVo.setIconCodeList(iconCodeList);
            List<MdmIconRespVo> mdmIconRespVos = this.mdmIconService.listCondition(mdmIconReqVo);
            if (!CollectionUtils.isEmpty(mdmIconRespVos)) {
                Map<String, String> iconMap = mdmIconRespVos.stream().collect(Collectors.toMap(MdmIconRespVo::getIconCode, MdmIconRespVo::getIconStyle));
                for (MdmFunctionRespVo mdmFunctionRespVo : list) {
                    if (!StringUtils.isEmpty((Object)mdmFunctionRespVo.getFunctionIcon())) continue;
                    mdmFunctionRespVo.setFunctionIcon(iconMap.get(mdmFunctionRespVo.getIconCode()));
                }
            }
        }
    }

    private void setUpChildren(MdmFunctionRespVo mdmFunctionRespVo, List<MdmFunctionRespVo> list, List<MdmFunctionRespVo> result, List<MdmFunctionRespVo> subList) {
        if (StringUtils.isEmpty((Object)mdmFunctionRespVo.getParentCode()) || "".equals(mdmFunctionRespVo.getParentCode().trim())) {
            if (!result.contains(mdmFunctionRespVo)) {
                result.add(mdmFunctionRespVo);
            }
            if (!subList.contains(mdmFunctionRespVo)) {
                subList.add(mdmFunctionRespVo);
            }
            return;
        }
        if (subList.contains(mdmFunctionRespVo)) {
            return;
        }
        Optional<MdmFunctionRespVo> any = list.stream().filter(x -> mdmFunctionRespVo.getParentCode().equals(x.getFunctionCode())).findAny();
        if (!any.isPresent()) {
            return;
        }
        MdmFunctionRespVo parentTreeRespVo = any.get();
        ArrayList<MdmFunctionRespVo> children = parentTreeRespVo.getChildren();
        if (CollectionUtils.isEmpty((Collection)children)) {
            children = new ArrayList<MdmFunctionRespVo>();
        }
        children.add(mdmFunctionRespVo);
        children.sort(Comparator.comparing(x -> Optional.ofNullable(x.getFunctionOrder()).map(Integer::parseInt).orElse(100)));
        parentTreeRespVo.setChildren(children);
        subList.add(mdmFunctionRespVo);
        this.setUpChildren(parentTreeRespVo, list, result, subList);
    }

    @Override
    public List<MdmFunctionRespVo> listMdmFunctionByMenuConfig() {
        List entities = this.mdmFunctionMapper.selectList((Wrapper)Wrappers.lambdaQuery(MdmFunctionEntity.class).eq(MdmFunctionEntity::getMenuConfig, (Object)YesNoEnum.yesNoEnum.Y.getValue()));
        List mdmFunctionRespVos = CrmBeanUtil.copyList((List)entities, MdmFunctionRespVo.class);
        return mdmFunctionRespVos;
    }

    @Override
    public PageResult<MdmFunctionRespVo> functionPage(MdmFunctionReqVo mdmFunctionReqVo) {
        Page page = PageUtil.buildPage((Integer)mdmFunctionReqVo.getPageNum(), (Integer)mdmFunctionReqVo.getPageSize());
        List<MdmFunctionRespVo> list = this.mdmFunctionMapper.findList((Page<MdmFunctionRespVo>)page, mdmFunctionReqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public List<MdmRoleFunctionTreeVo> roleFunctionTree(MdmRoleFunctionReqVo mdmRoleFunctionReqVo) {
        String roleCode = mdmRoleFunctionReqVo.getRoleCode();
        Assert.hasText((String)roleCode, (String)"\u89d2\u8272\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        MdmFunctionReqVo mdmFunctionReqVo = new MdmFunctionReqVo();
        mdmFunctionReqVo.setFunctionConfig(mdmFunctionReqVo.getFunctionConfig());
        List<Object> functionList = this.mdmFunctionMapper.roleFunctionTree(mdmFunctionReqVo);
        if (CollectionUtils.isEmpty(functionList)) {
            return new ArrayList<MdmRoleFunctionTreeVo>();
        }
        List<String> functionCodeList = this.mdmFunctionRoleService.findFunctionCodeByRole(roleCode);
        if (!CollectionUtils.isEmpty(functionCodeList)) {
            functionList = functionList.stream().peek(x -> {
                if (functionCodeList.contains(x.getFunctionCode())) {
                    x.setFunctionSelect(YesNoEnum.yesNoEnum.ONE.getValue());
                }
            }).collect(Collectors.toList());
        }
        ArrayList<MdmRoleFunctionTreeVo> rootList = new ArrayList<MdmRoleFunctionTreeVo>();
        for (MdmRoleFunctionTreeVo mdmRoleFunctionTreeVo : functionList) {
            ArrayList<MdmRoleFunctionTreeVo> children;
            if (StringUtils.isEmpty((Object)mdmRoleFunctionTreeVo.getParentCode())) {
                rootList.add(mdmRoleFunctionTreeVo);
            }
            if ((children = mdmRoleFunctionTreeVo.getChildren()) == null) {
                children = new ArrayList<MdmRoleFunctionTreeVo>();
            }
            for (MdmRoleFunctionTreeVo mdmRoleFunctionTreeVo2 : functionList) {
                String parentCode = mdmRoleFunctionTreeVo2.getParentCode();
                if (StringUtils.isEmpty((Object)parentCode) || !parentCode.equals(mdmRoleFunctionTreeVo.getFunctionCode())) continue;
                children.add(mdmRoleFunctionTreeVo2);
            }
            children.sort(Comparator.comparing(x -> Optional.ofNullable(x.getFunctionOrder()).orElse(100)));
            mdmRoleFunctionTreeVo.setChildren(children);
        }
        rootList.sort(Comparator.comparing(x -> Optional.ofNullable(x.getFunctionOrder()).orElse(100)));
        return rootList;
    }

    @Override
    public List<MdmFunctionRespVo> functionTree(MdmFunctionReqVo mdmFunctionReqVo) {
        MdmCheckAdminVo mdmCheckAdminVo = this.findCurrentUserFunctionCodeList();
        List functionCodeList = mdmCheckAdminVo.getFunctionCodeList();
        if (!mdmCheckAdminVo.isAuthorized() && CollectionUtils.isEmpty((Collection)functionCodeList)) {
            return new ArrayList<MdmFunctionRespVo>();
        }
        MdmFunctionReqVo condition = new MdmFunctionReqVo();
        condition.setFunctionConfig(mdmFunctionReqVo.getFunctionConfig());
        List<MdmFunctionRespVo> allFunction = this.listCondition(condition);
        if (CollectionUtils.isEmpty(allFunction)) {
            return new ArrayList<MdmFunctionRespVo>();
        }
        mdmFunctionReqVo.setFunctionCodeList(functionCodeList);
        allFunction = this.convert(allFunction);
        allFunction = this.convert(allFunction, mdmFunctionReqVo);
        this.excludeCodeAndChildren(allFunction, mdmFunctionReqVo.getExcludeFunctionCode());
        return allFunction;
    }

    protected List<MdmFunctionRespVo> convert(List<MdmFunctionRespVo> list) {
        ArrayList<MdmFunctionRespVo> result = new ArrayList<MdmFunctionRespVo>();
        if (!CollectionUtils.isEmpty(list)) {
            Set functionCodeSet = list.stream().map(MdmFunctionRespVo::getFunctionCode).collect(Collectors.toSet());
            for (MdmFunctionRespVo mdmFunctionRespVo : list) {
                ArrayList<MdmFunctionRespVo> children;
                if (StringUtils.isEmpty((Object)mdmFunctionRespVo.getParentCode()) || !functionCodeSet.contains(mdmFunctionRespVo.getParentCode())) {
                    result.add(mdmFunctionRespVo);
                }
                if ((children = mdmFunctionRespVo.getChildren()) == null) {
                    children = new ArrayList<MdmFunctionRespVo>();
                }
                for (MdmFunctionRespVo functionRespVo : list) {
                    if (!mdmFunctionRespVo.getFunctionCode().equals(functionRespVo.getParentCode())) continue;
                    children.add(functionRespVo);
                }
                children.sort(Comparator.comparing(x -> {
                    String functionOrder = x.getFunctionOrder();
                    if (StringUtils.isEmpty((Object)functionOrder)) {
                        return 1000;
                    }
                    return Integer.parseInt(functionOrder);
                }));
                mdmFunctionRespVo.setChildren(children);
            }
            result.sort(Comparator.comparing(x -> {
                String functionOrder = x.getFunctionOrder();
                if (StringUtils.isEmpty((Object)functionOrder)) {
                    return 1000;
                }
                return Integer.parseInt(functionOrder);
            }));
        }
        return result;
    }

    protected List<MdmFunctionRespVo> convert(List<MdmFunctionRespVo> collect, MdmFunctionReqVo mdmFunctionReqVo) {
        if (CollectionUtils.isEmpty(collect)) {
            return collect;
        }
        for (MdmFunctionRespVo mdmFunctionRespVo : collect) {
            mdmFunctionRespVo.setChildren(this.convert(mdmFunctionRespVo.getChildren(), mdmFunctionReqVo));
        }
        return collect.stream().filter(x -> !CollectionUtils.isEmpty((Collection)x.getChildren()) || this.treeFilter(mdmFunctionReqVo, (MdmFunctionRespVo)x)).collect(Collectors.toList());
    }

    protected boolean treeFilter(MdmFunctionReqVo mdmFunctionReqVo, MdmFunctionRespVo x) {
        return !(!CollectionUtils.isEmpty((Collection)mdmFunctionReqVo.getFunctionCodeList()) && !mdmFunctionReqVo.getFunctionCodeList().contains(x.getFunctionCode()) || !StringUtils.isEmpty((Object)mdmFunctionReqVo.getFunctionName()) && !x.getFunctionName().contains(mdmFunctionReqVo.getFunctionName()) || !StringUtils.isEmpty((Object)mdmFunctionReqVo.getFunctionCode()) && !x.getFunctionName().contains(mdmFunctionReqVo.getFunctionCode()) || !StringUtils.isEmpty((Object)mdmFunctionReqVo.getPageConfig()) && !mdmFunctionReqVo.getPageConfig().equals(x.getPageConfig()));
    }

    @Override
    public List<MdmFunctionRespVo> constructFunctionTree(String functionName, List<MdmFunctionRespVo> mdmFunctionRespVos, List<String> selectFunctionCodeList) {
        ArrayList result = new ArrayList();
        ArrayList subList = new ArrayList();
        List<String> finalFunctionCodeList = this.findUserFunctionCodeList();
        mdmFunctionRespVos.stream().filter(x -> StringUtils.isEmpty((Object)functionName) || x.getFunctionName().contains(functionName)).filter(x -> CollectionUtils.isEmpty((Collection)selectFunctionCodeList) || selectFunctionCodeList.contains(x.getFunctionCode())).filter(x -> StringUtils.isEmpty((Object)x.getParentCode()) || finalFunctionCodeList.contains(x.getFunctionCode())).forEach(x -> this.setUpChildren((MdmFunctionRespVo)x, mdmFunctionRespVos, result, subList));
        return result.stream().filter(x -> !CollectionUtils.isEmpty((Collection)x.getChildren()) || finalFunctionCodeList.contains(x.getFunctionCode())).sorted(Comparator.comparing(x -> Optional.ofNullable(x.getFunctionOrder()).map(Integer::parseInt).orElse(100))).collect(Collectors.toList());
    }

    protected void excludeCodeAndChildren(List<MdmFunctionRespVo> tree, String excludeFunctionCode) {
        if (!CollectionUtils.isEmpty(tree) && !StringUtils.isEmpty((Object)excludeFunctionCode)) {
            Iterator<MdmFunctionRespVo> iterator = tree.iterator();
            while (iterator.hasNext()) {
                MdmFunctionRespVo item = iterator.next();
                if (item.getFunctionCode().equals(excludeFunctionCode)) {
                    iterator.remove();
                    return;
                }
                this.excludeCodeAndChildren(item.getChildren(), excludeFunctionCode);
            }
        }
    }

    @Override
    public List<String> findCurrentAndSubFunctionCodeList(String functionCode) {
        List currentFunctionCodeList = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmFunctionEntity::getFunctionCode, (Object)functionCode)).select(new SFunction[]{MdmFunctionEntity::getFunctionCode}).list().stream().filter(x -> x != null && !StringUtils.isEmpty((Object)x.getFunctionCode())).map(MdmFunctionEntity::getFunctionCode).distinct().collect(Collectors.toList());
        ArrayList<String> result = new ArrayList<String>();
        while (!CollectionUtils.isEmpty(currentFunctionCodeList)) {
            result.addAll(currentFunctionCodeList);
            currentFunctionCodeList = ((LambdaQueryChainWrapper)this.lambdaQuery().in(MdmFunctionEntity::getParentCode, currentFunctionCodeList)).select(new SFunction[]{MdmFunctionEntity::getFunctionCode}).list().stream().filter(x -> x != null && !StringUtils.isEmpty((Object)x.getFunctionCode())).map(MdmFunctionEntity::getFunctionCode).distinct().collect(Collectors.toList());
        }
        return result;
    }

    @Override
    public List<MdmFunctionRespVo> functionSearchTree(MdmFunctionSearchReqVo mdmFunctionSearchReqVo) {
        List<String> userFunctionCodeList = this.findUserFunctionCodeList();
        if (CollectionUtils.isEmpty(userFunctionCodeList)) {
            return new ArrayList<MdmFunctionRespVo>();
        }
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(!StringUtils.isEmpty((Object)mdmFunctionSearchReqVo.getFunctionConfig()), MdmFunctionEntity::getFunctionConfig, (Object)mdmFunctionSearchReqVo.getFunctionConfig())).list();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return new ArrayList<MdmFunctionRespVo>();
        }
        List mdmFunctionRespVos = CrmBeanUtil.copyList((List)list, MdmFunctionRespVo.class);
        ArrayList<MdmFunctionRespVo> root = new ArrayList<MdmFunctionRespVo>();
        String specificRootCode = mdmFunctionSearchReqVo.getSpecificRootCode();
        for (MdmFunctionRespVo mdmFunctionRespVo : mdmFunctionRespVos) {
            ArrayList<MdmFunctionRespVo> children;
            if (userFunctionCodeList.contains(mdmFunctionRespVo.getFunctionCode())) {
                if (!StringUtils.isEmpty((Object)specificRootCode)) {
                    if (specificRootCode.equals(mdmFunctionRespVo.getFunctionCode())) {
                        root.add(mdmFunctionRespVo);
                    }
                } else if (StringUtils.isEmpty((Object)mdmFunctionRespVo.getParentCode())) {
                    root.add(mdmFunctionRespVo);
                }
            }
            if ((children = mdmFunctionRespVo.getChildren()) == null) {
                children = new ArrayList<MdmFunctionRespVo>();
            }
            for (MdmFunctionRespVo functionRespVo : mdmFunctionRespVos) {
                if (!mdmFunctionRespVo.getFunctionCode().equals(functionRespVo.getParentCode())) continue;
                children.add(functionRespVo);
            }
            children.sort(Comparator.comparing(x -> Optional.ofNullable(x.getFunctionOrder()).map(Integer::parseInt).orElse(100)));
            mdmFunctionRespVo.setChildren(children);
        }
        this.excludeCodeAndChildren(root, mdmFunctionSearchReqVo.getExcludeFunctionCode());
        return root;
    }

    protected List<String> functionWhiteList() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("CRM20201128000000156");
        if (!StringUtils.isEmpty((Object)this.whiteFunctionCodeList)) {
            list.addAll(Arrays.asList(this.whiteFunctionCodeList.split(",")));
        }
        return list;
    }

    @Override
    public Map<String, String> flattenTree(List<MdmFunctionRespVo> list) {
        if (CollectionUtils.isEmpty(list)) {
            return Collections.emptyMap();
        }
        HashMap<String, String> map = new HashMap<String, String>(list.size());
        this.flattenTree("", list, map);
        return map;
    }

    protected void flattenTree(String path, List<MdmFunctionRespVo> functionRespVos, Map<String, String> map) {
        for (MdmFunctionRespVo mdmFunctionRespVo : functionRespVos) {
            String newPath = path + mdmFunctionRespVo.getFunctionName();
            List children = mdmFunctionRespVo.getChildren();
            if (CollectionUtils.isEmpty((Collection)children)) {
                map.put(mdmFunctionRespVo.getFunctionCode(), newPath);
                continue;
            }
            newPath = newPath + "-";
            this.flattenTree(newPath, children, map);
        }
    }

    @Override
    public Integer functionHight() {
        List<MdmFunctionRespVo> respVos = this.functionTree(new MdmFunctionReqVo());
        return this.functionHight(respVos);
    }

    @Override
    public List<MdmFunctionPermissionVo> findDataPermissionFunctionTree(MdmFunctionReqVo mdmFunctionReqVo) {
        MdmDataPermissionReqVo mdmDataPermissionReqVo;
        Map<String, List<String>> dataPermissionMap;
        Set functionCodeSet;
        List<MdmFunctionRespVo> list = this.mdmFunctionMapper.findSimpleList(new MdmFunctionReqVo());
        if (CollectionUtils.isEmpty(list)) {
            return new ArrayList<MdmFunctionPermissionVo>();
        }
        for (MdmFunctionRespVo mdmFunctionPermissionVo : list) {
            mdmFunctionPermissionVo.setFunctionAuthorized(YesNoEnum.yesNoEnum.ZERO.getValue());
            mdmFunctionPermissionVo.setFunctionPermission(YesNoEnum.yesNoEnum.ZERO.getValue());
        }
        List<MdmFunctionSubPermissionVo> mdmFunctionSubPermissionVos = this.mdmFunctionSubService.findMdmFunctionSubPermissionVos(new MdmFunctionSubReqVo());
        if (!CollectionUtils.isEmpty(mdmFunctionSubPermissionVos) && !CollectionUtils.isEmpty(functionCodeSet = mdmFunctionSubPermissionVos.stream().filter(x -> !StringUtils.isEmpty((Object)x.getParentCode())).map(MdmFunctionSubPermissionVo::getParentCode).collect(Collectors.toSet()))) {
            for (MdmFunctionRespVo mdmFunctionPermissionVo : list) {
                if (!functionCodeSet.contains(mdmFunctionPermissionVo.getFunctionCode())) continue;
                mdmFunctionPermissionVo.setFunctionPermission(YesNoEnum.yesNoEnum.ONE.getValue());
            }
        }
        if ((dataPermissionMap = this.mdmDataPermissionService.findDataPermissionMap(mdmDataPermissionReqVo = new MdmDataPermissionReqVo())) != null && !dataPermissionMap.isEmpty()) {
            for (MdmFunctionRespVo mdmFunctionPermissionVo : list) {
                if (!dataPermissionMap.containsKey(mdmFunctionPermissionVo.getFunctionCode())) continue;
                mdmFunctionPermissionVo.setFunctionAuthorized(YesNoEnum.yesNoEnum.ONE.getValue());
            }
        }
        MdmFunctionReqVo functionReqVo = new MdmFunctionReqVo();
        List<MdmFunctionRespVo> filterList = this.mdmFunctionMapper.findSimpleList(mdmFunctionReqVo);
        if (!CollectionUtils.isEmpty(filterList)) {
            List filterFunctionCodeList = filterList.stream().filter(functionCode -> !StringUtils.isEmpty((Object)functionCode)).map(MdmFunctionRespVo::getFunctionCode).distinct().collect(Collectors.toList());
            functionReqVo.setFunctionCodeList(filterFunctionCodeList);
        }
        return CrmBeanUtil.copyList(this.convert(this.convert(list), functionReqVo), MdmFunctionPermissionVo.class);
    }

    @Override
    public List<MdmFunctionPermissionVo> pageEngineTree(MdmFunctionReqVo mdmFunctionReqVo) {
        return CrmBeanUtil.copyList(this.allFunctionTree(mdmFunctionReqVo), MdmFunctionPermissionVo.class);
    }

    @Override
    public List<MdmFunctionRespVo> allFunctionTree(MdmFunctionReqVo mdmFunctionReqVo) {
        MdmCheckAdminVo mdmCheckAdminVo = this.findCurrentUserFunctionCodeList();
        ArrayList functionCodeList = mdmCheckAdminVo.getFunctionCodeList();
        if (!mdmCheckAdminVo.isAuthorized() && CollectionUtils.isEmpty((Collection)functionCodeList)) {
            return new ArrayList<MdmFunctionRespVo>();
        }
        MdmFunctionReqVo condition = new MdmFunctionReqVo();
        condition.setFunctionConfig(mdmFunctionReqVo.getFunctionConfig());
        List<MdmFunctionRespVo> allFunction = this.mdmFunctionMapper.findList(null, condition);
        if (CollectionUtils.isEmpty(allFunction)) {
            return new ArrayList<MdmFunctionRespVo>();
        }
        if (functionCodeList == null) {
            functionCodeList = new ArrayList();
        }
        mdmFunctionReqVo.setFunctionCodeList((List)functionCodeList);
        return this.convert(this.convert(allFunction), mdmFunctionReqVo);
    }

    protected int functionHight(List<MdmFunctionRespVo> respVos) {
        if (CollectionUtils.isEmpty(respVos)) {
            return 0;
        }
        int hight = 0;
        for (MdmFunctionRespVo mdmFunctionRespVo : respVos) {
            hight = Math.max(this.functionHight(mdmFunctionRespVo.getChildren()), hight);
        }
        return hight + 1;
    }

    protected List<String> findAllChildFunctionCodeList(List<String> functionCodeList) {
        if (CollectionUtils.isEmpty(functionCodeList)) {
            return new ArrayList<String>();
        }
        List realFunctionCodeList = functionCodeList.stream().filter(x -> !StringUtils.isEmpty((Object)x)).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(realFunctionCodeList)) {
            return new ArrayList<String>();
        }
        List<MdmFunctionPermissionVo> list = this.mdmFunctionMapper.findFunctionCodeList(new MdmFunctionReqVo());
        if (CollectionUtils.isEmpty(list)) {
            return new ArrayList<String>();
        }
        ArrayList<String> result = new ArrayList<String>();
        while (!CollectionUtils.isEmpty(realFunctionCodeList)) {
            result.addAll(realFunctionCodeList);
            List finalRealFunctionCodeList = realFunctionCodeList;
            realFunctionCodeList = list.stream().filter(x -> finalRealFunctionCodeList.contains(x.getParentCode())).map(MdmFunctionPermissionVo::getFunctionCode).collect(Collectors.toList());
        }
        return result;
    }

    protected List<String> findAllParentFunctionCodeList(List<String> functionCodeList, String enableStatus) {
        if (CollectionUtils.isEmpty(functionCodeList)) {
            return new ArrayList<String>();
        }
        List realFunctionCodeList = functionCodeList.stream().filter(x -> !StringUtils.isEmpty((Object)x)).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(realFunctionCodeList)) {
            return new ArrayList<String>();
        }
        MdmFunctionReqVo mdmFunctionReqVo = new MdmFunctionReqVo();
        mdmFunctionReqVo.setEnableStatus(enableStatus);
        List<MdmFunctionPermissionVo> list = this.mdmFunctionMapper.findFunctionCodeList(mdmFunctionReqVo);
        if (CollectionUtils.isEmpty(list)) {
            return new ArrayList<String>();
        }
        ArrayList<String> result = new ArrayList<String>();
        while (!CollectionUtils.isEmpty(realFunctionCodeList)) {
            result.addAll(realFunctionCodeList);
            List finalRealFunctionCodeList = realFunctionCodeList;
            realFunctionCodeList = list.stream().filter(x -> finalRealFunctionCodeList.contains(x.getFunctionCode())).map(MdmFunctionPermissionVo::getParentCode).filter(x -> !StringUtils.isEmpty((Object)x)).collect(Collectors.toList());
        }
        return result;
    }
}

