/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.material.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.common.PageResult;
import com.biz.crm.crmlog.handle.util.CrmLogSendUtil;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.material.mapper.MdmMaterialGroupMapper;
import com.biz.crm.material.mapper.MdmMaterialGroupRelMapper;
import com.biz.crm.material.model.MdmMaterialGroupEntity;
import com.biz.crm.material.model.MdmMaterialGroupRelEntity;
import com.biz.crm.material.service.MdmMaterialGroupService;
import com.biz.crm.material.service.MdmMaterialMediaService;
import com.biz.crm.material.service.MdmMaterialService;
import com.biz.crm.nebular.mdm.material.MdmMaterialMediaRespVo;
import com.biz.crm.nebular.mdm.material.MdmMaterialReqVo;
import com.biz.crm.nebular.mdm.material.MdmMaterialRespVo;
import com.biz.crm.nebular.mdm.materialGroup.MdmMaterialGroupReqVo;
import com.biz.crm.nebular.mdm.materialGroup.MdmMaterialGroupRespVo;
import com.biz.crm.nebular.mdm.productlevel.resp.MdmProductLevelVo;
import com.biz.crm.productlevel.service.MdmProductLevelService;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.ValidateUtils;
import io.jsonwebtoken.lang.Assert;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"MdmMaterialGroupServiceExpandImpl"})
public class MdmMaterialGroupServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmMaterialGroupMapper, MdmMaterialGroupEntity>
implements MdmMaterialGroupService {
    private static final Logger log = LoggerFactory.getLogger(MdmMaterialGroupServiceImpl.class);
    @Autowired
    private MdmMaterialGroupMapper materialGroupMapper;
    @Autowired
    private MdmMaterialService mdmMaterialService;
    @Autowired
    private MdmMaterialGroupRelMapper groupRelMapper;
    @Autowired
    private CrmLogSendUtil crmLogSendUtil;
    @Autowired
    private MdmProductLevelService mdmProductLevelService;
    @Autowired
    private MdmMaterialMediaService mdmMaterialMediaService;

    @Override
    public PageResult<MdmMaterialGroupRespVo> findList(MdmMaterialGroupReqVo groupReqVo) {
        Page page = PageUtil.buildPage((Integer)groupReqVo.getPageNum(), (Integer)groupReqVo.getPageSize());
        List<MdmMaterialGroupRespVo> list = this.materialGroupMapper.findList((Page<MdmMaterialGroupRespVo>)page, groupReqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public MdmMaterialGroupRespVo detail(String id, String materialGroupCode) {
        MdmMaterialGroupEntity one;
        MdmMaterialGroupRespVo respVo = new MdmMaterialGroupRespVo();
        if ((StringUtils.isNotEmpty((String)id) || StringUtils.isNotEmpty((String)materialGroupCode)) && (one = (MdmMaterialGroupEntity)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(StringUtils.isNotEmpty((String)id), BaseIdEntity::getId, (Object)id)).eq(StringUtils.isNotEmpty((String)materialGroupCode), MdmMaterialGroupEntity::getMaterialGroupCode, (Object)materialGroupCode)).one()) != null) {
            respVo = (MdmMaterialGroupRespVo)CrmBeanUtil.copy((Object)one, MdmMaterialGroupRespVo.class);
            List<MdmMaterialRespVo> materialList = this.mdmMaterialService.findMaterialByMaterialGroupCode(one.getMaterialGroupCode());
            respVo.setMaterialList(materialList);
        }
        return respVo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(MdmMaterialGroupReqVo groupReqVo) {
        Object menuObject;
        this.FieldValidation(groupReqVo);
        MdmMaterialGroupEntity entity = (MdmMaterialGroupEntity)CrmBeanUtil.copy((Object)groupReqVo, MdmMaterialGroupEntity.class);
        List materialList = groupReqVo.getMaterialList();
        entity.setMaterialNum(Integer.valueOf(materialList == null ? 0 : materialList.size()));
        this.save(entity);
        if (CollectionUtil.listNotEmpty((List)materialList)) {
            materialList.forEach(item -> {
                MdmMaterialGroupRelEntity relEntity = (MdmMaterialGroupRelEntity)CrmBeanUtil.copy((Object)item, MdmMaterialGroupRelEntity.class);
                relEntity.setMaterialGroupCode(entity.getMaterialGroupCode());
                this.groupRelMapper.insert(relEntity);
            });
        }
        if ((menuObject = ThreadLocalUtil.getObj((String)"menuCode")) != null) {
            this.crmLogSendUtil.sendForAdd(menuObject.toString(), entity.getId(), entity.getMaterialGroupCode(), CrmBeanUtil.copy((Object)entity, MdmMaterialGroupReqVo.class));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(MdmMaterialGroupReqVo groupReqVo) {
        Object menuObject;
        this.FieldValidation(groupReqVo);
        MdmMaterialGroupEntity entity = (MdmMaterialGroupEntity)this.getById((Serializable)((Object)groupReqVo.getId()));
        Assert.notNull((Object)entity, (String)"\u65e0\u6548\u7684id");
        MdmMaterialReqVo oldObject = (MdmMaterialReqVo)CrmBeanUtil.copy((Object)entity, MdmMaterialReqVo.class);
        CrmBeanUtil.copyProperties((Object)groupReqVo, (Object)entity);
        List materialList = groupReqVo.getMaterialList();
        entity.setMaterialNum(Integer.valueOf(materialList == null ? 0 : materialList.size()));
        this.updateById(entity);
        this.groupRelMapper.delete((Wrapper)Wrappers.lambdaQuery(MdmMaterialGroupRelEntity.class).eq(MdmMaterialGroupRelEntity::getMaterialGroupCode, (Object)entity.getMaterialGroupCode()));
        if (CollectionUtil.listNotEmpty((List)materialList)) {
            materialList.forEach(item -> {
                MdmMaterialGroupRelEntity relEntity = (MdmMaterialGroupRelEntity)CrmBeanUtil.copy((Object)item, MdmMaterialGroupRelEntity.class);
                relEntity.setMaterialGroupCode(entity.getMaterialGroupCode());
                this.groupRelMapper.insert(relEntity);
            });
        }
        if ((menuObject = ThreadLocalUtil.getObj((String)"menuCode")) != null) {
            MdmMaterialGroupReqVo newObject = (MdmMaterialGroupReqVo)CrmBeanUtil.copy((Object)entity, MdmMaterialGroupReqVo.class);
            this.crmLogSendUtil.sendForUpdate(menuObject.toString(), entity.getId(), entity.getMaterialGroupCode(), (Object)oldObject, (Object)newObject);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<String> ids) {
        ValidateUtils.validate(ids, (String)"ids\u4e0d\u80fd\u4e3a\u7a7a");
        Object menuObject = ThreadLocalUtil.getObj((String)"menuCode");
        for (String id : ids) {
            Assert.hasText((String)id, (String)"\u4e0d\u80fd\u4f20\u7a7a\u503c");
            MdmMaterialGroupEntity material = (MdmMaterialGroupEntity)this.getById((Serializable)((Object)id));
            Assert.notNull((Object)material, (String)"\u7269\u6599\u7ec4\u4e0d\u5b58\u5728");
            this.groupRelMapper.delete((Wrapper)Wrappers.lambdaQuery(MdmMaterialGroupRelEntity.class).eq(MdmMaterialGroupRelEntity::getMaterialGroupCode, (Object)material.getMaterialGroupCode()));
            if (menuObject == null) continue;
            this.crmLogSendUtil.sendForDel(menuObject.toString(), id, material.getMaterialGroupCode(), CrmBeanUtil.copy((Object)material, MdmMaterialGroupReqVo.class));
        }
        this.removeByIds(ids);
    }

    @Override
    public void enableBatch(List<String> ids) {
        Assert.notEmpty(ids, (String)"ids\u4e0d\u80fd\u4e3a\u7a7a");
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(BaseIdEntity::getId, ids)).set(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).update();
    }

    @Override
    public void disableBatch(List<String> ids) {
        Assert.notEmpty(ids, (String)"ids\u4e0d\u80fd\u4e3a\u7a7a");
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(BaseIdEntity::getId, ids)).set(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.DISABLE.getCode())).update();
    }

    @Override
    public PageResult<MdmMaterialGroupRespVo> pageGroupCpsList(MdmMaterialGroupReqVo groupReqVo) {
        List<MdmMaterialGroupRespVo> list;
        Page page = PageUtil.buildPage((Integer)groupReqVo.getPageNum(), (Integer)groupReqVo.getPageSize());
        List materialGroupCodes = groupReqVo.getMaterialGroupCodes();
        if (StringUtils.isNotEmpty((String)groupReqVo.getMaterialCode()) || CollectionUtil.listNotEmpty((List)groupReqVo.getMaterialCodes())) {
            List materialGroupRelList;
            List materialCodes = groupReqVo.getMaterialCodes();
            if (StringUtils.isNotEmpty((String)groupReqVo.getMaterialCode())) {
                materialCodes.add(groupReqVo.getMaterialCode());
            }
            if (CollectionUtil.listNotEmpty((List)(materialGroupRelList = this.groupRelMapper.selectList((Wrapper)Wrappers.lambdaQuery(MdmMaterialGroupRelEntity.class).in(MdmMaterialGroupRelEntity::getMaterialCode, (Collection)materialCodes))))) {
                List materialGroupList = materialGroupRelList.stream().map(MdmMaterialGroupRelEntity::getMaterialGroupCode).distinct().collect(Collectors.toList());
                materialGroupCodes.addAll(materialGroupList);
                groupReqVo.setMaterialGroupCodes(materialGroupCodes);
            }
        }
        if (CollectionUtil.listNotEmpty(list = this.materialGroupMapper.findCpsList((Page<MdmMaterialGroupRespVo>)page, groupReqVo))) {
            list.forEach(item -> {
                List<MdmMaterialRespVo> materialList = this.mdmMaterialService.findMaterialByMaterialGroupCode(item.getMaterialGroupCode());
                if (CollectionUtil.listNotEmpty(materialList)) {
                    materialList.forEach(materialItem -> {
                        List<MdmProductLevelVo> productLevelList = this.mdmProductLevelService.getParentCpsList(null, materialItem.getProductLevelCode());
                        materialItem.setProductLevels(productLevelList);
                        List<MdmMaterialMediaRespVo> mediaPicList = this.mdmMaterialMediaService.findMediaListByCondition(materialItem.getId(), materialItem.getMaterialCode());
                        materialItem.setPicList(mediaPicList);
                    });
                }
                item.setMaterialList(materialList);
            });
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    private void FieldValidation(MdmMaterialGroupReqVo groupReqVo) {
        AssertUtils.isNotEmpty((String)groupReqVo.getMaterialGroupCode(), (String)"\u7269\u6599\u7ec4\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)groupReqVo.getMaterialGroupName(), (String)"\u7269\u6599\u7ec4\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)groupReqVo.getDescription(), (String)"\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.isTrue((groupReqVo.getMaterialGroupCode().length() < 64 ? 1 : 0) != 0, (String)"\u7269\u6599\u7ec4\u7f16\u7801\uff0c\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((groupReqVo.getMaterialGroupName().length() < 64 ? 1 : 0) != 0, (String)"\u7269\u6599\u7ec4\u7f16\u7801\uff0c\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((groupReqVo.getDescription().length() < 255 ? 1 : 0) != 0, (String)"\u7269\u6599\u7ec4\u63cf\u8ff0\uff0c\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }
}

