/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.shoppingcart.consumer;

import com.biz.crm.mq.AbstractRocketMQConsumer;
import com.biz.crm.mq.RocketMQMessageBody;
import com.biz.crm.nebular.order.OrderVo;
import com.biz.crm.shoppingcart.service.ShoppingCartService;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.JsonPropertyUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.assertj.core.util.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
@RocketMQMessageListener(topic="${rocketmq.topic}${rocketmq.environment-variable}", selectorExpression="CLEAR_SHOPPING_CAR", consumerGroup="CLEAR_SHOPPING_CAR${rocketmq.environment-variable}")
public class ClearShopingCarConsumer
extends AbstractRocketMQConsumer {
    private static final Logger log = LoggerFactory.getLogger(ClearShopingCarConsumer.class);
    @Resource
    private ShoppingCartService shoppingCartService;

    protected Object handleMessage(RocketMQMessageBody message) throws InterruptedException {
        log.info("\u5220\u9664\u5546\u54c1\u5f00\u59cb------------------------");
        String msg = message.getMsgBody();
        if (StringUtils.isEmpty((Object)msg)) {
            log.info("\u6d88\u606f\u4e3a\u7a7a------------------------");
            return "\u6d88\u606f\u4e3a\u7a7a!";
        }
        log.info("\u5546\u54c1\u7f16\u7801{}", (Object)msg);
        OrderVo orderVo = (OrderVo)JsonPropertyUtil.toObject((String)msg, OrderVo.class);
        if (orderVo == null || CollectionUtil.listEmpty((List)orderVo.getGroupItemVos())) {
            log.info("\u5546\u54c1\u5217\u8868\u4e3a\u7a7a------------------------");
            return "\u5546\u54c1\u5217\u8868\u4e3a\u7a7a!";
        }
        ArrayList productCodes = Lists.newArrayList();
        orderVo.getGroupItemVos().forEach(group -> {
            if (CollectionUtil.listNotEmpty((List)group.getNormalList())) {
                group.getNormalList().forEach(d -> productCodes.add(d.getProductCode()));
            }
        });
        this.shoppingCartService.clearShoppingCar(orderVo.getCusCode(), productCodes);
        log.info("\u6e05\u7a7a\u8d2d\u7269\u8f66\u7ed3\u675f------------------------");
        return "\u64cd\u4f5c\u6210\u529f";
    }
}

