/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.login.controller;

import com.biz.crm.aop.CrmGlobalLog;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.mdm.LoginFromTypeEnum;
import com.biz.crm.login.service.MdmTerminalAppletLoginService;
import com.biz.crm.nebular.mdm.login.MdmAppletLoginEncryptReqVo;
import com.biz.crm.nebular.mdm.login.MdmAppletLoginParamRespVo;
import com.biz.crm.nebular.mdm.login.MdmAppletLoginReqVo;
import com.biz.crm.nebular.mdm.login.MdmLoginRespVo;
import com.biz.crm.nebular.mdm.login.MdmLoginTypeControlVo;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.weixin.OpenIdUtil;
import com.biz.crm.util.weixin.OpenIdVo;
import com.biz.crm.utils.LoginAesUtil;
import com.biz.crm.utils.LoginEncryptUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mdmTerminalAppletLoginController"})
@Api(tags={"MDM-\u7ec8\u7aef\u767b\u5f55\u767b\u51fa-TERMINAL\u5fae\u4fe1\u5c0f\u7a0b\u5e8f"})
@CrmGlobalLog
public class MdmTerminalAppletLoginController {
    private static final Logger log = LoggerFactory.getLogger(MdmTerminalAppletLoginController.class);
    @Autowired
    private MdmTerminalAppletLoginService mdmTerminalAppletLoginService;

    @ApiOperation(value="\u767b\u5f55\uff08\u8d26\u53f7+\u5bc6\u7801+openId\uff09")
    @PostMapping(value={"/login"})
    public Result<MdmLoginRespVo> login(@RequestBody MdmAppletLoginEncryptReqVo reqVo) {
        return Result.ok((Object)this.mdmTerminalAppletLoginService.login(this.revert(reqVo)));
    }

    @ApiOperation(value="\u767b\u5f55")
    @PostMapping(value={"/loginAuto"})
    public Result<MdmLoginRespVo> loginAuto(@RequestBody MdmAppletLoginEncryptReqVo reqVo) {
        return Result.ok((Object)this.mdmTerminalAppletLoginService.loginAuto(this.revert(reqVo)));
    }

    @ApiOperation(value="\u767b\u5f55\uff08\u624b\u673a\u53f7+\u5bc6\u7801+openId\uff09")
    @PostMapping(value={"/loginByPhone"})
    public Result<MdmLoginRespVo> loginByPhone(@RequestBody MdmAppletLoginEncryptReqVo reqVo) {
        return Result.ok((Object)this.mdmTerminalAppletLoginService.loginByPhone(this.revert(reqVo)));
    }

    @ApiOperation(value="\u767b\u5f55\uff08\u624b\u673a\u53f7+\u9a8c\u8bc1\u7801+openId\uff09")
    @PostMapping(value={"/loginByPhoneVerification"})
    public Result<MdmLoginRespVo> loginByPhoneVerification(@RequestBody MdmAppletLoginEncryptReqVo reqVo) {
        return Result.ok((Object)this.mdmTerminalAppletLoginService.loginByPhoneVerification(this.revert(reqVo)));
    }

    @ApiOperation(value="\u53d1\u9001\u624b\u673a\u53f7\u767b\u5f55\u9a8c\u8bc1\u7801")
    @PostMapping(value={"/sendVerificationForLoginByMessage"})
    public Result sendVerificationForLoginByMessage(@RequestBody MdmAppletLoginEncryptReqVo reqVo) {
        this.mdmTerminalAppletLoginService.sendVerificationForLoginByMessage(this.revert(reqVo));
        return Result.ok();
    }

    @ApiOperation(value="\u514d\u5bc6\u767b\u5f55\uff08\u901a\u8fc7\u5fae\u4fe1\u767b\u5f55\u51ed\u8bc1\uff09\u5e76\u4e14\u83b7\u5f97openId")
    @PostMapping(value={"/loginByCode"})
    public Result<MdmLoginRespVo> loginByCode(@RequestBody MdmAppletLoginEncryptReqVo reqVo) {
        MdmLoginRespVo mdmLoginRespVo = new MdmLoginRespVo();
        mdmLoginRespVo.setAppletOpenIdLoginSuccessFlag(YesNoEnum.yesNoEnum.ONE.getValue());
        try {
            String code = reqVo.getCxfyzzpcxaqcwmai();
            Assert.hasText((String)code, (String)"\u7f3a\u5931\u5fae\u4fe1\u767b\u5f55\u51ed\u8bc1");
            OpenIdVo openIdVo = OpenIdUtil.getSfaAppletOpenId((String)code);
            Assert.notNull((Object)openIdVo, (String)"\u83b7\u53d6openId\u5931\u8d25");
            Assert.hasText((String)openIdVo.getOpenid(), (String)"\u83b7\u53d6openId\u5931\u8d25");
            mdmLoginRespVo.setOpenId(openIdVo.getOpenid());
            MdmAppletLoginReqVo revert = this.revert(reqVo);
            revert.setOpenId(openIdVo.getOpenid());
            mdmLoginRespVo = this.mdmTerminalAppletLoginService.loginByOpenId(revert);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u514d\u5bc6\u767b\u5f55\uff08\u901a\u8fc7\u5fae\u4fe1\u767b\u5f55\u51ed\u8bc1\uff09\u5931\u8d25\uff1a{}", (Throwable)e);
            mdmLoginRespVo.setAppletOpenIdLoginSuccessFlag(YesNoEnum.yesNoEnum.ZERO.getValue());
        }
        return Result.ok((Object)mdmLoginRespVo);
    }

    @ApiOperation(value="\uff08\u4e0d\u5b89\u5168\uff09\u514d\u5bc6\u767b\u5f55\uff08\u901a\u8fc7openId\uff09")
    @PostMapping(value={"/loginByOpenId"})
    public Result<MdmLoginRespVo> loginByOpenId(@RequestBody MdmAppletLoginEncryptReqVo reqVo) {
        MdmLoginRespVo mdmLoginRespVo = null;
        try {
            mdmLoginRespVo = this.mdmTerminalAppletLoginService.loginByOpenId(this.revert(reqVo));
            mdmLoginRespVo.setAppletOpenIdLoginSuccessFlag(YesNoEnum.yesNoEnum.ONE.getValue());
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u514d\u5bc6\u767b\u5f55\uff08\u901a\u8fc7openId\uff09\u5931\u8d25\uff1a{}", (Throwable)e);
            mdmLoginRespVo = new MdmLoginRespVo();
            mdmLoginRespVo.setAppletOpenIdLoginSuccessFlag(YesNoEnum.yesNoEnum.ZERO.getValue());
        }
        return Result.ok((Object)mdmLoginRespVo);
    }

    @ApiOperation(value="\u53d1\u9001\u91cd\u7f6e\u5bc6\u7801\u9a8c\u8bc1\u7801\uff08\u624b\u673a\u53f7\uff09")
    @PostMapping(value={"/sendVerificationForLoginAndResetByMessage"})
    public Result sendVerificationForLoginAndResetByMessage(@RequestBody MdmAppletLoginEncryptReqVo reqVo) {
        this.mdmTerminalAppletLoginService.sendVerificationForLoginAndResetByMessage(this.revert(reqVo));
        return Result.ok();
    }

    @ApiOperation(value="\u6821\u9a8c\u624b\u673a\u53f7\u662f\u5426\u5b58\u5728\u4e14\u53ef\u7528")
    @PostMapping(value={"/checkPhoneExistAndUsable"})
    public Result checkPhoneExistAndUsable(@RequestBody MdmAppletLoginEncryptReqVo reqVo) {
        this.mdmTerminalAppletLoginService.checkPhoneExistAndUsable(this.revert(reqVo));
        return Result.ok();
    }

    @ApiOperation(value="\u9a8c\u8bc1\u91cd\u7f6e\u5bc6\u7801\u9a8c\u8bc1\u7801\u5e76\u767b\u5f55\uff08\u624b\u673a\u53f7+\u9a8c\u8bc1\u7801\uff09")
    @PostMapping(value={"/loginAndResetByPhoneVerification"})
    public Result<MdmLoginRespVo> loginAndResetByPhoneVerification(@RequestBody MdmAppletLoginEncryptReqVo reqVo) {
        return Result.ok((Object)this.mdmTerminalAppletLoginService.loginAndResetByPhoneVerification(this.revert(reqVo)));
    }

    @ApiOperation(value="\u83b7\u53d6\u767b\u5f55\u65b9\u5f0f\u7684\u63a7\u5236\u53c2\u6570")
    @PostMapping(value={"/getLoginTypeControlConfig"})
    public Result<MdmLoginTypeControlVo> getLoginTypeControlConfig() {
        return Result.ok((Object)this.mdmTerminalAppletLoginService.getLoginTypeControlConfig());
    }

    @ApiOperation(value="\u9000\u51fa\u767b\u5f55\uff08\u9000\u51fa\u5f53\u524d\u4f1a\u8bdd\uff09")
    @PostMapping(value={"/logout"})
    public Result logout() {
        this.mdmTerminalAppletLoginService.logout();
        return Result.ok();
    }

    @ApiOperation(value="\u9000\u51fa\u767b\u5f55\uff08\u9000\u51fa\u5f53\u524d\u4f1a\u8bdd\u8d26\u53f7\u5728SFA\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u7684\u5168\u90e8\u4f1a\u8bdd\uff09")
    @PostMapping(value={"/logoutFromType"})
    public Result logoutFromType() {
        this.mdmTerminalAppletLoginService.logoutFromType();
        return Result.ok();
    }

    @ApiOperation(value="\u9000\u51fa\u767b\u5f55\uff08\u9000\u51fa\u5f53\u524d\u4f1a\u8bdd\u8d26\u53f7\u5728\u6240\u6709\u5e73\u53f0\u7684\u5168\u90e8\u4f1a\u8bdd\uff09")
    @PostMapping(value={"/logoutAll"})
    public Result logoutAll() {
        this.mdmTerminalAppletLoginService.logoutAll();
        return Result.ok();
    }

    @ApiOperation(value="\u6839\u636e\u5fae\u4fe1\u767b\u5f55\u51ed\u8bc1\u83b7\u53d6\u7ec8\u7aef\u5c0f\u7a0b\u5e8fopenId", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="code", value="\u5fae\u4fe1\u767b\u5f55\u51ed\u8bc1", required=true, dataType="String", paramType="query")})
    @GetMapping(value={"/getTerminalAppletOpenIdByCode"})
    public Result<MdmAppletLoginParamRespVo> getTerminalAppletOpenIdByCode(@RequestParam(value="code", required=true) String code) {
        OpenIdVo openIdVo = OpenIdUtil.getTerminalAppletOpenId((String)code);
        Assert.notNull((Object)openIdVo, (String)"\u83b7\u53d6openId\u5931\u8d25");
        Assert.hasText((String)openIdVo.getOpenid(), (String)"\u83b7\u53d6openId\u5931\u8d25");
        MdmAppletLoginParamRespVo respVo = new MdmAppletLoginParamRespVo();
        respVo.setOpenId(openIdVo.getOpenid());
        return Result.ok((Object)respVo);
    }

    private MdmAppletLoginReqVo revert(MdmAppletLoginEncryptReqVo reqVo) {
        ThreadLocalUtil.delObj();
        MdmAppletLoginReqVo loginReqVo = new MdmAppletLoginReqVo();
        if (StringUtils.isNotEmpty((String)reqVo.getUjlrwebjruzddjnu())) {
            loginReqVo.setUserName(reqVo.getUjlrwebjruzddjnu());
        }
        if (StringUtils.isNotEmpty((String)reqVo.getPthxivgijazekrss())) {
            loginReqVo.setPassword(LoginAesUtil.decrypt(reqVo.getPthxivgijazekrss()));
        } else if (StringUtils.isNotEmpty((String)reqVo.getPazjofxkyvyoosot())) {
            loginReqVo.setPassword(LoginEncryptUtil.decrypt(reqVo.getPazjofxkyvyoosot()));
        } else if (StringUtils.isNotEmpty((String)reqVo.getPenijmgsbybkfjvr())) {
            loginReqVo.setPassword(reqVo.getPenijmgsbybkfjvr());
        }
        if (StringUtils.isNotEmpty((String)reqVo.getTwpbmjhfxodboggf())) {
            loginReqVo.setUserPhone(reqVo.getTwpbmjhfxodboggf());
        }
        if (StringUtils.isNotEmpty((String)reqVo.getExzvsxwhvcvcctyk())) {
            loginReqVo.setEmail(reqVo.getExzvsxwhvcvcctyk());
        }
        if (StringUtils.isNotEmpty((String)reqVo.getVfymxygsefoeapvk())) {
            loginReqVo.setVerificationCode(reqVo.getVfymxygsefoeapvk());
        }
        if (StringUtils.isNotEmpty((String)reqVo.getOictwizfeumvvukh())) {
            loginReqVo.setOpenId(reqVo.getOictwizfeumvvukh());
        }
        if (StringUtils.isNotEmpty((String)reqVo.getWhspxyaumrkpgppm())) {
            loginReqVo.setHeadImgUrl(reqVo.getWhspxyaumrkpgppm());
        }
        if (StringUtils.isNotEmpty((String)reqVo.getWntyjilgzehqkbmy())) {
            loginReqVo.setNickName(reqVo.getWntyjilgzehqkbmy());
        }
        if (StringUtils.isNotEmpty((String)reqVo.getTerminalCode())) {
            loginReqVo.setTerminalCode(reqVo.getTerminalCode());
        }
        if (StringUtils.isNotEmpty((String)reqVo.getCustomerCode())) {
            loginReqVo.setCustomerCode(reqVo.getCustomerCode());
        }
        loginReqVo.setFromType(LoginFromTypeEnum.APPLET_TERMINAL.getValue());
        return loginReqVo;
    }

    @ApiOperation(value="cps\u7ec8\u7aef\u6ce8\u518c\u65f6\u53d1\u9001\u624b\u673a\u53f7\u83b7\u53d6\u9a8c\u8bc1\u7801")
    @PostMapping(value={"/sendTerminalVerificationByMessage"})
    public Result sendTerminalVerificationByMessage(@RequestParam(value="phoneCode") String phoneCode) {
        this.mdmTerminalAppletLoginService.sendTerminalVerificationByMessage(phoneCode);
        return Result.ok();
    }

    @ApiOperation(value="cps\u7ec8\u7aef\u6ce8\u518c\u65f6\u9a8c\u8bc1\uff1a\u9a8c\u8bc1\u7801\u5bf9\u5e94\u7684\u624b\u673a\u53f7\u7801\u662f\u5426\u6b63\u786e")
    @PostMapping(value={"/VerificationPhoneByCode"})
    public Result<Boolean> VerificationPhoneByCode(@RequestParam(value="phoneCode") String phoneCode, @RequestParam(value="verificationCode") String verificationCode) {
        this.mdmTerminalAppletLoginService.VerificationPhoneByCode(phoneCode, verificationCode);
        return Result.ok((Object)true);
    }

    @ApiOperation(value="\u767b\u5f55(openId+\u624b\u673a\u53f7+\u7ec8\u7aef\u7f16\u7801/\u5ba2\u6237\u7f16\u7801)")
    @PostMapping(value={"/loginByOpenIdAndPhoneAndCode"})
    public Result<MdmLoginRespVo> loginByOpenIdAndPhoneAndCode(@RequestBody MdmAppletLoginEncryptReqVo reqVo) {
        return Result.ok((Object)this.mdmTerminalAppletLoginService.loginByOpenIdAndPhoneAndCode(this.revert(reqVo)));
    }

    @ApiOperation(value="\u7528\u6237\u5207\u6362\u7ec8\u7aef")
    @PostMapping(value={"/switchoverTerminal"})
    public Result switchoverTerminal(@RequestBody MdmAppletLoginEncryptReqVo reqVo) {
        this.mdmTerminalAppletLoginService.switchoverTerminal(this.revert(reqVo));
        return Result.ok();
    }
}

