/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.login.service.impl;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.biz.crm.base.BusinessException;
import com.biz.crm.customer.service.MdmCustomerMsgService;
import com.biz.crm.customer.service.MdmCustomerROrgService;
import com.biz.crm.dict.service.MdmDictDataService;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.mdm.LoginFromTypeEnum;
import com.biz.crm.login.service.MdmLoginHelpService;
import com.biz.crm.login.service.MdmSystemLoginService;
import com.biz.crm.login.service.MdmTerminalAppletLoginService;
import com.biz.crm.message.ShortMessage;
import com.biz.crm.nebular.mdm.constant.UserTypeEnum;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.mdm.login.MdmAppletLoginReqVo;
import com.biz.crm.nebular.mdm.login.MdmLoginRespVo;
import com.biz.crm.nebular.mdm.login.MdmLoginTypeControlVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionUserOrgRespVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalLoginVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalVo;
import com.biz.crm.nebular.mdm.user.req.MdmUserRelWeChatReqVo;
import com.biz.crm.nebular.mdm.user.resp.MdmUserLoginLogRespVo;
import com.biz.crm.nebular.mdm.user.resp.MdmUserRelWeChatRespVo;
import com.biz.crm.nebular.mdm.user.resp.MdmUserRespVo;
import com.biz.crm.org.service.MdmOrgService;
import com.biz.crm.position.service.MdmPositionService;
import com.biz.crm.service.RedisService;
import com.biz.crm.terminal.model.MdmTerminalEntity;
import com.biz.crm.terminal.service.MdmTerminalService;
import com.biz.crm.user.service.MdmUserLoginLogAsyncService;
import com.biz.crm.user.service.MdmUserLoginLogService;
import com.biz.crm.user.service.MdmUserRelWeChatService;
import com.biz.crm.user.service.MdmUserService;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CookiesUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.HttpServletRequestUtil;
import com.biz.crm.util.Md5EncryptionAndDecryption;
import com.biz.crm.util.ParamUtil;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.util.ValidateUtils;
import com.biz.crm.utils.LoginHelpUtil;
import com.biz.crm.webservice.message.ShortMessageFeign;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
@ConditionalOnMissingBean(name={"MdmTerminalAppletLoginServiceExpandImpl"})
public class MdmTerminalAppletLoginServiceImpl
implements MdmTerminalAppletLoginService {
    private static final Logger log = LoggerFactory.getLogger(MdmTerminalAppletLoginServiceImpl.class);
    @Autowired
    private MdmUserRelWeChatService mdmUserRelWeChatService;
    @Resource
    private MdmUserService mdmUserService;
    @Resource
    private MdmPositionService mdmPositionService;
    @Resource
    private MdmUserLoginLogService mdmUserLoginLogService;
    @Resource
    private MdmUserLoginLogAsyncService mdmUserLoginLogAsyncService;
    @Resource
    private MdmSystemLoginService mdmSystemLoginService;
    @Resource
    private MdmOrgService mdmOrgService;
    @Resource
    private MdmLoginHelpService mdmLoginHelpService;
    @Resource
    private MdmTerminalService mdmTerminalService;
    @Resource
    private MdmCustomerMsgService mdmCustomerMsgService;
    @Resource
    private MdmCustomerROrgService mdmCustomerROrgService;
    @Resource
    private RedisService redisService;
    @Resource
    private MdmDictDataService mdmDictDataService;
    @Autowired(required=false)
    private ShortMessageFeign shortMessageFeign;

    @Override
    public MdmLoginRespVo loginAuto(MdmAppletLoginReqVo reqVo) {
        Assert.hasText((String)reqVo.getUserName(), (String)"\u7f3a\u5931\u8d26\u53f7");
        this.mdmLoginHelpService.checkLock(reqVo.getUserName(), LoginHelpUtil.AccountType.USER_NAME);
        MdmUserRespVo user = this.mdmUserService.getUserForLogin(reqVo.getUserName(), null, null);
        this.mdmLoginHelpService.checkUserLogin(user.getEnableStatus(), user.getStartTime(), user.getEndTime());
        return this.doLoginThisSystem(user, reqVo, true, false, true);
    }

    @Override
    public MdmLoginRespVo login(MdmAppletLoginReqVo reqVo) {
        Assert.hasText((String)reqVo.getUserName(), (String)"\u7f3a\u5931\u8d26\u53f7");
        Assert.hasText((String)reqVo.getPassword(), (String)"\u7f3a\u5931\u5bc6\u7801");
        this.mdmLoginHelpService.checkLock(reqVo.getUserName(), LoginHelpUtil.AccountType.USER_NAME);
        MdmUserRespVo user = this.mdmUserService.getUserForLogin(reqVo.getUserName(), null, null);
        this.mdmLoginHelpService.checkUserType(user.getUserType(), reqVo.getFromType());
        this.mdmLoginHelpService.checkUserLogin(user.getEnableStatus(), user.getStartTime(), user.getEndTime());
        if (Md5EncryptionAndDecryption.checkPwd((String)reqVo.getPassword(), (String)user.getUserPassword())) {
            this.mdmLoginHelpService.unlock(user.getUserName(), user.getUserPhone(), user.getEmail());
        } else {
            this.mdmLoginHelpService.addError(user.getUserName(), user.getUserPhone(), user.getEmail());
        }
        return this.doLoginThisSystem(user, reqVo, true, false, true);
    }

    @Override
    public MdmLoginRespVo loginByPhone(MdmAppletLoginReqVo reqVo) {
        Assert.hasText((String)reqVo.getUserPhone(), (String)"\u7f3a\u5931\u624b\u673a\u53f7");
        Assert.hasText((String)reqVo.getPassword(), (String)"\u7f3a\u5931\u5bc6\u7801");
        this.mdmLoginHelpService.checkLock(reqVo.getUserPhone(), LoginHelpUtil.AccountType.PHONE);
        MdmUserRespVo user = this.mdmUserService.getUserForLogin(null, reqVo.getUserPhone(), null);
        this.mdmLoginHelpService.checkUserType(user.getUserType(), reqVo.getFromType());
        this.mdmLoginHelpService.checkUserLogin(user.getEnableStatus(), user.getStartTime(), user.getEndTime());
        if (Md5EncryptionAndDecryption.checkPwd((String)reqVo.getPassword(), (String)user.getUserPassword())) {
            this.mdmLoginHelpService.unlock(user.getUserName(), user.getUserPhone(), user.getEmail());
        } else {
            this.mdmLoginHelpService.addError(user.getUserName(), user.getUserPhone(), user.getEmail());
        }
        return this.doLoginThisSystem(user, reqVo, true, false, true);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public MdmLoginRespVo loginByPhoneVerification(MdmAppletLoginReqVo reqVo) {
        Assert.hasText((String)reqVo.getUserPhone(), (String)"\u7f3a\u5931\u624b\u673a\u53f7");
        Assert.hasText((String)reqVo.getVerificationCode(), (String)"\u7f3a\u5931\u9a8c\u8bc1\u7801");
        this.mdmLoginHelpService.checkLock(reqVo.getUserPhone(), LoginHelpUtil.AccountType.PHONE);
        String userName = this.mdmLoginHelpService.checkVerificationCode(reqVo.getFromType(), reqVo.getVerificationCode(), reqVo.getUserPhone(), LoginHelpUtil.AccountType.PHONE, LoginHelpUtil.VerificationCodeType.LOGIN);
        MdmUserRespVo user = this.mdmUserService.getUserForLogin(userName, null, null);
        Assert.isTrue((boolean)reqVo.getUserPhone().equals(user.getUserPhone()), (String)"\u624b\u673a\u53f7\u5173\u8054\u7528\u6237\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
        this.mdmLoginHelpService.checkUserType(user.getUserType(), reqVo.getFromType());
        this.mdmLoginHelpService.checkUserLogin(user.getEnableStatus(), user.getStartTime(), user.getEndTime());
        this.mdmLoginHelpService.unlock(user.getUserName(), user.getUserPhone(), user.getEmail());
        return this.doLoginThisSystem(user, reqVo, true, false, true);
    }

    @Override
    public void sendVerificationForLoginByMessage(MdmAppletLoginReqVo reqVo) {
        Assert.hasText((String)reqVo.getUserPhone(), (String)"\u7f3a\u5931\u624b\u673a\u53f7");
        this.mdmLoginHelpService.checkLock(reqVo.getUserPhone(), LoginHelpUtil.AccountType.PHONE);
        MdmUserRespVo user = this.mdmUserService.getUserForLogin(null, reqVo.getUserPhone(), null);
        this.mdmLoginHelpService.checkLock(user.getUserName(), LoginHelpUtil.AccountType.USER_NAME);
        this.mdmLoginHelpService.checkLock(user.getEmail(), LoginHelpUtil.AccountType.EMAIL);
        this.mdmLoginHelpService.checkUserType(user.getUserType(), reqVo.getFromType());
        this.mdmLoginHelpService.checkUserLogin(user.getEnableStatus(), user.getStartTime(), user.getEndTime());
        String verification = this.mdmLoginHelpService.saveLoginVerificationCodeRelUser(reqVo.getFromType(), user.getUserName(), user.getUserPhone(), LoginHelpUtil.AccountType.PHONE, LoginHelpUtil.VerificationCodeType.LOGIN);
        this.mdmLoginHelpService.sendVerificationCode(reqVo.getFromType(), verification, user.getUserPhone(), LoginHelpUtil.AccountType.PHONE, LoginHelpUtil.VerificationCodeType.LOGIN);
    }

    @Override
    public MdmLoginRespVo loginByOpenId(MdmAppletLoginReqVo reqVo) {
        String openId = reqVo.getOpenId();
        Assert.hasText((String)openId, (String)"\u7f3a\u5931openId");
        List<MdmUserRelWeChatRespVo> list = this.mdmUserRelWeChatService.getBindUserListByOpenId(openId, LoginFromTypeEnum.APPLET_SFA.getValue());
        Assert.notEmpty(list, (String)"\u5fae\u4fe1\u672a\u7ed1\u5b9a\u4efb\u4f55\u7528\u6237");
        Assert.isTrue((list.size() == 1 ? 1 : 0) != 0, (String)"\u5fae\u4fe1\u7ed1\u5b9a\u4e86\u591a\u4e2a\u7528\u6237");
        MdmUserRelWeChatRespVo one = list.get(0);
        if (YesNoEnum.yesNoEnum.Y.getValue().equals(ParamUtil.getParameterValue((String)"sfa_applet_user_unique_flag"))) {
            List<MdmUserRelWeChatRespVo> userRelList = this.mdmUserRelWeChatService.getBindWeChatListByUserName(one.getUserName(), LoginFromTypeEnum.APPLET_SFA.getValue());
            Assert.isTrue((userRelList.size() == 1 ? 1 : 0) != 0, (String)"\u7528\u6237\u7ed1\u5b9a\u4e86\u591a\u4e2a\u5fae\u4fe1\uff0c\u8bf7\u5148\u5728\u540e\u53f0\u89e3\u7ed1");
        }
        Assert.isTrue((boolean)YesNoEnum.yesNoEnum.ONE.getValue().equals(one.getLoginStatus()), (String)"\u5904\u4e8e\u9000\u51fa\u767b\u5f55\u72b6\u6001\uff0c\u9700\u8981\u91cd\u65b0\u767b\u5f55");
        this.mdmLoginHelpService.checkLock(one.getUserName(), LoginHelpUtil.AccountType.USER_NAME);
        MdmUserRespVo user = this.mdmUserService.getUserForLogin(one.getUserName(), null, null);
        this.mdmLoginHelpService.checkUserType(user.getUserType(), reqVo.getFromType());
        this.mdmLoginHelpService.checkUserLogin(user.getEnableStatus(), user.getStartTime(), user.getEndTime());
        this.mdmLoginHelpService.unlock(user.getUserName(), user.getUserPhone(), user.getEmail());
        return this.doLoginThisSystem(user, reqVo, true, false, false);
    }

    @Override
    public MdmLoginRespVo loginByOpenIdAndPhoneAndCode(MdmAppletLoginReqVo reqVo) {
        if (StringUtils.isEmpty((CharSequence)reqVo.getTerminalCode()) && StringUtils.isEmpty((CharSequence)reqVo.getCustomerCode())) {
            throw new BusinessException("\u8bf7\u8f93\u5165\u7ec8\u7aef\u7f16\u7801\u6216\u5ba2\u6237\u7f16\u7801");
        }
        String openId = reqVo.getOpenId();
        if (StringUtils.isNotEmpty((CharSequence)openId)) {
            Assert.hasText((String)openId, (String)"\u7f3a\u5931openId");
            List<MdmUserRelWeChatRespVo> list = this.mdmUserRelWeChatService.getBindUserListByOpenId(openId, LoginFromTypeEnum.APPLET_SFA.getValue());
            Assert.notEmpty(list, (String)"\u5fae\u4fe1\u672a\u7ed1\u5b9a\u4efb\u4f55\u7528\u6237");
            Assert.isTrue((list.size() == 1 ? 1 : 0) != 0, (String)"\u5fae\u4fe1\u7ed1\u5b9a\u4e86\u591a\u4e2a\u7528\u6237");
            MdmUserRelWeChatRespVo one = list.get(0);
            if (YesNoEnum.yesNoEnum.Y.getValue().equals(ParamUtil.getParameterValue((String)"sfa_applet_user_unique_flag"))) {
                List<MdmUserRelWeChatRespVo> userRelList = this.mdmUserRelWeChatService.getBindWeChatListByUserName(one.getUserName(), LoginFromTypeEnum.APPLET_SFA.getValue());
                Assert.isTrue((userRelList.size() == 1 ? 1 : 0) != 0, (String)"\u7528\u6237\u7ed1\u5b9a\u4e86\u591a\u4e2a\u5fae\u4fe1\uff0c\u8bf7\u5148\u5728\u540e\u53f0\u89e3\u7ed1");
            }
            Assert.isTrue((boolean)YesNoEnum.yesNoEnum.ONE.getValue().equals(one.getLoginStatus()), (String)"\u5904\u4e8e\u9000\u51fa\u767b\u5f55\u72b6\u6001\uff0c\u9700\u8981\u91cd\u65b0\u767b\u5f55");
            this.mdmLoginHelpService.checkLock(one.getUserName(), LoginHelpUtil.AccountType.USER_NAME);
            MdmUserRespVo user = this.mdmUserService.getUserForLogin(one.getUserName(), null, null);
            this.mdmLoginHelpService.checkUserType(user.getUserType(), reqVo.getFromType());
            this.mdmLoginHelpService.checkUserLogin(user.getEnableStatus(), user.getStartTime(), user.getEndTime());
            this.mdmLoginHelpService.unlock(user.getUserName(), user.getUserPhone(), user.getEmail());
        }
        Assert.hasText((String)reqVo.getUserPhone(), (String)"\u7f3a\u5931\u624b\u673a\u53f7");
        this.mdmLoginHelpService.checkLock(reqVo.getUserPhone(), LoginHelpUtil.AccountType.PHONE);
        MdmUserRespVo user = this.mdmUserService.getUserForLogin(null, reqVo.getUserPhone(), null);
        this.mdmLoginHelpService.checkUserType(user.getUserType(), reqVo.getFromType());
        this.mdmLoginHelpService.checkUserLogin(user.getEnableStatus(), user.getStartTime(), user.getEndTime());
        MdmLoginRespVo mdmLoginRespVo = new MdmLoginRespVo();
        String token = UUID.randomUUID().toString().replaceAll("-", "");
        UserRedis userRedis = new UserRedis();
        userRedis.setUsername(user.getUserName());
        userRedis.setRealname(user.getFullName());
        userRedis.setUsertype(user.getUserType());
        mdmLoginRespVo.setUserCode(user.getUserCode());
        mdmLoginRespVo.setLoginUserToken(token);
        mdmLoginRespVo.setUserName(user.getUserName());
        mdmLoginRespVo.setFullName(user.getFullName());
        mdmLoginRespVo.setUserType(user.getUserType());
        mdmLoginRespVo.setLanguage(userRedis.getLanguage());
        if (UserTypeEnum.TERMINAL.getCode().equals(user.getUserType())) {
            MdmTerminalVo mdmTerminalVo2;
            List<MdmTerminalVo> terminalList = this.mdmTerminalService.findTerminalByUserName(user.getUserName());
            if (CollectionUtil.listEmpty(terminalList)) {
                throw new BusinessException("\u5f53\u524d\u8d26\u53f7\u672a\u5173\u8054\u53ef\u7528\u7684\u7ec8\u7aef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            }
            for (MdmTerminalVo mdmTerminalVo2 : terminalList) {
                if (mdmTerminalVo2.getTerminalCode().equals(reqVo.getTerminalCode())) continue;
                terminalList.remove(mdmTerminalVo2);
            }
            if (terminalList.size() == 0) {
                throw new BusinessException("\u7ec8\u7aef\u7f16\u7801\u4e0d\u5339\u914d\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            }
            List mdmTerminalLoginVos = CrmBeanUtil.copyList(terminalList, MdmTerminalLoginVo.class);
            mdmLoginRespVo.setTerminalVoList(mdmTerminalLoginVos);
            mdmTerminalVo2 = terminalList.get(0);
            if (mdmTerminalVo2 != null) {
                userRedis.setCustcode(mdmTerminalVo2.getTerminalCode());
                userRedis.setCustname(mdmTerminalVo2.getTerminalName());
                userRedis.setOrgcode(mdmTerminalVo2.getOrgCode());
                userRedis.setOrgname(mdmTerminalVo2.getOrgName());
            }
        } else if (UserTypeEnum.CUSTOMER.getCode().equals(user.getUserType())) {
            MdmCustomerMsgRespVo customer = this.mdmCustomerMsgService.getUserCurrentCustomer(user.getUserName());
            if (customer == null) {
                throw new BusinessException("\u5f53\u524d\u8d26\u53f7\u672a\u5173\u8054\u53ef\u7528\u7684\u5ba2\u6237\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            }
            if (customer.getCustomerCode().equals(reqVo.getCustomerCode())) {
                Map<String, List<String>> orgCodeListMap = this.mdmCustomerROrgService.findOrgCodeList(Collections.singletonList(customer.getCustomerCode()));
                String orgCode = null;
                String orgName = null;
                if (orgCodeListMap.containsKey(customer.getCustomerCode())) {
                    List<String> orgCodeList = orgCodeListMap.get(customer.getCustomerCode());
                    Map<String, String> orgNameMap = this.mdmOrgService.findOrgNameMap(orgCodeList);
                    orgName = orgCodeList.stream().map(orgNameMap::get).collect(Collectors.joining(","));
                    orgCode = String.join((CharSequence)",", orgCodeList);
                }
                userRedis.setCustcode(customer.getCustomerCode());
                userRedis.setCustname(customer.getCustomerName());
                userRedis.setOrgcode(orgCode);
                userRedis.setOrgname(orgName);
                mdmLoginRespVo.setCustomerCode(customer.getCustomerCode());
                mdmLoginRespVo.setCustomerName(customer.getCustomerName());
                mdmLoginRespVo.setOrgCode(orgCode);
                mdmLoginRespVo.setOrgName(orgName);
                mdmLoginRespVo.setMdmCustomerMsgRespVo(customer);
            } else {
                throw new BusinessException("\u5ba2\u6237\u7f16\u7801\u4e0d\u5339\u914d\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            }
        }
        userRedis.setFromtype(reqVo.getFromType());
        UserUtils.setUser((String)token, (UserRedis)userRedis);
        HttpServletRequest request = HttpServletRequestUtil.getRequest();
        HttpServletResponse response = HttpServletRequestUtil.getResponse();
        CookiesUtil.doCoke((HttpServletRequest)request, (HttpServletResponse)response, (String)token, (String)"loginUserToken");
        this.mdmUserLoginLogAsyncService.saveLoginLog(request, user.getUserName(), user.getFullName(), reqVo.getFromType(), DateUtil.dateNowHms());
        return mdmLoginRespVo;
    }

    @Override
    public void sendVerificationForLoginAndResetByMessage(MdmAppletLoginReqVo reqVo) {
        Assert.hasText((String)reqVo.getUserPhone(), (String)"\u7f3a\u5931\u624b\u673a\u53f7");
        this.mdmLoginHelpService.checkLock(reqVo.getUserPhone(), LoginHelpUtil.AccountType.PHONE);
        MdmUserRespVo user = this.mdmUserService.getUserForLogin(null, reqVo.getUserPhone(), null);
        this.mdmLoginHelpService.checkUserType(user.getUserType(), reqVo.getFromType());
        this.mdmLoginHelpService.checkUserLogin(user.getEnableStatus(), user.getStartTime(), user.getEndTime());
        String verification = this.mdmLoginHelpService.saveLoginVerificationCodeRelUser(reqVo.getFromType(), user.getUserName(), user.getUserPhone(), LoginHelpUtil.AccountType.PHONE, LoginHelpUtil.VerificationCodeType.LOGIN_AND_RESET);
        this.mdmLoginHelpService.sendVerificationCode(reqVo.getFromType(), verification, user.getUserPhone(), LoginHelpUtil.AccountType.PHONE, LoginHelpUtil.VerificationCodeType.LOGIN_AND_RESET);
    }

    @Override
    public void checkPhoneExistAndUsable(MdmAppletLoginReqVo reqVo) {
        Assert.hasText((String)reqVo.getUserPhone(), (String)"\u7f3a\u5931\u624b\u673a\u53f7");
        this.mdmLoginHelpService.checkLock(reqVo.getUserPhone(), LoginHelpUtil.AccountType.PHONE);
        MdmUserRespVo user = this.mdmUserService.getUserForLogin(null, reqVo.getUserPhone(), null);
        this.mdmLoginHelpService.checkUserType(user.getUserType(), reqVo.getFromType());
        this.mdmLoginHelpService.checkUserLogin(user.getEnableStatus(), user.getStartTime(), user.getEndTime());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public MdmLoginRespVo loginAndResetByPhoneVerification(MdmAppletLoginReqVo reqVo) {
        Assert.hasText((String)reqVo.getUserPhone(), (String)"\u7f3a\u5931\u624b\u673a\u53f7");
        Assert.hasText((String)reqVo.getVerificationCode(), (String)"\u7f3a\u5931\u9a8c\u8bc1\u7801");
        String userName = this.mdmLoginHelpService.checkVerificationCode(reqVo.getFromType(), reqVo.getVerificationCode(), reqVo.getUserPhone(), LoginHelpUtil.AccountType.PHONE, LoginHelpUtil.VerificationCodeType.LOGIN_AND_RESET);
        MdmUserRespVo user = this.mdmUserService.getUserForLogin(userName, null, null);
        Assert.isTrue((boolean)reqVo.getUserPhone().equals(user.getUserPhone()), (String)"\u624b\u673a\u53f7\u5173\u8054\u7528\u6237\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
        this.mdmLoginHelpService.checkUserType(user.getUserType(), reqVo.getFromType());
        this.mdmLoginHelpService.checkUserLogin(user.getEnableStatus(), user.getStartTime(), user.getEndTime());
        this.mdmLoginHelpService.unlock(user.getUserName(), user.getUserPhone(), user.getEmail());
        this.mdmUserService.editPassword(userName, reqVo.getPassword());
        return this.doLoginThisSystem(user, reqVo, false, false, false);
    }

    @Override
    public MdmLoginTypeControlVo getLoginTypeControlConfig() {
        return this.mdmSystemLoginService.getLoginTypeControlConfig();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void logout() {
        UserRedis user = UserUtils.getUser();
        if (user != null) {
            if (StringUtils.isNotEmpty((CharSequence)user.getOpenId())) {
                this.mdmUserRelWeChatService.changeLoginStatus(LoginFromTypeEnum.APPLET_SFA.getValue(), user.getOpenId(), YesNoEnum.yesNoEnum.ZERO.getValue());
            }
            UserUtils.logout();
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void logoutFromType() {
        UserRedis user = UserUtils.getUser();
        if (user != null) {
            if (StringUtils.isNotEmpty((CharSequence)user.getOpenId())) {
                this.mdmUserRelWeChatService.changeLoginStatus(LoginFromTypeEnum.APPLET_SFA.getValue(), user.getOpenId(), YesNoEnum.yesNoEnum.ZERO.getValue());
            }
            UserUtils.logout((String)LoginFromTypeEnum.APPLET_SFA.getValue());
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void logoutAll() {
        UserRedis user = UserUtils.getUser();
        if (user != null) {
            if (StringUtils.isNotEmpty((CharSequence)user.getOpenId())) {
                this.mdmUserRelWeChatService.changeLoginStatus(LoginFromTypeEnum.APPLET_SFA.getValue(), user.getOpenId(), YesNoEnum.yesNoEnum.ZERO.getValue());
            }
            UserUtils.deleteUser((String)user.getUsername());
        }
    }

    @Override
    public void sendTerminalVerificationByMessage(String phoneCode) {
        String verificationCode = this.mdmLoginHelpService.generateVerificationCode();
        this.redisService.hset("REGISTER_PHONE_VERIFICATION_0319::" + phoneCode, verificationCode, (Object)phoneCode, 300L);
        ShortMessage shortMessage = new ShortMessage();
        shortMessage.setPhoneNumbers(phoneCode);
        shortMessage.setTemplateParam("{\"code\":\"" + verificationCode + "\"}");
        String template = this.mdmDictDataService.getDictDataMap("message_template").get("system_login");
        Assert.hasText((String)template, (String)"\u672a\u914d\u7f6e\u624b\u673a\u9a8c\u8bc1\u7801\u6ce8\u518c\u77ed\u4fe1\u6a21\u677f");
        shortMessage.setTemplateCode(template);
        this.shortMessageFeign.sendMessage(shortMessage);
        log.debug("\u53d1\u9001\u9a8c\u8bc1\u7801\u6210\u529f\uff1a\u624b\u673a\u53f7\uff1a{}\uff0c\u9a8c\u8bc1\u7801\uff1a{}", (Object)phoneCode, (Object)verificationCode);
    }

    @Override
    public Boolean VerificationPhoneByCode(String phoneCode, String verificationCode) {
        ValidateUtils.validate((Object)phoneCode, (String)"\u7535\u8bdd\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        ValidateUtils.validate((Object)verificationCode, (String)"\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        String returnPhoneCode = null;
        Object hget = this.redisService.hget("REGISTER_PHONE_VERIFICATION_0319::" + phoneCode, verificationCode);
        if (hget != null) {
            this.redisService.del(new String[]{"REGISTER_PHONE_VERIFICATION_0319::" + phoneCode});
            returnPhoneCode = (String)hget;
        }
        Assert.hasText(returnPhoneCode, (String)"\u9a8c\u8bc1\u7801\u9519\u8bef\u6216\u8005\u9a8c\u8bc1\u7801\u5df2\u8fc7\u671f");
        boolean result = StringUtils.equals((CharSequence)phoneCode, returnPhoneCode);
        return result;
    }

    @Override
    public void switchoverTerminal(MdmAppletLoginReqVo reqVo) {
        if (StringUtils.isNotEmpty((CharSequence)reqVo.getTerminalCode())) {
            Assert.hasText((String)reqVo.getTerminalCode(), (String)"\u7ec8\u7aef\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        UserRedis user = UserUtils.getUser();
        String token = UserUtils.getToken();
        List list = ((LambdaQueryChainWrapper)this.mdmTerminalService.lambdaQuery().eq(MdmTerminalEntity::getTerminalCode, (Object)reqVo.getTerminalCode())).list();
        if (!CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
            Assert.isNull((Object)list, (String)"\u672a\u67e5\u8be2\u5230\u7ec8\u7aef\u4fe1\u606f");
        }
        UserRedis userRedis = new UserRedis();
        userRedis.setUsername(user.getUsername());
        userRedis.setRealname(user.getRealname());
        userRedis.setUsertype(user.getUsertype());
        userRedis.setCustcode(((MdmTerminalEntity)list.get(0)).getTerminalCode());
        userRedis.setCustname(((MdmTerminalEntity)list.get(0)).getTerminalName());
        userRedis.setOrgcode(((MdmTerminalEntity)list.get(0)).getOrgCode());
        userRedis.setFromtype(reqVo.getFromType());
        UserUtils.setUser((String)token, (UserRedis)userRedis);
        HttpServletRequest request = HttpServletRequestUtil.getRequest();
        HttpServletResponse response = HttpServletRequestUtil.getResponse();
        CookiesUtil.doCoke((HttpServletRequest)request, (HttpServletResponse)response, (String)token, (String)"loginUserToken");
    }

    protected MdmLoginRespVo doLoginThisSystem(MdmUserRespVo user, MdmAppletLoginReqVo reqVo, boolean getLastLoginLog, boolean resetPassword, boolean bind) {
        if (bind && StringUtils.isNotEmpty((CharSequence)reqVo.getOpenId())) {
            MdmUserRelWeChatReqVo bindReq = new MdmUserRelWeChatReqVo();
            CrmBeanUtil.copyProperties((Object)reqVo, (Object)bindReq);
            bindReq.setUserName(user.getUserName());
            bindReq.setOriginModule(reqVo.getFromType());
            bindReq.setLoginStatus(YesNoEnum.yesNoEnum.ONE.getValue());
            bindReq.setOpenId(reqVo.getOpenId());
            this.mdmUserRelWeChatService.bind(bindReq);
        }
        MdmLoginRespVo mdmLoginRespVo = new MdmLoginRespVo();
        String token = UUID.randomUUID().toString().replaceAll("-", "");
        UserRedis userRedis = new UserRedis();
        userRedis.setUsername(user.getUserName());
        userRedis.setRealname(user.getFullName());
        userRedis.setUsertype(user.getUserType());
        userRedis.setOpenId(reqVo.getOpenId());
        mdmLoginRespVo.setUserCode(user.getUserCode());
        mdmLoginRespVo.setLoginUserToken(token);
        mdmLoginRespVo.setUserName(user.getUserName());
        mdmLoginRespVo.setFullName(user.getFullName());
        mdmLoginRespVo.setUserType(user.getUserType());
        mdmLoginRespVo.setLanguage(userRedis.getLanguage());
        mdmLoginRespVo.setOpenId(reqVo.getOpenId());
        if (UserTypeEnum.USER.getCode().equals(user.getUserType())) {
            MdmPositionUserOrgRespVo positionUserOrg = this.mdmPositionService.getCurrentPositionByUserName(user.getUserName());
            userRedis.setPoscode(positionUserOrg.getPositionCode());
            userRedis.setPosname(positionUserOrg.getPositionName());
            userRedis.setOrgcode(positionUserOrg.getOrgCode());
            userRedis.setOrgname(positionUserOrg.getOrgName());
            mdmLoginRespVo.setPositionCode(positionUserOrg.getPositionCode());
            mdmLoginRespVo.setPositionName(positionUserOrg.getPositionName());
            mdmLoginRespVo.setOrgCode(positionUserOrg.getOrgCode());
            mdmLoginRespVo.setOrgName(positionUserOrg.getOrgName());
        } else if (UserTypeEnum.TERMINAL.getCode().equals(user.getUserType())) {
            List<MdmTerminalVo> terminalList = this.mdmTerminalService.findTerminalByUserName(user.getUserName());
            if (CollectionUtil.listEmpty(terminalList)) {
                throw new BusinessException("\u5f53\u524d\u8d26\u53f7\u672a\u5173\u8054\u53ef\u7528\u7684\u7ec8\u7aef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            }
            List mdmTerminalLoginVos = CrmBeanUtil.copyList(terminalList, MdmTerminalLoginVo.class);
            mdmLoginRespVo.setTerminalVoList(mdmTerminalLoginVos);
            MdmTerminalVo mdmTerminalVo = terminalList.get(0);
            if (mdmTerminalVo != null) {
                userRedis.setCustcode(mdmTerminalVo.getTerminalCode());
                userRedis.setCustname(mdmTerminalVo.getTerminalName());
                userRedis.setOrgcode(mdmTerminalVo.getOrgCode());
                userRedis.setOrgname(mdmTerminalVo.getOrgName());
                mdmLoginRespVo.setCustomerCode(mdmTerminalVo.getTerminalCode());
                mdmLoginRespVo.setCustomerName(mdmTerminalVo.getTerminalName());
                mdmLoginRespVo.setOrgCode(mdmTerminalVo.getOrgCode());
                mdmLoginRespVo.setOrgName(mdmTerminalVo.getOrgName());
            }
        } else if (UserTypeEnum.CUSTOMER.getCode().equals(user.getUserType())) {
            MdmCustomerMsgRespVo customer = this.mdmCustomerMsgService.getUserCurrentCustomer(user.getUserName());
            if (customer == null) {
                throw new BusinessException("\u5f53\u524d\u8d26\u53f7\u672a\u5173\u8054\u53ef\u7528\u7684\u5ba2\u6237\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            }
            Map<String, List<String>> orgCodeListMap = this.mdmCustomerROrgService.findOrgCodeList(Collections.singletonList(customer.getCustomerCode()));
            String orgCode = null;
            String orgName = null;
            if (orgCodeListMap.containsKey(customer.getCustomerCode())) {
                List<String> orgCodeList = orgCodeListMap.get(customer.getCustomerCode());
                Map<String, String> orgNameMap = this.mdmOrgService.findOrgNameMap(orgCodeList);
                orgName = orgCodeList.stream().map(orgNameMap::get).collect(Collectors.joining(","));
                orgCode = String.join((CharSequence)",", orgCodeList);
            }
            userRedis.setCustcode(customer.getCustomerCode());
            userRedis.setCustname(customer.getCustomerName());
            userRedis.setOrgcode(orgCode);
            userRedis.setOrgname(orgName);
            mdmLoginRespVo.setCustomerCode(customer.getCustomerCode());
            mdmLoginRespVo.setCustomerName(customer.getCustomerName());
            mdmLoginRespVo.setOrgCode(orgCode);
            mdmLoginRespVo.setOrgName(orgName);
            mdmLoginRespVo.setMdmCustomerMsgRespVo(customer);
        }
        userRedis.setFromtype(reqVo.getFromType());
        UserUtils.setUser((String)token, (UserRedis)userRedis);
        HttpServletRequest request = HttpServletRequestUtil.getRequest();
        HttpServletResponse response = HttpServletRequestUtil.getResponse();
        CookiesUtil.doCoke((HttpServletRequest)request, (HttpServletResponse)response, (String)token, (String)"loginUserToken");
        if (getLastLoginLog) {
            MdmUserLoginLogRespVo lastLoginLog = this.mdmUserLoginLogService.getLastLoginLog(user.getUserName(), null);
            mdmLoginRespVo.setLastLoginLog(lastLoginLog);
        }
        if (resetPassword) {
            mdmLoginRespVo.setResetPassword(YesNoEnum.yesNoEnum.ONE.getValue());
            this.mdmUserService.setUserForceChangePassword(user.getUserName());
        } else if (YesNoEnum.yesNoEnum.ONE.getValue().equals(user.getForceChangePassword())) {
            mdmLoginRespVo.setResetPassword(YesNoEnum.yesNoEnum.ONE.getValue());
        }
        this.mdmUserLoginLogAsyncService.saveLoginLog(request, user.getUserName(), user.getFullName(), reqVo.getFromType(), DateUtil.dateNowHms());
        return mdmLoginRespVo;
    }
}

