/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.user.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.mdm.LoginFromTypeEnum;
import com.biz.crm.login.service.MdmTerminalAppletLoginService;
import com.biz.crm.nebular.mdm.constant.UserTypeEnum;
import com.biz.crm.nebular.mdm.user.req.MdmUserRelWeChatReqVo;
import com.biz.crm.nebular.mdm.user.resp.MdmUserRelWeChatRespVo;
import com.biz.crm.nebular.mdm.user.resp.MdmUserRespVo;
import com.biz.crm.user.mapper.MdmUserRelWeChatMapper;
import com.biz.crm.user.model.MdmUserRelWeChatEntity;
import com.biz.crm.user.service.MdmUserRelWeChatService;
import com.biz.crm.user.service.MdmUserService;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CookiesUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.HttpServletRequestUtil;
import com.biz.crm.util.ParamUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
@ConditionalOnMissingBean(name={"MdmUserRelWeChatServiceExpandImpl"})
public class MdmUserRelWeChatServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmUserRelWeChatMapper, MdmUserRelWeChatEntity>
implements MdmUserRelWeChatService {
    private static final Logger log = LoggerFactory.getLogger(MdmUserRelWeChatServiceImpl.class);
    @Resource
    private MdmUserRelWeChatMapper mdmUserRelWeChatMapper;
    @Lazy
    @Resource
    private MdmUserService mdmUserService;
    @Autowired
    private MdmTerminalAppletLoginService mdmTerminalAppletLoginService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void bind(MdmUserRelWeChatReqVo reqVo) {
        List existCheck;
        List collect;
        Assert.hasText((String)reqVo.getUserName(), (String)"\u7f3a\u5931\u7528\u6237\u540d");
        Assert.hasText((String)reqVo.getOpenId(), (String)"\u7f3a\u5931openId");
        Assert.hasText((String)reqVo.getOriginModule(), (String)"\u7f3a\u5931\u5173\u8054\u5c0f\u7a0b\u5e8f\u6a21\u5757");
        MdmUserRespVo mdmUserRespVo = this.mdmUserService.queryByUserName(reqVo.getUserName());
        Assert.notNull((Object)mdmUserRespVo, (String)"\u7528\u6237\u4e0d\u5b58\u5728");
        boolean uniqueCheck = false;
        if (LoginFromTypeEnum.APPLET_SFA.getValue().equals(reqVo.getOriginModule())) {
            Assert.isTrue((boolean)UserTypeEnum.USER.getCode().equals(mdmUserRespVo.getUserType()), (String)"\u975e\u4f01\u4e1a\u7528\u6237\u4e0d\u80fd\u7ed1\u5b9aSFA\u5c0f\u7a0b\u5e8f");
            uniqueCheck = YesNoEnum.yesNoEnum.Y.getValue().equals(ParamUtil.getParameterValue((String)"sfa_applet_user_unique_flag"));
        } else if (LoginFromTypeEnum.APPLET_DMS.getValue().equals(reqVo.getOriginModule())) {
            Assert.isTrue((boolean)UserTypeEnum.CUSTOMER.getCode().equals(mdmUserRespVo.getUserType()), (String)"\u975e\u5ba2\u6237\u7528\u6237\u4e0d\u80fd\u7ed1\u5b9aDMS\u5c0f\u7a0b\u5e8f");
        } else if (LoginFromTypeEnum.APPLET_TERMINAL.getValue().equals(reqVo.getOriginModule())) {
            Assert.isTrue((UserTypeEnum.CUSTOMER.getCode().equals(mdmUserRespVo.getUserType()) || UserTypeEnum.TERMINAL.getCode().equals(mdmUserRespVo.getUserType()) ? 1 : 0) != 0, (String)"\u975e\u5ba2\u6237\u7528\u6237\u6216\u7ec8\u7aef\u7528\u6237\u4e0d\u80fd\u7ed1\u5b9a\u7ec8\u7aef\u5c0f\u7a0b\u5e8f");
        } else {
            throw new BusinessException("\u5c0f\u7a0b\u5e8f\u6a21\u5757\u4e0d\u5b58\u5728");
        }
        if (uniqueCheck) {
            List userCheck = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmUserRelWeChatEntity::getOriginModule, (Object)reqVo.getOriginModule())).eq(MdmUserRelWeChatEntity::getUserName, (Object)reqVo.getUserName())).list().stream().filter(x -> !reqVo.getOpenId().equals(x.getOpenId())).collect(Collectors.toList());
            Assert.isTrue((boolean)CollectionUtil.listEmpty(userCheck), (String)"\u8be5\u7528\u6237\u5df2\u7ecf\u7ed1\u5b9a\u4e86\u5fae\u4fe1\uff0c\u4e0d\u80fd\u91cd\u590d\u7ed1\u5b9a");
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(collect = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmUserRelWeChatEntity::getOriginModule, (Object)reqVo.getOriginModule())).eq(MdmUserRelWeChatEntity::getOpenId, (Object)reqVo.getOpenId())).select(new SFunction[]{BaseIdEntity::getId, MdmUserRelWeChatEntity::getUserName}).list().stream().filter(x -> !reqVo.getUserName().equals(x.getUserName())).collect(Collectors.toList()))) {
            this.removeByIds(collect.stream().map(BaseIdEntity::getId).collect(Collectors.toList()));
        }
        if (CollectionUtil.listEmpty((List)(existCheck = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmUserRelWeChatEntity::getOriginModule, (Object)reqVo.getOriginModule())).eq(MdmUserRelWeChatEntity::getUserName, (Object)reqVo.getUserName())).eq(MdmUserRelWeChatEntity::getOpenId, (Object)reqVo.getOpenId())).list()))) {
            if (StringUtils.isEmpty((String)reqVo.getLoginStatus())) {
                reqVo.setLoginStatus(YesNoEnum.yesNoEnum.ZERO.getValue());
            }
            this.save(CrmBeanUtil.copy((Object)reqVo, MdmUserRelWeChatEntity.class));
        } else if (!YesNoEnum.yesNoEnum.ONE.getValue().equals(((MdmUserRelWeChatEntity)existCheck.get(0)).getLoginStatus())) {
            ((MdmUserRelWeChatEntity)existCheck.get(0)).setLoginStatus(YesNoEnum.yesNoEnum.ONE.getValue());
            this.updateById(existCheck.get(0));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void unbindByOpenId(String originModule, String openId) {
        if (!YesNoEnum.yesNoEnum.Y.getValue().equals(ParamUtil.getParameterValue((String)"sfa_applet_user_unique_flag"))) {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmUserRelWeChatEntity::getOriginModule, (Object)originModule)).eq(MdmUserRelWeChatEntity::getOpenId, (Object)openId)).remove();
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void unbindByIds(List<String> ids) {
        List list;
        if (CollectionUtil.listNotEmptyNotSizeZero(ids) && CollectionUtil.listNotEmptyNotSizeZero((List)(list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(BaseIdEntity::getId, ids)).list()))) {
            this.removeByIds(list.stream().map(BaseIdEntity::getId).collect(Collectors.toList()));
            UserUtils.deleteUser(list.stream().filter(x -> LoginFromTypeEnum.APPLET_SFA.getValue().equals(x.getOriginModule())).map(MdmUserRelWeChatEntity::getUserName).distinct().collect(Collectors.toList()), Collections.singletonList(LoginFromTypeEnum.APPLET_SFA.getValue()));
            UserUtils.deleteUser(list.stream().filter(x -> LoginFromTypeEnum.APPLET_DMS.getValue().equals(x.getOriginModule())).map(MdmUserRelWeChatEntity::getUserName).distinct().collect(Collectors.toList()), Collections.singletonList(LoginFromTypeEnum.APPLET_DMS.getValue()));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void unbindByUserName(List<String> userNameList) {
        List list;
        if (CollectionUtil.listNotEmptyNotSizeZero(userNameList) && CollectionUtil.listNotEmptyNotSizeZero((List)(list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(MdmUserRelWeChatEntity::getUserName, userNameList)).list()))) {
            this.removeByIds(list.stream().map(BaseIdEntity::getId).collect(Collectors.toList()));
            UserUtils.deleteUser(list.stream().filter(x -> LoginFromTypeEnum.APPLET_SFA.getValue().equals(x.getOriginModule())).map(MdmUserRelWeChatEntity::getUserName).distinct().collect(Collectors.toList()), Collections.singletonList(LoginFromTypeEnum.APPLET_SFA.getValue()));
            UserUtils.deleteUser(list.stream().filter(x -> LoginFromTypeEnum.APPLET_DMS.getValue().equals(x.getOriginModule())).map(MdmUserRelWeChatEntity::getUserName).distinct().collect(Collectors.toList()), Collections.singletonList(LoginFromTypeEnum.APPLET_DMS.getValue()));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void changeLoginStatus(String originModule, String openId, String loginStatus) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmUserRelWeChatEntity::getOriginModule, (Object)originModule)).eq(MdmUserRelWeChatEntity::getOpenId, (Object)openId)).set(MdmUserRelWeChatEntity::getLoginStatus, (Object)loginStatus)).update();
    }

    @Override
    public List<MdmUserRelWeChatRespVo> findUserRelWeChatList(MdmUserRelWeChatReqVo reqVo) {
        Assert.notNull((Object)reqVo, (String)"\u7a7a\u53c2\u6570");
        Assert.hasText((String)reqVo.getUserName(), (String)"\u7f3a\u5931\u7528\u6237\u540d");
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmUserRelWeChatEntity::getUserName, (Object)reqVo.getUserName())).eq(StringUtils.isNotEmpty((String)reqVo.getOriginModule()), MdmUserRelWeChatEntity::getOriginModule, (Object)reqVo.getOriginModule())).eq(StringUtils.isNotEmpty((String)reqVo.getLoginStatus()), MdmUserRelWeChatEntity::getLoginStatus, (Object)reqVo.getLoginStatus())).like(StringUtils.isNotEmpty((String)reqVo.getNickName()), MdmUserRelWeChatEntity::getNickName, (Object)reqVo.getNickName())).list();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
            return list.stream().map(x -> {
                MdmUserRelWeChatRespVo copy = (MdmUserRelWeChatRespVo)CrmBeanUtil.copy((Object)x, MdmUserRelWeChatRespVo.class);
                copy.setOriginModuleName(LoginFromTypeEnum.getDesc((String)copy.getOriginModule()));
                return copy;
            }).collect(Collectors.toList());
        }
        return new ArrayList<MdmUserRelWeChatRespVo>();
    }

    @Override
    public List<MdmUserRelWeChatRespVo> getBindUserListByOpenId(String openId, String originModule) {
        List list;
        if (StringUtils.isNotEmpty((String)openId) && CollectionUtil.listNotEmptyNotSizeZero((List)(list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmUserRelWeChatEntity::getOpenId, (Object)openId)).eq(StringUtils.isNotEmpty((String)originModule), MdmUserRelWeChatEntity::getOriginModule, (Object)originModule)).list()))) {
            return CrmBeanUtil.copyList((List)list, MdmUserRelWeChatRespVo.class);
        }
        return new ArrayList<MdmUserRelWeChatRespVo>();
    }

    @Override
    public List<MdmUserRelWeChatRespVo> getBindWeChatListByUserName(String userName, String originModule) {
        List list;
        if (StringUtils.isNotEmpty((String)userName) && CollectionUtil.listNotEmptyNotSizeZero((List)(list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmUserRelWeChatEntity::getUserName, (Object)userName)).eq(StringUtils.isNotEmpty((String)originModule), MdmUserRelWeChatEntity::getOriginModule, (Object)originModule)).list()))) {
            return CrmBeanUtil.copyList((List)list, MdmUserRelWeChatRespVo.class);
        }
        return new ArrayList<MdmUserRelWeChatRespVo>();
    }

    @Override
    public void bindUserWeChatVerificationPhone(MdmUserRelWeChatReqVo bindReq, String phone, String code) {
        this.mdmTerminalAppletLoginService.VerificationPhoneByCode(phone, code);
        this.bind(bindReq);
        UserRedis user = UserUtils.getUser();
        String token = UserUtils.getToken();
        user.setOpenId(bindReq.getOpenId());
        UserUtils.setUser((String)token, (UserRedis)user);
        HttpServletRequest request = HttpServletRequestUtil.getRequest();
        HttpServletResponse response = HttpServletRequestUtil.getResponse();
        CookiesUtil.doCoke((HttpServletRequest)request, (HttpServletResponse)response, (String)token, (String)"loginUserToken");
    }
}

