/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.login.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.biz.crm.base.BusinessException;
import com.biz.crm.customer.mapper.MdmCustomerMsgMapper;
import com.biz.crm.customer.model.MdmCustomerEntity;
import com.biz.crm.customer.service.MdmCustomerMsgService;
import com.biz.crm.customer.service.MdmCustomerROrgService;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.login.service.MdmDmsMallLoginService;
import com.biz.crm.login.service.MdmLoginHelpService;
import com.biz.crm.login.service.MdmSystemLoginService;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.mdm.login.MdmLoginReqVo;
import com.biz.crm.nebular.mdm.login.MdmLoginRespVo;
import com.biz.crm.nebular.mdm.login.MdmLoginTypeControlVo;
import com.biz.crm.nebular.mdm.user.resp.MdmUserLoginLogRespVo;
import com.biz.crm.nebular.mdm.user.resp.MdmUserRespVo;
import com.biz.crm.org.service.MdmOrgService;
import com.biz.crm.user.service.MdmUserLoginLogAsyncService;
import com.biz.crm.user.service.MdmUserLoginLogService;
import com.biz.crm.user.service.MdmUserService;
import com.biz.crm.util.CookiesUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.HttpServletRequestUtil;
import com.biz.crm.util.Md5EncryptionAndDecryption;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.utils.LoginHelpUtil;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
@ConditionalOnMissingBean(name={"MdmDmsMallLoginServiceExpandImpl"})
public class MdmDmsMallLoginServiceImpl
implements MdmDmsMallLoginService {
    private static final Logger log = LoggerFactory.getLogger(MdmDmsMallLoginServiceImpl.class);
    @Autowired
    private MdmUserService mdmUserService;
    @Autowired
    private MdmCustomerMsgService mdmCustomerMsgService;
    @Resource
    private MdmUserLoginLogService mdmUserLoginLogService;
    @Lazy
    @Resource
    private MdmUserLoginLogAsyncService mdmUserLoginLogAsyncService;
    @Resource
    private MdmSystemLoginService mdmSystemLoginService;
    @Resource
    private MdmCustomerROrgService mdmCustomerROrgService;
    @Resource
    private MdmOrgService mdmOrgService;
    @Resource
    private MdmLoginHelpService mdmLoginHelpService;
    @Autowired
    private MdmCustomerMsgMapper mdmCustomerMsgMapper;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public MdmLoginRespVo login(MdmLoginReqVo reqVo) {
        Assert.hasText((String)reqVo.getUserName(), (String)"\u7f3a\u5931\u8d26\u53f7");
        Assert.hasText((String)reqVo.getPassword(), (String)"\u7f3a\u5931\u5bc6\u7801");
        this.mdmLoginHelpService.checkLock(reqVo.getUserName(), LoginHelpUtil.AccountType.USER_NAME);
        MdmUserRespVo user = this.mdmUserService.getUserForLogin(reqVo.getUserName(), null, null);
        this.mdmLoginHelpService.checkUserType(user.getUserType(), reqVo.getFromType());
        this.mdmLoginHelpService.checkUserLogin(user.getEnableStatus(), user.getStartTime(), user.getEndTime());
        if (Md5EncryptionAndDecryption.checkPwd((String)reqVo.getPassword(), (String)user.getUserPassword())) {
            this.mdmLoginHelpService.unlock(user.getUserName(), user.getUserPhone(), user.getEmail());
        } else {
            this.mdmLoginHelpService.addError(user.getUserName(), user.getUserPhone(), user.getEmail());
        }
        return this.doLoginThisSystem(user, reqVo.getFromType(), true, false);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public MdmLoginRespVo loginByToken(String token) {
        Assert.hasText((String)token, (String)"\u7f3a\u5931\u8d26\u53f7token");
        UserRedis user1 = UserUtils.getUser();
        MdmUserRespVo user = this.mdmUserService.getUserForLogin(user1.getUsername(), null, null);
        Wrapper mdmCustomerEntityWrapper = (Wrapper)new LambdaQueryWrapper().eq(MdmCustomerEntity::getCustomerCode, (Object)user1.getUsername());
        MdmCustomerEntity mdmCustomerEntity = (MdmCustomerEntity)this.mdmCustomerMsgMapper.selectOne(mdmCustomerEntityWrapper);
        if (mdmCustomerEntity == null) {
            throw new BusinessException("\u6839\u636e\u7f16\u7801:" + user1.getUsername() + "\uff0c\u67e5\u8be2\u7ecf\u9500\u5546\u4fe1\u606f\u4e3a\u7a7a");
        }
        MdmLoginRespVo mdmLoginRespVo = new MdmLoginRespVo();
        mdmLoginRespVo.setUserCode(user.getUserCode());
        mdmLoginRespVo.setLoginUserToken(token);
        mdmLoginRespVo.setUserName(user.getUserName());
        mdmLoginRespVo.setFullName(user.getFullName());
        mdmLoginRespVo.setUserType(user.getUserType());
        mdmLoginRespVo.setCustomerCode(mdmCustomerEntity.getCustomerCode());
        mdmLoginRespVo.setCustomerName(mdmCustomerEntity.getCustomerName());
        mdmLoginRespVo.setOrgCode(user1.getOrgcode());
        mdmLoginRespVo.setOrgName(user1.getOrgname());
        mdmLoginRespVo.setLanguage(user1.getLanguage());
        mdmLoginRespVo.setMdmCustomerMsgRespVo((MdmCustomerMsgRespVo)CrmBeanUtil.copy((Object)mdmCustomerEntity, MdmCustomerMsgRespVo.class));
        return mdmLoginRespVo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public MdmLoginRespVo loginByPhone(MdmLoginReqVo reqVo) {
        Assert.hasText((String)reqVo.getUserPhone(), (String)"\u7f3a\u5931\u624b\u673a\u53f7");
        Assert.hasText((String)reqVo.getPassword(), (String)"\u7f3a\u5931\u5bc6\u7801");
        this.mdmLoginHelpService.checkLock(reqVo.getUserPhone(), LoginHelpUtil.AccountType.PHONE);
        MdmUserRespVo user = this.mdmUserService.getUserForLogin(null, reqVo.getUserPhone(), null);
        this.mdmLoginHelpService.checkUserType(user.getUserType(), reqVo.getFromType());
        this.mdmLoginHelpService.checkUserLogin(user.getEnableStatus(), user.getStartTime(), user.getEndTime());
        if (Md5EncryptionAndDecryption.checkPwd((String)reqVo.getPassword(), (String)user.getUserPassword())) {
            this.mdmLoginHelpService.unlock(user.getUserName(), user.getUserPhone(), user.getEmail());
        } else {
            this.mdmLoginHelpService.addError(user.getUserName(), user.getUserPhone(), user.getEmail());
        }
        return this.doLoginThisSystem(user, reqVo.getFromType(), true, false);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public MdmLoginRespVo loginByEmail(MdmLoginReqVo reqVo) {
        Assert.hasText((String)reqVo.getEmail(), (String)"\u7f3a\u5931\u90ae\u7bb1");
        Assert.hasText((String)reqVo.getPassword(), (String)"\u7f3a\u5931\u5bc6\u7801");
        this.mdmLoginHelpService.checkLock(reqVo.getEmail(), LoginHelpUtil.AccountType.EMAIL);
        MdmUserRespVo user = this.mdmUserService.getUserForLogin(null, null, reqVo.getEmail());
        this.mdmLoginHelpService.checkUserType(user.getUserType(), reqVo.getFromType());
        this.mdmLoginHelpService.checkUserLogin(user.getEnableStatus(), user.getStartTime(), user.getEndTime());
        if (Md5EncryptionAndDecryption.checkPwd((String)reqVo.getPassword(), (String)user.getUserPassword())) {
            this.mdmLoginHelpService.unlock(user.getUserName(), user.getUserPhone(), user.getEmail());
        } else {
            this.mdmLoginHelpService.addError(user.getUserName(), user.getUserPhone(), user.getEmail());
        }
        return this.doLoginThisSystem(user, reqVo.getFromType(), true, false);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public MdmLoginRespVo loginByPhoneVerification(MdmLoginReqVo reqVo) {
        Assert.hasText((String)reqVo.getUserPhone(), (String)"\u7f3a\u5931\u624b\u673a\u53f7");
        Assert.hasText((String)reqVo.getVerificationCode(), (String)"\u7f3a\u5931\u9a8c\u8bc1\u7801");
        this.mdmLoginHelpService.checkLock(reqVo.getUserPhone(), LoginHelpUtil.AccountType.PHONE);
        String userName = this.mdmLoginHelpService.checkVerificationCode(reqVo.getFromType(), reqVo.getVerificationCode(), reqVo.getUserPhone(), LoginHelpUtil.AccountType.PHONE, LoginHelpUtil.VerificationCodeType.LOGIN);
        MdmUserRespVo user = this.mdmUserService.getUserForLogin(userName, null, null);
        Assert.isTrue((boolean)reqVo.getUserPhone().equals(user.getUserPhone()), (String)"\u624b\u673a\u53f7\u5173\u8054\u7528\u6237\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
        this.mdmLoginHelpService.checkUserType(user.getUserType(), reqVo.getFromType());
        this.mdmLoginHelpService.checkUserLogin(user.getEnableStatus(), user.getStartTime(), user.getEndTime());
        this.mdmLoginHelpService.unlock(user.getUserName(), user.getUserPhone(), user.getEmail());
        return this.doLoginThisSystem(user, reqVo.getFromType(), true, false);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public MdmLoginRespVo loginByEmailVerification(MdmLoginReqVo reqVo) {
        Assert.hasText((String)reqVo.getEmail(), (String)"\u7f3a\u5931\u90ae\u7bb1");
        Assert.hasText((String)reqVo.getVerificationCode(), (String)"\u7f3a\u5931\u9a8c\u8bc1\u7801");
        this.mdmLoginHelpService.checkLock(reqVo.getEmail(), LoginHelpUtil.AccountType.EMAIL);
        String userName = this.mdmLoginHelpService.checkVerificationCode(reqVo.getFromType(), reqVo.getVerificationCode(), reqVo.getEmail(), LoginHelpUtil.AccountType.EMAIL, LoginHelpUtil.VerificationCodeType.LOGIN);
        MdmUserRespVo user = this.mdmUserService.getUserForLogin(userName, null, null);
        Assert.isTrue((boolean)reqVo.getEmail().equals(user.getEmail()), (String)"\u90ae\u7bb1\u5173\u8054\u7528\u6237\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
        this.mdmLoginHelpService.checkUserType(user.getUserType(), reqVo.getFromType());
        this.mdmLoginHelpService.checkUserLogin(user.getEnableStatus(), user.getStartTime(), user.getEndTime());
        this.mdmLoginHelpService.unlock(user.getUserName(), user.getUserPhone(), user.getEmail());
        return this.doLoginThisSystem(user, reqVo.getFromType(), true, false);
    }

    @Override
    public void sendVerificationForLoginByMessage(MdmLoginReqVo reqVo) {
        Assert.hasText((String)reqVo.getUserPhone(), (String)"\u7f3a\u5931\u624b\u673a\u53f7");
        this.mdmLoginHelpService.checkLock(reqVo.getUserPhone(), LoginHelpUtil.AccountType.PHONE);
        MdmUserRespVo user = this.mdmUserService.getUserForLogin(null, reqVo.getUserPhone(), null);
        this.mdmLoginHelpService.checkLock(user.getUserName(), LoginHelpUtil.AccountType.USER_NAME);
        this.mdmLoginHelpService.checkLock(user.getEmail(), LoginHelpUtil.AccountType.EMAIL);
        this.mdmLoginHelpService.checkUserType(user.getUserType(), reqVo.getFromType());
        this.mdmLoginHelpService.checkUserLogin(user.getEnableStatus(), user.getStartTime(), user.getEndTime());
        String verification = this.mdmLoginHelpService.saveLoginVerificationCodeRelUser(reqVo.getFromType(), user.getUserName(), user.getUserPhone(), LoginHelpUtil.AccountType.PHONE, LoginHelpUtil.VerificationCodeType.LOGIN);
        this.mdmLoginHelpService.sendVerificationCode(reqVo.getFromType(), verification, user.getUserPhone(), LoginHelpUtil.AccountType.PHONE, LoginHelpUtil.VerificationCodeType.LOGIN);
    }

    @Override
    public void sendVerificationForLoginByEmail(MdmLoginReqVo reqVo) {
        Assert.hasText((String)reqVo.getEmail(), (String)"\u7f3a\u5931\u90ae\u7bb1");
        this.mdmLoginHelpService.checkLock(reqVo.getEmail(), LoginHelpUtil.AccountType.EMAIL);
        MdmUserRespVo user = this.mdmUserService.getUserForLogin(null, null, reqVo.getEmail());
        this.mdmLoginHelpService.checkLock(user.getUserName(), LoginHelpUtil.AccountType.USER_NAME);
        this.mdmLoginHelpService.checkLock(user.getEmail(), LoginHelpUtil.AccountType.EMAIL);
        this.mdmLoginHelpService.checkUserType(user.getUserType(), reqVo.getFromType());
        this.mdmLoginHelpService.checkUserLogin(user.getEnableStatus(), user.getStartTime(), user.getEndTime());
        String verification = this.mdmLoginHelpService.saveLoginVerificationCodeRelUser(reqVo.getFromType(), user.getUserName(), user.getEmail(), LoginHelpUtil.AccountType.EMAIL, LoginHelpUtil.VerificationCodeType.LOGIN);
        this.mdmLoginHelpService.sendVerificationCode(reqVo.getFromType(), verification, user.getEmail(), LoginHelpUtil.AccountType.EMAIL, LoginHelpUtil.VerificationCodeType.LOGIN);
    }

    @Override
    public void checkPhoneExistAndUsable(MdmLoginReqVo reqVo) {
        this.mdmSystemLoginService.checkPhoneExistAndUsable(reqVo);
    }

    @Override
    public void checkEmailExistAndUsable(MdmLoginReqVo reqVo) {
        this.mdmSystemLoginService.checkEmailExistAndUsable(reqVo);
    }

    @Override
    public void sendVerificationForLoginAndResetByMessage(MdmLoginReqVo reqVo) {
        this.mdmSystemLoginService.sendVerificationForLoginAndResetByMessage(reqVo);
    }

    @Override
    public void sendVerificationForLoginAndResetByEmail(MdmLoginReqVo reqVo) {
        this.mdmSystemLoginService.sendVerificationForLoginAndResetByEmail(reqVo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public MdmLoginRespVo loginAndResetByPhoneVerification(MdmLoginReqVo reqVo) {
        Assert.hasText((String)reqVo.getUserPhone(), (String)"\u7f3a\u5931\u624b\u673a\u53f7");
        Assert.hasText((String)reqVo.getVerificationCode(), (String)"\u7f3a\u5931\u9a8c\u8bc1\u7801");
        String userName = this.mdmLoginHelpService.checkVerificationCode(reqVo.getFromType(), reqVo.getVerificationCode(), reqVo.getUserPhone(), LoginHelpUtil.AccountType.PHONE, LoginHelpUtil.VerificationCodeType.LOGIN_AND_RESET);
        MdmUserRespVo user = this.mdmUserService.getUserForLogin(userName, null, null);
        Assert.isTrue((boolean)reqVo.getUserPhone().equals(user.getUserPhone()), (String)"\u624b\u673a\u53f7\u5173\u8054\u7528\u6237\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
        this.mdmLoginHelpService.checkUserType(user.getUserType(), reqVo.getFromType());
        this.mdmLoginHelpService.checkUserLogin(user.getEnableStatus(), user.getStartTime(), user.getEndTime());
        this.mdmLoginHelpService.unlock(user.getUserName(), user.getUserPhone(), user.getEmail());
        return this.doLoginThisSystem(user, reqVo.getFromType(), false, true);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public MdmLoginRespVo loginAndResetByEmailVerification(MdmLoginReqVo reqVo) {
        Assert.hasText((String)reqVo.getEmail(), (String)"\u7f3a\u5931\u90ae\u7bb1");
        Assert.hasText((String)reqVo.getVerificationCode(), (String)"\u7f3a\u5931\u9a8c\u8bc1\u7801");
        String userName = this.mdmLoginHelpService.checkVerificationCode(reqVo.getFromType(), reqVo.getVerificationCode(), reqVo.getEmail(), LoginHelpUtil.AccountType.EMAIL, LoginHelpUtil.VerificationCodeType.LOGIN_AND_RESET);
        MdmUserRespVo user = this.mdmUserService.getUserForLogin(userName, null, null);
        Assert.isTrue((boolean)reqVo.getEmail().equals(user.getEmail()), (String)"\u90ae\u7bb1\u5173\u8054\u7528\u6237\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
        this.mdmLoginHelpService.checkUserType(user.getUserType(), reqVo.getFromType());
        this.mdmLoginHelpService.checkUserLogin(user.getEnableStatus(), user.getStartTime(), user.getEndTime());
        this.mdmLoginHelpService.unlock(user.getUserName(), user.getUserPhone(), user.getEmail());
        return this.doLoginThisSystem(user, reqVo.getFromType(), false, true);
    }

    @Override
    public MdmLoginTypeControlVo getLoginTypeControlConfig() {
        return this.mdmSystemLoginService.getLoginTypeControlConfig();
    }

    protected MdmLoginRespVo doLoginThisSystem(MdmUserRespVo user, String fromType, boolean getLastLoginLog, boolean resetPassword) {
        MdmCustomerMsgRespVo customer = this.mdmCustomerMsgService.getUserCurrentCustomer(user.getUserName());
        if (customer == null) {
            throw new BusinessException("\u5f53\u524d\u8d26\u53f7\u672a\u5173\u8054\u53ef\u7528\u7684\u5ba2\u6237\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        Map<String, List<String>> orgCodeListMap = this.mdmCustomerROrgService.findOrgCodeList(Collections.singletonList(customer.getCustomerCode()));
        String orgCode = null;
        String orgName = null;
        if (orgCodeListMap.containsKey(customer.getCustomerCode())) {
            List<String> orgCodeList = orgCodeListMap.get(customer.getCustomerCode());
            Map<String, String> orgNameMap = this.mdmOrgService.findOrgNameMap(orgCodeList);
            orgName = orgCodeList.stream().map(orgNameMap::get).collect(Collectors.joining(","));
            orgCode = String.join((CharSequence)",", orgCodeList);
        }
        String token = UUID.randomUUID().toString().replaceAll("-", "");
        UserRedis userRedis = new UserRedis();
        userRedis.setUsername(user.getUserName());
        userRedis.setRealname(user.getFullName());
        userRedis.setUsertype(user.getUserType());
        userRedis.setCustcode(customer.getCustomerCode());
        userRedis.setCustname(customer.getCustomerName());
        userRedis.setOrgcode(orgCode);
        userRedis.setOrgname(orgName);
        userRedis.setFromtype(fromType);
        UserUtils.setUser((String)token, (UserRedis)userRedis);
        HttpServletRequest request = HttpServletRequestUtil.getRequest();
        HttpServletResponse response = HttpServletRequestUtil.getResponse();
        CookiesUtil.doCoke((HttpServletRequest)request, (HttpServletResponse)response, (String)token, (String)"loginUserToken");
        MdmLoginRespVo mdmLoginRespVo = new MdmLoginRespVo();
        mdmLoginRespVo.setUserCode(user.getUserCode());
        mdmLoginRespVo.setLoginUserToken(token);
        mdmLoginRespVo.setUserName(user.getUserName());
        mdmLoginRespVo.setFullName(user.getFullName());
        mdmLoginRespVo.setUserType(user.getUserType());
        mdmLoginRespVo.setCustomerCode(customer.getCustomerCode());
        mdmLoginRespVo.setCustomerName(customer.getCustomerName());
        mdmLoginRespVo.setOrgCode(orgCode);
        mdmLoginRespVo.setOrgName(orgName);
        mdmLoginRespVo.setLanguage(userRedis.getLanguage());
        mdmLoginRespVo.setMdmCustomerMsgRespVo(customer);
        if (getLastLoginLog) {
            MdmUserLoginLogRespVo lastLoginLog = this.mdmUserLoginLogService.getLastLoginLog(user.getUserName(), null);
            mdmLoginRespVo.setLastLoginLog(lastLoginLog);
        }
        if (resetPassword) {
            this.mdmUserService.setUserForceChangePassword(user.getUserName());
            mdmLoginRespVo.setResetPassword(YesNoEnum.yesNoEnum.ONE.getValue());
        } else if (YesNoEnum.yesNoEnum.ONE.getValue().equals(user.getForceChangePassword())) {
            mdmLoginRespVo.setResetPassword(YesNoEnum.yesNoEnum.ONE.getValue());
        }
        this.mdmUserLoginLogAsyncService.saveLoginLog(request, user.getUserName(), user.getFullName(), fromType, DateUtil.dateNowHms());
        return mdmLoginRespVo;
    }
}

