/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tableconfig.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.eunm.mdm.TrueOrFalseEnum;
import com.biz.crm.nebular.mdm.pageconfig.MdmColumnConfigReqVo;
import com.biz.crm.nebular.mdm.pageconfig.MdmColumnConfigRespVo;
import com.biz.crm.nebular.mdm.pageconfig.MdmColumnRoleConfigBatchReqVo;
import com.biz.crm.nebular.mdm.pageconfig.MdmColumnRoleConfigReqVo;
import com.biz.crm.tableconfig.manager.MdmColumnRoleConfigConverter;
import com.biz.crm.tableconfig.mapper.MdmColumnRoleConfigMapper;
import com.biz.crm.tableconfig.model.MdmColumnRoleConfigEntity;
import com.biz.crm.tableconfig.service.IMdmColumnConfigService;
import com.biz.crm.tableconfig.service.IMdmColumnRoleConfigService;
import com.biz.crm.tableconfig.service.MdmColumnConfigPersonalService;
import com.biz.crm.util.AssertUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Service
@ConditionalOnMissingBean(name={"MdmColumnRoleConfigServiceExpandImpl"})
@CacheConfig(cacheNames={"mdm_column"})
public class MdmColumnRoleConfigServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmColumnRoleConfigMapper, MdmColumnRoleConfigEntity>
implements IMdmColumnRoleConfigService {
    private static final Logger log = LoggerFactory.getLogger(MdmColumnRoleConfigServiceImpl.class);
    @Resource
    private IMdmColumnConfigService mdmColumnConfigService;
    @Resource
    private MdmColumnConfigPersonalService mdmColumnConfigPersonalService;

    @Override
    @Cacheable(sync=true, key="#reqVo.parentCode+#reqVo.functionCode+#reqVo.roleCode")
    public List<MdmColumnConfigRespVo> listCondition(MdmColumnRoleConfigReqVo reqVo) {
        String parentCode = reqVo.getParentCode();
        String functionCode = reqVo.getFunctionCode();
        String roleCode = reqVo.getRoleCode();
        if (StringUtils.isEmpty((Object)parentCode) || StringUtils.isEmpty((Object)functionCode) || StringUtils.isEmpty((Object)roleCode)) {
            return new ArrayList<MdmColumnConfigRespVo>();
        }
        List<MdmColumnRoleConfigEntity> list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmColumnRoleConfigEntity::getParentCode, (Object)parentCode)).eq(MdmColumnRoleConfigEntity::getFunctionCode, (Object)functionCode)).eq(MdmColumnRoleConfigEntity::getRoleCode, (Object)roleCode)).list();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            list = list.stream().sorted(Comparator.comparing(x -> Optional.ofNullable(x.getFormorder()).map(Integer::valueOf).orElse(100))).collect(Collectors.toList());
            return MdmColumnRoleConfigConverter.INSTANCE.entity2RespVo(list);
        }
        return this.mdmColumnConfigService.listCondition((MdmColumnConfigReqVo)reqVo);
    }

    @Override
    @CacheEvict(allEntries=true)
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(MdmColumnRoleConfigReqVo reqVo) {
        List ids = reqVo.getIds();
        Assert.notEmpty((Collection)ids, (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(BaseIdEntity::getId, (Collection)reqVo.getIds())).list();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            MdmColumnRoleConfigEntity mdmColumnConfigEntity = (MdmColumnRoleConfigEntity)list.get(0);
            String parentCode = mdmColumnConfigEntity.getParentCode();
            String functionCode = mdmColumnConfigEntity.getFunctionCode();
            String roleCode = mdmColumnConfigEntity.getRoleCode();
            if (!StringUtils.isEmpty((Object)parentCode) && !StringUtils.isEmpty((Object)functionCode)) {
                this.mdmColumnConfigPersonalService.deleteColumnConfig(parentCode, functionCode, roleCode);
            }
            this.removeByIds(ids);
        }
    }

    @Override
    @CacheEvict(key="#reqVo.parentCode+#reqVo.functionCode+#reqVo.roleCode")
    public void addBatch(MdmColumnRoleConfigBatchReqVo reqVo) {
        String parentCode = reqVo.getParentCode();
        Assert.hasText((String)parentCode, (String)"\u83dc\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        String functionCode = reqVo.getFunctionCode();
        Assert.hasText((String)functionCode, (String)"\u529f\u80fd\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        String roleCode = reqVo.getRoleCode();
        Assert.hasText((String)roleCode, (String)"\u89d2\u8272\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        List mdmColumnConfigVos = reqVo.getMdmColumnRoleConfigVos();
        Assert.notEmpty((Collection)mdmColumnConfigVos, (String)"\u65b0\u589e\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        HashSet<String> set = new HashSet<String>(mdmColumnConfigVos.size());
        for (MdmColumnRoleConfigReqVo mdmColumnConfigVo : mdmColumnConfigVos) {
            Assert.isTrue((boolean)set.add(mdmColumnConfigVo.getField()), (String)("\u5b58\u5728\u76f8\u540c\u7684\u5b57\u6bb5:" + mdmColumnConfigVo.getField()));
        }
        this.validSearch(mdmColumnConfigVos);
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmColumnRoleConfigEntity::getParentCode, (Object)parentCode)).eq(MdmColumnRoleConfigEntity::getFunctionCode, (Object)functionCode)).eq(MdmColumnRoleConfigEntity::getRoleCode, (Object)roleCode)).remove();
        List list = mdmColumnConfigVos.stream().map(x -> {
            Assert.hasText((String)x.getField(), (String)"\u5b57\u6bb5\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            x.setParentCode(parentCode);
            x.setFunctionCode(functionCode);
            x.setRoleCode(roleCode);
            MdmColumnRoleConfigEntity entity = MdmColumnRoleConfigConverter.INSTANCE.reqVo2Entity((MdmColumnRoleConfigReqVo)x);
            entity.setId(null);
            return entity;
        }).collect(Collectors.toList());
        this.saveBatch(list);
        this.mdmColumnConfigPersonalService.deleteColumnConfig(reqVo.getParentCode(), reqVo.getFunctionCode(), roleCode);
    }

    @Override
    @CacheEvict(allEntries=true)
    public void cleanCache() {
    }

    protected void validSearch(List<MdmColumnRoleConfigReqVo> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        for (MdmColumnRoleConfigReqVo mdmColumnConfigReqVo : list) {
            if (mdmColumnConfigReqVo != null && TrueOrFalseEnum.TRUE.getCode().equalsIgnoreCase(mdmColumnConfigReqVo.getSearch())) {
                Assert.hasText((String)mdmColumnConfigReqVo.getType(), (String)("\u5b57\u6bb5(" + mdmColumnConfigReqVo.getTitle() + ")\u5141\u8bb8\u67e5\u8be2\u9700\u8981\u914d\u7f6e\u63a7\u4ef6\u7c7b\u578b"));
            }
            if (!org.apache.commons.lang3.StringUtils.equals((CharSequence)"1", (CharSequence)mdmColumnConfigReqVo.getColumnExport())) continue;
            AssertUtils.isNotEmpty((String)mdmColumnConfigReqVo.getTitle(), (String)("\u9700\u8981\u5bfc\u51fa\u7684\u5b57\u6bb5:" + mdmColumnConfigReqVo.getField() + ",\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a"));
        }
    }
}

