/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.utils;

import com.biz.crm.base.BusinessException;
import com.biz.crm.service.RedisService;
import com.google.code.kaptcha.impl.DefaultKaptcha;
import io.jsonwebtoken.lang.Assert;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Optional;
import javax.imageio.ImageIO;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Component
public class VerificationUtil {
    private static final Logger log = LoggerFactory.getLogger(VerificationUtil.class);
    private static RedisService redisService;
    private static DefaultKaptcha defaultKaptcha;
    private static final String VERIFICATION = "verification:";
    private static final Integer MIN_LENGTH;
    private static final String SMALL_LETTERS = "abcdefghijklmnopqrstuvwxyz";
    private static final String BIG_LETTERS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final String SPECIAL_CHARS = "~!@#$%^&*()_+-={}[],./<>?:|";
    private static final String NUMBERS = "1234567890";

    @Autowired
    public void setRedisService(RedisService redisService) {
        VerificationUtil.redisService = redisService;
    }

    @Autowired
    public void setDefaultKaptcha(DefaultKaptcha defaultKaptcha) {
        VerificationUtil.defaultKaptcha = defaultKaptcha;
    }

    public static String generateRandomStr() {
        String createText = defaultKaptcha.createText();
        Assert.hasText((String)createText, (String)"\u751f\u6210\u968f\u673a\u5b57\u7b26\u4e32\u5931\u8d25");
        return createText;
    }

    public static void generate(String token) {
        Assert.hasText((String)"\u552f\u4e00\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a", (String)"token");
        ByteArrayOutputStream jpegOutputStream = new ByteArrayOutputStream();
        String createText = VerificationUtil.generateRandomStr();
        redisService.setMinutes(VERIFICATION + token, (Object)createText, 1L);
        BufferedImage challenge = defaultKaptcha.createImage(createText);
        try {
            ImageIO.write((RenderedImage)challenge, "jpg", jpegOutputStream);
        }
        catch (IOException e) {
            log.error("\u751f\u6210\u56fe\u5f62\u9a8c\u8bc1\u7801\u5931\u8d25", (Throwable)e);
            throw new BusinessException("\u751f\u6210\u9a8c\u8bc1\u7801\u5931\u8d25");
        }
        HttpServletResponse response = Optional.ofNullable((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).map(ServletRequestAttributes::getResponse).orElseThrow(() -> new BusinessException("\u83b7\u53d6\u5f53\u524d\u7ebf\u7a0b\u54cd\u5e94\u5931\u8d25"));
        response.setHeader("Cache-Control", "no-store");
        response.setHeader("Pragma", "no-cache");
        response.setDateHeader("Expires", 0L);
        response.setContentType("image/jpeg");
        try {
            byte[] captchaChallengeAsJpeg = jpegOutputStream.toByteArray();
            ServletOutputStream servletOutputStream = response.getOutputStream();
            servletOutputStream.write(captchaChallengeAsJpeg);
            servletOutputStream.flush();
            servletOutputStream.close();
        }
        catch (IOException e) {
            log.error("\u8f93\u51fa\u9a8c\u8bc1\u7801\u5931\u8d25", (Throwable)e);
            throw new BusinessException("\u751f\u6210\u9a8c\u8bc1\u7801\u5931\u8d25");
        }
    }

    public static void checkVerification(String token, String verification) {
        Assert.hasText((String)token, (String)"\u552f\u4e00\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)verification, (String)"\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Object object = redisService.get(VERIFICATION + token);
        log.info("\u56fe\u5f62\u9a8c\u8bc1\u7801\uff1a\u83b7\u53d6\u9a8c\u8bc1\u7801:{}", object);
        Assert.notNull((Object)object, (String)"\u9a8c\u8bc1\u7801\u5df2\u5931\u6548");
        Assert.isTrue((boolean)verification.equals(object), (String)"\u9a8c\u8bc1\u7801\u4e0d\u6b63\u786e");
        redisService.del(new String[]{VERIFICATION + token});
    }

    public static void isStrongPwd(String pwd) {
        boolean isLongEnough;
        boolean bl = isLongEnough = pwd.length() >= MIN_LENGTH;
        if (!isLongEnough) {
            throw new BusinessException("\u5bc6\u7801\u957f\u5ea6\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e8\u4f4d\u6570");
        }
        int len = pwd.length();
        boolean hasAllBumber = true;
        for (int i = 0; i < len; ++i) {
            if (NUMBERS.indexOf(pwd.charAt(i)) != -1) continue;
            hasAllBumber = false;
            break;
        }
        if (hasAllBumber) {
            throw new BusinessException("\u5bc6\u7801\u4e0d\u80fd\u5168\u662f\u6570\u5b57");
        }
    }

    static {
        MIN_LENGTH = 8;
    }
}

