/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.login.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmExtEntity;
import com.biz.crm.customer.service.MdmCustomerMsgService;
import com.biz.crm.customer.service.MdmCustomerROrgService;
import com.biz.crm.dict.service.MdmDictDataService;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.mdm.LoginFromTypeEnum;
import com.biz.crm.login.service.MdmLoginHelpService;
import com.biz.crm.login.service.MdmSystemLoginService;
import com.biz.crm.nebular.mdm.constant.UserTypeEnum;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.mdm.login.MdmLoginReqVo;
import com.biz.crm.nebular.mdm.login.MdmLoginRespVo;
import com.biz.crm.nebular.mdm.login.MdmLoginTypeControlVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionUserOrgRespVo;
import com.biz.crm.nebular.mdm.user.resp.MdmUserLoginLogRespVo;
import com.biz.crm.nebular.mdm.user.resp.MdmUserRespVo;
import com.biz.crm.org.mapper.MdmOrgMapper;
import com.biz.crm.org.model.MdmOrgEntity;
import com.biz.crm.org.service.MdmOrgService;
import com.biz.crm.position.mapper.MdmPositionMapper;
import com.biz.crm.position.model.MdmPositionEntity;
import com.biz.crm.position.service.MdmPositionService;
import com.biz.crm.user.mapper.MdmUserMapper;
import com.biz.crm.user.model.MdmUserEntity;
import com.biz.crm.user.service.MdmUserLoginLogAsyncService;
import com.biz.crm.user.service.MdmUserLoginLogService;
import com.biz.crm.user.service.MdmUserService;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CookiesUtil;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.HttpServletRequestUtil;
import com.biz.crm.util.Md5EncryptionAndDecryption;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.utils.LoginHelpUtil;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
@ConditionalOnMissingBean(name={"MdmSystemLoginServiceExpandImpl"})
public class MdmSystemLoginServiceImpl
implements MdmSystemLoginService {
    private static final Logger log = LoggerFactory.getLogger(MdmSystemLoginServiceImpl.class);
    @Autowired
    private MdmUserService mdmUserService;
    @Autowired
    private MdmUserMapper mdmUserMapper;
    @Autowired
    private MdmPositionMapper positionMapper;
    @Autowired
    private MdmOrgMapper mdmOrgMapper;
    @Autowired
    private MdmPositionService mdmPositionService;
    @Resource
    private MdmUserLoginLogService mdmUserLoginLogService;
    @Lazy
    @Resource
    private MdmUserLoginLogAsyncService mdmUserLoginLogAsyncService;
    @Resource
    private MdmDictDataService mdmDictDataService;
    @Resource
    private MdmCustomerMsgService mdmCustomerMsgService;
    @Resource
    private MdmCustomerROrgService mdmCustomerROrgService;
    @Resource
    private MdmOrgService mdmOrgService;
    @Resource
    private MdmLoginHelpService mdmLoginHelpService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public MdmLoginRespVo login(MdmLoginReqVo reqVo) {
        Assert.hasText((String)reqVo.getUserName(), (String)"\u7f3a\u5931\u8d26\u53f7");
        Assert.hasText((String)reqVo.getPassword(), (String)"\u7f3a\u5931\u5bc6\u7801");
        String userName = reqVo.getUserName();
        String userPhone = null;
        String email = null;
        String accountContext = "\u8d26\u53f7";
        this.mdmLoginHelpService.checkLock(reqVo.getUserName(), LoginHelpUtil.AccountType.USER_NAME);
        MdmUserRespVo user = this.mdmUserService.getUserForLogin(userName, userPhone, email);
        Assert.notNull((Object)user, (String)"\u7528\u6237\u540d\u4e0d\u5b58\u5728\u6216\u5bc6\u7801\u9519\u8bef");
        userPhone = user.getUserPhone();
        email = user.getEmail();
        this.mdmLoginHelpService.checkUserType(user.getUserType(), reqVo.getFromType());
        this.mdmLoginHelpService.checkUserLogin(user.getEnableStatus(), user.getStartTime(), user.getEndTime());
        if (Md5EncryptionAndDecryption.checkPwd((String)reqVo.getPassword(), (String)user.getUserPassword())) {
            this.mdmLoginHelpService.unlock(userName, userPhone, email);
        } else {
            this.mdmLoginHelpService.addError(userName, userPhone, email);
        }
        return this.doLoginThisSystem(user, reqVo.getFromType(), true, false);
    }

    @Override
    public MdmLoginRespVo lignByYzjOpenId(String openId) {
        log.info("\u4e91\u4e4b\u5bb6\u81ea\u52a8\u767b\u9646\u63a5\u53e3\uff0copenId={}", (Object)openId);
        Assert.hasText((String)openId, (String)"\u7f3a\u5931openId");
        Wrapper wrapper = (Wrapper)new LambdaQueryWrapper().eq(CrmExtEntity::getExt3, (Object)openId);
        List list = this.mdmUserMapper.selectList(wrapper);
        if (CollectionUtil.listNotEmpty((List)list)) {
            MdmUserEntity userEntity = (MdmUserEntity)list.get(0);
            MdmLoginReqVo reqVo = new MdmLoginReqVo();
            reqVo.setUserName(userEntity.getUserName());
            return this.loginByOnlyUserName(reqVo);
        }
        throw new BusinessException("CRM\u4e2d\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7528\u6237\u4fe1\u606f");
    }

    @Override
    public MdmLoginRespVo loginByOnlyUserName(MdmLoginReqVo reqVo) {
        if (StringUtils.isNotEmpty((String)reqVo.getUjlrwebjruzddjnu())) {
            reqVo.setUserName(reqVo.getUjlrwebjruzddjnu());
        }
        if (StringUtils.isEmpty((String)reqVo.getFromType())) {
            reqVo.setFromType(LoginFromTypeEnum.EXTERNAL.getValue());
        }
        Assert.hasText((String)reqVo.getUserName(), (String)"\u7f3a\u5931\u8d26\u53f7");
        String userName = reqVo.getUserName();
        String userPhone = null;
        String email = null;
        String accountContext = "\u8d26\u53f7";
        this.mdmLoginHelpService.checkLock(reqVo.getUserName(), LoginHelpUtil.AccountType.USER_NAME);
        MdmUserRespVo user = this.mdmUserService.getUserForLogin(userName, userPhone, email);
        Assert.notNull((Object)user, (String)(accountContext + "\u4e0d\u5b58\u5728"));
        if (StringUtils.isNotEmpty((String)reqVo.getPCode())) {
            user.setPositionCode(reqVo.getPCode());
        }
        userPhone = user.getUserPhone();
        email = user.getEmail();
        this.mdmLoginHelpService.checkUserType(user.getUserType(), reqVo.getFromType());
        this.mdmLoginHelpService.checkUserLogin(user.getEnableStatus(), user.getStartTime(), user.getEndTime());
        this.mdmLoginHelpService.unlock(userName, userPhone, email);
        return this.doLoginThisSystem(user, reqVo.getFromType(), true, false);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public MdmLoginRespVo loginByPhone(MdmLoginReqVo reqVo) {
        Assert.hasText((String)reqVo.getUserPhone(), (String)"\u7f3a\u5931\u624b\u673a\u53f7");
        Assert.hasText((String)reqVo.getPassword(), (String)"\u7f3a\u5931\u5bc6\u7801");
        String userName = null;
        String userPhone = reqVo.getUserPhone();
        String email = null;
        String accountContext = "\u624b\u673a\u53f7";
        this.mdmLoginHelpService.checkLock(reqVo.getUserPhone(), LoginHelpUtil.AccountType.PHONE);
        MdmUserRespVo user = this.mdmUserService.getUserForLogin(userName, userPhone, email);
        Assert.notNull((Object)user, (String)"\u624b\u673a\u53f7\u4e0d\u5b58\u5728\u6216\u5bc6\u7801\u9519\u8bef");
        userName = user.getUserName();
        email = user.getEmail();
        this.mdmLoginHelpService.checkUserType(user.getUserType(), reqVo.getFromType());
        this.mdmLoginHelpService.checkUserLogin(user.getEnableStatus(), user.getStartTime(), user.getEndTime());
        if (Md5EncryptionAndDecryption.checkPwd((String)reqVo.getPassword(), (String)user.getUserPassword())) {
            this.mdmLoginHelpService.unlock(userName, userPhone, email);
        } else {
            this.mdmLoginHelpService.addError(userName, userPhone, email);
        }
        return this.doLoginThisSystem(user, reqVo.getFromType(), true, false);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public MdmLoginRespVo loginByEmail(MdmLoginReqVo reqVo) {
        Assert.hasText((String)reqVo.getEmail(), (String)"\u7f3a\u5931\u90ae\u7bb1");
        Assert.hasText((String)reqVo.getPassword(), (String)"\u7f3a\u5931\u5bc6\u7801");
        String userName = null;
        String userPhone = null;
        String email = reqVo.getEmail();
        String accountContext = "\u90ae\u7bb1";
        this.mdmLoginHelpService.checkLock(reqVo.getEmail(), LoginHelpUtil.AccountType.EMAIL);
        MdmUserRespVo user = this.mdmUserService.getUserForLogin(userName, userPhone, email);
        Assert.notNull((Object)user, (String)"\u90ae\u7bb1\u4e0d\u5b58\u5728\u6216\u5bc6\u7801\u9519\u8bef");
        userName = user.getUserName();
        userPhone = user.getUserPhone();
        this.mdmLoginHelpService.checkUserType(user.getUserType(), reqVo.getFromType());
        this.mdmLoginHelpService.checkUserLogin(user.getEnableStatus(), user.getStartTime(), user.getEndTime());
        if (Md5EncryptionAndDecryption.checkPwd((String)reqVo.getPassword(), (String)user.getUserPassword())) {
            this.mdmLoginHelpService.unlock(userName, userPhone, email);
        } else {
            this.mdmLoginHelpService.addError(userName, userPhone, email);
        }
        return this.doLoginThisSystem(user, reqVo.getFromType(), true, false);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public MdmLoginRespVo loginByPhoneVerification(MdmLoginReqVo reqVo) {
        Assert.hasText((String)reqVo.getUserPhone(), (String)"\u7f3a\u5931\u624b\u673a\u53f7");
        Assert.hasText((String)reqVo.getVerificationCode(), (String)"\u7f3a\u5931\u9a8c\u8bc1\u7801");
        String userName = null;
        String userPhone = reqVo.getUserPhone();
        String email = null;
        String accountContext = "\u624b\u673a\u53f7";
        this.mdmLoginHelpService.checkLock(reqVo.getUserPhone(), LoginHelpUtil.AccountType.PHONE);
        userName = this.mdmLoginHelpService.checkVerificationCode(reqVo.getFromType(), reqVo.getVerificationCode(), reqVo.getUserPhone(), LoginHelpUtil.AccountType.PHONE, LoginHelpUtil.VerificationCodeType.LOGIN);
        MdmUserRespVo user = this.mdmUserService.getUserForLogin(userName, userPhone, email);
        userPhone = user.getUserPhone();
        email = user.getEmail();
        Assert.notNull((Object)user, (String)"\u624b\u673a\u53f7\u4e0d\u5b58\u5728\u6216\u5bc6\u7801\u9519\u8bef");
        Assert.isTrue((boolean)reqVo.getUserPhone().equals(user.getUserPhone()), (String)"\u624b\u673a\u53f7\u5173\u8054\u7528\u6237\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
        this.mdmLoginHelpService.checkUserType(user.getUserType(), reqVo.getFromType());
        this.mdmLoginHelpService.checkUserLogin(user.getEnableStatus(), user.getStartTime(), user.getEndTime());
        this.mdmLoginHelpService.unlock(userName, userPhone, email);
        return this.doLoginThisSystem(user, reqVo.getFromType(), true, false);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public MdmLoginRespVo loginByEmailVerification(MdmLoginReqVo reqVo) {
        Assert.hasText((String)reqVo.getEmail(), (String)"\u7f3a\u5931\u90ae\u7bb1");
        Assert.hasText((String)reqVo.getVerificationCode(), (String)"\u7f3a\u5931\u9a8c\u8bc1\u7801");
        String userName = null;
        String userPhone = null;
        String email = reqVo.getEmail();
        String accountContext = "\u90ae\u7bb1";
        this.mdmLoginHelpService.checkLock(reqVo.getEmail(), LoginHelpUtil.AccountType.EMAIL);
        userName = this.mdmLoginHelpService.checkVerificationCode(reqVo.getFromType(), reqVo.getVerificationCode(), reqVo.getEmail(), LoginHelpUtil.AccountType.EMAIL, LoginHelpUtil.VerificationCodeType.LOGIN);
        MdmUserRespVo user = this.mdmUserService.getUserForLogin(userName, userPhone, email);
        Assert.notNull((Object)user, (String)"\u7528\u6237\u540d\u4e0d\u5b58\u5728\u6216\u5bc6\u7801\u9519\u8bef");
        userName = user.getUserName();
        userPhone = user.getUserPhone();
        Assert.isTrue((boolean)reqVo.getEmail().equals(user.getEmail()), (String)"\u90ae\u7bb1\u5173\u8054\u7528\u6237\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
        this.mdmLoginHelpService.checkUserType(user.getUserType(), reqVo.getFromType());
        this.mdmLoginHelpService.checkUserLogin(user.getEnableStatus(), user.getStartTime(), user.getEndTime());
        this.mdmLoginHelpService.unlock(userName, userPhone, email);
        return this.doLoginThisSystem(user, reqVo.getFromType(), true, false);
    }

    @Override
    public void checkPhoneExistAndUsable(MdmLoginReqVo reqVo) {
        Assert.hasText((String)reqVo.getUserPhone(), (String)"\u7f3a\u5931\u624b\u673a\u53f7");
        this.mdmLoginHelpService.checkLock(reqVo.getUserPhone(), LoginHelpUtil.AccountType.PHONE);
        MdmUserRespVo user = this.mdmUserService.getUserForLogin(null, reqVo.getUserPhone(), null);
        Assert.notNull((Object)user, (String)"\u624b\u673a\u53f7\u4e0d\u5b58\u5728\u6216\u5bc6\u7801\u9519\u8bef");
        this.mdmLoginHelpService.checkUserType(user.getUserType(), reqVo.getFromType());
        this.mdmLoginHelpService.checkUserLogin(user.getEnableStatus(), user.getStartTime(), user.getEndTime());
    }

    @Override
    public void checkEmailExistAndUsable(MdmLoginReqVo reqVo) {
        Assert.hasText((String)reqVo.getEmail(), (String)"\u7f3a\u5931\u90ae\u7bb1");
        this.mdmLoginHelpService.checkLock(reqVo.getEmail(), LoginHelpUtil.AccountType.EMAIL);
        MdmUserRespVo user = this.mdmUserService.getUserForLogin(null, null, reqVo.getEmail());
        Assert.notNull((Object)user, (String)"\u90ae\u7bb1\u4e0d\u5b58\u5728\u6216\u5bc6\u7801\u9519\u8bef");
        this.mdmLoginHelpService.checkUserType(user.getUserType(), reqVo.getFromType());
        this.mdmLoginHelpService.checkUserLogin(user.getEnableStatus(), user.getStartTime(), user.getEndTime());
    }

    @Override
    public void sendVerificationForLoginByMessage(MdmLoginReqVo reqVo) {
        Assert.hasText((String)reqVo.getUserPhone(), (String)"\u7f3a\u5931\u624b\u673a\u53f7");
        this.mdmLoginHelpService.checkLock(reqVo.getUserPhone(), LoginHelpUtil.AccountType.PHONE);
        MdmUserRespVo user = this.mdmUserService.getUserForLogin(null, reqVo.getUserPhone(), null);
        Assert.notNull((Object)user, (String)"\u624b\u673a\u53f7\u4e0d\u5b58\u5728\u6216\u5bc6\u7801\u9519\u8bef");
        this.mdmLoginHelpService.checkLock(user.getUserName(), LoginHelpUtil.AccountType.USER_NAME);
        this.mdmLoginHelpService.checkLock(user.getEmail(), LoginHelpUtil.AccountType.EMAIL);
        this.mdmLoginHelpService.checkUserType(user.getUserType(), reqVo.getFromType());
        this.mdmLoginHelpService.checkUserLogin(user.getEnableStatus(), user.getStartTime(), user.getEndTime());
        String verification = this.mdmLoginHelpService.saveLoginVerificationCodeRelUser(reqVo.getFromType(), user.getUserName(), user.getUserPhone(), LoginHelpUtil.AccountType.PHONE, LoginHelpUtil.VerificationCodeType.LOGIN);
        this.mdmLoginHelpService.sendVerificationCode(reqVo.getFromType(), verification, user.getUserPhone(), LoginHelpUtil.AccountType.PHONE, LoginHelpUtil.VerificationCodeType.LOGIN);
    }

    @Override
    public void sendVerificationForLoginByEmail(MdmLoginReqVo reqVo) {
        Assert.hasText((String)reqVo.getEmail(), (String)"\u7f3a\u5931\u90ae\u7bb1");
        this.mdmLoginHelpService.checkLock(reqVo.getEmail(), LoginHelpUtil.AccountType.EMAIL);
        MdmUserRespVo user = this.mdmUserService.getUserForLogin(null, null, reqVo.getEmail());
        Assert.notNull((Object)user, (String)"\u90ae\u7bb1\u4e0d\u5b58\u5728\u6216\u5bc6\u7801\u9519\u8bef");
        this.mdmLoginHelpService.checkLock(user.getUserName(), LoginHelpUtil.AccountType.USER_NAME);
        this.mdmLoginHelpService.checkLock(user.getUserPhone(), LoginHelpUtil.AccountType.PHONE);
        this.mdmLoginHelpService.checkUserType(user.getUserType(), reqVo.getFromType());
        this.mdmLoginHelpService.checkUserLogin(user.getEnableStatus(), user.getStartTime(), user.getEndTime());
        String verification = this.mdmLoginHelpService.saveLoginVerificationCodeRelUser(reqVo.getFromType(), user.getUserName(), user.getEmail(), LoginHelpUtil.AccountType.EMAIL, LoginHelpUtil.VerificationCodeType.LOGIN);
        this.mdmLoginHelpService.sendVerificationCode(reqVo.getFromType(), verification, user.getEmail(), LoginHelpUtil.AccountType.EMAIL, LoginHelpUtil.VerificationCodeType.LOGIN);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public MdmLoginRespVo loginAndResetByPhoneVerification(MdmLoginReqVo reqVo) {
        Assert.hasText((String)reqVo.getUserPhone(), (String)"\u7f3a\u5931\u624b\u673a\u53f7");
        Assert.hasText((String)reqVo.getVerificationCode(), (String)"\u7f3a\u5931\u9a8c\u8bc1\u7801");
        String userName = this.mdmLoginHelpService.checkVerificationCode(reqVo.getFromType(), reqVo.getVerificationCode(), reqVo.getUserPhone(), LoginHelpUtil.AccountType.PHONE, LoginHelpUtil.VerificationCodeType.LOGIN_AND_RESET);
        MdmUserRespVo user = this.mdmUserService.getUserForLogin(userName, null, null);
        Assert.notNull((Object)user, (String)"\u624b\u673a\u53f7\u4e0d\u5b58\u5728\u6216\u5bc6\u7801\u9519\u8bef");
        Assert.isTrue((boolean)reqVo.getUserPhone().equals(user.getUserPhone()), (String)"\u624b\u673a\u53f7\u5173\u8054\u7528\u6237\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
        this.mdmLoginHelpService.checkUserType(user.getUserType(), reqVo.getFromType());
        this.mdmLoginHelpService.checkUserLogin(user.getEnableStatus(), user.getStartTime(), user.getEndTime());
        this.mdmLoginHelpService.unlock(user.getUserName(), user.getUserPhone(), user.getEmail());
        return this.doLoginThisSystem(user, reqVo.getFromType(), false, false);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public MdmLoginRespVo loginAndResetByEmailVerification(MdmLoginReqVo reqVo) {
        Assert.hasText((String)reqVo.getEmail(), (String)"\u7f3a\u5931\u90ae\u7bb1");
        Assert.hasText((String)reqVo.getVerificationCode(), (String)"\u7f3a\u5931\u9a8c\u8bc1\u7801");
        String userName = this.mdmLoginHelpService.checkVerificationCode(reqVo.getFromType(), reqVo.getVerificationCode(), reqVo.getEmail(), LoginHelpUtil.AccountType.EMAIL, LoginHelpUtil.VerificationCodeType.LOGIN_AND_RESET);
        MdmUserRespVo user = this.mdmUserService.getUserForLogin(userName, null, null);
        Assert.notNull((Object)user, (String)"\u90ae\u7bb1\u4e0d\u5b58\u5728\u6216\u5bc6\u7801\u9519\u8bef");
        Assert.isTrue((boolean)reqVo.getEmail().equals(user.getEmail()), (String)"\u90ae\u7bb1\u5173\u8054\u7528\u6237\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
        this.mdmLoginHelpService.checkUserType(user.getUserType(), reqVo.getFromType());
        this.mdmLoginHelpService.checkUserLogin(user.getEnableStatus(), user.getStartTime(), user.getEndTime());
        this.mdmLoginHelpService.unlock(user.getUserName(), user.getUserPhone(), user.getEmail());
        return this.doLoginThisSystem(user, reqVo.getFromType(), false, false);
    }

    @Override
    public void sendVerificationForLoginAndResetByMessage(MdmLoginReqVo reqVo) {
        Assert.hasText((String)reqVo.getUserPhone(), (String)"\u7f3a\u5931\u624b\u673a\u53f7");
        this.mdmLoginHelpService.checkLock(reqVo.getUserPhone(), LoginHelpUtil.AccountType.PHONE);
        MdmUserRespVo user = this.mdmUserService.getUserForLogin(null, reqVo.getUserPhone(), null);
        Assert.notNull((Object)user, (String)"\u624b\u673a\u53f7\u4e0d\u5b58\u5728\u6216\u5bc6\u7801\u9519\u8bef");
        this.mdmLoginHelpService.checkUserType(user.getUserType(), reqVo.getFromType());
        this.mdmLoginHelpService.checkUserLogin(user.getEnableStatus(), user.getStartTime(), user.getEndTime());
        String verification = this.mdmLoginHelpService.saveLoginVerificationCodeRelUser(reqVo.getFromType(), user.getUserName(), user.getUserPhone(), LoginHelpUtil.AccountType.PHONE, LoginHelpUtil.VerificationCodeType.LOGIN_AND_RESET);
        this.mdmLoginHelpService.sendVerificationCode(reqVo.getFromType(), verification, user.getUserPhone(), LoginHelpUtil.AccountType.PHONE, LoginHelpUtil.VerificationCodeType.LOGIN_AND_RESET);
    }

    @Override
    public void sendVerificationForLoginAndResetByEmail(MdmLoginReqVo reqVo) {
        Assert.hasText((String)reqVo.getEmail(), (String)"\u7f3a\u5931\u90ae\u7bb1");
        this.mdmLoginHelpService.checkLock(reqVo.getEmail(), LoginHelpUtil.AccountType.EMAIL);
        MdmUserRespVo user = this.mdmUserService.getUserForLogin(null, null, reqVo.getEmail());
        Assert.notNull((Object)user, (String)"\u90ae\u7bb1\u4e0d\u5b58\u5728\u6216\u5bc6\u7801\u9519\u8bef");
        this.mdmLoginHelpService.checkUserType(user.getUserType(), reqVo.getFromType());
        this.mdmLoginHelpService.checkUserLogin(user.getEnableStatus(), user.getStartTime(), user.getEndTime());
        String verification = this.mdmLoginHelpService.saveLoginVerificationCodeRelUser(reqVo.getFromType(), user.getUserName(), user.getEmail(), LoginHelpUtil.AccountType.EMAIL, LoginHelpUtil.VerificationCodeType.LOGIN_AND_RESET);
        this.mdmLoginHelpService.sendVerificationCode(reqVo.getFromType(), verification, user.getEmail(), LoginHelpUtil.AccountType.EMAIL, LoginHelpUtil.VerificationCodeType.LOGIN_AND_RESET);
    }

    @Override
    public MdmLoginTypeControlVo getLoginTypeControlConfig() {
        MdmLoginTypeControlVo controlVo = new MdmLoginTypeControlVo();
        try {
            Map<String, String> map = this.mdmDictDataService.getDictDataMap("login_control_config");
            controlVo.setLoginByUserName(YesNoEnum.yesNoEnum.ZERO.getValue().equals(map.get("system_login_by_user_name_pwd")) ? YesNoEnum.yesNoEnum.ZERO.getValue() : YesNoEnum.yesNoEnum.ONE.getValue());
            controlVo.setLoginByPhone(YesNoEnum.yesNoEnum.ONE.getValue().equals(map.get("system_login_by_phone_pwd")) ? YesNoEnum.yesNoEnum.ONE.getValue() : YesNoEnum.yesNoEnum.ZERO.getValue());
            controlVo.setLoginByPhoneVerification(YesNoEnum.yesNoEnum.ONE.getValue().equals(map.get("system_login_by_phone_verification")) ? YesNoEnum.yesNoEnum.ONE.getValue() : YesNoEnum.yesNoEnum.ZERO.getValue());
            controlVo.setLoginByEmail(YesNoEnum.yesNoEnum.ONE.getValue().equals(map.get("system_login_by_email_pwd")) ? YesNoEnum.yesNoEnum.ONE.getValue() : YesNoEnum.yesNoEnum.ZERO.getValue());
            controlVo.setLoginByEmailVerification(YesNoEnum.yesNoEnum.ONE.getValue().equals(map.get("system_login_by_email_verification")) ? YesNoEnum.yesNoEnum.ONE.getValue() : YesNoEnum.yesNoEnum.ZERO.getValue());
            controlVo.setLoginByWeChatWork(YesNoEnum.yesNoEnum.ONE.getValue().equals(map.get("system_login_by_we_chat_work")) ? YesNoEnum.yesNoEnum.ONE.getValue() : YesNoEnum.yesNoEnum.ZERO.getValue());
            controlVo.setResetByPhone(YesNoEnum.yesNoEnum.ONE.getValue().equals(map.get("system_reset_by_phone")) ? YesNoEnum.yesNoEnum.ONE.getValue() : YesNoEnum.yesNoEnum.ZERO.getValue());
            controlVo.setResetByEmail(YesNoEnum.yesNoEnum.ONE.getValue().equals(map.get("system_reset_by_email")) ? YesNoEnum.yesNoEnum.ONE.getValue() : YesNoEnum.yesNoEnum.ZERO.getValue());
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u767b\u5f55\u65b9\u5f0f\u63a7\u5236\u5931\u8d25\uff1a{}", (Throwable)e);
        }
        return controlVo;
    }

    @Override
    public void logout() {
        UserUtils.logout();
    }

    @Override
    public void logoutFromType() {
        UserUtils.logout((String)LoginFromTypeEnum.CONSOLE.getValue());
    }

    @Override
    public void logoutAll() {
        UserRedis user = UserUtils.getUser();
        if (user != null && StringUtils.isNotEmpty((String)user.getUsername())) {
            UserUtils.deleteUser((String)user.getUsername());
        }
    }

    protected MdmLoginRespVo doLoginThisSystem(MdmUserRespVo user, String fromType, boolean getLastLoginLog, boolean resetPassword) {
        int monthSpace;
        MdmLoginRespVo mdmLoginRespVo = new MdmLoginRespVo();
        String token = UUID.randomUUID().toString().replaceAll("-", "");
        UserRedis userRedis = new UserRedis();
        userRedis.setUsername(user.getUserName());
        userRedis.setRealname(user.getFullName());
        userRedis.setUsertype(user.getUserType());
        mdmLoginRespVo.setUserCode(user.getUserCode());
        mdmLoginRespVo.setLoginUserToken(token);
        mdmLoginRespVo.setUserName(user.getUserName());
        mdmLoginRespVo.setFullName(user.getFullName());
        mdmLoginRespVo.setUserType(user.getUserType());
        mdmLoginRespVo.setLanguage(userRedis.getLanguage());
        if (UserTypeEnum.USER.getCode().equals(user.getUserType())) {
            MdmPositionUserOrgRespVo positionUserOrg = null;
            if (StringUtils.isNotEmpty((String)user.getPositionCode())) {
                positionUserOrg = new MdmPositionUserOrgRespVo();
                Wrapper wrapper = (Wrapper)new LambdaQueryWrapper().eq(MdmPositionEntity::getPositionCode, (Object)user.getPositionCode());
                MdmPositionEntity positionEntity = (MdmPositionEntity)this.positionMapper.selectOne(wrapper);
                if (positionEntity != null) {
                    positionUserOrg.setPositionCode(user.getPositionCode());
                    positionUserOrg.setPositionName(positionEntity.getPositionName());
                    positionUserOrg.setOrgCode(positionEntity.getOrgCode());
                    wrapper = (Wrapper)new LambdaQueryWrapper().eq(MdmOrgEntity::getOrgCode, (Object)positionEntity.getOrgCode());
                    MdmOrgEntity entity = (MdmOrgEntity)this.mdmOrgMapper.selectOne(wrapper);
                    if (entity != null) {
                        positionUserOrg.setOrgName(entity.getOrgName());
                    }
                }
            } else {
                positionUserOrg = this.mdmPositionService.getCurrentPositionByUserName(user.getUserName());
            }
            userRedis.setPoscode(positionUserOrg.getPositionCode());
            userRedis.setPosname(positionUserOrg.getPositionName());
            userRedis.setOrgcode(positionUserOrg.getOrgCode());
            userRedis.setOrgname(positionUserOrg.getOrgName());
            mdmLoginRespVo.setPositionCode(positionUserOrg.getPositionCode());
            mdmLoginRespVo.setPositionName(positionUserOrg.getPositionName());
            mdmLoginRespVo.setOrgCode(positionUserOrg.getOrgCode());
            mdmLoginRespVo.setOrgName(positionUserOrg.getOrgName());
        } else if (UserTypeEnum.CUSTOMER.getCode().equals(user.getUserType()) || UserTypeEnum.CUSTOMER_EMPLOYEE.getCode().equals(user.getUserType())) {
            MdmCustomerMsgRespVo customer = this.mdmCustomerMsgService.getUserCurrentCustomer(user.getUserName());
            if (customer == null) {
                throw new BusinessException("\u5f53\u524d\u8d26\u53f7\u672a\u5173\u8054\u53ef\u7528\u7684\u5ba2\u6237\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            }
            Map<String, List<String>> orgCodeListMap = this.mdmCustomerROrgService.findOrgCodeList(Collections.singletonList(customer.getCustomerCode()));
            String orgCode = null;
            String orgName = null;
            if (orgCodeListMap.containsKey(customer.getCustomerCode())) {
                List<String> orgCodeList = orgCodeListMap.get(customer.getCustomerCode());
                Map<String, String> orgNameMap = this.mdmOrgService.findOrgNameMap(orgCodeList);
                orgName = orgCodeList.stream().map(orgNameMap::get).collect(Collectors.joining(","));
                orgCode = String.join((CharSequence)",", orgCodeList);
            }
            mdmLoginRespVo.setPositionCode(user.getUserName());
            userRedis.setRealname(user.getFullName());
            userRedis.setPoscode(user.getUserName());
            userRedis.setCustcode(customer.getCustomerCode());
            userRedis.setCustname(customer.getCustomerName());
            userRedis.setOrgcode(orgCode);
            userRedis.setOrgname(orgName);
            mdmLoginRespVo.setCustomerCode(customer.getCustomerCode());
            mdmLoginRespVo.setCustomerName(customer.getCustomerName());
            mdmLoginRespVo.setOrgCode(orgCode);
            mdmLoginRespVo.setOrgName(orgName);
            mdmLoginRespVo.setMdmCustomerMsgRespVo(customer);
        }
        userRedis.setFromtype(fromType);
        UserUtils.setUser((String)token, (UserRedis)userRedis);
        HttpServletRequest request = HttpServletRequestUtil.getRequest();
        HttpServletResponse response = HttpServletRequestUtil.getResponse();
        CookiesUtil.doCoke((HttpServletRequest)request, (HttpServletResponse)response, (String)token, (String)"loginUserToken");
        if (getLastLoginLog) {
            MdmUserLoginLogRespVo lastLoginLog = this.mdmUserLoginLogService.getLastLoginLog(user.getUserName(), null);
            mdmLoginRespVo.setLastLoginLog(lastLoginLog);
        }
        if (resetPassword) {
            mdmLoginRespVo.setResetPassword(YesNoEnum.yesNoEnum.ONE.getValue());
            this.mdmUserService.setUserForceChangePassword(user.getUserName());
        } else if (YesNoEnum.yesNoEnum.ONE.getValue().equals(user.getForceChangePassword())) {
            mdmLoginRespVo.setResetPassword(YesNoEnum.yesNoEnum.ONE.getValue());
        }
        String updatePasswordDate = user.getUpdatePasswordDate();
        if (StringUtils.isNotEmpty((String)updatePasswordDate) && (monthSpace = DateUtil.getMonthSpace((String)DateUtil.getYYYYMMDD(), (String)updatePasswordDate, (String)"yyyy-MM-dd")) > 3) {
            mdmLoginRespVo.setRemandMessage("\u6e29\u99a8\u63d0\u793a\uff1a\u4f60\u7684\u5bc6\u7801\u5df2\u8d85\u8fc7\u4e09\u4e2a\u6708\u672a\u4fee\u6539\uff0c\u8bf7\u4fee\u6539\u5bc6\u7801\u3002");
        }
        this.mdmUserLoginLogAsyncService.saveLoginLog(request, user.getUserName(), user.getFullName(), fromType, DateUtil.dateNowHms());
        return mdmLoginRespVo;
    }

    @Override
    public MdmLoginRespVo findUserByToken() {
        UserRedis userRedis = UserUtils.getUser();
        String userName = userRedis.getUsername();
        String userPhone = null;
        String email = null;
        String accountContext = "\u8d26\u53f7";
        this.mdmLoginHelpService.checkLock(userName, LoginHelpUtil.AccountType.USER_NAME);
        MdmUserRespVo user = this.mdmUserService.getUserForLogin(userName, userPhone, email);
        Assert.notNull((Object)user, (String)"\u8d26\u53f7\u4e0d\u5b58\u5728\u6216\u5bc6\u7801\u9519\u8bef");
        userPhone = user.getUserPhone();
        email = user.getEmail();
        this.mdmLoginHelpService.checkUserType(user.getUserType(), LoginFromTypeEnum.EXTERNAL.getValue());
        this.mdmLoginHelpService.checkUserLogin(user.getEnableStatus(), user.getStartTime(), user.getEndTime());
        MdmLoginRespVo mdmLoginRespVo = new MdmLoginRespVo();
        mdmLoginRespVo.setUserCode(user.getUserCode());
        mdmLoginRespVo.setLoginUserToken(UserUtils.getToken());
        mdmLoginRespVo.setUserName(user.getUserName());
        mdmLoginRespVo.setFullName(user.getFullName());
        mdmLoginRespVo.setUserType(user.getUserType());
        mdmLoginRespVo.setLanguage(userRedis.getLanguage());
        if (UserTypeEnum.USER.getCode().equals(user.getUserType())) {
            MdmPositionUserOrgRespVo positionUserOrg = this.mdmPositionService.getCurrentPositionByUserName(user.getUserName());
            mdmLoginRespVo.setPositionCode(positionUserOrg.getPositionCode());
            mdmLoginRespVo.setPositionName(positionUserOrg.getPositionName());
            mdmLoginRespVo.setOrgCode(positionUserOrg.getOrgCode());
            mdmLoginRespVo.setOrgName(positionUserOrg.getOrgName());
        }
        return mdmLoginRespVo;
    }
}

