/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.position.controller;

import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.nebular.mdm.position.req.MdmPositionCurrentUserReqVo;
import com.biz.crm.nebular.mdm.position.req.MdmPositionPageReqVo;
import com.biz.crm.nebular.mdm.position.req.MdmPositionReqVo;
import com.biz.crm.nebular.mdm.position.req.MdmPositionSelectReqVo;
import com.biz.crm.nebular.mdm.position.req.MdmPositionUserOrgOptReqVo;
import com.biz.crm.nebular.mdm.position.req.MdmPositionUserOrgPageReqVo;
import com.biz.crm.nebular.mdm.position.req.MdmPositionUserOrgReqVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionDetailRespVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionPageRespVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionRespVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionSelectRespVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionUserOrgPageRespVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionUserOrgRespVo;
import com.biz.crm.nebular.mdm.user.req.MdmUserReqVo;
import com.biz.crm.position.service.MdmPositionService;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PositionUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mdmPositionController"})
@Api(tags={"MDM-\u804c\u4f4d\u7ba1\u7406"})
public class MdmPositionController {
    private static final Logger log = LoggerFactory.getLogger(MdmPositionController.class);
    @Autowired
    private MdmPositionService mdmPositionService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @PostMapping(value={"/pageList"})
    @CrmDictMethod
    public Result<PageResult<MdmPositionPageRespVo>> pageList(@RequestBody MdmPositionPageReqVo reqVo) {
        PageResult<MdmPositionPageRespVo> result = this.mdmPositionService.findList(reqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="\u8be6\u60c5(\u9875\u9762\u7f16\u8f91\u56de\u663e\u6570\u636e\u4f7f\u7528)", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="ID", required=false, dataType="String", paramType="query"), @ApiImplicitParam(name="positionCode", value="\u7f16\u7801\u7f16\u7801", required=false, dataType="String", paramType="query")})
    @GetMapping(value={"/detail"})
    @CrmDictMethod
    public Result<MdmPositionRespVo> detail(@RequestParam(value="id", required=false) String id, @RequestParam(value="positionCode", required=false) String positionCode) {
        MdmPositionRespVo respVo = this.mdmPositionService.detail(id, positionCode);
        return Result.ok((Object)respVo);
    }

    @ApiOperation(value="\u6839\u636e\u804c\u4f4did\u6216\u8005\u804c\u4f4d\u7f16\u7801\u67e5\u8be2\u804c\u4f4d\u4e3b\u8868\uff0c\u4ee5\u53ca\u804c\u4f4d\u5173\u8054\u7528\u6237\u3001\u7ec4\u7ec7\u3001\u89d2\u8272\u3001\u6d41\u7a0b\u89d2\u8272\uff0c\u67e5\u8be2\u6570\u636e\u8f83\u591a\uff0c\u8bf7\u8c28\u614e\u4f7f\u7528", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="ID", required=false, dataType="String", paramType="query"), @ApiImplicitParam(name="positionCode", value="\u7f16\u7801\u7f16\u7801", required=false, dataType="String", paramType="query")})
    @GetMapping(value={"/getPositionDetail"})
    @CrmDictMethod
    public Result<MdmPositionDetailRespVo> getPositionDetail(@RequestParam(value="id", required=false) String id, @RequestParam(value="positionCode", required=false) String positionCode) {
        return Result.ok((Object)this.mdmPositionService.getPositionDetail(id, positionCode));
    }

    @ApiOperation(value="\u901a\u8fc7id\u96c6\u5408\u6279\u91cf\u67e5\u8be2\u804c\u4f4d\u5168\u8868\u53ca\u5173\u8054\u7528\u6237\u3001\u7ec4\u7ec7\u3001\u4e0a\u7ea7\u7684\u4e3b\u8981\u5b57\u6bb5", httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u96c6\u5408", required=true, paramType="body")})
    @PostMapping(value={"/detailBatchByIds"})
    public Result<List<MdmPositionUserOrgRespVo>> detailBatchByIds(@RequestBody List<String> ids) {
        return Result.ok(this.mdmPositionService.detailBatch(ids, null));
    }

    @ApiOperation(value="\u901a\u8fc7\u804c\u4f4d\u7f16\u7801\u96c6\u5408\u6279\u91cf\u67e5\u8be2\u804c\u4f4d\u5168\u8868\u53ca\u5173\u8054\u7528\u6237\u3001\u7ec4\u7ec7\u3001\u4e0a\u7ea7\u7684\u4e3b\u8981\u5b57\u6bb5", httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="positionCodeList", value="\u804c\u4f4d\u7f16\u7801\u96c6\u5408", required=true, paramType="body")})
    @PostMapping(value={"/detailBatchByPositionCodeList"})
    public Result<List<MdmPositionUserOrgRespVo>> detailBatchByPositionCodeList(@RequestBody List<String> positionCodeList) {
        return Result.ok(this.mdmPositionService.detailBatch(null, positionCodeList));
    }

    @ApiOperation(value="\u65b0\u589e")
    @PostMapping(value={"/save"})
    public Result save(@RequestBody MdmPositionReqVo mdmPositionReqVo) {
        this.mdmPositionService.save(mdmPositionReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u66f4\u65b0")
    @PostMapping(value={"/update"})
    public Result update(@RequestBody MdmPositionReqVo mdmPositionReqVo) {
        this.mdmPositionService.update(mdmPositionReqVo);
        return Result.ok((String)"\u4fee\u6539\u6210\u529f");
    }

    @ApiOperation(value="\u5220\u9664", httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u96c6\u5408", required=true, paramType="body")})
    @PostMapping(value={"/delete"})
    public Result delete(@RequestBody List<String> ids) {
        this.mdmPositionService.deleteBatch(ids);
        return Result.ok((String)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u542f\u7528", httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u96c6\u5408", required=true, paramType="body")})
    @PostMapping(value={"/enable"})
    public Result enable(@RequestBody List<String> ids) {
        this.mdmPositionService.enableBatch(ids);
        return Result.ok((String)"\u542f\u7528\u6210\u529f");
    }

    @ApiOperation(value="\u7981\u7528", httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u96c6\u5408", required=true, paramType="body")})
    @PostMapping(value={"/disable"})
    public Result disable(@RequestBody List<String> ids) {
        this.mdmPositionService.disableBatch(ids);
        return Result.ok((String)"\u7981\u7528\u6210\u529f");
    }

    @ApiOperation(value="\u67e5\u8be2\u804c\u4f4d\u4e0b\u62c9\u6846\u5217\u8868")
    @PostMapping(value={"/positionSelectList"})
    public Result<List<MdmPositionSelectRespVo>> positionSelectList(@RequestBody MdmPositionSelectReqVo reqVo) {
        return Result.ok(this.mdmPositionService.findPositionSelectList(reqVo));
    }

    @ApiOperation(value="\u6839\u636euserName\u83b7\u53d6\u7528\u6237\u4e3b\u804c\u4f4d", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userName", value="\u7528\u6237\u767b\u5f55\u540d", dataType="String", paramType="query")})
    @GetMapping(value={"/getPrimaryPositionByUserName"})
    public Result<MdmPositionRespVo> getPrimaryPositionByUserName(@RequestParam(value="userName") String userName) {
        return Result.ok((Object)this.mdmPositionService.getUserPrimaryPosition(new MdmUserReqVo().setUserName(userName)));
    }

    @ApiOperation(value="\uff08\u4e0d\u63a8\u8350\u4f7f\u7528\uff09\u6839\u636euserName\u83b7\u53d6\u7528\u6237\u5f53\u524d\u804c\u4f4d", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userName", value="\u7528\u6237\u767b\u5f55\u540d", dataType="String", paramType="query")})
    @GetMapping(value={"/getCurrentPositionByUserName"})
    public Result<MdmPositionUserOrgRespVo> getCurrentPositionByUserName(@RequestParam(value="userName") String userName) {
        return Result.ok((Object)this.mdmPositionService.getCurrentPositionByUserName(userName));
    }

    @ApiOperation(value="\u6839\u636euserName\u83b7\u53d6\u7528\u6237\u5168\u90e8\u804c\u4f4d")
    @PostMapping(value={"/getUserAllPositionList"})
    public Result<List<MdmPositionRespVo>> getUserAllPositionList(@RequestBody MdmUserReqVo reqVo) {
        return Result.ok(this.mdmPositionService.getUserAllPositionList(reqVo.getUserName()));
    }

    @ApiOperation(value="\uff08\u5df2\u5e9f\u5f03\uff09\u6839\u636e\u7528\u6237\u7f16\u7801\uff08userCode\uff09\u83b7\u53d6\u7528\u6237\u5168\u90e8\u804c\u4f4d", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userCode", value="\u7528\u6237\u7f16\u7801", dataType="String", paramType="query")})
    @GetMapping(value={"/getUserPositionByUserCode"})
    public Result<List<MdmPositionRespVo>> getUserPositionByUserCode(@RequestParam(value="userCode") String userCode) {
        return Result.ok(this.mdmPositionService.getUserPositionByUserCode(userCode));
    }

    @ApiOperation(value="\u5207\u6362\u7528\u6237\u4e3b\u804c\u4f4d")
    @PostMapping(value={"/changeUserPrimaryPosition"})
    public Result changeUserPrimaryPosition(@RequestBody MdmPositionUserOrgOptReqVo reqVo) {
        this.mdmPositionService.changeUserPrimaryPosition(reqVo.getUserName(), reqVo.getPositionCode());
        return Result.ok();
    }

    @ApiOperation(value="\u5207\u6362\u7528\u6237\u5f53\u524d\u804c\u4f4d")
    @PostMapping(value={"/changeUserCurrentPosition"})
    public Result changeUserCurrentPosition(@RequestBody MdmPositionUserOrgOptReqVo reqVo) {
        this.mdmPositionService.changeUserCurrentPosition(reqVo.getUserName(), reqVo.getPositionCode());
        return Result.ok();
    }

    @ApiOperation(value="\u6839\u636e\u804c\u4f4d\u7f16\u7801\u67e5\u8be2\u804c\u4f4d\u4e3b\u8868\u53ca\u5173\u8054\u7528\u6237\u3001\u7ec4\u7ec7\u3001\u4e0a\u7ea7\u7684\u4e3b\u8981\u5b57\u6bb5", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="positionCode", value="\u804c\u4f4d\u7f16\u7801", required=true, dataType="String", paramType="query")})
    @GetMapping(value={"/getPositionUserOrgByPositionCode"})
    public Result<MdmPositionUserOrgRespVo> getPositionUserOrgByPositionCode(@RequestParam(value="positionCode") String positionCode) {
        return Result.ok((Object)this.mdmPositionService.getPositionUserOrgByPositionCode(positionCode));
    }

    @ApiOperation(value="\u67e5\u8be2\u4ee5\u804c\u4f4d\u7ef4\u5ea6\u7684\u804c\u4f4d\u5168\u8868\u53ca\u5173\u8054\u7528\u6237\u3001\u7ec4\u7ec7\u3001\u4e0a\u7ea7\u7684\u4e3b\u8981\u5b57\u6bb5")
    @PostMapping(value={"/findPositionUserOrgList"})
    public Result<List<MdmPositionUserOrgRespVo>> findPositionUserOrgList(@RequestBody MdmPositionUserOrgReqVo reqVo) {
        return Result.ok(this.mdmPositionService.findPositionUserOrgList(reqVo));
    }

    @ApiOperation(value="\u67e5\u8be2\u4ee5\u804c\u4f4d\u7ef4\u5ea6\u7684\u804c\u4f4d\u5168\u8868\u53ca\u5173\u8054\u7528\u6237\u3001\u7ec4\u7ec7\u3001\u4e0a\u7ea7\u7684\u4e3b\u8981\u5b57\u6bb5\uff08\u5206\u9875\uff09\uff0c\u90e8\u5206\u5b57\u6bb5\u4e3a\u6a21\u7cca\u67e5\u8be2\uff0c\u4e00\u822c\u7528\u4e8e\u4ee5\u804c\u4f4d\u4e3a\u4e3b\u4f53\u7684\u5f39\u6846")
    @PostMapping(value={"/findPositionUserOrgPageList"})
    @CrmDictMethod
    public Result<PageResult<MdmPositionUserOrgPageRespVo>> findPositionUserOrgPageList(@RequestBody MdmPositionUserOrgPageReqVo reqVo) {
        return Result.ok(this.mdmPositionService.findPositionUserOrgPageList(reqVo));
    }

    @ApiOperation(value="\uff08SFA\u4e13\u7528\uff09\u4ee5\u5f53\u524d\u767b\u5f55\u4eba\u67e5\u8be2\u672c\u4eba\u53ca\u540c\u7ec4\u7ec7\u7684\u4eba\u53ca\u4e0b\u5c5e\uff08\u5206\u9875\uff09")
    @PostMapping(value={"/findCurrentPositionUserOrgPageList"})
    public Result<PageResult<MdmPositionUserOrgPageRespVo>> findCurrentPositionUserOrgPageList(@RequestBody MdmPositionCurrentUserReqVo reqVo) {
        UserRedis user = UserUtils.getUser();
        if (null == user) {
            throw new BusinessException("\u65e0\u6cd5\u83b7\u53d6\u767b\u9646\u4fe1\u606f\uff0c\u8bf7\u91cd\u65b0\u767b\u9646");
        }
        String orgCode = user.getOrgcode();
        if (StringUtils.isBlank((CharSequence)orgCode)) {
            throw new BusinessException("\u65e0\u6cd5\u83b7\u53d6\u767b\u9646\u8005\u5f53\u524d\u7ec4\u7ec7\u4fe1\u606f\uff0c\u8bf7\u91cd\u65b0\u767b\u9646");
        }
        MdmPositionUserOrgPageReqVo orgReqVo = (MdmPositionUserOrgPageReqVo)CrmBeanUtil.copy((Object)reqVo, MdmPositionUserOrgPageReqVo.class);
        if (null == reqVo.getCurrentLoginOrg() || reqVo.getCurrentLoginOrg().booleanValue()) {
            orgReqVo.setAllUnderThisOrgCode(orgCode);
        } else {
            orgReqVo.setAllUnderThisOrgCodeExcludeSelf(orgCode);
        }
        orgReqVo.setPrimaryFlag(YesNoEnum.yesNoEnum.ONE.getValue());
        orgReqVo.setUserNameOrFullName(reqVo.getUserNameOrFullName());
        orgReqVo.setIncludeEmptyUserPosition(Boolean.valueOf(false));
        orgReqVo.setNotInUserNameList(reqVo.getNotInUserNameList());
        return Result.ok(this.mdmPositionService.findPositionUserOrgPageList(orgReqVo));
    }

    @ApiOperation(value="\u6279\u91cf\u4fee\u6539\u4e0e\u804c\u4f4d\u5173\u8054\u7684\u7ec4\u7ec7\u7f16\u7801")
    @PostMapping(value={"/batchUpdatePositionOrg"})
    public Result batchUpdatePositionOrg(@RequestBody MdmPositionUserOrgReqVo reqVo) {
        this.mdmPositionService.batchUpdatePositionOrg(reqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u91cd\u7f6e\u964d\u7ef4\u7f16\u7801")
    @PostMapping(value={"/resetPositionRuleCode"})
    public Result resetPositionRuleCode() {
        this.mdmPositionService.resetPositionRuleCode();
        PositionUtil.reloadAllCache();
        return Result.ok();
    }

    @ApiOperation(value="\u5220\u9664\u5168\u90e8\u7f13\u5b58")
    @PostMapping(value={"/deleteAllCache"})
    public Result deleteAllCache() {
        PositionUtil.deleteAllCache();
        return Result.ok();
    }

    @ApiOperation(value="\u91cd\u65b0\u52a0\u8f7d\u5168\u90e8\u7f13\u5b58")
    @PostMapping(value={"/reloadAllCache"})
    public Result reloadAllCache() {
        PositionUtil.reloadAllCache();
        return Result.ok();
    }

    @ApiOperation(value="\u6839\u636e\u6d41\u7a0b\u89d2\u8272\u7f16\u7801\u67e5\u8be2\u804c\u4f4d\uff0c\u6309\u7167\u7ec4\u7ec7\u4ece\u6307\u5b9a\u7ec4\u7ec7\u5411\u4e0a\u5bfb\u5740", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="orgCode", value="\u7ec4\u7ec7\u7f16\u7801", required=true, dataType="String", paramType="query"), @ApiImplicitParam(name="bpmRoleCode", value="\u6d41\u7a0b\u89d2\u8272\u7f16\u7801", required=true, dataType="String", paramType="query")})
    @GetMapping(value={"/findPositionListByBpmRoleStartUpByOrgCode"})
    public Result<List<MdmPositionUserOrgRespVo>> findPositionListByBpmRoleStartUpByOrgCode(@RequestParam(value="orgCode") String orgCode, @RequestParam(value="bpmRoleCode") String bpmRoleCode) {
        return Result.ok(this.mdmPositionService.findPositionListByBpmRoleStartUpByOrgCode(orgCode, bpmRoleCode));
    }

    @ApiOperation(value="\u6839\u636e\u6d41\u7a0b\u89d2\u8272\u7f16\u7801\u67e5\u8be2\u804c\u4f4d\u7f16\u7801\u96c6\u5408\uff0c\u6309\u7167\u7ec4\u7ec7\u53ca\u7ec4\u7ec7\u4e0a\u7ea7")
    @PostMapping(value={"/findPositionCodeSetByOrgParentAndBpmRoleCodeList"})
    public Result<Set<String>> findPositionCodeSetByOrgParentAndBpmRoleCodeList(@RequestParam(value="orgCode", required=false) String orgCode, @RequestBody List<String> bpmRoleCodeList) {
        return Result.ok(this.mdmPositionService.findPositionCodeSetByOrgParentAndBpmRoleCodeList(orgCode, bpmRoleCodeList));
    }

    @ApiOperation(value="\u6839\u636e\u6d41\u7a0b\u89d2\u8272\u7f16\u7801\u67e5\u8be2\u804c\u4f4d\u7f16\u7801\u96c6\u5408\uff0c\u6309\u7167\u7ec4\u7ec7")
    @PostMapping(value={"/findPositionCodeSetByOrgAndBpmRoleCodeList"})
    public Result<Set<String>> findPositionCodeSetByOrgAndBpmRoleCodeList(@RequestParam(value="orgCode", required=false) String orgCode, @RequestBody List<String> bpmRoleCodeList) {
        return Result.ok(this.mdmPositionService.findPositionCodeSetByOrgAndBpmRoleCodeList(orgCode, bpmRoleCodeList));
    }

    @ApiOperation(value="\u804c\u4f4d\u4e0e\u7528\u6237\u5206\u9875\u5217\u8868(SFA)")
    @PostMapping(value={"/positionAndUserPage"})
    public Result<PageResult<MdmPositionPageRespVo>> positionAndUserPage(@RequestBody MdmPositionCurrentUserReqVo reqVo) {
        PageResult<MdmPositionPageRespVo> result = this.mdmPositionService.positionAndUserPage(reqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="\u6839\u636e\u5f53\u524d\u7528\u6237\u7c7b\u578b\u67e5\u8be2\u804c\u4f4d\u4e0e\u7528\u6237\u5206\u9875\u5217\u8868(SFA)")
    @PostMapping(value={"/findPositionAndUserByType"})
    public Result<PageResult<MdmPositionPageRespVo>> findPositionAndUserByType(@RequestBody MdmPositionCurrentUserReqVo reqVo) {
        PageResult<MdmPositionPageRespVo> result = this.mdmPositionService.findPositionAndUserByType(reqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="\u6839\u636e\u7528\u6237\u67e5\u8be2\u5f53\u524d\u7528\u6237\u7684\u6240\u6709\u5c97\u4f4d\u7f16\u7801")
    @PostMapping(value={"/findAllPositionsByUserName"})
    public Result<List<String>> findAllPositionsByUserName(@RequestBody MdmPositionCurrentUserReqVo reqVo) {
        List<String> allPositionsByUserName = this.mdmPositionService.findAllPositionsByUserName(reqVo.getUserName());
        return Result.ok(allPositionsByUserName);
    }
}

