package com.biz.crm.approval.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.approval.model.MdmApprovalConfigEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.mdm.approval.req.MdmApprovalConfigReqVo;
import com.biz.crm.nebular.mdm.approval.resp.MdmApprovalConfigRedisVo;
import com.biz.crm.nebular.mdm.approval.resp.MdmApprovalConfigRespVo;

import java.util.List;

/**
 * 审批配置主表接口
 *
 * @author Tao.Chen
 * @date 2021-03-01 17:50:29
 */
public interface MdmApprovalConfigService extends IService<MdmApprovalConfigEntity> {

    /**
     * 分页列表
     *
     * @param mdmApprovalConfigReqVo
     * @return PageResult<MdmApprovalConfigRespVo>
     */
    PageResult<MdmApprovalConfigRespVo> findApprovalConfigPageList(MdmApprovalConfigReqVo mdmApprovalConfigReqVo);

    /**
     * 列表
     *
     * @param mdmApprovalConfigReqVo
     * @return List<MdmApprovalConfigRespVo>
     */
    List<MdmApprovalConfigRespVo> findApprovalConfigList(MdmApprovalConfigReqVo mdmApprovalConfigReqVo);

    /**
     * 查询
     *
     * @param id
     * @return MdmApprovalConfigRespVo
     */
    MdmApprovalConfigRespVo queryById(String id);

    /**
     * 查询redis待缓存数据
     *
     * @param businessCode 业务编码
     * @return
     */
    MdmApprovalConfigRedisVo queryForRedis(String businessCode);

    /**
     * 新增
     *
     * @param mdmApprovalConfigReqVo
     * @return
     */
    void save(MdmApprovalConfigReqVo mdmApprovalConfigReqVo);

    /**
     * 更新
     *
     * @param mdmApprovalConfigReqVo
     * @return
     */
    void update(MdmApprovalConfigReqVo mdmApprovalConfigReqVo);

    /**
     * 删除
     *
     * @param ids
     * @return
     */

    void deleteBatch(List<String> ids);

    /**
     * 开启
     *
     * @param ids
     * @return
     */
    void open(List<String> ids);

    /**
     * 关闭
     *
     * @param ids
     * @return
     */
    void close(List<String> ids);
}

