package com.biz.crm.approval.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.approval.mapper.MdmApprovalConfigConditionMapper;
import com.biz.crm.approval.model.MdmApprovalConfigConditionEntity;
import com.biz.crm.approval.service.MdmApprovalConfigConditionService;
import com.biz.crm.nebular.mdm.approval.req.MdmApprovalConfigConditionReqVo;
import com.biz.crm.nebular.mdm.approval.resp.MdmApprovalConfigConditionRespVo;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;

/**
 * 审批配置条件字段表接口实现
 *
 * @author Tao.Chen
 * @date 2021-03-01 17:50:29
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name = "MdmBpmConfigConditionServiceExpandImpl")
public class MdmApprovalConfigConditionServiceImpl<M extends BaseMapper<T>, T> extends ServiceImpl<MdmApprovalConfigConditionMapper, MdmApprovalConfigConditionEntity> implements MdmApprovalConfigConditionService {

    @Resource
    private MdmApprovalConfigConditionMapper mdmApprovalConfigConditionMapper;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void saveConditionList(String businessCode, List<MdmApprovalConfigConditionReqVo> conditionList) {
        if (CollectionUtil.listNotEmptyNotSizeZero(conditionList)) {
            Assert.hasText(businessCode, "缺失业务编码");
            List<MdmApprovalConfigConditionEntity> collect = conditionList.stream().map(x -> {
                MdmApprovalConfigConditionEntity copy = CrmBeanUtil.copy(x, MdmApprovalConfigConditionEntity.class);
                copy.setBusinessCode(businessCode);
                //TODO 防止有的项目数据库有非空限制报错
                copy.setMenuCode(UUID.randomUUID().toString().replace("-", ""));
                return copy;
            }).collect(Collectors.toList());
            this.saveBatch(collect);
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteConditionList(String businessCode) {
        Assert.hasText(businessCode, "缺失业务编码");
        this.lambdaUpdate()
                .eq(MdmApprovalConfigConditionEntity::getBusinessCode, businessCode)
                .remove();
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteConditionList(List<String> businessCodeList) {
        if (CollectionUtil.listNotEmptyNotSizeZero(businessCodeList)) {
            this.lambdaUpdate()
                    .in(MdmApprovalConfigConditionEntity::getBusinessCode, businessCodeList)
                    .remove();
        }
    }

    @Override
    public List<MdmApprovalConfigConditionRespVo> findConditionList(String businessCode) {
        Assert.hasText(businessCode, "缺失业务编码");
        List<MdmApprovalConfigConditionEntity> list = this.lambdaQuery()
                .eq(MdmApprovalConfigConditionEntity::getBusinessCode, businessCode)
                .list();
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            return CrmBeanUtil.copyList(list, MdmApprovalConfigConditionRespVo.class);
        }
        return new ArrayList<>();
    }

}
