package com.biz.crm.availablelist.consumer;

import com.biz.crm.availablelist.service.CusAvailablelistService;
import com.biz.crm.availablelist.service.TerminalAvailablelistService;
import com.biz.crm.mq.AbstractRocketMQConsumer;
import com.biz.crm.mq.RocketMQConstant;
import com.biz.crm.mq.RocketMQMessageBody;
import com.biz.crm.util.JsonPropertyUtil;
import com.biz.crm.utils.AvailableUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import javax.annotation.Resource;
import java.util.List;

/**
 * @Description: 删除商品
 * @Author: zhangyuzhu
 * @Date: 2020/10/30 14:18
 **/
@Slf4j
@Component
@RocketMQMessageListener(topic = "${rocketmq.topic}" + "${rocketmq.environment-variable}",
        /**
         * tag
         * 可用 || 监听多个tag： "tag1 || tag2 || tag3"
        */
        selectorExpression = RocketMQConstant.CRM_MQ_TAG.AVAILBLELIST_DELPRODUCT,
        /**
         * 相同分组下 consumer 可自动负载均衡
        */
        consumerGroup = RocketMQConstant.CONSUMER_GROUP.AVAILBLELIST_DELPRODUCT + "${rocketmq.environment-variable}")
public class AvailableListDelProductConsumer extends AbstractRocketMQConsumer {

    @Resource
    private CusAvailablelistService cusAvailablelistService;


    @Resource
    private TerminalAvailablelistService terminalAvailablelistService;

    @Override
    protected Object handleMessage(RocketMQMessageBody message) throws InterruptedException {
        log.info("删除商品开始------------------------");
        String msg = message.getMsgBody();
        if(StringUtils.isEmpty(msg)){
            log.info("消息为空------------------------");
            return "消息为空!";
        }
        log.info("商品编码{}",msg);
        List<String> goodsCodes = JsonPropertyUtil.toObject(msg,List.class);
        if(CollectionUtils.isEmpty(goodsCodes)){
            log.info("商品列表为空------------------------");
            return "商品列表为空!";
        }
        log.info("客户商品");
        cusAvailablelistService.delByGoodsCodes(goodsCodes);
        log.info("终端商品");
        terminalAvailablelistService.delByGoodsCodes(goodsCodes);
        log.info("删除更新商品结束------------------------");
        return "操作成功";
    }
}
