package com.biz.crm.availablelist.consumer;

import com.biz.crm.availablelist.service.CusAvailablelistService;
import com.biz.crm.mq.AbstractRocketMQConsumer;
import com.biz.crm.mq.RocketMQConstant;
import com.biz.crm.mq.RocketMQMessageBody;
import com.biz.crm.util.JsonPropertyUtil;
import com.biz.crm.utils.AvailableUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import javax.annotation.Resource;
import java.util.List;

/**
 * @Description: 刷新客户可购清单促销消息消费者
 * @Author: zhangyuzhu
 * @Date: 2020/10/30 14:18
 **/
@Slf4j
@Component
@RocketMQMessageListener(topic = "${rocketmq.topic}" + "${rocketmq.environment-variable}",
        /**
         * tag
         * 可用 || 监听多个tag： "tag1 || tag2 || tag3"
        */
        selectorExpression = RocketMQConstant.CRM_MQ_TAG.CUS_AVAILBLELIST_REFRSH_PROMOTION,
        /**
         * 相同分组下 consumer 可自动负载均衡
        */
        consumerGroup = RocketMQConstant.CONSUMER_GROUP.CUS_AVAILBLELIST_REFRSH_PROMOTION + "${rocketmq.environment-variable}")
public class CusAvailableListRefreshPromotionConsumer extends AbstractRocketMQConsumer {

    @Resource
    private CusAvailablelistService cusAvailablelistService;

    @Override
    protected Object handleMessage(RocketMQMessageBody message) throws InterruptedException {
        log.info("客户可够清单促销刷新开始-------------");
        String msg = message.getMsgBody();
        if(StringUtils.isEmpty(msg)){
            return "消息为空!";
        }
        log.info("客户：{}",msg);
        List<String> cusCodes = JsonPropertyUtil.toObject(msg,List.class);
        if(CollectionUtils.isEmpty(cusCodes)){
            log.info("客户列表为空");
            return "客户列表为空!";
        }
        cusAvailablelistService.reFreshPromotion(cusCodes);
        log.info("客户可够清单促销刷新结束-------------");
        return "操作成功";
    }
}
