package com.biz.crm.availablelist.consumer;

import com.biz.crm.availablelist.service.CusAvailablelistService;
import com.biz.crm.availablelist.service.TerminalAvailablelistService;
import com.biz.crm.mq.AbstractRocketMQConsumer;
import com.biz.crm.mq.RocketMQConstant;
import com.biz.crm.mq.RocketMQMessageBody;
import com.biz.crm.util.JsonPropertyUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import javax.annotation.Resource;
import java.util.List;

/**
 * @Description: 修改商品層級，同时刷新产品层级的可购清单规则
 * 备注：需传递新旧两个产品层级code
 * @Author: zhangyuzhu
 * @Date: 2020/10/30 14:18
 **/
@Slf4j
@Component
@RocketMQMessageListener(topic = "${rocketmq.topic}" + "${rocketmq.environment-variable}",
        /**
         * tag
         * 可用 || 监听多个tag： "tag1 || tag2 || tag3"
        */
        selectorExpression = RocketMQConstant.CRM_MQ_TAG.AVAILBLELIST_REFRSH_UPDATE_PRODUCT_LEVEL,
        /**
         * 相同分组下 consumer 可自动负载均衡
        */
        consumerGroup = RocketMQConstant.CONSUMER_GROUP.AVAILBLELIST_REFRSH_UPDATE_PRODUCT_LEVEL + "${rocketmq.environment-variable}")
public class ProductLevelChangeConsumer extends AbstractRocketMQConsumer {

    @Resource
    private CusAvailablelistService cusAvailablelistService;

    @Resource
    private TerminalAvailablelistService terminalAvailablelistService;

    @Override
    protected Object handleMessage(RocketMQMessageBody message) throws InterruptedException {//检测可购清单刷新开关，如果为关闭状态则不刷新

        log.info("产品层级变动通知开始，--------------");
        String msg = message.getMsgBody();
        if (StringUtils.isEmpty(msg)) {
            return "消息为空!";
        }

        handleMessageExtend(msg);
//        List<AvalibleListProductLevelChangeDto> dtos = JsonPropertyUtil.toObject(msg, List.class);
//        if (CollectionUtils.isEmpty(dtos)) {
//            log.info("产品层级code列表为空!");
//            return "产品层级code列表为空!";
//        }
//
//        //检测可购清单刷新开关，如果为关闭状态则不刷新
//        if (!AvailableUtil.refreshFlag()) {
//            Map<String, AvalibleListProductLevelChangeDto> dtoMap = new HashMap<>();
//            for (AvalibleListProductLevelChangeDto dto : dtos) {
//                if (!StringUtils.isEmpty(dto.getGoodsCode())) {
//                    dtoMap.put(dto.getGoodsCode(), dto);
//                }
//            }
//            if (CollectionUtils.isEmpty(dtoMap)) {
//                log.info("商品编码全部为空!");
//                return "商品编码全部为空!";
//            }
//            cusAvailablelistService.reFreshProductLevel(dtoMap);
//            terminalAvailablelistService.reFreshProductLevel(dtoMap);
//        } else {
//            Set<String> productLevelCode = new HashSet<>();
//            for (AvalibleListProductLevelChangeDto dto : dtos) {
//                if (!StringUtils.isEmpty(dto.getNewLevelCode())) {
//                    productLevelCode.add(dto.getNewLevelCode());
//                }
//                if (!StringUtils.isEmpty(dto.getOldLevelCode())) {
//                    productLevelCode.add(dto.getOldLevelCode());
//                }
//            }
//            cusAvailablelistService.reFreshByProductLevel(new ArrayList<>(productLevelCode));
//            terminalAvailablelistService.reFreshByProductLevel(new ArrayList<>(productLevelCode));
//        }
        log.info("产品层级变动通知结束，--------------");
        return "操作成功";
    }

    private void handleMessageExtend(String msg) {
        List<String> levelCodes = JsonPropertyUtil.toObject(msg, List.class);
        if (CollectionUtils.isEmpty(levelCodes)) {
            log.info("商品层级列表为空");
        }
        cusAvailablelistService.reFreshByProductLevel(levelCodes);
        terminalAvailablelistService.reFreshByProductLevel(levelCodes);
    }
}
