package com.biz.crm.availablelist.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.availablelist.service.TerminalAvailablelistService;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.mdm.availablelist.TerminalAvailablelistVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

/**可购清单规则
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2020/9/25 16:47
 **/
@Api(value = "管理端-终端可购清单", tags = "管理端-终端可购清单")
@RestController
@RequestMapping("/m/terminal/availableList")
public class TerminalAvailableListmController {

    @Resource
    private TerminalAvailablelistService terminalAvailablelistService;

    @CrmLog
    @ApiOperation(value = "批量刷新终端可购清单")
    @PostMapping(value = "reFresh/terminal")
    public Result<Object> reFreshTerminal(@RequestBody ArrayList<String> terminalCodes) {
        terminalAvailablelistService.reFresh(terminalCodes);
        return Result.ok();
    }

    @CrmLog
    @CrossOrigin
    @ApiOperation(value = "查询终端可购清单")
    @PostMapping(value = "terminal/list")
    public Result<PageResult<TerminalAvailablelistVo>> listTerminal(@RequestBody TerminalAvailablelistVo terminalAvailablelistVo) {
        return Result.ok(terminalAvailablelistService.listForM(terminalAvailablelistVo));
    }


    @CrmLog
    @CrossOrigin
    @ApiOperation(value = "根据id删除终端可购清单")
    @GetMapping(value = "terminal/delById/{id}")
    public Result<Object> delById(@PathVariable("id") String id) {
        terminalAvailablelistService.delById(id);
        return Result.ok();
    }


    @CrmLog
    @CrossOrigin
    @ApiOperation(value = "根据id批量删除终端可购清单")
    @PostMapping(value = "terminal/delByIds")
    public Result<Object> delByIds(@RequestBody List<String> ids) {
        terminalAvailablelistService.delByIds(ids);
        return Result.ok();
    }


//    @CrmLog
//    @CrossOrigin
//    @ApiOperation(value = "批量根据商品code删除")
//    @PostMapping(value = "delByGoodsCode")
//    public Result<Object> delByGoodsCode(@RequestBody List<String> goodsCodes) {
//        terminalAvailablelistService.delByGoodsCodes(goodsCodes);
//        return Result.ok();
//    }
//
//
//    @CrmLog
//    @CrossOrigin
//    @ApiOperation(value = "批量跟新商品数据")
//    @PostMapping(value = "updateByGoodsCodes")
//    public Result<Object> updateByGoodsCodes(@RequestBody List<MdmProductAdviseRespVo> mdmProductAdviseRespVos) {
//        terminalAvailablelistService.updateByGoodsCodes(mdmProductAdviseRespVos);
//        return Result.ok();
//    }


    @CrmLog
    @ApiOperation(value = "通过id查询客户可购清单")
    @GetMapping(value = "terminal/findById/{id}")
    public Result<TerminalAvailablelistVo> findById(@PathVariable("id") String id) {
        return Result.ok(terminalAvailablelistService.findById(id));
    }
}
