package com.biz.crm.availablelist.entity;

import com.biz.crm.nebular.mdm.product.resp.MdmProductAdviseRespVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalVo;
import com.biz.crm.utils.MdmConstant;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.springframework.data.elasticsearch.annotations.Document;


/**
 * @Description: 终端可够清单列表
 * 当前类没有添加50个拓展字段，如果项目上需要用到拓展字段，请自行在该类添加，请务必注意不要跟现有的拓展字段重复
 * @Author: zhangyuzhu
 * @Date: 2020/10/9 14:40
 **/
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@Document(indexName= MdmConstant.ES_TERMINALAVAILABLELIST_INDEXNAME, type=MdmConstant.ES_TERMINALAVAILABLELIST_TYPE,createIndex = false)
public class TerminalAvailablelistEntity extends MdmProductAdviseRespVo {

    /**
     * 终端编码
     */
    private String terminalCode;

    /**
     * 终端名称
     */
    private String terminalName;

    /**
     * 终端所属组织编码
     */
    private String terminalOrgCode;

    /**
     * 终端所属组织名称
     */
    private String terminalOrgName;

    /**
     * 终端所属渠道编码
     */
    private String terminalChannelCode;

    /**
     * 终端所属渠道名称
     */
    private String terminalChannelName;

    /**
     * 终端信息（拓展用）
     */
    private MdmTerminalVo mdmTerminalVo;

    /**
     * 是否常购
     */
    private Integer ofenFlag;
}
