package com.biz.crm.availablelist.repositories;

import com.biz.crm.availablelist.entity.TerminalAvailablelistEntity;
import org.springframework.data.repository.CrudRepository;

import java.util.List;

/**
 * @Author zhangyuzhu
 * @Description
 * @Created data 2019/7/11 11:56
 */
public interface TerminalAvailablelistRepositories extends CrudRepository<TerminalAvailablelistEntity, String> {

    /**
     * 根据商品code查询
     * @param productCodes
     * @return
     */
    List<TerminalAvailablelistEntity> findByTerminalCodeAndProductCodeIn(String terminalCode,List<String> productCodes);


    /**
     * 根据id批量查询
     * @param ids
     * @return
     */
    List<TerminalAvailablelistEntity> findByIdIn(List<String> ids);

    /**
     * 根据商品code列表删除
     * @param productCodes
     */
    void deleteByTerminalCodeAndProductCodeIn(String terminalCode,List<String> productCodes);

    /**
     * 根据虚拟id批量删除
     * @param ids
     */
    void deleteByIdIn(List<String> ids);

    /**
     * 根据商品code查询
     * @param productCodes
     * @return
     */
    List<TerminalAvailablelistEntity> findByProductCodeIn(List<String> productCodes);


}
