package com.biz.crm.availablelist.service;

import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.mdm.availablelist.AvalibleListProductLevelChangeDto;
import com.biz.crm.nebular.mdm.availablelist.TerminalAvailablelistVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductAdviseRespVo;

import java.util.List;
import java.util.Map;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2020/10/9 15:01
 **/
public interface TerminalAvailablelistService {

    /**
     *  为客户替换可够清单（如果没有则添加，有则替换）
     * @param goods 商品列表
     * @param terminalCode 终端编码
     */
    void reFresh(List<MdmProductAdviseRespVo> goods, String terminalCode);


    /**
     *  刷新终端可够清单
     * @param terminalCode 终端code
     */
    void reFresh(String terminalCode);


    /**
     *  批量刷新终端可够清单
     * @param terminalCodes 终端code列表
     */
    void reFresh(List<String> terminalCodes);

    /**
     * 根据产品层级刷新可够清单
     * @param productLevelCode
     */
    void reFreshByProductLevel(List<String> productLevelCode);

    /**
     * 修改商品的层级信息
     * @param dtoMap key->商品编码
     */
    void reFreshProductLevel(Map<String,AvalibleListProductLevelChangeDto> dtoMap);

    /**
     * 根据客户编码修改商品的层级信息(reFreshProductLevel 专用)
     * @param cusCode
     * @param dtoMap
     */
    void reFreshProductLevelByCus(String cusCode,Map<String,AvalibleListProductLevelChangeDto> dtoMap);

    /**
     * 根据商品codes更新商品信息
     * @param mdmProductAdviseRespVos
     */
    void updateByGoodsCodes(List<MdmProductAdviseRespVo> mdmProductAdviseRespVos);


    /**
     * 根据商品codes更新商品信息
     * @param mdmProductAdviseRespVos
     */
    void updateByGoodsCodesAndTerminalCode(List<MdmProductAdviseRespVo> mdmProductAdviseRespVos,String terminalCode);

    /**
     * 根据商品code删除可够清单
     * @param goodsCodes
     */
    void delByGoodsCodes(List<String> goodsCodes);

    /**
     * 根据商品code删除可够清单(delByGoodsCodes 专用)
     * @param goodsCodes
     */
    void delByGoodsCodesAndTerminalCode(List<String> goodsCodes, String terminalCode);


    /**
     * 查询可够商品
     * @return
     */
    PageResult<TerminalAvailablelistVo> list(TerminalAvailablelistVo terminalAvailablelistVo);

    /**
     * 查询可够商品
     * @return
     */
    PageResult<TerminalAvailablelistVo> listForM(TerminalAvailablelistVo terminalAvailablelistVo);


    /**
     * 根据id删除
     * @param id
     */
    void delById(String id);

    /**
     * 根据id删除(delById方法专用)
     * @param id
     * @param terminalCode
     */
    void delByIdAndTerminalCode(String id,String terminalCode);

    /**
     * 根据虚拟id批量删除
     * @param ids
     */
    void delByIds(List<String> ids);

    /**
     * 根据虚拟id批量删除(delByIds方法专用)
     * @param ids
     */
    void delByIdsAndTerminalCode(List<String> ids,String terminalCode);

    /**
     * 根据id查询
     * @param id
     * @return
     */
    TerminalAvailablelistVo findById(String id);

}
