package com.biz.crm.availablelistrule.consumer;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.availablelistrule.service.AvailableListRuleService;
import com.biz.crm.mq.AbstractRocketMQConsumer;
import com.biz.crm.mq.RocketMQConstant;
import com.biz.crm.mq.RocketMQMessageBody;
import com.biz.crm.nebular.mdm.availablelistrule.AvailableListRuleVo;
import com.biz.crm.util.JsonPropertyUtil;
import java.util.List;
import javax.annotation.Resource;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

/**
 * @Description: 可购规则导入消费者
 * @Author: zhangyuzhu
 * @Date: 2020/10/30 14:18
 **/
@Component
@RocketMQMessageListener(topic = "${rocketmq.topic}" + "${rocketmq.environment-variable}",
        /**
         * tag
         * 可用 || 监听多个tag： "tag1 || tag2 || tag3"
        */
        selectorExpression = RocketMQConstant.CRM_MQ_TAG.AVAILABLE_RULE_IMPORT_TAG,
        /**
         * 相同分组下 consumer 可自动负载均衡
        */
        consumerGroup = RocketMQConstant.CONSUMER_GROUP.AVAILABLE_RULE_IMPORT_CONSUMER + "${rocketmq.environment-variable}")
public class AvailableRuleImportConsumer extends AbstractRocketMQConsumer {

    @Resource
    private AvailableListRuleService availableListRuleService;

    @Override
    protected Object handleMessage(RocketMQMessageBody message){
        String msg = message.getMsgBody();
        if(StringUtils.isEmpty(msg)){
            return "消息为空!";
        }
//        List<AvailableListRuleVo> ruleVos = JsonPropertyUtil.toObject(msg,List.class);
        List<AvailableListRuleVo> ruleVos = JSONObject.parseArray(msg, AvailableListRuleVo.class);
        if(CollectionUtils.isEmpty(ruleVos)){
            return "可购规则列表为空!";
        }
        ruleVos.forEach(rule -> availableListRuleService.add(rule));
        return "操作成功";
    }
}
