package com.biz.crm.availablelistrule.handler;

import com.biz.crm.availablelistrule.advise.Advise;
import com.biz.crm.availablelistrule.advise.strategy.ProductLevelChangeAdviseTargetStrategy;
import com.biz.crm.nebular.mdm.product.req.ProductChangeHandlerReqVo;
import com.biz.crm.product.handler.ProductChangeHandler;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.Set;

/**
 * 商品变更规则执行刷新
 *
 * @author sunx
 * @date 2021/9/13
 */
@Component
@Slf4j
public class ProductChangeAvailableListRuleHandler implements ProductChangeHandler {
    @Resource
    private Advise advise;

    @Resource
    private ProductLevelChangeAdviseTargetStrategy productLevelChangeAdviseTargetStrategy;

    /**
     * 客户变更处理方法
     *
     * @param vo
     */
    @Override
    public void handler(ProductChangeHandlerReqVo vo) {
        log.info("ProductChangeAvailableListRuleHandler->handler[{}]", vo);
        Set<String> codes = Sets.newHashSet();
        if (StringUtils.isNotBlank(vo.getOldLevelCode())) {
            codes.add(vo.getOldLevelCode());
        }
        if (StringUtils.isNotBlank(vo.getCurrentLevelCode())) {
            codes.add(vo.getCurrentLevelCode());
        }
        if (CollectionUtils.isEmpty(codes)) {
            log.error("ProductChangeAvailableListRuleHandler->handler无层级变更信息[{}]", vo);
            return;
        }
        advise.adviseTarget(productLevelChangeAdviseTargetStrategy, Lists.newArrayList(codes));
    }
}
