package com.biz.crm.availablelistrule.handler;

import com.biz.crm.availablelistrule.advise.Advise;
import com.biz.crm.availablelistrule.advise.strategy.TerminalOrgChangeAdviseTargetStrategy;
import com.biz.crm.nebular.mdm.terminal.req.TerminalChangeHandlerReqVo;
import com.biz.crm.terminal.handler.TerminalChangeHandler;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.Set;

/**
 * 终端信息变更规则执行刷新
 *
 * @author sunx
 * @date 2021/9/9
 */
@Component
@Slf4j
public class TerminalChangeAvailableListRuleHandler implements TerminalChangeHandler {

    @Resource
    private Advise advise;

    @Resource
    private TerminalOrgChangeAdviseTargetStrategy terminalOrgChangeAdviseTargetStrategy;

    /**
     * 关联业务需要实现对应的逻辑
     *
     * @param vo
     */
    @Override
    public void handler(TerminalChangeHandlerReqVo vo) {
        log.info("TerminalChangeAvailableListRuleHandler->handler[{}]", vo);
        Set<String> codes = Sets.newHashSet();
        if (StringUtils.isNotBlank(vo.getOldOrgCode())) {
            codes.add(vo.getOldOrgCode());
        }
        if (StringUtils.isNotBlank(vo.getCurrentOrgCode())) {
            codes.add(vo.getCurrentOrgCode());
        }
        if (CollectionUtils.isEmpty(codes)) {
            log.error("TerminalChangeAvailableListRuleHandler->handler无组织信息[{}]", vo);
            return;
        }
        advise.adviseTarget(terminalOrgChangeAdviseTargetStrategy, Lists.newArrayList(codes));
    }
}
