package com.biz.crm.availablelistrule.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.availablelistrule.doo.AvailableDo;
import com.biz.crm.availablelistrule.entity.AvailableListRuleGoodsEntity;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2020/9/25 16:43
 **/
public interface AvailableListRuleGoodsMapper extends BaseMapper<AvailableListRuleGoodsEntity> {


    /**
     * 通过客户编码和客户组织查询所有的可够和不可够
     * @param cusCode
     * @param orgCodes
     * @param orgType
     * @param cusType
     * @return
     */
    List<AvailableDo> findGoodsByCusCodeAndOrgCode(@Param("cusCode") String cusCode,
                                                   @Param("orgCodes")List<String> orgCodes,
                                                   @Param("orgType")Integer orgType,
                                                   @Param("cusType")Integer cusType);


    /**
     * 通过终端编码和客户组织查询所有的可够和不可够
     * @param terminalCode
     * @param orgCodes
     * @param orgType
     * @param terminalType
     * @return
     */
    List<AvailableDo> findGoodsByTerminalCodeAndOrgCode(@Param("terminalCode") String terminalCode,
                                                        @Param("orgCodes")List<String> orgCodes,
                                                        @Param("orgType")Integer orgType,
                                                        @Param("terminalType")Integer terminalType);


    /**
     * 查询包含以下产品层级的可够规则编码(只查询产品层级的)
     * @param productLevels
     * @param dimensions
     * @return
     */
    List<String> findRuleCodesByProductLevels(@Param("productLevels") List<String> productLevels,
                                              @Param("dimensions") List<Integer> dimensions,
                                              @Param("yesOrNo") String yesOrNo);


    /**
     * 查询包含以下产品层级的可够规则编码(只查询产品层级的)
     * @param productLevels
     * @param dimensions
     * @return
     */
    List<String> findRuleCodesByProductLevelsToOracle(@Param("productLevels") List<String> productLevels,
                                              @Param("dimensions") List<Integer> dimensions,
                                              @Param("yesOrNo") String yesOrNo);
}
