package com.biz.crm.availablelistrule.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.availablelistrule.entity.AvailableListRuleEntity;
import com.biz.crm.availablelistrule.entity.AvailableListRuleGoodsEntity;
import com.biz.crm.availablelistrule.mapper.AvailableListRuleGoodsMapper;
import com.biz.crm.availablelistrule.service.AvailableListRuleGoodsService;
import com.biz.crm.availablelistrule.utils.AvailableListRuleGoodsUtil;
import com.biz.crm.nebular.mdm.availablelistrule.AvailableListRuleGoodsVo;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.ValidateUtils;
import org.assertj.core.util.Lists;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2020/9/25 16:47
 **/
@ConditionalOnMissingBean(name = "availableListRuleServiceGoodsExpandImpl")
@Service(value = "availableListRuleGoodsService")
public class AvailableListRuleGoodsServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<AvailableListRuleGoodsMapper, AvailableListRuleGoodsEntity> implements AvailableListRuleGoodsService {

    @Autowired
    private AvailableListRuleGoodsMapper availableListRuleGoodsMapper;

    /**
     * 1、删除原有商品
     * 2、组装保存
     * @param vos
     * @param ruleEntity
     */
    @Transactional
    @Override
    public void replace(List<AvailableListRuleGoodsVo> vos, AvailableListRuleEntity ruleEntity) {
        //1
        this.removeByMap(new HashMap<String, Object>(){{
            put("rule_code",ruleEntity.getRuleCode());
        }});

        //2
        if(CollectionUtils.isEmpty(vos)){
            return;
        }
        this.saveBatch(AvailableListRuleGoodsUtil.packageEntities(vos,ruleEntity));
    }

    @Override
    public List<AvailableListRuleGoodsVo> findByRuleCode(String ruleCode) {
        //1
        if(StringUtils.isEmpty(ruleCode)){
            return new ArrayList<>();
        }

        //2
        QueryWrapper<AvailableListRuleGoodsEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("rule_code", ruleCode);
        List<AvailableListRuleGoodsEntity> goodsEntities = availableListRuleGoodsMapper.selectList(wrapper);
        if(CollectionUtils.isEmpty(goodsEntities)){
            return new ArrayList<>();
        }
        List<AvailableListRuleGoodsVo> reList = new ArrayList<>(goodsEntities.size());
        for(AvailableListRuleGoodsEntity entity : goodsEntities){
            AvailableListRuleGoodsVo vo = new AvailableListRuleGoodsVo();
            BeanUtils.copyProperties(entity,vo);
            reList.add(vo);
        }
        return reList;
    }

    @Override
    public List<AvailableListRuleGoodsVo> findByRuleCodes(List<String> ruleCodes) {
        List<AvailableListRuleGoodsVo> vos = null;
        ValidateUtils.validate(ruleCodes,"请指定需要查询的可够规则编号！");
        List<AvailableListRuleGoodsEntity> list = this.lambdaQuery()
                .in(AvailableListRuleGoodsEntity::getRuleCode, ruleCodes)
                .list();
        vos = CrmBeanUtil.copyList(list, AvailableListRuleGoodsVo.class);
        if (CollectionUtil.listEmpty(vos)) {
            return Lists.newArrayList();
        }
        return vos;
    }
}
