package com.biz.crm.availablelistrule.utils;

import com.biz.crm.availablelistrule.entity.AvailableListRuleAreaEntity;
import com.biz.crm.availablelistrule.entity.AvailableListRuleEntity;
import com.biz.crm.customer.utils.ValidateUtils;
import com.biz.crm.eunm.dms.AvailableListRuleEunm;
import com.biz.crm.nebular.mdm.availablelistrule.AvailableListRuleAreaVo;
import org.springframework.beans.BeanUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2020/9/25 17:49
 **/
public class AvailableListRuleAreaUtil {


    /**
     * 组装实体类
     * @param vos
     * @param ruleEntity
     * @return
     */
    public static List<AvailableListRuleAreaEntity> packageEntities(List<AvailableListRuleAreaVo> vos, AvailableListRuleEntity ruleEntity){
        List<AvailableListRuleAreaEntity> entities = new ArrayList<>(vos.size());
        for(AvailableListRuleAreaVo vo : vos){
            validate(vo, AvailableListRuleEunm.Dimension.getByCode(ruleEntity.getDimension()));
            AvailableListRuleAreaEntity entity = new AvailableListRuleAreaEntity();
            BeanUtils.copyProperties(vo,entity);
            entity.setRuleCode(ruleEntity.getRuleCode());
            entities.add(entity);
        }
        return entities;
    }

    /**
     * 验证逻辑
     * @param vo
     */
    public static void validate(AvailableListRuleAreaVo vo, AvailableListRuleEunm.Dimension dimension){
        if(dimension.getCode().intValue() == AvailableListRuleEunm.Dimension.CUSORG.getCode().intValue()
            ||dimension.getCode().intValue() == AvailableListRuleEunm.Dimension.TERMINALORG.getCode().intValue()){
            ValidateUtils.validate(vo.getOrgCode(),"组织编码不能为空!");
            ValidateUtils.validate(vo.getOrgName(),"组织名称不能为空!");
        }
        if(dimension.getCode().intValue() == AvailableListRuleEunm.Dimension.CUS.getCode().intValue()){
            ValidateUtils.validate(vo.getCusCode(),"客户编码不能为空!");
            ValidateUtils.validate(vo.getCusName(),"客户名称不能为空!");
        }
        if(dimension.getCode().intValue() == AvailableListRuleEunm.Dimension.TERMINAL.getCode().intValue()){
            ValidateUtils.validate(vo.getTerminalCode(),"终端编码不能为空!");
            ValidateUtils.validate(vo.getTerminalName(),"终端名称不能为空!");
        }
    }
}
