package com.biz.crm.bpmrole.controller;

import com.biz.crm.aop.CrmGlobalLog;
import com.biz.crm.bpmrole.service.MdmBpmRoleService;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.nebular.mdm.bpmrole.req.MdmBpmRoleReqVo;
import com.biz.crm.nebular.mdm.bpmrole.req.MdmBpmRoleSelectReqVo;
import com.biz.crm.nebular.mdm.bpmrole.resp.MdmBpmRoleRedisRespVo;
import com.biz.crm.nebular.mdm.bpmrole.resp.MdmBpmRoleRespVo;
import com.biz.crm.nebular.mdm.bpmrole.resp.MdmBpmRoleSelectRespVo;
import com.biz.crm.util.BpmRoleUtil;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Set;

/**
 * 流程角色表
 *
 * @author Tao.Chen
 * @date 2020-11-26 20:07:10
 */
@Slf4j
@RestController
@RequestMapping("/mdmBpmRoleController")
@Api(tags = "MDM-流程角色")
@CrmGlobalLog
public class MdmBpmRoleController {

    @Autowired
    private MdmBpmRoleService mdmBpmRoleService;

    @ApiOperation(value = "查询分页列表")
    @PostMapping("/pageList")
    @CrmDictMethod
    public Result<PageResult<MdmBpmRoleRespVo>> pageList(@RequestBody MdmBpmRoleReqVo reqVo) {
        PageResult<MdmBpmRoleRespVo> result = mdmBpmRoleService.findList(reqVo);
        return Result.ok(result);
    }

    @ApiOperation(value = "通过id或者编码获取详情", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "ID", required = false, dataType = "String", paramType = "query"),
            @ApiImplicitParam(name = "bpmRoleCode", value = "流程角色编码", required = false, dataType = "String", paramType = "query")
    })
    @GetMapping("/detail")
    @CrmDictMethod
    public Result<MdmBpmRoleRespVo> detail(@RequestParam(value = "id", required = false) String id, @RequestParam(value = "bpmRoleCode", required = false) String bpmRoleCode) {
        return Result.ok(mdmBpmRoleService.detail(id, bpmRoleCode));
    }

    @ApiOperation(value = "新增")
    @PostMapping("/save")
    public Result save(@RequestBody MdmBpmRoleReqVo reqVo) {
        mdmBpmRoleService.save(reqVo);
        return Result.ok();
    }

    @ApiOperation(value = "更新")
    @PostMapping("/update")
    public Result update(@RequestBody MdmBpmRoleReqVo reqVo) {
        mdmBpmRoleService.update(reqVo);
        return Result.ok("修改成功");
    }

    @ApiOperation(value = "删除", httpMethod = "POST")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "id集合", required = true, paramType = "body")
    })
    @PostMapping("/delete")
    public Result delete(@RequestBody List<String> ids) {
        mdmBpmRoleService.deleteBatch(ids);
        return Result.ok("删除成功");
    }

    @ApiOperation(value = "启用", httpMethod = "POST")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "id集合", required = true, paramType = "body")
    })
    @PostMapping("/enable")
    public Result enable(@RequestBody List<String> ids) {
        mdmBpmRoleService.enableBatch(ids);
        return Result.ok("启用成功");
    }

    @ApiOperation(value = "禁用", httpMethod = "POST")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "id集合", required = true, paramType = "body")
    })
    @PostMapping("/disable")
    public Result disable(@RequestBody List<String> ids) {
        mdmBpmRoleService.disableBatch(ids);
        return Result.ok("禁用成功");
    }

    @ApiOperation(value = "流程角色下拉框(限制数量)")
    @PostMapping("/selectList")
    public Result<List<MdmBpmRoleSelectRespVo>> selectList(@RequestBody MdmBpmRoleSelectReqVo reqVo) {
        return Result.ok(mdmBpmRoleService.selectList(reqVo));
    }

    @ApiOperation(value = "根据职位编码集合查询关联的流程角色编码集合")
    @PostMapping("/findBpmRoleCodeSetByPositionCodeList")
    public Result<Set<String>> findBpmRoleCodeSetByPositionCodeList(@RequestBody List<String> positionCodeList) {
        return Result.ok(mdmBpmRoleService.findBpmRoleCodeSetByPositionCodeList(positionCodeList));
    }

    @ApiOperation(value = "流程角色redis查询")
    @PostMapping("/redis")
    public Result<MdmBpmRoleRespVo> selectList(@RequestBody String code) {
        return Result.ok(BpmRoleUtil.getBpmRoleCode(code));
    }

    @ApiOperation(value = "重新加载redis缓存")
    @PostMapping("/reloadAllCache")
    public Result reloadAllCache(){
        BpmRoleUtil.reloadAllCache();
        return Result.ok();
    }
}
