package com.biz.crm.bpmrole.controller;

import com.biz.crm.aop.CrmGlobalLog;
import com.biz.crm.bpmrole.service.MdmBpmRoleService;
import com.biz.crm.nebular.mdm.bpmrole.resp.MdmBpmRoleRedisRespVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRedisVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgReloadRedisVo;
import com.biz.crm.org.service.MdmOrgService;
import com.biz.crm.util.BpmRoleUtil;
import com.biz.crm.util.Result;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @Description: 流程角色缓存请求接口
 * @project：crm-core
 * @package：com.biz.crm.bpmrole.controller
 * @author：longyu
 * @create：2021/1/14 14:48
 */
@Slf4j
@RestController
@RequestMapping("/mdmBpmRoleRedisController")
@CrmGlobalLog
public class MdmBpmRoleRedisController {

    @Autowired
    private MdmBpmRoleService mdmBpmRoleService;

    /**
     * 根据流程角色编码查询流程角色
     * @param bpmRoleCodeList
     * @return
     */
    @PostMapping("/findRedisListByBpmRoleCodeList")
    public Result<List<MdmBpmRoleRedisRespVo>> findRedisListByBpmRoleCodeList(@RequestBody List<String> bpmRoleCodeList) {
        return Result.ok(mdmBpmRoleService.findRedisListByBpmRoleCodeList(bpmRoleCodeList));
    }

    /**
     * 获取全部流程角色redis缓存数据
     *
     * @return
     */
    @PostMapping("/findRedisReloadList")
    public Result<List<MdmBpmRoleRedisRespVo>> findRedisReloadList() {
        return Result.ok(mdmBpmRoleService.findRedisList());
    }

}
