package com.biz.crm.bpmrole.provider;

import com.biz.crm.eunm.mdm.MdmProviderEnum;
import com.biz.crm.nebular.mdm.bpmrole.req.MdmBpmRoleReqVo;
import com.biz.crm.nebular.mdm.pageconfig.MdmColumnConfigRespVo;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.utils.ProviderUtil;
import org.apache.ibatis.jdbc.SQL;

import java.util.List;
import java.util.Map;

/**
 * @Author hej
 * @Created Date 2020-12-29
 **/
public class MdmBpmRoleProvider {

    public String findList(Map<String,Object> map) {
        MdmBpmRoleReqVo vo = (MdmBpmRoleReqVo) map.get("vo");
        List<MdmColumnConfigRespVo> cvo = ProviderUtil.gainConfigVo();
        return new SQL() {{
            SELECT("a.*");
            FROM("mdm_bpm_role a");
            if (StringUtils.isNotEmpty(vo.getEnableStatus())) {
                WHERE("a.enable_status = #{vo.enableStatus}");
            }
            if (StringUtils.isNotEmpty(vo.getBpmRoleCode())) {
                WHERE("a.bpm_role_code like " + ProviderUtil.bindPercent(vo.getBpmRoleCode(), MdmProviderEnum.SQL_JOIN_ALL));
            }
            if (StringUtils.isNotEmpty(vo.getBpmRoleName())) {
                WHERE("a.bpm_role_name like " +ProviderUtil.bindPercent(vo.getBpmRoleName(), MdmProviderEnum.SQL_JOIN_ALL));
            }
            if (StringUtils.isNotEmpty(vo.getCreateName())) {
                WHERE("a.create_name like " +ProviderUtil.bindPercent(vo.getCreateName(), MdmProviderEnum.SQL_JOIN_ALL));
            }
            if (StringUtils.isNotEmpty(vo.getUpdateName())) {
                WHERE("a.update_name like "+ProviderUtil.bindPercent(vo.getUpdateName(), MdmProviderEnum.SQL_JOIN_ALL));
            }
            if (CollectionUtil.listNotEmptyNotSizeZero(cvo)) {
                WHERE(ProviderUtil.gainExtendSql(cvo, "a"));
            }
            ORDER_BY("a.create_date desc,a.create_date_second desc");
        }}.toString();
    }


}
