package com.biz.crm.bpmrole.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.bpmrole.model.MdmBpmRoleEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.mdm.bpmrole.req.MdmBpmRoleReqVo;
import com.biz.crm.nebular.mdm.bpmrole.req.MdmBpmRoleSelectReqVo;
import com.biz.crm.nebular.mdm.bpmrole.resp.MdmBpmRoleRedisRespVo;
import com.biz.crm.nebular.mdm.bpmrole.resp.MdmBpmRoleRespVo;
import com.biz.crm.nebular.mdm.bpmrole.resp.MdmBpmRoleSelectRespVo;

import java.util.List;
import java.util.Set;

/**
 * 流程角色表接口
 *
 * @author Tao.Chen
 * @date 2020-11-26 20:07:10
 */
public interface MdmBpmRoleService extends IService<MdmBpmRoleEntity> {

    /**
     * 列表
     *
     * @param mdmBpmRoleReqVo
     * @return PageResult<MdmBpmRoleRespVo>
     */
    PageResult<MdmBpmRoleRespVo> findList(MdmBpmRoleReqVo mdmBpmRoleReqVo);

    /**
     * 查询
     *
     * @param id
     * @param bpmRoleCode
     * @return MdmBpmRoleRespVo
     */
    MdmBpmRoleRespVo detail(String id, String bpmRoleCode);

    /**
     * 根据流程角色编码集合批量查询流程角色
     *
     * @param bpmRoleCodeList
     * @return
     */
    List<MdmBpmRoleRespVo> queryBatchByBpmRoleCodeList(List<String> bpmRoleCodeList);

    /**
     * 新增
     *
     * @param mdmBpmRoleReqVo
     * @return
     */
    void save(MdmBpmRoleReqVo mdmBpmRoleReqVo);

    /**
     * 更新
     *
     * @param mdmBpmRoleReqVo
     * @return
     */
    void update(MdmBpmRoleReqVo mdmBpmRoleReqVo);

    /**
     * 删除
     *
     * @param ids
     * @return
     */
    void deleteBatch(List<String> ids);

    /**
     * 启用
     *
     * @param ids
     * @return
     */
    void enableBatch(List<String> ids);

    /**
     * 禁用
     *
     * @param ids
     * @return
     */
    void disableBatch(List<String> ids);

    /**
     * 流程角色下拉框
     *
     * @param reqVo
     * @return
     */
    List<MdmBpmRoleSelectRespVo> selectList(MdmBpmRoleSelectReqVo reqVo);

    /**
     * 根据职位编码集合查询关联的流程角色编码集合
     *
     * @param positionCodeList
     * @return
     */
    Set<String> findBpmRoleCodeSetByPositionCodeList(List<String> positionCodeList);

    /**
     * 流程角色redis缓存查询
     * @param bpmRoleCodeList
     * @return
     */
    List<MdmBpmRoleRedisRespVo> findRedisListByBpmRoleCodeList(List<String> bpmRoleCodeList);

    /**
     * 获取所有流程角色进行redis缓存
     * @return
     */
    List<MdmBpmRoleRedisRespVo> findRedisList();
}

