package com.biz.crm.button.service;


import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.button.model.MdmButtonEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.mdm.button.MdmButtonReqVo;
import com.biz.crm.nebular.mdm.button.MdmButtonRespVo;

import java.util.List;

/**
 * 按扭接口
 *
 * @author zxw
 * @date 2020-11-18 11:33:08
 */
public interface MdmButtonService extends IService<MdmButtonEntity> {

    /**
     * 列表
     * @param mdmButtonReqVo
     * @return PageResult<MdmButtonRespVo>
     */
    PageResult<MdmButtonRespVo> findList(MdmButtonReqVo mdmButtonReqVo);

    /**
     * 查询
     * @param mdmButtonReqVo
     * @return MdmButtonRespVo
     */
    MdmButtonRespVo query(String id,String buttonCode);

    /**
     * 新增
     * @param mdmButtonReqVo
     * @return
     */
    void save(MdmButtonReqVo mdmButtonReqVo);

    /**
     * 更新
     * @param mdmButtonReqVo
     * @return
     */
    void update(MdmButtonReqVo mdmButtonReqVo);

    /**
     * 删除
     * @param mdmButtonReqVo
     * @return
     */
    void deleteBatch(List<String> ids);

    /**
     * 启用
     * @param ids
     * @return
     */
    void enableBatch(List<String> ids);

    /**
     * 禁用
     * @param ids
     * @return
     */
    void disableBatch(List<String> ids);

    /**
     * 按钮列表查询
     * @param mdmButtonReqVo vo
     * @return list
     */
    List<MdmButtonRespVo> listCondition(MdmButtonReqVo mdmButtonReqVo);
}

