package com.biz.crm.coderule.controller;

import com.biz.crm.aop.CrmGlobalLog;
import com.biz.crm.coderule.service.MdmCodeRuleService;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.nebular.mdm.coderule.req.MdmCodeRuleReqVo;
import com.biz.crm.nebular.mdm.coderule.resp.MdmCodeRuleRespVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 编码规则
 *
 * @author Tao.Chen
 * @date 2020-11-05 10:47:13
 */
@Slf4j
@RestController
@RequestMapping("/mdmcoderule")
@Api(tags = "编码规则")
@CrmGlobalLog
public class MdmCodeRuleController {

    @Autowired
    private MdmCodeRuleService mdmCodeRuleService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表（分页）")
    @PostMapping("/list")
    @CrmDictMethod
    public Result<PageResult<MdmCodeRuleRespVo>> list(@RequestBody MdmCodeRuleReqVo mdmCodeRuleReqVo) {
        PageResult<MdmCodeRuleRespVo> result = mdmCodeRuleService.findList(mdmCodeRuleReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询详情（传id或者ruleCode）")
    @PostMapping("/query")
    @CrmDictMethod
    public Result<MdmCodeRuleRespVo> query(@RequestBody MdmCodeRuleReqVo mdmCodeRuleReqVo) {
        MdmCodeRuleRespVo respVo = mdmCodeRuleService.query(mdmCodeRuleReqVo);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    public Result save(@RequestBody MdmCodeRuleReqVo mdmCodeRuleReqVo) {
        mdmCodeRuleService.save(mdmCodeRuleReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    public Result update(@RequestBody MdmCodeRuleReqVo mdmCodeRuleReqVo) {
        mdmCodeRuleService.update(mdmCodeRuleReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除", httpMethod = "POST")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "id集合", required = true, paramType = "body")
    })
    @PostMapping("/delete")
    public Result delete(@RequestBody List<String> ids) {
        mdmCodeRuleService.deleteBatch(ids);
        return Result.ok("删除成功");
    }

    /**
     * 重置
     */
    @ApiOperation(value = "重置编码(传ids)")
    @PostMapping("/reset")
    public Result reset(@RequestBody MdmCodeRuleReqVo mdmCodeRuleReqVo) {
        mdmCodeRuleService.reset(mdmCodeRuleReqVo);
        return Result.ok("重置成功");
    }

}
