package com.biz.crm.coderule.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.coderule.model.MdmCodeRuleEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.mdm.coderule.req.MdmCodeRuleReqVo;
import com.biz.crm.nebular.mdm.coderule.resp.MdmCodeRuleRespVo;

import java.util.List;

/**
 * 编码规则接口
 *
 * @author Tao.Chen
 * @date 2020-11-05 10:47:13
 */
public interface MdmCodeRuleService extends IService<MdmCodeRuleEntity> {

    /**
     * 列表
     *
     * @param mdmCodeRuleReqVo
     * @return PageResult<MdmCodeRuleRespVo>
     */
    PageResult<MdmCodeRuleRespVo> findList(MdmCodeRuleReqVo mdmCodeRuleReqVo);

    /**
     * 查询
     *
     * @param mdmCodeRuleReqVo
     * @return MdmCodeRuleRespVo
     */
    MdmCodeRuleRespVo query(MdmCodeRuleReqVo mdmCodeRuleReqVo);

    /**
     * 新增
     *
     * @param mdmCodeRuleReqVo
     * @return
     */
    void save(MdmCodeRuleReqVo mdmCodeRuleReqVo);

    /**
     * 更新
     *
     * @param mdmCodeRuleReqVo
     * @return
     */
    void update(MdmCodeRuleReqVo mdmCodeRuleReqVo);

    /**
     * 删除
     *
     * @return
     */
    void deleteBatch(List<String> ids);

    /**
     * 重置
     *
     * @param mdmCodeRuleReqVo
     * @return
     */
    void reset(MdmCodeRuleReqVo mdmCodeRuleReqVo);

}

