package com.biz.crm.common.service;

import com.biz.crm.nebular.mdm.common.BaseTreeReqVo;
import com.biz.crm.nebular.mdm.common.BaseTreeRespVo;
import com.biz.crm.nebular.mdm.org.req.BaseOrgTreeReqVo;

import java.util.List;

/**
 * @author zxw
 */
public interface BaseTreeService {

    /**
     * 组织树
     *
     * @param reqVo reqVo
     * @return java.util.List<com.biz.crm.nebular.mdm.common.BaseTreeRespVo>
     **/
    List<BaseTreeRespVo> orgTree(BaseOrgTreeReqVo reqVo);


    /**
     * 菜单树
     *
     * @param reqVo reqVo
     * @return java.util.List<com.biz.crm.nebular.mdm.common.BaseTreeRespVo>
     **/
    List<BaseTreeRespVo> menuTree(BaseTreeReqVo reqVo);

    /**
     * 产品层级树
     *
     * @param reqVo reqVo
     * @return java.util.List<com.biz.crm.nebular.mdm.common.BaseTreeRespVo>
     **/
    List<BaseTreeRespVo> productLevelTree(BaseTreeReqVo reqVo);

    /**
     * 客户组织树
     *
     * @param reqVo reqVo
     * @return java.util.List<com.biz.crm.nebular.mdm.common.BaseTreeRespVo>
     **/
    List<BaseTreeRespVo> customerOrgTree(BaseTreeReqVo reqVo);
}
