package com.biz.crm.common.service.impl;

import com.biz.crm.common.service.BaseLazyTreeService;
import com.biz.crm.cusorg.entity.MdmCusOrgEntity;
import com.biz.crm.cusorg.mapper.MdmCusOrgMapper;
import com.biz.crm.cusorg.service.MdmCusOrgService;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.function.mapper.MdmFunctionMapper;
import com.biz.crm.function.model.MdmFunctionEntity;
import com.biz.crm.function.service.MdmFunctionService;
import com.biz.crm.nebular.mdm.common.BaseLazyTreeReqVo;
import com.biz.crm.nebular.mdm.common.BaseLazyTreeRespVo;
import com.biz.crm.org.mapper.MdmOrgMapper;
import com.biz.crm.org.model.MdmOrgEntity;
import com.biz.crm.org.service.MdmOrgService;
import com.biz.crm.productlevel.mapper.MdmProductLevelMapper;
import com.biz.crm.productlevel.model.MdmProductLevelEntity;
import com.biz.crm.productlevel.service.MdmProductLevelService;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.TreeRuleCodeUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.*;
import java.util.stream.Collectors;

@Slf4j
@Service
@ConditionalOnMissingBean(name = "BaseLazyTreeServiceExpandImpl")
public class BaseLazyTreeServiceImpl implements BaseLazyTreeService {

    @Resource
    private MdmOrgService mdmOrgService;
    @Resource
    private MdmFunctionService mdmFunctionService;
    @Resource
    private MdmProductLevelService mdmProductLevelService;
    @Resource
    private MdmCusOrgService mdmCusOrgService;
    @Resource
    private MdmOrgMapper mdmOrgMapper;
    @Resource
    private MdmFunctionMapper mdmFunctionMapper;
    @Resource
    private MdmProductLevelMapper mdmProductLevelMapper;
    @Resource
    private MdmCusOrgMapper mdmCusOrgMapper;

    @Override
    public List<BaseLazyTreeRespVo> orgLazyTree(BaseLazyTreeReqVo reqVo) {
        List<BaseLazyTreeRespVo> list = new ArrayList<>();
        String excludeRuleCode = "";
        if (StringUtils.isNotEmpty(reqVo.getExcludeCodeAndChildren())) {
            MdmOrgEntity one = mdmOrgService.lambdaQuery()
                    .eq(MdmOrgEntity::getOrgCode, reqVo.getExcludeCodeAndChildren())
                    .select(MdmOrgEntity::getRuleCode)
                    .one();
            if (one != null) {
                excludeRuleCode = one.getRuleCode();
            }
        }
        if (!StringUtils.isEmpty(reqVo.getParentCode())) {
            //查询parentCode下一级
            list.addAll(mdmOrgMapper.findOrgLazyTreeList(reqVo.getEnableStatus(), null, reqVo.getParentCode(), null, null, excludeRuleCode));
        } else if (!StringUtils.isEmpty(reqVo.getName())) {
            //模糊查询并构建成树
            List<MdmOrgEntity> likeList = mdmOrgService.lambdaQuery()
                    .eq(StringUtils.isNotEmpty(reqVo.getEnableStatus()), MdmOrgEntity::getEnableStatus, reqVo.getEnableStatus())
                    .like(MdmOrgEntity::getOrgName, reqVo.getName())
                    .select(MdmOrgEntity::getOrgCode, MdmOrgEntity::getRuleCode)
                    .list();
            if (CollectionUtil.listNotEmptyNotSizeZero(likeList)) {
                Set<String> parentRuleCodes = TreeRuleCodeUtil.splitParentRuleCodes(likeList.stream().map(MdmOrgEntity::getRuleCode).collect(Collectors.toList()));
                list.addAll(mdmOrgMapper.findOrgLazyTreeList(reqVo.getEnableStatus(), null, null, null, new ArrayList<>(parentRuleCodes), excludeRuleCode));
            }
        } else {
            //查询第一层
            list.addAll(mdmOrgMapper.findOrgLazyTreeList(reqVo.getEnableStatus(), true, null, null, null, excludeRuleCode));
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            list.forEach(item -> item.setHasChild(YesNoEnum.yesNoEnum.ONE.getValue().equalsIgnoreCase(String.valueOf(item.getHasChildFlag()))));
            return generateTreeByParentCode(list);
        }
        return new ArrayList<>();
    }

    @Override
    public List<BaseLazyTreeRespVo> menuLazyTree(BaseLazyTreeReqVo reqVo) {
        List<BaseLazyTreeRespVo> list = new ArrayList<>();
        if (!StringUtils.isEmpty(reqVo.getParentCode())) {
            //查询parentCode下一级
            list.addAll(mdmFunctionMapper.findFunctionLazyTreeList(reqVo.getEnableStatus(), null, reqVo.getParentCode(), null));
        } else if (!StringUtils.isEmpty(reqVo.getName())) {
            //模糊查询并构建成树
            List<MdmFunctionEntity> likeList = mdmFunctionService.lambdaQuery()
                    .like(MdmFunctionEntity::getFunctionName, reqVo.getName())
                    .select(MdmFunctionEntity::getFunctionCode, MdmFunctionEntity::getParentCode)
                    .list();
            Set<String> set = new HashSet<>(16);
            if (CollectionUtil.listNotEmptyNotSizeZero(likeList)) {
                set.addAll(likeList.stream().map(MdmFunctionEntity::getFunctionCode).collect(Collectors.toSet()));
                List<String> parentCodeList = likeList.stream().map(MdmFunctionEntity::getParentCode).filter(StringUtils::isNotEmpty).distinct().collect(Collectors.toList());
                //防止死循环
                int index = 0;
                while (CollectionUtil.listNotEmptyNotSizeZero(parentCodeList) && index < 10) {
                    index++;
                    List<MdmFunctionEntity> parentList = mdmFunctionService.lambdaQuery()
                            .in(MdmFunctionEntity::getFunctionCode, parentCodeList)
                            .select(MdmFunctionEntity::getFunctionCode, MdmFunctionEntity::getParentCode)
                            .list();
                    parentCodeList.clear();
                    if (CollectionUtil.listNotEmptyNotSizeZero(parentList)) {
                        set.addAll(parentList.stream().map(MdmFunctionEntity::getFunctionCode).collect(Collectors.toSet()));
                        parentCodeList = parentList.stream().map(MdmFunctionEntity::getParentCode).filter(StringUtils::isNotEmpty).distinct().collect(Collectors.toList());
                    }
                }
                list.addAll(mdmFunctionMapper.findFunctionLazyTreeList(reqVo.getEnableStatus(), null, null, new ArrayList<>(set)));
            }
        } else {
            //查询第一层
            list.addAll(mdmFunctionMapper.findFunctionLazyTreeList(reqVo.getEnableStatus(), true, null, null));
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            list.forEach(item -> item.setHasChild(YesNoEnum.yesNoEnum.ONE.getValue().equalsIgnoreCase(String.valueOf(item.getHasChildFlag()))));
            return generateTreeByParentCode(list);
        }
        return new ArrayList<>();
    }

    @Override
    public List<BaseLazyTreeRespVo> productLevelLazyTree(BaseLazyTreeReqVo reqVo) {
        List<BaseLazyTreeRespVo> list = new ArrayList<>();
        String excludeRuleCode = "";
        if (StringUtils.isNotEmpty(reqVo.getExcludeCodeAndChildren())) {
            MdmProductLevelEntity one = mdmProductLevelService.lambdaQuery()
                    .eq(MdmProductLevelEntity::getProductLevelCode, reqVo.getExcludeCodeAndChildren())
                    .select(MdmProductLevelEntity::getRuleCode)
                    .one();
            if (one != null) {
                excludeRuleCode = one.getRuleCode();
            }
        }
        if (!StringUtils.isEmpty(reqVo.getParentCode())) {
            //查询parentCode下一级
            list.addAll(mdmProductLevelMapper.findProductLevelLazyTreeList(reqVo.getEnableStatus(), null, reqVo.getParentCode(), null, null, excludeRuleCode));
        } else if (!StringUtils.isEmpty(reqVo.getName())) {
            //模糊查询并构建成树
            List<MdmProductLevelEntity> likeList = mdmProductLevelService.lambdaQuery()
                    .like(MdmProductLevelEntity::getProductLevelName, reqVo.getName())
                    .select(MdmProductLevelEntity::getProductLevelCode, MdmProductLevelEntity::getRuleCode)
                    .list();
            if (CollectionUtil.listNotEmptyNotSizeZero(likeList)) {
                Set<String> parentRuleCodes = TreeRuleCodeUtil.splitParentRuleCodes(likeList.stream().map(MdmProductLevelEntity::getRuleCode).collect(Collectors.toList()));
                list.addAll(mdmProductLevelMapper.findProductLevelLazyTreeList(reqVo.getEnableStatus(), null, null, null, new ArrayList<>(parentRuleCodes), excludeRuleCode));
            }
        } else {
            //查询第一层
            list.addAll(mdmProductLevelMapper.findProductLevelLazyTreeList(reqVo.getEnableStatus(), true, null, null, null, excludeRuleCode));
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            list.forEach(item -> item.setHasChild(YesNoEnum.yesNoEnum.ONE.getValue().equalsIgnoreCase(String.valueOf(item.getHasChildFlag()))));
            return generateTreeByParentCode(list);
        }
        return new ArrayList<>();
    }

    @Override
    public List<BaseLazyTreeRespVo> customerOrgLazyTree(BaseLazyTreeReqVo reqVo) {
        List<BaseLazyTreeRespVo> list = new ArrayList<>();
        String excludeRuleCode = "";
        if (StringUtils.isNotEmpty(reqVo.getExcludeCodeAndChildren())) {
            MdmCusOrgEntity one = mdmCusOrgService.lambdaQuery()
                    .eq(MdmCusOrgEntity::getCustomerOrgCode, reqVo.getExcludeCodeAndChildren())
                    .select(MdmCusOrgEntity::getRuleCode)
                    .one();
            if (one != null) {
                excludeRuleCode = one.getRuleCode();
            }
        }
        if (!StringUtils.isEmpty(reqVo.getParentCode())) {
            //查询parentCode下一级
            list.addAll(mdmCusOrgMapper.findCusOrgLazyTreeList(reqVo.getEnableStatus(), null, reqVo.getParentCode(), null, null, excludeRuleCode));
        } else if (!StringUtils.isEmpty(reqVo.getName())) {
            //模糊查询并构建成树
            List<MdmCusOrgEntity> likeList = mdmCusOrgService.lambdaQuery()
                    .like(MdmCusOrgEntity::getCustomerOrgName, reqVo.getName())
                    .select(MdmCusOrgEntity::getCustomerOrgCode, MdmCusOrgEntity::getRuleCode)
                    .list();
            if (CollectionUtil.listNotEmptyNotSizeZero(likeList)) {
                Set<String> parentRuleCodes = TreeRuleCodeUtil.splitParentRuleCodes(likeList.stream().map(MdmCusOrgEntity::getRuleCode).collect(Collectors.toList()));
                list.addAll(mdmCusOrgMapper.findCusOrgLazyTreeList(reqVo.getEnableStatus(), null, null, null, new ArrayList<>(parentRuleCodes), excludeRuleCode));
            }
        } else {
            //查询第一层
            list.addAll(mdmCusOrgMapper.findCusOrgLazyTreeList(reqVo.getEnableStatus(), true, null, null, null, excludeRuleCode));
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            list.forEach(item -> item.setHasChild(YesNoEnum.yesNoEnum.ONE.getValue().equalsIgnoreCase(String.valueOf(item.getHasChildFlag()))));
            return generateTreeByParentCode(list);
        }
        return new ArrayList<>();
    }

    /**
     * 构建树形结构
     *
     * @param totalList
     * @return
     */
    protected List<BaseLazyTreeRespVo> generateTreeByParentCode(List<BaseLazyTreeRespVo> totalList) {

        //构建树list
        List<BaseLazyTreeRespVo> treeList = new ArrayList<>();
        //当前操作层级数据
        List<BaseLazyTreeRespVo> curLevelList = new ArrayList<>();
        //未操作数据
        List<BaseLazyTreeRespVo> restList = new ArrayList<>();

        //key:id
        Map<String, BaseLazyTreeRespVo> totalMap = totalList.stream().collect(Collectors.toMap(BaseLazyTreeRespVo::getCode, v -> v));

        //查找第一层
        for (BaseLazyTreeRespVo item :
                totalList) {
            if (StringUtils.isEmpty(item.getParentCode()) || !totalMap.containsKey(item.getParentCode())) {
                treeList.add(item);
                curLevelList.add(item);
            } else {
                restList.add(item);
            }
        }

        //构建数据，从第二层开始
        while (curLevelList.size() > 0 && restList.size() > 0) {
            List<BaseLazyTreeRespVo> restTempList = new ArrayList<>();
            List<BaseLazyTreeRespVo> curLevelTempList = new ArrayList<>();
            Map<String, String> curLevelMap = curLevelList.stream().collect(Collectors.toMap(BaseLazyTreeRespVo::getCode, BaseLazyTreeRespVo::getCode));
            Map<String, List<BaseLazyTreeRespVo>> curLevelChildrenMap = new HashMap<>(16);

            for (BaseLazyTreeRespVo item :
                    restList) {
                if (curLevelMap.containsKey(item.getParentCode())) {
                    curLevelTempList.add(item);

                    List<BaseLazyTreeRespVo> childrenList = new ArrayList<>();
                    if (curLevelChildrenMap.containsKey(item.getParentCode())) {
                        childrenList.addAll(curLevelChildrenMap.get(item.getParentCode()));
                    }
                    childrenList.add(item);
                    curLevelChildrenMap.put(item.getParentCode(), childrenList);
                } else {
                    restTempList.add(item);
                }
            }

            for (BaseLazyTreeRespVo item :
                    curLevelList) {
                if (curLevelChildrenMap.containsKey(item.getCode())) {
                    item.setChildren(curLevelChildrenMap.get(item.getCode()));
                }
            }

            curLevelList.clear();
            curLevelList.addAll(curLevelTempList);
            restList.clear();
            restList.addAll(restTempList);
        }

        return treeList;
    }
}
