package com.biz.crm.config;

import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import lombok.SneakyThrows;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;

@Component
public class BeanUtil implements ApplicationContextAware {

    private ApplicationContext applicationContext;

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }


    @SneakyThrows
    public void setFieldValue(Object o) {
        if (o instanceof Result) {
            Object data = ((Result) o).getResult();
            if (data.getClass().isArray() || data instanceof Collection) {
                for (Object datum : ((Collection) data)) {
                    convertData(datum);
                }
            } else if (data instanceof PageResult) {
                List innerData = ((PageResult) data).getData();
                for (Object obj : innerData) {
                    convertData(obj);
                }
            } else {
                convertData(data);
            }
        }
    }

    @SneakyThrows
    private void convertData(Object o) {
        Class<?> sourceClass = o.getClass();
        for (; sourceClass != Object.class; sourceClass = sourceClass.getSuperclass()) {
            Field[] fields = sourceClass.getDeclaredFields();
            for (Field field : fields) {
                CrmSetVal crmSetVal = field.getAnnotation(CrmSetVal.class);
                if (crmSetVal == null) {
                    continue;
                }
                field.setAccessible(true);
                String fieldNames = crmSetVal.paramField();
                String[] split = fieldNames.split(",");
                Class<?>[] paramFieldTypeList = new Class[split.length];
                Object[] paramFieldValList = new Object[split.length];
                for (int i = 0; i < split.length; i++) {
                    String fieldName = split[i];
                    Field paramField = sourceClass.getDeclaredField(fieldName);
                    paramField.setAccessible(true);
                    paramFieldTypeList[i] = paramField.getType();
                    paramFieldValList[i] = paramField.get(o);
                }
                Class<?> targetClass = Class.forName(crmSetVal.targetClass());
                Method targetMethod = targetClass.getDeclaredMethod(crmSetVal.targetMethod(), paramFieldTypeList);
                Object invoke = targetMethod.invoke(null, paramFieldValList);
                if (invoke != null) {
                    field.set(o,invoke);
                }
            }
        }
//        Field[] declaredFields = sourceClass.getFields();
//        for (Field field : declaredFields) {
//            CrmSetVal crmSetVal = field.getAnnotation(CrmSetVal.class);
//            if (crmSetVal == null) {
//                continue;
//            }
//            field.setAccessible(true);
//            Object target = operate(o, sourceClass, crmSetVal);
//            if (target != null) {
//                field.set(o, target);
//            }
//        }
    }

//    @SneakyThrows
//    private Object operate(Object o, Class<?> sourceClass, CrmSetVal crmSetVal) {
//        String fieldNames = crmSetVal.paramField();
//        String[] split = fieldNames.split(",");
//        Class<?>[] paramFieldTypeList = new Class[split.length];
//        Object[] paramFieldValList = new Object[split.length];
//        for (int i = 0; i < split.length; i++) {
//            String fieldName = split[i];
//            Field paramField = sourceClass.getDeclaredField(fieldName);
//            paramField.setAccessible(true);
//            paramFieldTypeList[i] = paramField.getType();
//            paramFieldValList[i] = paramField.get(o);
//        }
//        Class<?> targetClass = Class.forName(crmSetVal.targetClass());
//        Method targetMethod = targetClass.getDeclaredMethod(crmSetVal.targetMethod(), paramFieldTypeList);
//        return targetMethod.invoke(null, paramFieldValList);
//    }
}
