package com.biz.crm.cusorg.controller;

import com.biz.crm.aop.CrmGlobalLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.cusorg.service.MdmCusOrgService;
import com.biz.crm.nebular.mdm.cusorg.CusOrgVo;
import com.biz.crm.nebular.mdm.cusorg.MdmCustomerOrgSelectReqVo;
import com.biz.crm.nebular.mdm.cusorg.MdmCustomerOrgSelectRespVo;
import com.biz.crm.util.CustomerOrgUtil;
import com.biz.crm.util.Result;
import io.swagger.annotations.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author zxw
 */
@Api(value = "客户组织", tags = "客户组织")
@RestController
@RequestMapping("/mdmCusOrgController")
@CrmGlobalLog
public class MdmCusOrgController {

    @Autowired
    private MdmCusOrgService mdmCusOrgService;


    @ApiOperation(value = "添加客户组织")
    @PostMapping(value = "add")
    public Result<Object> add(@RequestBody CusOrgVo cusOrgVo) {
        mdmCusOrgService.add(cusOrgVo);
        return Result.ok();
    }

    @ApiOperation("查询客户组织")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "id", required = false, paramType = "query"),
            @ApiImplicitParam(name = "customerOrgCode", value = "客户组织编码", required = false, paramType = "query")
    })
    @GetMapping("/query")
    @CrmDictMethod
    public Result<CusOrgVo> query(@RequestParam(value = "id", required = false) String id,
                                  @RequestParam(value = "customerOrgCode", required = false) String customerOrgCode) {
        return Result.ok(mdmCusOrgService.query(id, customerOrgCode));
    }


    @ApiOperation(value = "修改客户组织")
    @PostMapping(value = "edit")
    public Result<Object> edit(@RequestBody CusOrgVo cusOrgVo) {
        mdmCusOrgService.edit(cusOrgVo);
        return Result.ok();
    }

    @ApiOperation(value = "分页搜索客户组织")
    @PostMapping(value = "list")
    @CrmDictMethod
    public Result<PageResult<CusOrgVo>> list(@RequestBody CusOrgVo cusOrgVo) {
        return Result.ok(mdmCusOrgService.list(cusOrgVo));
    }

    @ApiOperation(value = "搜索客户组织list")
    @PostMapping("/findList")
    @CrmDictMethod
    public Result<List<CusOrgVo>> findList(@RequestBody CusOrgVo cusOrgVo){
        List<CusOrgVo> cusOrgVos = mdmCusOrgService.findList(cusOrgVo);
        return Result.ok(cusOrgVos);
    }

    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "id集合", required = true, paramType = "body")
    })
    @ApiOperation(value = "根据id批量启用")
    @PostMapping(value = "enAbleBatch")
    public Result<Object> enAbleBatch(@RequestBody List<String> ids) {
        mdmCusOrgService.ableBatch(ids);
        return Result.ok();
    }

    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "id集合", required = true, paramType = "body")
    })
    @ApiOperation(value = "根据id批量禁用")
    @PostMapping(value = "disAbleBatch")
    public Result<Object> disAbleBatch(@RequestBody List<String> ids) {
        mdmCusOrgService.disableBatch(ids);
        return Result.ok();
    }

    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "id集合", required = true, paramType = "body")
    })
    @ApiOperation(value = "根据id批量删除")
    @PostMapping(value = "delBatch")
    public Result<Object> delBatch(@RequestBody List<String> ids) {
        mdmCusOrgService.stateBatch(ids);
        return Result.ok();
    }

    @ApiOperation("客户组织下拉框")
    @PostMapping("/select")
    public Result<List<MdmCustomerOrgSelectRespVo>> customerOrgSelect(@RequestBody CusOrgVo cusOrgVo) {
        return Result.ok(mdmCusOrgService.customerOrgSelect(cusOrgVo));
    }

    @ApiOperation("客户组织下拉框（限制数量）")
    @PostMapping("/findCustomerOrgSelectList")
    public Result<List<MdmCustomerOrgSelectRespVo>> findCustomerOrgSelectList(@RequestBody MdmCustomerOrgSelectReqVo reqVo) {
        return Result.ok(mdmCusOrgService.findCustomerOrgSelectList(reqVo));
    }

    @ApiModelProperty("重置物化路径编码")
    @PostMapping("/rule_code_set")
    public Result<Object> setUpRuleCode() {
        mdmCusOrgService.setUpRuleCode();
        CustomerOrgUtil.reloadAllCache();
        return Result.ok();
    }
}
