package com.biz.crm.cusorg.mapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cusorg.entity.MdmCusOrgEntity;
import com.biz.crm.cusorg.provider.MdmCusOrgProvider;
import com.biz.crm.nebular.mdm.common.BaseLazyTreeRespVo;
import com.biz.crm.nebular.mdm.common.BaseTreeReqVo;
import com.biz.crm.nebular.mdm.common.BaseTreeRespVo;
import com.biz.crm.nebular.mdm.cusorg.*;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.SelectProvider;

import java.util.ArrayList;
import java.util.List;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2020/8/26 11:31
 **/
public interface MdmCusOrgMapper extends BaseMapper<MdmCusOrgEntity> {

    /**
     * 根据id批量操作启用禁用
     *
     * @param ids
     * @param crmBStateEnumValue
     */
    void ableBatch(@Param("ids") ArrayList<String> ids, @Param("crmBStateEnumValue") String crmBStateEnumValue);


    /**
     * 根据id批量删除或者恢复
     *
     * @param ids
     * @param crmStateEnumValue
     */
    void stateBatch(@Param("ids") ArrayList<String> ids, @Param("crmStateEnumValue") String crmStateEnumValue);

    /**
     * 分页搜索客户组织
     *
     * @param page     page
     * @param cusOrgVo privilege
     * @return list
     */
    List<CusOrgVo> list(Page page, @Param("vo") CusOrgVo cusOrgVo);

    /**
     * 分页搜索客户组织(provider)
     *
     * @param page     page
     * @param cusOrgVo privilege
     * @return list
     */
    @SelectProvider(type = MdmCusOrgProvider.class,method = "listProvider")
    List<CusOrgVo> listProvider(Page page, @Param("vo") CusOrgVo cusOrgVo);


    @Select("select * from mdm_cus_org ${ew.customSqlSegment}")
    List<CusOrgTreeRespVo> findCondition(@Param("ew") QueryWrapper<CusOrgTreeRespVo> wrapper);

    /**
     * 查询非下集客户组织
     *
     * @param cusOrgVo cusOrgVo
     * @return java.util.List<com.biz.crm.nebular.mdm.cusorg.CusOrgTreeRespVo>
     **/
    List<CusOrgVo> ruleNotLikeRight(@Param("vo") CusOrgVo cusOrgVo);


    /**
     * 客户组织树的基本条件查询
     *
     * @param baseTreeReqVo baseTreeRespVo
     * @return java.util.List<com.biz.crm.nebular.mdm.common.BaseTreeRespVo>
     **/
    List<BaseTreeRespVo> findBaseTreeConditionList(@Param("vo") BaseTreeReqVo baseTreeReqVo);

    /**
     * 客户组织条件查询列表
     *
     * @param mdmCustomerOrgConditionReqVo mdmCustomerOrgConditionReqVo
     * @return java.util.List<com.biz.crm.nebular.mdm.cusorg.CusOrgVo>
     **/
    List<CusOrgVo> listCondition(@Param("vo") MdmCustomerOrgConditionReqVo mdmCustomerOrgConditionReqVo);

    /**
     * 查询客户组织懒加载数据
     *
     * @param enableStatus    启用状态
     * @param topOnly         传true只查第一层
     * @param parentCode      只查询该编码下一级
     * @param codeList        只查询这些编码
     * @param ruleCodeList    只查询这些降维编码
     * @param excludeRuleCode 排除这个降维编码的下级
     * @return
     */
    List<BaseLazyTreeRespVo> findCusOrgLazyTreeList(@Param("enableStatus") String enableStatus, @Param("topOnly") Boolean topOnly, @Param("parentCode") String parentCode, @Param("codeList") List<String> codeList, @Param("ruleCodeList") List<String> ruleCodeList, @Param("excludeRuleCode") String excludeRuleCode);

    /**
     * 把职位表的降维编码刷成id
     */
    void copyIdToRuleCode();

    /**
     * 把不存在的上级编码置成空
     */
    void setNullNotExistParentCode();

    /**
     * 根据降维编码查询下级
     *
     * @param rightLikeCusOrgRuleCodeList 降维编码集合，右边带“%”
     * @param enableStatus                启用状态
     * @return
     */
    List<CusOrgVo> findChildrenByRuleCodeList(@Param("rightLikeCusOrgRuleCodeList") List<String> rightLikeCusOrgRuleCodeList, @Param("enableStatus") String enableStatus);

    /**
     * 查询客户组织下拉框
     *
     * @param page
     * @param reqVo
     * @return
     */
    List<MdmCustomerOrgSelectRespVo> findCustomerOrgSelectList(Page<MdmCustomerOrgSelectRespVo> page, @Param("vo") MdmCustomerOrgSelectReqVo reqVo);

    /**
     * 搜索客户组织list
     * @param cusOrgVo
     * @return
     */
    List<CusOrgVo> list(@Param("vo") CusOrgVo cusOrgVo);

}
