package com.biz.crm.cusorg.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.common.PageResult;
import com.biz.crm.cusorg.entity.MdmCusOrgEntity;
import com.biz.crm.nebular.mdm.common.BaseTreeReqVo;
import com.biz.crm.nebular.mdm.common.BaseTreeRespVo;
import com.biz.crm.nebular.mdm.cusorg.*;

import java.util.List;

/**
 * @Description: 客户组织服务
 * @Author: zhangyuzhu
 * @Date: 2020/8/26 10:52
 **/
public interface MdmCusOrgService extends IService<MdmCusOrgEntity> {

    /**
     * 添加客户组织
     *
     * @param cusOrgVo vo
     */
    void add(CusOrgVo cusOrgVo);


    /**
     * 查询
     *
     * @param id              id
     * @param customerOrgCode 客户组织编码
     * @return vo
     */
    CusOrgVo query(String id, String customerOrgCode);

    /**
     * 修改客户组织
     *
     * @param cusOrgVo vo
     */
    void edit(CusOrgVo cusOrgVo);

    /**
     * 分页搜索客户组织
     *
     * @param cusOrgVo vo
     * @return page
     */
    PageResult<CusOrgVo> list(CusOrgVo cusOrgVo);


    /**
     * 根据id获取对象
     *
     * @param id id
     * @return vo
     */
    CusOrgVo findById(String id);


    /**
     * 根据id批量启用
     *
     * @param ids id集合
     */
    void ableBatch(List<String> ids);


    /**
     * 根据id批量删除
     *
     * @param ids id集合
     */
    void stateBatch(List<String> ids);


    /**
     * 根据id集合批量禁用
     *
     * @param ids id集合
     */
    void disableBatch(List<String> ids);

    /**
     * 客户组织下拉框
     *
     * @param cusOrgVo vo
     * @return list
     */
    List<MdmCustomerOrgSelectRespVo> customerOrgSelect(CusOrgVo cusOrgVo);

    /**
     * 客户组织下拉框
     *
     * @param reqVo
     * @return
     */
    List<MdmCustomerOrgSelectRespVo> findCustomerOrgSelectList(MdmCustomerOrgSelectReqVo reqVo);

    /**
     * 公共字段树条件查询
     *
     * @param baseTreeReqVo baseTreeReqVo
     * @return java.util.List<com.biz.crm.nebular.mdm.common.BaseTreeRespVo>
     **/
    List<BaseTreeRespVo> findBaseTreeConditionList(BaseTreeReqVo baseTreeReqVo);

    /**
     * 设置物化路径编码
     **/
    void setUpRuleCode();

    /**
     * 查询非当前及下级客户组织
     *
     * @param cusOrgVo vo
     * @return list
     */
    List<CusOrgVo> findUnSubList(CusOrgVo cusOrgVo);

    /**
     * 查询当前及上级客户组织
     *
     * @param customerOrgCode customerOrgCode
     * @return java.util.List<com.biz.crm.nebular.mdm.cusorg.CusOrgVo>
     **/
    List<CusOrgVo> findAllParentList(String customerOrgCode);

    /**
     * 条件查询列表
     *
     * @param mdmCustomerOrgConditionReqVo mdmCustomerOrgConditionReqVo
     * @return java.util.List<com.biz.crm.nebular.mdm.cusorg.CusOrgVo>
     **/
    List<CusOrgVo> listCondition(MdmCustomerOrgConditionReqVo mdmCustomerOrgConditionReqVo);

    /**
     * 根据客户组织编码集合获取客户组织详情redis缓存数据
     *
     * @param customerOrgCodeList 客户组织编码集合
     * @return
     */
    List<MdmCustomerOrgRedisVo> findRedisListByCustomerOrgCodeList(List<String> customerOrgCodeList);

    /**
     * 根据客户组织编码集合获取客户组织上级redis缓存数据
     *
     * @param customerOrgCodeList 客户组织编码集合
     * @return
     */
    List<MdmCustomerOrgParentChildrenRedisVo> findRedisCustomerOrgParentListByCodeList(List<String> customerOrgCodeList);

    /**
     * 根据客户组织编码集合获取客户组织下级redis缓存数据
     *
     * @param customerOrgCodeList 客户组织编码集合
     * @return
     */
    List<MdmCustomerOrgParentChildrenRedisVo> findRedisCustomerOrgChildrenListByCodeList(List<String> customerOrgCodeList);

    /**
     * 获取全部客户组织redis缓存数据
     *
     * @return
     */
    List<MdmCustomerOrgReloadRedisVo> findRedisReloadList();

    /**
     * 搜索客户组织list
     * @param cusOrgVo
     * @return
     */
    List<CusOrgVo> findList(CusOrgVo cusOrgVo);
}
